/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.tm.im.RowType;
import com.kingdee.eas.tm.im.client.AbstractMakeInvoiceRebateUI;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MakeInvoiceRebateUI
extends AbstractMakeInvoiceRebateUI {
    private static final Logger logger = CoreUIObject.getLogger(MakeInvoiceRebateUI.class);
    private static final int AMT_PRECISION = 2;
    private static int RATE_PRECISION = 4;
    private static final int CAL_PERCISION = 10;
    private static final String TB_NOTAXAMT = "noTaxAmt";
    private static final String TB_PRICETAX = "priceTax";
    private static final String TB_BILLROWTYPE = "billRowType";
    private static final String TB_PRODUCTNAME = "productName";
    private static final String TB_TAXAMT = "taxAmt";
    private static final String TB_TAXCLASSIFICATIONCODE = "taxClassificationCode";
    private ChangeListener isContainTaxChange = null;
    private DataChangeListener txtDiscountRowsChange = null;
    private DataChangeListener txtDiscountRateChange = null;
    private DataChangeListener txtDiscountAmtChange = null;
    private boolean isOk = false;
    private boolean isContainTax = false;
    private KDTable kdtEntries = null;
    private int activeRowIndex = 0;
    private boolean confirmError = false;
    private HashMap retMap = new HashMap();

    public boolean isOk() {
        return this.isOk;
    }

    public void setOk(boolean isOk) {
        this.isOk = isOk;
    }

    public HashMap getRetMap() {
        return this.retMap;
    }

    public void setRetMap(HashMap retMap) {
        this.retMap = retMap;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() {
        this.initParams();
        this.initEditor();
        this.initDefaultValue();
        this.initListeners();
    }

    private void initParams() {
        Map uiCtx = this.getUIContext();
        this.isContainTax = (Boolean)uiCtx.get("isContainTax");
        this.activeRowIndex = (Integer)uiCtx.get("activeRowIndex");
        this.kdtEntries = (KDTable)uiCtx.get("kdtEntries");
        String[] paramNumbers = new String[]{"DISCOUNTRATEPRECISION"};
        try {
            String ratePrecision = IMUtils.getParamByNumber(null, (String)uiCtx.get("companyId"), paramNumbers);
            if (ratePrecision != null) {
                RATE_PRECISION = Integer.parseInt(ratePrecision);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void initListeners() {
        if (this.isContainTaxChange == null) {
            this.isContainTaxChange = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    MakeInvoiceRebateUI.this.initIsContainTax();
                }
            };
        }
        this.chkIsContainTax.addChangeListener(this.isContainTaxChange);
        if (this.txtDiscountRowsChange == null) {
            this.txtDiscountRowsChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    MakeInvoiceRebateUI.this.txtDiscountRows_dataChanged(eventObj);
                }
            };
        }
        this.txtDiscountRows.addDataChangeListener(this.txtDiscountRowsChange);
        if (this.txtDiscountRateChange == null) {
            this.txtDiscountRateChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    MakeInvoiceRebateUI.this.txtDiscountRate_dataChanged();
                }
            };
        }
        this.txtDiscountRate.addDataChangeListener(this.txtDiscountRateChange);
        if (this.txtDiscountAmtChange == null) {
            this.txtDiscountAmtChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    MakeInvoiceRebateUI.this.txtDiscountAmt_dataChanged(eventObj);
                }
            };
        }
        this.txtDiscountAmt.addDataChangeListener(this.txtDiscountAmtChange);
    }

    private void initIsContainTax() {
        this.recalculationAmt();
    }

    private void txtDiscountRows_dataChanged(DataChangeEvent e) {
        int disRows = 1;
        if (e.getNewValue() instanceof Integer) {
            disRows = (Integer)e.getNewValue();
        } else if (e.getNewValue() instanceof BigDecimal) {
            disRows = ((BigDecimal)e.getNewValue()).intValue();
        }
        if (disRows - 1 > this.activeRowIndex) {
            this.txtDiscountRows.setValue(e.getOldValue(), false);
            this.confirmError = true;
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"DiscountRowsTooLarge"));
            return;
        }
        for (int i = 0; i < disRows; ++i) {
            Object amt;
            IRow row = this.kdtEntries.getRow(this.activeRowIndex - i);
            if (!RowType.NORMAL_ROW.equals(row.getCell(TB_BILLROWTYPE).getValue())) {
                this.txtDiscountRows.setValue(e.getOldValue(), false);
                this.confirmError = true;
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"DiscountRows_Error", (Object[])new Object[]{i}));
                return;
            }
            String amtField = TB_NOTAXAMT;
            if (this.chkIsContainTax.isSelected()) {
                amtField = TB_PRICETAX;
            }
            if ((amt = row.getCell(amtField).getValue()) == null || IMUtils.isEmpty(amt.toString())) {
                this.txtDiscountRows.setValue(e.getOldValue(), false);
                this.confirmError = true;
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"REBATE_ERROR_AMTISNULL"));
                return;
            }
            if (new BigDecimal(amt.toString()).compareTo(BigDecimal.ZERO) <= 0) {
                this.txtDiscountRows.setValue(e.getOldValue(), false);
                this.confirmError = true;
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"REBATE_ERROR_AMTNEGATIVE"));
                return;
            }
            StringBuffer sb = new StringBuffer();
            if (row.getCell(TB_PRODUCTNAME).getValue() == null) {
                sb.append(this.getEntryMsg(this.activeRowIndex - i + 1, "TB_PRODUCTNAME"));
            }
            if (row.getCell(TB_TAXAMT).getValue() == null) {
                sb.append(this.getEntryMsg(this.activeRowIndex - i + 1, "TB_TAXAMT"));
            }
            if (row.getCell(TB_TAXCLASSIFICATIONCODE).getValue() == null) {
                sb.append(this.getEntryMsg(this.activeRowIndex - i + 1, "TB_TAXCLASSIFICATIONCODE"));
            }
            if (sb.length() <= 0) continue;
            this.txtDiscountRows.setValue(e.getOldValue(), false);
            this.confirmError = true;
            MsgBox.showError((String)sb.toString());
            return;
        }
        this.recalculationAmt();
    }

    private void recalculationAmt() {
        int disRows = 1;
        if (this.txtDiscountRows.getValue() instanceof Integer) {
            disRows = (Integer)this.txtDiscountRows.getValue();
        } else if (this.txtDiscountRows.getValue() instanceof BigDecimal) {
            disRows = ((BigDecimal)this.txtDiscountRows.getValue()).intValue();
        }
        String amtFieldString = TB_NOTAXAMT;
        BigDecimal proAmt = BigDecimal.ZERO;
        amtFieldString = this.chkIsContainTax.isSelected() ? TB_PRICETAX : TB_NOTAXAMT;
        for (int i = 0; i < disRows; ++i) {
            IRow row = this.kdtEntries.getRow(this.activeRowIndex - i);
            proAmt = proAmt.add((BigDecimal)row.getCell(amtFieldString).getValue());
        }
        proAmt = proAmt.setScale(2, 4);
        this.txtProductAmt.setValue((Object)proAmt, false);
        BigDecimal disRate = (BigDecimal)this.txtDiscountRate.getValue();
        this.txtDiscountAmt.setValue((Object)proAmt.multiply(disRate).divide(new BigDecimal("100"), 10, 4).setScale(2, 4), false);
    }

    private String getEntryMsg(int i, String field) {
        return EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"ENTRYNULL_MSG", (Object[])new Object[]{i, EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)field)});
    }

    private void txtDiscountRate_dataChanged() {
        BigDecimal proAmt = (BigDecimal)this.txtProductAmt.getValue();
        BigDecimal disRate = (BigDecimal)this.txtDiscountRate.getValue();
        this.txtDiscountAmt.setValue((Object)proAmt.multiply(disRate).divide(new BigDecimal("100"), 10, 4).setScale(2, 4), false);
        this.setEnabledOk();
    }

    private void txtDiscountAmt_dataChanged(DataChangeEvent e) {
        BigDecimal proAmt = (BigDecimal)this.txtProductAmt.getValue();
        BigDecimal disAmt = (BigDecimal)e.getNewValue();
        if (disAmt.compareTo(proAmt) > 0) {
            this.txtDiscountAmt.setValue(e.getOldValue(), false);
            this.confirmError = true;
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"DiscountAmt_Error"));
            return;
        }
        this.txtDiscountRate.setValue((Object)disAmt.divide(proAmt, 10, 4).multiply(new BigDecimal("100")).setScale(RATE_PRECISION, 4), false);
        this.setEnabledOk();
    }

    private void initEditor() {
        this.setIntEditor(this.txtDiscountRows);
        this.setBigDecimalEditor(this.txtProductAmt, 2);
        this.setRatioEditor(this.txtDiscountRate, RATE_PRECISION);
        this.setBigDecimalEditor(this.txtDiscountAmt, 2);
        this.setEnabledOk();
    }

    private void initDefaultValue() {
        this.chkIsContainTax.setSelected(this.isContainTax);
        this.txtDiscountRows.setValue((Object)1);
        String amtFieldString = TB_NOTAXAMT;
        BigDecimal proAmt = BigDecimal.ZERO;
        amtFieldString = this.isContainTax ? TB_PRICETAX : TB_NOTAXAMT;
        proAmt = (BigDecimal)this.kdtEntries.getRow(this.activeRowIndex).getCell(amtFieldString).getValue();
        proAmt = proAmt.setScale(2, 4);
        this.txtProductAmt.setValue((Object)proAmt);
        this.txtDiscountRate.setValue((Object)BigDecimal.ZERO);
        this.txtDiscountAmt.setValue((Object)BigDecimal.ZERO);
    }

    private void setBigDecimalEditor(KDFormattedTextField formattedField, int Precision) {
        formattedField.setDataType(1);
        formattedField.setPrecision(Precision);
        formattedField.setNegatived(false);
        formattedField.setSupportedEmpty(false);
        formattedField.setRemoveingZeroInEdit(false);
        formattedField.setRemoveingZeroInDispaly(false);
        formattedField.setHorizontalAlignment(4);
    }

    private void setRatioEditor(KDFormattedTextField formattedField, int Precision) {
        formattedField.setDataType(1);
        formattedField.setPrecision(Precision);
        formattedField.setNegatived(false);
        formattedField.setSupportedEmpty(false);
        formattedField.setRemoveingZeroInEdit(false);
        formattedField.setRemoveingZeroInDispaly(false);
        formattedField.setHorizontalAlignment(4);
        formattedField.setMinimumValue((Comparable)BigDecimal.ZERO);
        formattedField.setMaximumValue((Comparable)new BigDecimal("100"));
    }

    private void setIntEditor(KDFormattedTextField formattedField) {
        formattedField.setDataType(0);
        formattedField.setNegatived(false);
        formattedField.setSupportedEmpty(false);
        formattedField.setHorizontalAlignment(4);
        formattedField.setDecimalSeparatorAlwaysShown(false);
        formattedField.setMinimumValue((Comparable)Integer.valueOf(1));
    }

    private void setEnabledOk() {
        try {
            this.txtDiscountAmt.commitEdit();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        BigDecimal disAmt = BigDecimal.ZERO;
        if (this.txtDiscountAmt.getValue() != null) {
            disAmt = (BigDecimal)this.txtDiscountAmt.getValue();
        }
        if (disAmt.compareTo(BigDecimal.ZERO) > 0) {
            this.kDWorkButton1.setEnabled(true);
        } else {
            this.kDWorkButton1.setEnabled(false);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.confirmError) {
            this.confirmError = false;
            return;
        }
        this.retMap.put("isContainTax", this.chkIsContainTax.isSelected());
        int disRows = 1;
        if (this.txtDiscountRows.getValue() instanceof Integer) {
            disRows = (Integer)this.txtDiscountRows.getValue();
        } else if (this.txtDiscountRows.getValue() instanceof BigDecimal) {
            disRows = ((BigDecimal)this.txtDiscountRows.getValue()).intValue();
        }
        this.retMap.put("disRows", disRows);
        BigDecimal proAmt = (BigDecimal)this.txtProductAmt.getValue();
        this.retMap.put("proAmt", proAmt);
        BigDecimal disRate = (BigDecimal)this.txtDiscountRate.getValue();
        this.retMap.put("disRate", disRate);
        BigDecimal disAmt = (BigDecimal)this.txtDiscountAmt.getValue();
        this.retMap.put("disAmt", disAmt);
        this.setOk(true);
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }
}

