/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.appframework.syncUI.BeanMonitor;
import com.kingdee.bos.appframework.syncUI.BeanPropertyChangeListener;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.ProgressBarDialog;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MyThreadPool {
    private static Set threadSet = new HashSet();
    private static BeanMonitor beanMonitor = null;
    private static KDDialog progressDialog = null;
    protected static KDProgressBar kDProgressBar;
    private static String hint;
    private static boolean enable;

    public static MyThreadPool getInstance() {
        if (progressDialog == null) {
            progressDialog = ProgressBarDialog.getDialogInstance(null);
        } else {
            progressDialog.setLocationRelativeTo(null);
        }
        JPanel contentPane = (JPanel)progressDialog.getContentPane();
        JPanel panel1 = (JPanel)contentPane.getComponent(0);
        panel1.getComponent(1).setVisible(false);
        kDProgressBar = (KDProgressBar)contentPane.getComponent(1);
        kDProgressBar.setStringPainted(true);
        kDProgressBar.setMinimum(0);
        kDProgressBar.setMaximum(100);
        kDProgressBar.setIndeterminate(false);
        kDProgressBar.setValue(0);
        return new MyThreadPool();
    }

    public static Set getCurrentThread() {
        return threadSet;
    }

    public static String getHint() {
        return hint;
    }

    public static boolean isShowDialog() {
        if (beanMonitor != null) {
            return beanMonitor.isShowDialog();
        }
        return false;
    }

    public static void addActionThread(MonitorInfo info) {
        hint = info.getTitle();
        threadSet.add(info);
        MyThreadPool.createBeanMonitor();
        if (info.isDialog()) {
            MyThreadPool.showProgressDialog(info.getUi(), info.getTitle());
        }
        beanMonitor.setRefreshMonitor(MyThreadPool.getCurrentThread().size());
        if (info.getWorker() != null) {
            info.getWorker().start();
        }
    }

    public static void removeActionThread(Object obj) {
        if (!MyThreadPool.getCurrentThread().contains(obj)) {
            return;
        }
        MyThreadPool.getCurrentThread().remove(obj);
        beanMonitor.setRefreshMonitor(MyThreadPool.getCurrentThread().size());
        ((SwingWorker)obj).interrupt();
    }

    private static BeanMonitor createBeanMonitor() {
        if (beanMonitor == null) {
            beanMonitor = new BeanMonitor();
            beanMonitor.addPropertyChangeListener((PropertyChangeListener)new BeanPropertyChangeListener());
        }
        return beanMonitor;
    }

    public static void destroyMonitor() {
        MyThreadPool.destroyMonitor(null);
    }

    public static void destroyMonitor(MonitorInfo info) {
        if (beanMonitor == null) {
            return;
        }
        beanMonitor.setShowDialog(false);
        if (info != null) {
            MyThreadPool.getCurrentThread().remove(info);
            beanMonitor.setRefreshMonitor(MyThreadPool.getCurrentThread().size());
            MyThreadPool.setBackgroundRunButtonEnabled(true);
        }
    }

    public static void showProgressDialog(Object ui, String hint) {
        if (progressDialog == null) {
            progressDialog = ProgressBarDialog.getDialogInstance((Object)ui);
        } else {
            progressDialog.setLocationRelativeTo(null);
        }
        if (beanMonitor == null || beanMonitor.isShowDialog() || progressDialog.isShowing()) {
            return;
        }
        if (hint == null) {
            hint = "";
        }
        progressDialog.setTitle(hint + "...");
        beanMonitor.setShowDialog(true);
        SwingWorker worker = MyThreadPool.getSwingWorker(ui);
        worker.start();
    }

    public static void destroyPorgressDialog() {
        if (progressDialog == null) {
            return;
        }
        progressDialog.dispose();
    }

    private static SwingWorker getSwingWorker(final Object ui) {
        SwingWorker dialogWorker = new SwingWorker(){

            public Object construct() {
                if (progressDialog == null) {
                    return null;
                }
                if (ui != null && CustomerQueryPanel.class.isAssignableFrom(ui.getClass()) && ((JComponent)ui).getParent().getParent() == null) {
                    return null;
                }
                MyThreadPool.setEnabled(enable);
                progressDialog.show();
                return null;
            }
        };
        return dialogWorker;
    }

    public static void setBackgroundRunButtonEnabled(boolean b) {
        enable = b;
        MyThreadPool.setEnabled(b);
    }

    private static void setEnabled(boolean b) {
        if (progressDialog != null) {
            ((ProgressBarDialog)progressDialog).setBackgroundRunButtonEnabled(b);
        }
    }

    public static void refreshProgress(MonitorInfo info, int size) {
        if (progressDialog == null) {
            return;
        }
        if (!progressDialog.isVisible()) {
            SwingWorker worker = MyThreadPool.getSwingWorker(info.getUi());
            worker.start();
        }
        kDProgressBar.setValue(size);
    }

    public static void refreshProgress(int size) {
        if (kDProgressBar != null) {
            kDProgressBar.setValue(size);
        }
    }

    static {
        hint = "";
    }
}

