/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.CtrlPlainDocument;
import com.kingdee.bos.ctrl.swing.ICtrTextDocumentFilter;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTipInfo;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipResourceUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipUtil;
import com.kingdee.eas.tm.im.CombinRuleSettingCollection;
import com.kingdee.eas.tm.im.CombinRuleSettingFactory;
import com.kingdee.eas.tm.im.CombinRuleSettingInfo;
import com.kingdee.eas.tm.im.CombinRuleStatusEnum;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.NumConstantQtyDocumentFilter;
import com.kingdee.eas.tm.im.client.AbstractSelectCombinRuleSchemeUI;
import com.kingdee.eas.tm.im.client.RuleItem;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class SelectCombinRuleSchemeUI
extends AbstractSelectCombinRuleSchemeUI {
    private static final Logger logger = CoreUIObject.getLogger(SelectCombinRuleSchemeUI.class);
    private String srcBosType;
    private String destBosType;
    private boolean isCache = false;
    private Map<String, RuleItem> combinRuleColl = new HashMap<String, RuleItem>();
    private RuleItem srcRule = null;
    private RuleItem destRule = null;
    private Map otherParams = new HashMap();
    private boolean isConfirm = false;
    private ItemListener isConstantQtyChange = null;
    private static NumConstantQtyDocumentFilter constantQtyDocumentFilter = new NumConstantQtyDocumentFilter();

    public SelectCombinRuleSchemeUI(String srcBosType, String destBosType, boolean isCache) throws Exception {
        this.srcBosType = srcBosType;
        this.destBosType = destBosType;
        this.isCache = isCache;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    protected void addCustomerToolTip() {
        TMToolTipUtil.setToolTipInfo((JComponent)this.contLabel, (TMToolTipInfo)new TMToolTipInfo("contLabel", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("SELECTCOMBINRULESCHEMEUI_isConstantQty"), (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("OPERATIONTITLE") + ";" + "https://vip.kingdee.com/article/465113052589732864"));
    }

    protected void initListener() {
        if (this.isConstantQtyChange == null) {
            this.isConstantQtyChange = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    SelectCombinRuleSchemeUI.this.chkIsConstantQty_change(arg0);
                }
            };
        }
        this.chkIsConstantQty.addItemListener(this.isConstantQtyChange);
    }

    private void initUI() throws BOSException {
        HashSet<String> bosType = new HashSet<String>();
        bosType.add(this.destBosType);
        bosType.add(this.srcBosType);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billBosType", bosType, CompareType.INCLUDE));
        ev.setFilter(filter);
        CombinRuleSettingCollection combinRuleCollection = CombinRuleSettingFactory.getRemoteInstance().getCombinRuleSettingCollection(ev);
        for (int i = 0; i < combinRuleCollection.size(); ++i) {
            CombinRuleSettingInfo info = combinRuleCollection.get(i);
            RuleItem item = this.buildRule(info);
            this.combinRuleColl.put(info.getId().toString(), item);
            if (CombinRuleStatusEnum.FORBIDDEN.equals((Object)info.getStatus())) continue;
            if (this.destBosType.equals(info.getBillBosType())) {
                this.comboDestRule.addItem((Object)item);
                continue;
            }
            this.comboSrcRule.addItem((Object)item);
        }
        this.initConstantQtyEx();
        this.initConstantQty();
        this.addCustomerToolTip();
    }

    protected void initConstantQtyEx() {
        ((CtrlPlainDocument)this.numConstantQty.getDocument()).setCtrTextDocumentFilter(null);
        ((CtrlPlainDocument)this.numConstantQty.getDocument()).setCtrTextDocumentFilter((ICtrTextDocumentFilter)constantQtyDocumentFilter);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SelectCombinRuleSchemeUI.this.contLabel.requestFocus();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    protected void initConstantQty() {
        this.chkIsConstantQty.setSelected(false);
        this.kDLabelConstantQty.setVisible(false);
        this.numConstantQty.setValue((Object)BigDecimal.ONE);
        this.numConstantQty.setPrecision(2);
    }

    private RuleItem buildRule(CombinRuleSettingInfo info) {
        String id = info.getId().toString();
        String name = info.getRuleName();
        RuleItem item = new RuleItem();
        String fieldsName = "";
        fieldsName = info.getCombinFieldsName() != null ? fieldsName + info.getCombinFieldsName() + ";" : fieldsName + ";";
        if (info.getSplitFieldsName() != null) {
            fieldsName = fieldsName + info.getSplitFieldsName();
        }
        item.setId(id);
        item.setRuleName(name);
        item.setFieldsName(fieldsName);
        return item;
    }

    protected void chkIsConstantQty_change(ItemEvent e) {
        boolean selected = e.getStateChange() != 2;
        this.kDLabelConstantQty.setVisible(selected);
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.comboSrcRule.getSelectedItem() != null) {
            this.setSrcRule((RuleItem)this.comboSrcRule.getSelectedItem());
        }
        if (this.comboDestRule.getSelectedItem() != null) {
            this.setDestRule((RuleItem)this.comboDestRule.getSelectedItem());
        }
        this.checkConstantQtyRequired();
        this.setIsComfirm(true);
        HashMap<String, Comparable<Boolean>> otherParams = new HashMap<String, Comparable<Boolean>>();
        if (this.chkIsConstantQty.isSelected()) {
            otherParams.put("isConstantQty", Boolean.valueOf(true));
            otherParams.put("constantQty", this.numConstantQty.getBigDecimalValue());
        } else {
            otherParams.put("isConstantQty", Boolean.valueOf(false));
        }
        this.setOtherParams(otherParams);
        this.actionExitCurrent_actionPerformed(e);
    }

    protected void checkConstantQtyRequired() throws IMException {
        BigDecimal constantQty = this.numConstantQty.getBigDecimalValue();
        boolean isConstantQty = this.chkIsConstantQty.isSelected();
        if (isConstantQty && constantQty == null) {
            String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMCommonResource", (String)"constantQty_required");
            throw new IMException(IMException.ERRORMSG, new Object[]{msg});
        }
    }

    @Override
    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.exitSaveSolution();
        Util.getWindow((Component)((Object)this)).dispose();
    }

    protected void exitSaveSolution() {
        if (!this.isCache) {
            return;
        }
        CommonQueryPanel queryPanel = this.getCommonQueryPanel();
        QuerySolutionInfo solution = queryPanel.getCurrentSolution();
        String queryName = queryPanel.getQueryPK().getFullName();
        String parentUIName = CoreBillListUI.class.getName();
        int tempt = queryPanel.getRealRowCount();
        if (solution.getId() == null) {
            solution.setRowCount(tempt);
            return;
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (!StringUtils.equals((String)userId, (String)StringUtils.cnulls((Object)solution.getOwner()))) {
            return;
        }
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            if (queryPanel.getSolutionListPanel() != null) {
                QuerySolutionCollection coll = queryPanel.getSolutionListPanel().getAllSolutionCollection();
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    QuerySolutionInfo tmpInfo = coll.get(i);
                    if (!tmpInfo.getId().toString().equals(solution.getId().toString())) {
                        tmpInfo.setIsUserDefaultSolu(false);
                        iQuerySolution.saveDefaultSolution(tmpInfo.getId().toString(), parentUIName, queryName, tempt, false);
                        continue;
                    }
                    if (!tmpInfo.getId().toString().equals(solution.getId().toString())) continue;
                    tmpInfo.setIsUserDefaultSolu(true);
                    tmpInfo.setRowCount(tempt);
                    iQuerySolution.saveDefaultSolution(tmpInfo.getId().toString(), parentUIName, queryName, tempt, true);
                }
            }
        }
        catch (EASBizException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        solution.setIsUserDefaultSolu(true);
        solution.setRowCount(tempt);
    }

    public boolean getIsComfirm() {
        return this.isConfirm;
    }

    public void setIsComfirm(boolean comfirm) {
        this.isConfirm = comfirm;
    }

    public RuleItem getSrcRule() {
        return this.srcRule;
    }

    public void setSrcRule(RuleItem srcRule) {
        this.srcRule = srcRule;
    }

    public RuleItem getDestRule() {
        return this.destRule;
    }

    public void setDestRule(RuleItem destRule) {
        this.destRule = destRule;
    }

    public Map getOtherParams() {
        return this.otherParams;
    }

    public void setOtherParams(Map otherParams) {
        this.otherParams = otherParams;
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        RptParams params = new RptParams();
        if (this.comboSrcRule.getSelectedItem() != null) {
            String srcRuleId = ((RuleItem)this.comboSrcRule.getSelectedItem()).getId();
            params.setObject("srcRule", (Object)srcRuleId);
        } else {
            params.setObject("srcRule", null);
        }
        if (this.comboDestRule.getSelectedItem() != null) {
            String destRuleId = ((RuleItem)this.comboDestRule.getSelectedItem()).getId();
            params.setObject("destRule", (Object)destRuleId);
        } else {
            params.setObject("destRule", null);
        }
        try {
            this.checkConstantQtyRequired();
        }
        catch (IMException e) {
            MsgBox.showInfo((String)e.getMessage());
            SysUtil.abort();
        }
        if (this.chkIsConstantQty.isSelected()) {
            params.setObject("isConstantQty", (Object)true);
            params.setObject("constantQty", (Object)this.numConstantQty.getBigDecimalValue());
        } else {
            params.setObject("isConstantQty", (Object)false);
            params.setObject("constantQty", (Object)BigDecimal.ONE);
        }
        return params;
    }

    public void setCustomCondition(RptParams params) {
        CommonQueryPanel queryPanel = this.getCommonQueryPanel();
        if (queryPanel.getSolutionListPanel() == null) {
            return;
        }
        boolean isContinue = this.setCustomCombinRuleCondition(params, "srcRule");
        if (isContinue) {
            this.setCustomCombinRuleCondition(params, "destRule");
        }
        this.setCustomConstantQty(params);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean setCustomCombinRuleCondition(RptParams params, String rule) {
        try {
            if (params.getObject(rule) != null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                String ruleId = (String)params.getObject(rule);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)ruleId, CompareType.EQUALS));
                view.setFilter(filter);
                CombinRuleSettingCollection coll = CombinRuleSettingFactory.getRemoteInstance().getCombinRuleSettingCollection(view);
                if (coll != null && coll.size() > 0) {
                    CombinRuleSettingInfo info = coll.get(0);
                    if (CombinRuleStatusEnum.FORBIDDEN.equals((Object)info.getStatus())) {
                        this.comboSrcRule.setSelectedItem(null);
                        this.comboDestRule.setSelectedItem(null);
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.IMCommonResource", (String)"SoluRuleToActive"));
                        return false;
                    }
                    if ("srcRule".equals(rule)) {
                        this.comboSrcRule.setSelectedItem((Object)this.combinRuleColl.get(info.getId().toString()));
                        return true;
                    }
                    if (!"destRule".equals(rule)) return true;
                    this.comboDestRule.setSelectedItem((Object)this.combinRuleColl.get(info.getId().toString()));
                    return true;
                }
                this.comboSrcRule.setSelectedItem(null);
                this.comboDestRule.setSelectedItem(null);
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.IMCommonResource", (String)"SoluRuleToDel"));
                return false;
            }
            if ("srcRule".equals(rule)) {
                this.comboSrcRule.setSelectedItem(null);
                return true;
            }
            if (!"destRule".equals(rule)) return true;
            this.comboDestRule.setSelectedItem(null);
            return true;
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void setCustomConstantQty(RptParams params) {
        boolean isConstantQty = false;
        if (params.getObject("isConstantQty") != null && ((Boolean)params.getObject("isConstantQty")).booleanValue()) {
            isConstantQty = true;
        }
        if (isConstantQty) {
            this.chkIsConstantQty.setSelected(true);
            this.kDLabelConstantQty.setVisible(true);
            if (params.getObject("constantQty") != null) {
                this.numConstantQty.setValue((Object)((BigDecimal)params.getObject("constantQty")));
            } else {
                this.numConstantQty.setValue((Object)BigDecimal.ONE);
            }
        } else {
            this.chkIsConstantQty.setSelected(false);
            this.kDLabelConstantQty.setVisible(false);
            this.numConstantQty.setValue((Object)BigDecimal.ONE);
        }
    }

    public void clear() {
        if (this.comboSrcRule.getItemCount() > 0) {
            this.comboSrcRule.setSelectedIndex(0);
        }
        if (this.comboDestRule.getItemCount() > 0) {
            this.comboDestRule.setSelectedIndex(0);
        }
        this.initConstantQty();
    }
}

