/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.tm.im.FilterCommonStatusEnum;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.client.AbstractTaxTransferFilterUI;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class TaxTransferFilterUI
extends AbstractTaxTransferFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxTransferFilterUI.class);

    public TaxTransferFilterUI() throws Exception {
        this.getElementsInfo();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadStatus();
    }

    protected void setDefaultValue() {
        SCMQueryFormat.formatStartTime((KDDatePicker)this.transferDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.transferDateTo);
        this.txtNumber.setText(null);
        this.kDTextInvoiceCode.setText(null);
        this.kDTextInvoiceNumber.setText(null);
        this.prmtTaxPeriod.setText(null);
    }

    private void loadStatus() {
        this.kDComboStatus.removeAllItems();
        this.kDComboStatus.addItem((Object)FilterCommonStatusEnum.NULL);
        this.kDComboStatus.addItem((Object)InvoiceBillStatus.TEMPSTROE);
        this.kDComboStatus.addItem((Object)InvoiceBillStatus.SUBMITED);
        this.kDComboStatus.addItem((Object)InvoiceBillStatus.AUDITED);
    }

    public void afterMainOrgChanged(String ids) {
        if (ids == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
            idSet.add(info.getAccountPeriodType().getId().toString());
        } else {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("accountPeriodType.*"));
            viewInfo.setSelector(sic);
            try {
                CompanyOrgUnitCollection collection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(viewInfo);
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    idSet.add(collection.get(i).getAccountPeriodType().getId().toString());
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (idSet.size() != 0) {
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            this.prmtTaxPeriod.setEntityViewInfo(view);
            this.prmtTaxPeriod.setValue(null);
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected String getViewPermission() {
        return "im_taxTransfer_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "company.id";
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        RangeFilterElement transferDateElements = new RangeFilterElement("transferDate", (Component)this.transferDateFrom, (Component)this.transferDateTo);
        transferDateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)transferDateElements);
        elements.add((FilterElement)new SingleFilterElement("status", (Component)this.kDComboStatus, (Object)FilterCommonStatusEnum.NULL));
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("company.id", (Component)this.prmtCompany);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, SCMClientUtils.getResource((String)"MAINBIZORGISNULL")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "company.id");
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        FilterInfo newFilterInfo = new FilterInfo();
        PeriodInfo periodInfo = (PeriodInfo)this.prmtTaxPeriod.getValue();
        if (periodInfo != null) {
            newFilterInfo.getFilterItems().add(new FilterItemInfo("taxPeriod.number", (Object)periodInfo.getNumber(), CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((String)this.txtNumber.getText())) {
            newFilterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + this.txtNumber.getText() + "%"), CompareType.LIKE));
        }
        if (!StringUtils.isEmpty((String)this.kDTextInvoiceCode.getText())) {
            newFilterInfo.getFilterItems().add(new FilterItemInfo("entries.invoiceCode", (Object)("%" + this.kDTextInvoiceCode.getText() + "%"), CompareType.LIKE));
        }
        if (!StringUtils.isEmpty((String)this.kDTextInvoiceNumber.getText())) {
            newFilterInfo.getFilterItems().add(new FilterItemInfo("entries.invoiceNumber", (Object)("%" + this.kDTextInvoiceNumber.getText() + "%"), CompareType.LIKE));
        }
        try {
            filterInfo.mergeFilter(newFilterInfo, "and");
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        FilterItemCollection filters = entityViewInfo.getFilter().getFilterItems();
        Object obj = IMUtils.getCompareValue(filters, "taxPeriod.number", CompareType.EQUALS);
        if (obj != null) {
            this.prmtTaxPeriod.setText(obj.toString());
        } else {
            this.prmtTaxPeriod.setText(null);
        }
        obj = IMUtils.getCompareValue(filters, "number", CompareType.LIKE);
        if (obj != null) {
            this.txtNumber.setText(obj.toString().split("%")[1]);
        } else {
            this.txtNumber.setText(null);
        }
        obj = IMUtils.getCompareValue(filters, "entries.invoiceCode", CompareType.LIKE);
        if (obj != null) {
            this.kDTextInvoiceCode.setText(obj.toString().split("%")[1]);
        } else {
            this.kDTextInvoiceCode.setText(null);
        }
        obj = IMUtils.getCompareValue(filters, "entries.invoiceNumber", CompareType.LIKE);
        if (obj != null) {
            this.kDTextInvoiceNumber.setText(obj.toString().split("%")[1]);
        } else {
            this.kDTextInvoiceNumber.setText(null);
        }
    }
}

