/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.util.BizOrgEnum;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.tm.common.help.msgHelp.client.TMMsgBox;
import com.kingdee.eas.tm.common.help.msgHelp.client.util.TMMsgURLUtil;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.TaxTransferFactory;
import com.kingdee.eas.tm.im.client.AbstractTaxTransferListUI;
import com.kingdee.eas.tm.im.client.TaxTransferFilterUI;
import com.kingdee.eas.tm.im.client.comp.IProgressMonitor;
import com.kingdee.eas.tm.im.client.comp.IRunnableWithProgress;
import com.kingdee.eas.tm.im.client.comp.ProgressDialog;
import com.kingdee.eas.tm.im.client.comp.ProgressDialogHelper;
import com.kingdee.eas.tm.im.common.IMCommonProcessor;
import com.kingdee.eas.tm.im.common.print.IMPrintCommonDataProvider;
import com.kingdee.eas.tm.im.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TaxTransferListUI
extends AbstractTaxTransferListUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxTransferListUI.class);
    public CommonQueryDialog commonQueryDialog = null;
    private TaxTransferFilterUI filterUI = null;
    private ListUIHelper uiHelper = null;
    private ProgressDialog progressDialog = null;
    QuickFilteringSupportItems qsi = new QuickFilteringSupportItems(true, true);

    public TaxTransferListUI() throws Exception {
        this.uiHelper = new ListUIHelper((ListUI)this);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnAudit.addAssistMenuItem((JMenuItem)IMUtils.cloneMenuItem(this.menuUnAudit));
    }

    public void onLoad() throws Exception {
        this.setDefaultQuickFilterInfo();
        super.onLoad();
        String[] amtfields = new String[]{"totalTaxAmount", "entries.tax", "entries.amount"};
        for (int i = 0; i < amtfields.length; ++i) {
            this.tblMain.getColumn(amtfields[i]).getStyleAttributes().setNumberFormat("#,##0.00");
            this.tblMain.getColumn(amtfields[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        String[] zerofields = new String[]{"entries.proportion"};
        for (int i = 0; i < zerofields.length; ++i) {
            this.tblMain.getColumn(zerofields[i]).getStyleAttributes().setNumberFormat("%{0.##########}f");
            this.tblMain.getColumn(zerofields[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        this.appendFootRow();
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    protected void setDefaultQuickFilterInfo() {
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null) {
            qfsi.getSystemSolutionItem().getDefaultFilter().add("company.id", CompareType.EQUALS, (Object)BizOrgEnum.DEFAULTMAINORG).add("transferDate", CompareType.GREATER_EQUALS, (Object)SCMUtils.getSCMQueryTime((Date)new Date(), (String)"startDate")).add("transferDate", CompareType.LESS_EQUALS, (Object)SCMUtils.getSCMQueryTime((Date)new Date(), (String)"endDate"));
        }
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        if (this.getUIContext().get("ExchangeFilter") == null) {
            return this.qsi;
        }
        return null;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    protected String getEditUIName() {
        return "com.kingdee.eas.tm.im.client.TaxTransferEditUI";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TaxTransferFactory.getRemoteInstance();
    }

    @Override
    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"id", "company.name", "number", "transferDate", "taxPeriod.number", "totalTaxAmount", "taxTransferItem.name", "status", "srcType", "fiVouchered", "voucherType.name", "voucher.number", "creator.name", "auditor.name", "remark", "auditTime", "lastUpdate.name", "lastUpdateTime", "createTime"};
        return columns;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            if (this.getUIContext().get("OwnerWindow") == null) {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            try {
                this.commonQueryDialog.setProcessor((IProcessor)new IMCommonProcessor());
                ISCMFilter filterUI = (ISCMFilter)this.getFilterUI();
                filterUI.setIsSupportMultiOrgs(true);
                this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            this.commonQueryDialog.setWidth(510);
            this.commonQueryDialog.setHeight(320);
        }
        return this.commonQueryDialog;
    }

    private CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new TaxTransferFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.dispatchActionInProgress(e, "submit");
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.dispatchActionInProgress(e, "passAudit");
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.dispatchActionInProgress(e, "unpassAudit");
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        String status = ListUiHelper.getSelectedKeyValue((int[])selectRows, (KDTable)this.tblMain, (String)"status");
        if (InvoiceBillStatus.AUDITED.getAlias().equals(status)) {
            MsgBox.showWarning((String)(InvoiceBillStatus.AUDITED.getAlias() + EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"CANNOTEDIT")));
            return;
        }
        String companyId = ListUiHelper.getSelectedKeyValue((int[])selectRows, (KDTable)this.tblMain, (String)"company.id");
        String companyName = ListUiHelper.getSelectedKeyValue((int[])selectRows, (KDTable)this.tblMain, (String)"company.name");
        HashSet<String> companyIds = new HashSet<String>();
        companyIds.add(companyId);
        if (!IncomeInvoiceFactory.getRemoteInstance().checkPermission(companyIds, "im_taxTransfer_update")) {
            throw new IMException(IMException.CHECK_EDIT, new Object[]{companyName});
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int size = this.tblMain.getSelectManager().size();
        HashSet<String> companySet = new HashSet<String>();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                String status = this.tblMain.getRow(i).getCell("status").getValue().toString();
                String companyId = this.tblMain.getRow(i).getCell("company.id").getValue().toString();
                companySet.add(companyId);
                if (status.equals(InvoiceBillStatus.AUDITED.getAlias())) continue;
                throw new IMException(IMException.GENERATE_VOUCHER_CHECK);
            }
        }
        if (companySet.size() > 1) {
            throw new IMException(IMException.GENERALVOUCHERVALID);
        }
        if (companySet.iterator().hasNext()) {
            String companyId = (String)companySet.iterator().next();
            PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(companyId), "im_taxTransfer_generalvoucher");
        }
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.actionDelVoucher_actionPerformed(e, this.tblMain, "company.id", "im_taxTransfer_deletevoucher");
        super.actionDelVoucher_actionPerformed(e);
    }

    private void dispatchActionInProgress(ActionEvent e, String actionName) {
        if (this.progressDialog == null) {
            this.progressDialog = ProgressDialogHelper.createProgressDialog((CoreUI)this, true);
        }
        this.progressDialog.run(false, true, this.getRunnableWithProgress(e, actionName));
    }

    protected IRunnableWithProgress getRunnableWithProgress(final ActionEvent e, final String actionName) {
        return new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(TaxTransferListUI.this.uiHelper.getActionName(e), -1);
                    TaxTransferListUI.this.dispatchAction(actionName);
                    monitor.done();
                }
                catch (Exception e2) {
                    logger.error((Object)e2);
                    monitor.done();
                    TaxTransferListUI.this.handUIException(e2);
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchAction(String method) throws Exception {
        int failedLock;
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        Map numMap = this.getSelectedIdNumber();
        String[] idArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            idArray[i] = (String)list.get(i);
        }
        if ("passAudit".equals(method) && SCMClientUtils.checkAllBizObjInWfProcess((String[])idArray)) {
            this.actionMultiapprove_actionPerformed(null);
            this.actionRefresh_actionPerformed(null);
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        int total = list.size();
        int failed = 0;
        ArrayList<String> errorMsg = new ArrayList<String>();
        try {
            Map result;
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)list);
            Set idSet = map.keySet();
            ArrayList<String> lockIdList = new ArrayList<String>();
            failedLock = 0;
            for (Object id : idSet) {
                if (!((Boolean)map.get(id)).booleanValue()) {
                    errorMsg.add(numMap.get(id) + ":" + EASResource.getString((String)"com.kingdee.eas.scm.common.ActionResource.ERROR_MUTEX"));
                    ++failedLock;
                    continue;
                }
                lockIdList.add((String)id);
            }
            if (lockIdList.size() > 0 && !"0".equals((result = IMFacadeFactory.getRemoteInstance().batchOperation("573282EF", method, lockIdList.toArray(new String[lockIdList.size()]))).get("ERROR_COUNT"))) {
                for (Object cause : result.keySet()) {
                    if ("ERROR_COUNT".equals(cause.toString())) {
                        failed = Integer.parseInt(result.get(cause).toString());
                        continue;
                    }
                    errorMsg.add(numMap.get(cause.toString()) + ":" + result.get(cause).toString() + "\r\n");
                }
            }
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)list);
        }
        String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"BATCHACTION_MSG", (Object[])new Object[]{total, total - (failed += failedLock), failed});
        String detail = IMUtils.buildErrorMsg(errorMsg);
        TaxTransferListUI owner = this;
        final boolean hasFailed = failed > 0;
        SwingUtilities.invokeLater(new Runnable((CoreUI)owner, msg, detail){
            final /* synthetic */ CoreUI val$owner;
            final /* synthetic */ String val$msg;
            final /* synthetic */ String val$detail;
            {
                this.val$owner = coreUI;
                this.val$msg = string;
                this.val$detail = string2;
            }

            @Override
            public void run() {
                if (hasFailed) {
                    TMMsgBox.showDetailAndOK((Component)this.val$owner, (String)this.val$msg, (String)this.val$detail, (int)1, (Map)TMMsgURLUtil.getMsgURL((String)"IMS"));
                }
                try {
                    TaxTransferListUI.this.refreshList();
                }
                catch (Exception e) {
                    TaxTransferListUI.this.handUIException(e);
                }
            }
        });
    }

    @Override
    public void actionMultiPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValuesArrayList();
        String tdFileName = "/TM/IM/IncomeInvoice/TaxTransferPrintList";
        KDNoteHelper appHlp = new KDNoteHelper();
        IMPrintCommonDataProvider data = new IMPrintCommonDataProvider(appHlp, BOSObjectType.create((String)"573282EF"), idList);
        appHlp.print(tdFileName, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionMultiPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValuesArrayList();
        String tdFileName = "/TM/IM/IncomeInvoice/TaxTransferPrintList";
        KDNoteHelper appHlp = new KDNoteHelper();
        IMPrintCommonDataProvider data = new IMPrintCommonDataProvider(appHlp, BOSObjectType.create((String)"573282EF"), idList);
        appHlp.printPreview(tdFileName, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }
}

