/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client.comp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tm.common.help.msgHelp.client.util.TMMsgURLUtil;
import com.kingdee.eas.tm.im.IMInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.InvoiceRespInfo;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.MakeInvoiceReqCollection;
import com.kingdee.eas.tm.im.MakeInvoiceReqFactory;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.client.comp.MakeVolumnInvoiceClientService;
import com.kingdee.eas.tm.im.client.util.IMClientUtils;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoicePwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.common.uihelper.IAsyncJob;
import com.kingdee.eas.tm.im.common.uihelper.UIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.tm.im.util.invoice.MakeInvoiceClientService;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MakeInvoiceReqHelper {
    private CoreUI comp = null;
    private UIHelper uiHelper = null;
    private int invoicePercent = 0;

    public MakeInvoiceReqHelper(CoreUI comp, int invoicePercent) {
        this.comp = comp;
        this.invoicePercent = invoicePercent;
        this.uiHelper = new UIHelper(comp);
    }

    public void doMakeInvoice(ActionEvent e, final int makeInvType, final int invoiceType, final ArrayList ids, final IAsyncJob job) throws Exception {
        if (this.comp instanceof CoreBillListUI) {
            ((CoreBillListUI)this.comp).checkSelected();
        } else if (this.comp instanceof CoreBillEditUI) {
            ((CoreBillEditUI)this.comp).checkSelected();
        }
        if (ids == null || ids.size() == 0) {
            return;
        }
        int retValue = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"TO_MAKEINVOICE"));
        if (retValue == 2) {
            return;
        }
        HashMap combinRuleParams = (HashMap)this.uiHelper.chooseCombinRule(this.comp, "AC368D2D");
        if (combinRuleParams == null) {
            return;
        }
        HashMap ruleIDs = (HashMap)combinRuleParams.get("ruleIDs");
        Map otherParams = (Map)combinRuleParams.get("otherParams");
        StringBuffer paramID = new StringBuffer();
        for (int i = 0; i < ids.size(); ++i) {
            paramID.append(ids.get(i)).append(",");
        }
        final MakeInvoiceParam param = new MakeInvoiceParam();
        param.setBilBillIds(paramID.toString());
        param.setInvoiceType(invoiceType + "");
        param.setPrint(false);
        param.setReq(makeInvType == 2);
        param.setRuleIDs(ruleIDs);
        param.setSrcBosType("AC368D2D");
        param.setSrcSystem(IMConstant.SRCTYPE_IM_INVOICEREQ);
        param.setOtherParams(otherParams);
        this.uiHelper.doInDeamon(e, new IAsyncJob(){

            @Override
            public CoreUI getOwner() {
                return MakeInvoiceReqHelper.this.comp;
            }

            @Override
            public int getProgress() {
                return MakeInvoiceReqHelper.this.invoicePercent;
            }

            @Override
            public Object execute() {
                try {
                    MakeInvoiceReqHelper.this.innerMakeInvoiceWithLock(makeInvType, invoiceType, ids.size(), param, ids);
                    job.execute();
                }
                catch (Exception e) {
                    MakeInvoiceReqHelper.this.comp.handUIException((Throwable)e);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerMakeInvoiceWithLock(int makeInvType, int invoiceType, int billSize, MakeInvoiceParam param, List ids) throws BOSException, EASBizException, JSONException {
        try {
            IMUtils.tryLock(ids);
            this.innerMakeInvoice(makeInvType, invoiceType, billSize, param, ids);
        }
        finally {
            IMUtils.releaseLock(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerMakeInvoice(int makeInvType, int invoiceType, int billSize, MakeInvoiceParam param, List ids) throws BOSException, EASBizException, JSONException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        HashSet idSet = new HashSet();
        idSet.addAll(ids);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company"));
        view.setSelector(sic);
        MakeInvoiceReqCollection mkReqColl = MakeInvoiceReqFactory.getRemoteInstance().getMakeInvoiceReqCollection(view);
        IObjectPK logPk = null;
        HashMap<String, IObjectPK> logMap = new HashMap<String, IObjectPK>();
        String logItemName = "im_makeInvoiceReq_oneKeyInvoice";
        if (makeInvType == 2) {
            logItemName = "im_makeInvoiceReq_invoice";
        } else if (makeInvType == 3) {
            logItemName = "im_makeInvoiceReq_oneKeyVolInv";
        }
        MakeInvoiceReqInfo makeInvoiceReqInfo = null;
        int j = mkReqColl.size();
        for (int i = 0; i < j; ++i) {
            makeInvoiceReqInfo = mkReqColl.get(i);
            logPk = LogUtils.beginLog(null, "invoiceReq", BOSObjectType.create((String)"AC368D2D"), (IObjectPK)new ObjectUuidPK(makeInvoiceReqInfo.getId().toString()), makeInvoiceReqInfo.getNumber(), logItemName, makeInvoiceReqInfo.getCompany().getId().toString());
            logMap.put(makeInvoiceReqInfo.getId().toString(), logPk);
        }
        InvoiceRespInfo resp = IMInvoiceFacadeFactory.getRemoteInstance().makeInvoice(param);
        String errorMsg = resp.getErrorMsg();
        ArrayList mkBillIds = resp.getMkSucessBillIds();
        ArrayList mkfailBills = resp.getMkFailBills();
        ArrayList arFailBills = resp.getBizFailBills();
        if (logMap.size() > 0) {
            int j2 = arFailBills.size();
            for (int i = 0; i < j2; ++i) {
                logMap.remove(String.valueOf(arFailBills.get(i)));
            }
            for (Map.Entry entry : logMap.entrySet()) {
                LogUtils.afterLog(null, (IObjectPK)entry.getValue());
            }
        }
        StringBuffer mkmsg = new StringBuffer();
        PwyServiceType serviceType = PwyServiceType.OPR_INV_PAPER_MAKE;
        if (invoiceType == 3 || invoiceType == 5 || invoiceType == 6) {
            serviceType = PwyServiceType.OPR_INV_DISKELECT_MAKE;
        }
        if (makeInvType == 2) {
            String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"MKINVOICEREQ_MSG", (Object[])new Object[]{billSize - arFailBills.size(), arFailBills.size()});
            IMClientUtils.showMsgAfterCurrentThread((Component)this.comp, msg, resp.getErrorMsg() + mkmsg.toString(), 1, TMMsgURLUtil.getMsgURL((String)"IMK"));
        } else if (mkBillIds.size() == 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"ALL_MAKEINVOICE_REQ_MSG", (Object[])new Object[]{billSize - arFailBills.size(), arFailBills.size(), mkBillIds.size(), mkfailBills.size()});
            IMClientUtils.showMsgAfterCurrentThread((Component)this.comp, msg, resp.getErrorMsg() + mkmsg.toString(), 1, TMMsgURLUtil.getMsgURL((String)"IMK"));
        } else {
            try {
                IMUtils.tryLock(mkBillIds);
                if (makeInvType == 3) {
                    HashMap<String, Object> msgParam = new HashMap<String, Object>();
                    msgParam.put("billSize", billSize);
                    msgParam.put("fromSrc", IMConstant.SRCTYPE_IM_INVOICEREQ);
                    msgParam.put("mkBillIds", mkBillIds);
                    msgParam.put("mkfailBills", mkfailBills);
                    msgParam.put("srcFailBills", arFailBills);
                    msgParam.put("logMap", logMap);
                    MakeVolumnInvoiceClientService service = new MakeVolumnInvoiceClientService(this.comp, msgParam);
                    service.invoice(mkBillIds);
                } else {
                    this.doMakeInvoiceRequest(billSize, logMap, resp, mkBillIds, mkfailBills, arFailBills, mkmsg, serviceType);
                }
            }
            finally {
                IMUtils.releaseLock(mkBillIds);
            }
        }
    }

    protected void doMakeInvoiceRequest(int billSize, HashMap<String, IObjectPK> logMap, InvoiceRespInfo resp, ArrayList mkBillIds, ArrayList mkfailBills, ArrayList arFailBills, StringBuffer mkmsg, PwyServiceType serviceType) throws BOSException, EASBizException {
        ArrayList list = IMInvoiceFacadeFactory.getRemoteInstance().buildPwyParam(mkBillIds, serviceType, TransSrcSystemEnum.easgui);
        int total = mkBillIds.size() + mkfailBills.size();
        int sucess = 0;
        BigDecimal a = new BigDecimal(90);
        BigDecimal b = new BigDecimal(list.size());
        BigDecimal c = BigDecimal.ZERO;
        if (list.size() > 0) {
            c = a.divide(b, 2, RoundingMode.HALF_UP);
        }
        for (int i = 0; i < list.size(); ++i) {
            this.invoicePercent = 10 + c.multiply(new BigDecimal(i)).intValue();
            Map resultMap = (Map)list.get(i);
            if (resultMap.get("error") != null) {
                String id = resultMap.get("error").toString();
                if (id.equals("exception")) {
                    mkmsg.append(resultMap.get("exception") + "\r\n");
                    continue;
                }
                mkmsg.append(resultMap.get("number") + ":" + resultMap.get(id) + "\r\n");
                continue;
            }
            String invoiceNum = (String)resultMap.get("number");
            PwyInvokeParam invokeParam = (PwyInvokeParam)resultMap.get("invokeParam");
            MakeInvoicePwyService pwyService = (MakeInvoicePwyService)PwyServiceHelper.getPwyService(null, invokeParam);
            pwyService.invoke();
            if (pwyService.isSuccess()) {
                ++sucess;
                continue;
            }
            if (mkmsg.length() == 0) {
                mkmsg.append("\r\n").append(EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"MAKEINVOICE_ERROR")).append("\r\n");
            }
            mkmsg.append(invoiceNum).append("-").append(pwyService.getInvokeParam().getDescription()).append("\r\n");
        }
        String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"ALL_MAKEINVOICE_REQ_MSG", (Object[])new Object[]{billSize - arFailBills.size(), arFailBills.size(), sucess, total - sucess});
        String detailMsg = resp.getErrorMsg() + mkmsg.toString();
        IMClientUtils.showMsgAfterCurrentThread((Component)this.comp, msg, detailMsg, 1, TMMsgURLUtil.getMsgURL((String)"IMK"));
    }

    public void doInvoicePrintWithLock(ActionEvent e, final boolean isPrintList, final boolean isRePrint, final ArrayList ids) throws Exception {
        this.uiHelper.doInDeamon(e, new IAsyncJob(){

            @Override
            public CoreUI getOwner() {
                return MakeInvoiceReqHelper.this.comp;
            }

            @Override
            public int getProgress() {
                return MakeInvoiceReqHelper.this.invoicePercent;
            }

            @Override
            public Object execute() {
                try {
                    MakeInvoiceReqHelper.this.doPrintInvoice(isPrintList, isRePrint, ids);
                }
                catch (Exception e) {
                    MakeInvoiceReqHelper.this.comp.handUIException((Throwable)e);
                }
                return null;
            }
        });
    }

    private void doPrintInvoice(boolean isPrintList, boolean isRePrint, ArrayList ids) throws EASBizException, BOSException, JSONException {
        if (this.comp instanceof CoreBillListUI) {
            ((CoreBillListUI)this.comp).checkSelected();
        } else if (this.comp instanceof CoreBillEditUI) {
            ((CoreBillEditUI)this.comp).checkSelected();
        }
        MakeInvoiceClientService service = new MakeInvoiceClientService();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("coreUI", this.comp);
        params.put("ids", ids);
        params.put("isPrintList", isPrintList);
        params.put("isRePrint", isRePrint);
        params.put("sourceType", "makeInvoiceReq");
        service.doInvoicePrint(params);
    }
}

