/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client.comp;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tm.im.client.comp.IProgressMonitor;
import com.kingdee.eas.tm.im.client.comp.IRunnableWithProgress;
import com.kingdee.eas.tm.im.client.comp.IShowWindow;
import com.kingdee.eas.tm.im.client.comp.ProgressDialogHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class ProgressDialog
extends KDDialog {
    private static final long serialVersionUID = -624291349009136334L;
    private static final Logger logger = CoreUIObject.getLogger(ProgressDialog.class);
    private static final String COMMAND_BACKRUN = "BACKRUN";
    private static int BACK_RUNNING = 1;
    private static int WAIT_RUNNING = 2;
    private int result = WAIT_RUNNING;
    private KDButton btnGoBackRunning;
    private KDLabel labelTaskName;
    private KDLabel labelIcon;
    private KDProgressBar progressBar;
    private KDLabel subTaskName;
    private KDLabel labelTimer;
    private Timer timer;
    private IProgressMonitor monitor;
    protected boolean isLoading = false;
    protected CoreUI owner = null;
    private String uiTitle;
    private String windowMsgTitle;
    private String msg;
    private IShowWindow showparent;
    private Runnable run;

    protected ProgressDialog() {
    }

    protected ProgressDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    protected ProgressDialog(Dialog owner, boolean modal) {
        super(owner, modal);
    }

    protected void showParentWindow() throws Exception {
        if (this.showparent == null) {
            if (this.owner != null) {
                this.owner.onShow();
            }
        } else {
            this.showparent.onShow();
        }
    }

    public void reSetTime() {
        this.timer.stop();
        this.startTimer();
    }

    protected void hideParentWindow() {
        if (this.showparent == null) {
            if (this.owner != null) {
                this.owner.getUIWindow().hide();
            }
        } else {
            this.showparent.hide();
        }
    }

    public void setSpecialShowParentWindowModal(IShowWindow show) {
        this.showparent = show;
    }

    public boolean isSpecialShow() {
        return this.showparent != null;
    }

    public boolean isShowWindow() {
        if (this.isSpecialShow()) {
            return this.showparent.isShowWindow();
        }
        return true;
    }

    protected void dialogInit() {
        super.dialogInit();
        this.setDefaultCloseOperation(0);
        this.setBounds(new Rectangle(10, 10, 350, 163));
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.labelIcon = new KDLabel();
        this.labelIcon.setIcon(EASResource.getIcon((String)"imgTbtn_help"));
        this.labelIcon.setBounds(new Rectangle(10, 8, 20, 20));
        this.getContentPane().add((Component)this.labelIcon, null);
        this.labelTaskName = new KDLabel();
        this.labelTaskName.setName("calculating");
        this.labelTaskName.setBounds(new Rectangle(30, 10, 250, 19));
        this.getContentPane().add((Component)this.labelTaskName, null);
        this.progressBar = new KDProgressBar();
        this.progressBar.setName("calcProgress");
        this.progressBar.setBounds(new Rectangle(10, 35, 329, 19));
        this.getContentPane().add((Component)this.progressBar, null);
        this.subTaskName = new KDLabel();
        this.subTaskName.setBounds(new Rectangle(10, 62, 329, 19));
        this.getContentPane().add((Component)this.subTaskName, null);
        this.labelTimer = new KDLabel();
        this.labelTimer.setBounds(new Rectangle(10, 85, 329, 19));
        this.getContentPane().add((Component)this.labelTimer, null);
        this.btnGoBackRunning = new KDButton();
        this.btnGoBackRunning.setEnabled(true);
        this.btnGoBackRunning.setBounds(new Rectangle(248, 109, 90, 19));
        this.btnGoBackRunning.setActionCommand(COMMAND_BACKRUN);
        this.btnGoBackRunning.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.41BackRunning"));
        this.getContentPane().add((Component)this.btnGoBackRunning, null);
        this.btnGoBackRunning.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDialog.this.result = BACK_RUNNING;
                if (ProgressDialog.this.isSpecialShow()) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ProgressDialog.this.moveDialog();
                            ProgressDialog.this.processOtherEvent();
                            ProgressDialog.this.dispose();
                        }
                    }).start();
                } else {
                    ProgressDialog.this.dispose();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                if (ProgressDialog.this.timer != null) {
                    ProgressDialog.this.timer.stop();
                }
            }
        });
        this.monitor = new ProgressMonitor();
    }

    private void processOtherEvent() {
        if (this.run != null) {
            SwingUtilities.invokeLater(this.run);
        }
    }

    private void moveDialog() {
        int ownerX = this.owner.getX() + this.owner.getWidth();
        int ownerY = this.owner.getY() + this.owner.getHeight();
        int myX = this.getX();
        int myY = this.getY();
        double px = (double)(ownerX - myX) / (double)(ownerY - myY);
        int count = 0;
        while (true) {
            int x = this.getLocation().x;
            int y = this.getLocation().y;
            int width = this.getWidth();
            int height = this.getHeight();
            if (ownerX - this.getWidth() + 10 <= x || ownerY - this.getHeight() + 10 <= y) break;
            int moveY = y + 50;
            int moveX = x + (int)(40.0 * px);
            this.setLocation(moveX, moveY);
            this.setSize(new Dimension(width - 30, height - 10));
            ++count;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.dispose();
    }

    public void addBtnGoBackActionListener(ActionListener l) {
        if (l != null) {
            this.btnGoBackRunning.addActionListener(l);
        }
    }

    public void addOtherHandleEvent(Runnable r) {
        this.run = r;
    }

    public void setBackgroundRunButtonEnabled(boolean b) {
        this.btnGoBackRunning.setEnabled(b);
    }

    public boolean goBackRunning() {
        return this.result == BACK_RUNNING;
    }

    public void setIcon(Icon icon) {
        this.labelIcon.setIcon(icon);
    }

    public void run(boolean canBackRun, boolean enableTimer, IRunnableWithProgress runable) {
        this.btnGoBackRunning.setVisible(canBackRun);
        this.btnGoBackRunning.setEnabled(canBackRun);
        if (enableTimer) {
            this.labelTimer.setVisible(true);
            this.startTimer();
        } else {
            this.labelTimer.setVisible(false);
        }
        ProgressDialogHelper.setToScreenCenter((Window)((Object)this));
        ProgressDialogHelper.run(runable, this, this.monitor, canBackRun);
        if (canBackRun) {
            logger.info((Object)(this.uiTitle + " back running"));
        }
    }

    private void startTimer() {
        this.labelTimer.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.passTime"));
        this.timer = new Timer(1000, new ActionListener(){
            long start = System.currentTimeMillis();

            @Override
            public void actionPerformed(ActionEvent e) {
                long end = System.currentTimeMillis();
                ProgressDialog.this.labelTimer.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.passTimeing") + ProgressDialogHelper.formatTime(end - this.start));
            }
        });
        this.timer.setRepeats(true);
        this.timer.start();
    }

    public String getUiTitle() {
        return this.uiTitle;
    }

    public String getWindowMsgTitle() {
        return this.windowMsgTitle;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setUiTitle(String uiTitle) {
        this.uiTitle = uiTitle;
    }

    public void setWindowMsgTitle(String windowMsgTitle) {
        this.windowMsgTitle = windowMsgTitle;
    }

    class ProgressMonitor
    implements IProgressMonitor {
        private boolean isCancel = false;
        private int totalWork;
        private boolean isEnd = false;

        ProgressMonitor() {
        }

        @Override
        public void beginTask(final String name, final int totalWork) {
            this.totalWork = totalWork;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.setTitle(name);
                    ProgressDialog.this.labelTaskName.setText(name);
                    if (totalWork < 0) {
                        ProgressDialog.this.progressBar.setIndeterminate(true);
                    }
                    ProgressDialog.this.progressBar.setMaximum(totalWork);
                    ProgressDialog.this.progressBar.setMinimum(0);
                }
            });
        }

        @Override
        public void done() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ProgressMonitor.this.totalWork < 0) {
                        ProgressDialog.this.progressBar.setIndeterminate(false);
                    }
                    if (ProgressDialog.this.timer != null) {
                        ProgressDialog.this.timer.stop();
                    }
                    ProgressDialog.this.dispose();
                    ProgressMonitor.this.isEnd = true;
                }
            });
        }

        @Override
        public boolean isCanceled() {
            return this.isCancel;
        }

        @Override
        public void setCanceled(boolean value) {
            this.isCancel = value;
        }

        @Override
        public void setTaskName(String name) {
            ProgressDialog.this.labelTaskName.setText(name);
        }

        @Override
        public void nextStep(String name) {
            ProgressDialog.this.subTaskName.setText(name);
        }

        @Override
        public void worked(int work) {
            if (this.totalWork >= 0) {
                ProgressDialog.this.progressBar.setValue(ProgressDialog.this.progressBar.getValue() + work);
            }
        }

        public boolean isEnd() {
            return this.isEnd;
        }
    }
}

