/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client.comp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tm.common.PoolInvoiceInfo;
import com.kingdee.eas.tm.common.TMCommonFacadeFactory;
import com.kingdee.eas.tm.common.help.msgHelp.client.TMMsgBox;
import com.kingdee.eas.tm.common.help.msgHelp.client.util.TMMsgURLUtil;
import com.kingdee.eas.tm.common.httpClient.HttpClientUtil;
import com.kingdee.eas.tm.common.httpClient.SSLClientConfig;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceType;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.common.utils.TMPwyHelperUtils;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IMInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceActionEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceActionTypeEnum;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PwyHelper;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.PwyUrlHelp;
import com.kingdee.eas.tm.im.client.InvoiceTabListUI;
import com.kingdee.eas.tm.im.client.comp.FpzsInvoicesUI;
import com.kingdee.eas.tm.im.client.comp.InvoiceHelperUI;
import com.kingdee.eas.tm.im.param.ActionParam;
import com.kingdee.eas.tm.im.param.InvoiceHelperParam;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class PwyInvoiceHelper {
    private static final Logger logger = CoreUIObject.getLogger(PwyInvoiceHelper.class);
    private PwyHelper pwyHelper = new PwyHelper();
    private CoreUI ui = null;
    Map<String, String> msgIdMap = new ConcurrentHashMap<String, String>();
    private IUIWindow fpzsWindow = null;
    private volatile boolean isDoPolling = true;

    public PwyInvoiceHelper(CoreUI ui) {
        this.ui = ui;
    }

    public void invoiceHelperAction(InvoiceHelperParam helperParam) throws Exception {
        CompanyOrgUnitInfo org = helperParam.getCompany();
        PwySettingInfo pwyInfo = (PwySettingInfo)PwySettingFactory.getRemoteInstance().getPwySetting(org.getId().toString(), OPTypeEnum.RecInvoice, null, null);
        if (pwyInfo == null) {
            TMMsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "pwySettingIsNull", IMUtils.getLocale()), (Map)TMMsgURLUtil.getMsgURL((String)"IMS"));
            return;
        }
        String accessToken = this.pwyHelper.getAccessToken(null, pwyInfo.getClientId(), pwyInfo.getClientSecret());
        if (StringUtils.isEmpty((String)accessToken)) {
            TMMsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "getAccessTokenError", IMUtils.getLocale()), (Map)TMMsgURLUtil.getMsgURL((String)"IMS"));
            return;
        }
        helperParam.setPwySetting(pwyInfo);
        helperParam.setAccessToken(accessToken);
        if (helperParam.getUserInfo() == null) {
            helperParam.setUserInfo(SysContext.getSysContext().getCurrentUserInfo());
        }
        this.openFpzsInvoicesUI(helperParam);
    }

    protected void openFpzsInvoicesUI(InvoiceHelperParam helperParam) throws Exception {
        this.closeFpzsInvoicesUI();
        String userkey = this.getUserKey(helperParam);
        StringBuffer url = new StringBuffer();
        url.append(PwyUrlHelp.getWebfpzsIndexUrl());
        url.append(userkey);
        String openFpzsWithBrowser = IMFacadeFactory.getRemoteInstance().getParamByKey("openFpzsWithBrowser");
        if ("1".equals(openFpzsWithBrowser)) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            this.createPollingThread(helperParam);
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"url", (Object)url.toString());
            uiContext.put((Object)"helperParam", (Object)helperParam);
            uiContext.put((Object)"pwyInvoiceHelper", (Object)this);
            String uiClass = "com.kingdee.eas.tm.im.client.comp.FpzsInvoicesUI";
            this.fpzsWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
            this.fpzsWindow.show();
        }
    }

    public void createPollingThread(final InvoiceHelperParam helperParam) {
        this.isDoPolling = true;
        Runnable polling = new Runnable(){

            @Override
            public void run() {
                while (PwyInvoiceHelper.this.isDoPolling && !PwyInvoiceHelper.this.doPollingRequest(helperParam)) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        };
        Thread pollingThread = new Thread(polling, "fpzsPooling");
        pollingThread.start();
    }

    public void shutdownPollingThread() {
        this.isDoPolling = false;
    }

    public void closeFpzsInvoicesUI() {
        if (this.fpzsWindow != null) {
            ((FpzsInvoicesUI)this.fpzsWindow.getUIObject()).setAutoClose(true);
            ((UIDialog)this.fpzsWindow).destoryWindow();
            this.fpzsWindow = null;
        }
        this.shutdownPollingThread();
    }

    public boolean doPollingRequest(InvoiceHelperParam helperParam) {
        try {
            String billId = null;
            billId = helperParam.getParams().get("billId") != null ? helperParam.getParams().get("billId").toString() : helperParam.getUserInfo().getId().toString();
            String key = TMCommonUtil.StringToMD5((String)(billId + helperParam.getRandom()));
            String pollingUrl = this.getPollingUrl(helperParam.getAccessToken(), key);
            String receiptUrl = this.getReceiptUrl(helperParam.getAccessToken(), key);
            String data = HttpClientUtil.doGet((String)pollingUrl);
            logger.error((Object)("[" + Thread.currentThread().getName() + "][PwyInvoiceHelper]:polling:" + pollingUrl + "," + data));
            if (!StringUtils.isEmpty((String)data) && data.startsWith("{")) {
                JSONObject json = new JSONObject(data);
                String errorCode = json.getString("errcode");
                if ("0000".equals(errorCode)) {
                    String msgId = json.getJSONObject("data").getString("msgId");
                    String receiptNewUrl = receiptUrl.replace("{0}", msgId);
                    String callbackResult = HttpClientUtil.doGet((String)receiptNewUrl);
                    logger.error((Object)("[PwyInvoiceHelper]: callbackResult+" + callbackResult));
                    if (this.isNewMessage(msgId, json)) {
                        this.handleSuccess(json, helperParam);
                        if (helperParam.isOtherbill()) {
                            this.closeFpzsInvoicesUI();
                            if (helperParam.getParams().get("hasAttchemnt") != null && ((Boolean)helperParam.getParams().get("hasAttchemnt")).booleanValue()) {
                                MsgBox.showInfo((Component)this.ui, (String)this.getResource("addAttchment"));
                            } else {
                                MsgBox.showInfo((Component)this.ui, (String)this.getResource("addIncomeInvoice"));
                            }
                            return true;
                        }
                    }
                } else {
                    if ("1300".equals(errorCode)) {
                        this.closeFpzsInvoicesUI();
                        MsgBox.showInfo((Component)this.ui, (String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "reqError", IMUtils.getLocale()));
                        return true;
                    }
                    Thread.sleep(5000L);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof BOSException || e instanceof EASBizException) {
                this.closeFpzsInvoicesUI();
                MsgBox.showError((Component)this.ui, (String)e.getMessage());
                return true;
            }
            logger.error((Object)("[PwyInvoiceHelper] waitPYWRequestData :" + e.getMessage()), (Throwable)e);
        }
        return false;
    }

    private synchronized boolean isNewMessage(String msgId, JSONObject json) throws JSONException {
        boolean newMessage = false;
        if (StringUtils.isEmpty((String)this.msgIdMap.get(msgId))) {
            this.msgIdMap.put(msgId, json.getJSONObject("data").getString("data"));
            newMessage = true;
        }
        return newMessage;
    }

    private String getReceiptUrl(String accessToken, String key) {
        return PwyUrlHelp.getWebFpzsReceiptUrl() + "?access_token=" + accessToken + "&key=" + key + "&msgId={0}";
    }

    private String getPollingUrl(String accessToken, String key) {
        return PwyUrlHelp.getWebFpzsPollingUrl() + "?access_token=" + accessToken + "&key=" + key;
    }

    private void handleSuccess(JSONObject json, InvoiceHelperParam helperParam) throws Exception {
        String opr;
        JSONObject jsono;
        int i;
        logger.error((Object)("enter method handleSuccess.json=" + json));
        HashMap pwyBillMap = new HashMap();
        if (!json.has("data") || json.getJSONObject("data") == null || json.getJSONObject("data").getJSONObject("data") == null || json.getJSONObject("data").getJSONObject("data").getJSONObject("data") == null) {
            return;
        }
        ArrayList<PoolInvoiceInfo> invoiceDataList = new ArrayList<PoolInvoiceInfo>();
        PoolInvoiceInfo poolInvoiceInfo = null;
        logger.error((Object)"enter method handleSuccess1.");
        JSONObject dataJsonObj = json.getJSONObject("data").getJSONObject("data").getJSONObject("data");
        List downloadInvoiceTypesList = TMPwyHelperUtils.getAPDownloadInvoiceTypes();
        HashSet<String> vatInvoiceType = new HashSet<String>();
        vatInvoiceType.add("1");
        vatInvoiceType.add("2");
        vatInvoiceType.add("3");
        vatInvoiceType.add("4");
        vatInvoiceType.add("5");
        HashSet<String> fullElecInvoiceType = new HashSet<String>();
        fullElecInvoiceType.add("26");
        fullElecInvoiceType.add("27");
        ArrayList<String> snList = new ArrayList<String>();
        if (dataJsonObj.getJSONArray("data") != null) {
            JSONArray array = dataJsonObj.getJSONArray("data");
            int size = dataJsonObj.getJSONArray("data").length();
            for (i = 0; i < size; ++i) {
                jsono = array.getJSONObject(i);
                String invoiceType = jsono.getString("invoiceType");
                opr = helperParam.getOperation();
                snList.add(jsono.getString("serialNo"));
                if (InvoiceHelperParam.OPR_DOWNLOAD.equals(opr)) {
                    if (TMInvoiceType.getEnum((String)invoiceType) == null || downloadInvoiceTypesList.contains(invoiceType)) {
                        poolInvoiceInfo = new PoolInvoiceInfo();
                        poolInvoiceInfo.setInvoiceType(invoiceType);
                        poolInvoiceInfo.setInvoiceCode(jsono.getString("invoiceCode"));
                        poolInvoiceInfo.setInvoiceNumber(jsono.getString("invoiceNo"));
                        poolInvoiceInfo.setSerialNo(jsono.getString("serialNo"));
                        poolInvoiceInfo.setBillingCompany(jsono.getString("salerName"));
                        invoiceDataList.add(poolInvoiceInfo);
                        continue;
                    }
                    StringBuffer allowInvoiceTypes = new StringBuffer();
                    List apAllowTMInvoiceType = TMPwyHelperUtils.getAPAllowTMInvoiceType();
                    int length = apAllowTMInvoiceType.size();
                    for (int a = 0; a < length; ++a) {
                        if (TMInvoiceType.INVOICETYPE_OTHER.equals(apAllowTMInvoiceType.get(a))) continue;
                        allowInvoiceTypes.append(((TMInvoiceType)apAllowTMInvoiceType.get(a)).getAlias(IMUtils.getLocale()));
                        allowInvoiceTypes.append("\u3001");
                    }
                    throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "PwyHelper_InvoiceTypeErr", IMUtils.getLocale(), new Object[]{allowInvoiceTypes.substring(0, allowInvoiceTypes.length() - 1)})});
                }
                if (!InvoiceHelperParam.OPR_ACCEPT.equals(opr) && !InvoiceHelperParam.OPR_RECEIVE.equals(opr) && !InvoiceHelperParam.OPR_FULLELEC_ACCEPT.equals(opr)) continue;
                if (InvoiceHelperParam.OPR_ACCEPT.equals(opr) || InvoiceHelperParam.OPR_RECEIVE.equals(opr)) {
                    if (!vatInvoiceType.contains(invoiceType)) {
                        throw new IMException(IMException.ERRORMSG, new Object[]{this.getResource("Err_OnlyVat")});
                    }
                } else if (InvoiceHelperParam.OPR_FULLELEC_ACCEPT.equals(opr) && !fullElecInvoiceType.contains(invoiceType)) {
                    throw new IMException(IMException.ERRORMSG, new Object[]{this.getResource("Err_OnlyFullElecInvoice")});
                }
                poolInvoiceInfo = new PoolInvoiceInfo();
                poolInvoiceInfo.setInvoiceType(invoiceType);
                poolInvoiceInfo.setInvoiceCode(jsono.getString("invoiceCode"));
                poolInvoiceInfo.setInvoiceNumber(jsono.getString("invoiceNo"));
                poolInvoiceInfo.setSerialNo(jsono.getString("serialNo"));
                invoiceDataList.add(poolInvoiceInfo);
            }
        }
        boolean hasAttchemnt = false;
        if (dataJsonObj.has("certificateList") && dataJsonObj.getJSONArray("certificateList") != null) {
            JSONArray certificateList = dataJsonObj.getJSONArray("certificateList");
            for (i = 0; i < certificateList.length(); ++i) {
                jsono = certificateList.getJSONObject(i);
                String attchSerialNo = jsono.getString("serialNo");
                opr = helperParam.getOperation();
                if (!InvoiceHelperParam.OPR_DOWNLOAD.equals(opr) || StringUtils.isEmpty((String)attchSerialNo)) continue;
                hasAttchemnt = true;
                break;
            }
        }
        if (hasAttchemnt && invoiceDataList.size() == 0 && snList.size() == 0) {
            helperParam.getParams().put("hasAttchemnt", hasAttchemnt);
            logger.error((Object)"exit method handleSuccess.");
            return;
        }
        this.downInvoiceBySn(snList, helperParam);
        List billList = TMCommonFacadeFactory.getRemoteInstance().getInvoiceInfoList(invoiceDataList);
        this.dispatchOperation(helperParam, billList, dataJsonObj);
        logger.error((Object)"exit method handleSuccess.");
    }

    private void dispatchOperation(InvoiceHelperParam helperParam, List billList, JSONObject dataJsonObj) throws Exception {
        if (billList == null || billList.size() == 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "DownLoadInvoiceError", IMUtils.getLocale())});
        }
        HashSet<String> vatInvoiceType = new HashSet<String>();
        vatInvoiceType.add("1");
        vatInvoiceType.add("2");
        vatInvoiceType.add("3");
        vatInvoiceType.add("4");
        vatInvoiceType.add("5");
        HashSet<String> fullElecInvoiceType = new HashSet<String>();
        fullElecInvoiceType.add("26");
        fullElecInvoiceType.add("27");
        int size = billList.size();
        String opr = helperParam.getOperation();
        logger.error((Object)("[PWYHELP_DOWNLOAD] dispatchOperation : " + opr + " size : " + size));
        IncomeInvoiceActionEnum action = null;
        String actionName = null;
        HashSet acceptInvoiceType = new HashSet();
        if (InvoiceHelperParam.OPR_ACCEPT.equals(opr)) {
            action = IncomeInvoiceActionEnum.ACCEPTINVOICE;
            actionName = "AcceptAction";
            acceptInvoiceType = vatInvoiceType;
        } else if (InvoiceHelperParam.OPR_RECEIVE.equals(opr)) {
            action = IncomeInvoiceActionEnum.RECEIVEINVOICE;
            actionName = "ReceiveAction";
            acceptInvoiceType = vatInvoiceType;
        } else if (InvoiceHelperParam.OPR_FULLELEC_ACCEPT.equals(opr)) {
            action = IncomeInvoiceActionEnum.ACCEPTCHECKINVOICE;
            actionName = "AcceptAction";
            acceptInvoiceType = fullElecInvoiceType;
        }
        ArrayList<String> ids = new ArrayList<String>();
        PoolInvoiceInfo info = null;
        for (int i = 0; i < size; ++i) {
            String invoiceType;
            info = (PoolInvoiceInfo)billList.get(i);
            if (StringUtils.isEmpty((String)info.getInvoiceType()) || !acceptInvoiceType.contains(invoiceType = info.getInvoiceType())) continue;
            ids.add(info.getId().toString());
        }
        if (InvoiceHelperParam.OPR_DOWNLOAD.equals(opr)) {
            if (this.ui instanceof InvoiceHelperUI) {
                ((InvoiceHelperUI)this.ui).fillTable(billList);
            } else {
                this.fillTable4OtherUI(this.ui.getClass().getName(), dataJsonObj);
            }
        } else {
            ActionParam params = new ActionParam();
            params.setAction(action);
            params.setActiontype(IncomeInvoiceActionTypeEnum.SAME);
            params.setFpzsAction(true);
            ((InvoiceTabListUI)this.ui).dispatchAction(this.getResource(actionName), params, ids, this);
            ((InvoiceTabListUI)this.ui).refreshList();
        }
    }

    private void fillTable4OtherUI(String className, JSONObject dataJsonObj) {
        try {
            Class<?> uiClazz = Class.forName(className);
            Method fillTable = uiClazz.getMethod("fillTable", JSONObject.class);
            fillTable.invoke((Object)this.ui, dataJsonObj);
        }
        catch (ReflectiveOperationException e) {
            logger.error((Object)e);
        }
    }

    private void downInvoiceBySn(ArrayList snList, InvoiceHelperParam helperParam) throws Exception {
        logger.error((Object)"enter method downInvoiceBySn.");
        if (snList.isEmpty()) {
            return;
        }
        StringBuffer queryUrl = new StringBuffer();
        queryUrl.append(PwyUrlHelp.getWebFpzsInvoiceQueryBySN());
        queryUrl.append("?access_token=").append(helperParam.getAccessToken());
        StringBuffer snStr = new StringBuffer();
        for (int i = 0; i < snList.size(); ++i) {
            snStr.append(snList.get(i)).append(",");
        }
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("serialNos", snStr.toString().substring(0, snStr.length() - 1));
        String paramStr = Kson.getGson().toJson(reqMap);
        String retJsonStr = HttpClientUtil.doPost((String)queryUrl.toString(), (String)IMInvoiceFacadeFactory.getRemoteInstance().encryptAES(paramStr, helperParam.getPwySetting().getSecretKey()), (SSLClientConfig)SSLClientConfig.custom().setNeedEncrypt(true).build());
        if (retJsonStr == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{helperParam.getCompany().getName() + ":" + IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "reqError", IMUtils.getLocale())});
        }
        try {
            JSONObject retJson = null;
            retJson = new JSONObject(retJsonStr);
            if (retJson == null || !"0000".equals(retJson.get("errcode"))) {
                logger.error((Object)("downInvoiceBySn retJson=" + retJson));
                throw new IMException(IMException.ERRORMSG, new Object[]{helperParam.getCompany().getName() + ":" + IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "reqError", IMUtils.getLocale()) + "\n" + retJson.get("description")});
            }
            logger.error((Object)"enter method downLoadInvoice.");
            DownloadInvoiceParams downloadParams = new DownloadInvoiceParams(DownloadInvoiceType.PWYHELP);
            downloadParams.setCompanyId(helperParam.getCompany().getId().toString());
            downloadParams.setCompanyID(helperParam.getCompany().getId().toString());
            downloadParams.put((Object)"operation", (Object)helperParam.getOperation());
            downloadParams.setNeedFilterSave(false);
            TMCommonFacadeFactory.getRemoteInstance().parseDownLoadInvoice(retJsonStr, downloadParams);
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.error((Object)"exit method downInvoiceBySn.");
    }

    private String getUserKey(InvoiceHelperParam helperParam) throws Exception {
        String buyerAccount;
        HashMap<String, Object> params = new HashMap<String, Object>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bank.name"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(helperParam.getCompany().getId().toString()), sic);
        PwySettingInfo pwySetting = helperParam.getPwySetting();
        long timestamp = System.currentTimeMillis();
        String userID = helperParam.getUserInfo().getId().toString();
        String clientid = pwySetting.getClientId();
        String clientSecret = pwySetting.getClientSecret();
        String sign = TMCommonUtil.StringToMD5((String)(clientid + clientSecret + timestamp));
        String buyerAddressPhone = this.dealNullString(company.getTaxAddress()) + this.dealNullString(company.getContactPhone());
        if (!StringUtils.isEmpty((String)pwySetting.getAddressPhone())) {
            buyerAddressPhone = pwySetting.getAddressPhone();
        }
        String string = buyerAccount = company.getBank() == null ? company.getBankAccount() : this.dealNullString(company.getBank().getName()) + this.dealNullString(company.getBankAccount());
        if (!StringUtils.isEmpty((String)pwySetting.getBankAccount())) {
            buyerAccount = pwySetting.getBankAccount();
        }
        params.put("timestamp", timestamp);
        params.put("client_id", clientid);
        params.put("tin", company.getTaxNumber());
        if (StringUtils.isEmpty((String)company.getTaxNumber())) {
            throw new IMException(IMException.COMPANY_TAXNUMBER_ISNULL, new Object[]{company.getName()});
        }
        params.put("ghf_mc", company.getRegisteredCode());
        params.put("eid", URLEncoder.encode(userID, "UTF-8"));
        params.put("sign", sign);
        params.put("billNumber", userID);
        params.put("bxd_key", userID);
        if (helperParam.getParams().get("billNumber") != null) {
            params.put("billNumber", helperParam.getParams().get("billNumber").toString());
        }
        if (helperParam.getParams().get("billId") != null) {
            params.put("bxd_key", helperParam.getParams().get("billId").toString());
        }
        params.put("random", helperParam.getRandom());
        params.put("buyerAddressPhone", buyerAddressPhone);
        params.put("buyerAccount", buyerAccount);
        this.extendTicketParam(params);
        params.put("billType", "");
        String invoiceSerialNos = (String)helperParam.getParams().get("invoiceSerialNos");
        if (!StringUtils.isEmpty((String)invoiceSerialNos)) {
            params.put("invoiceSerialNos", invoiceSerialNos);
        } else {
            params.put("invoiceSerialNos", "");
        }
        if (helperParam.getCurrAcct() != null && helperParam.getCurrAcct() instanceof SupplierInfo) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("taxRegisterNo"));
            SupplierInfo supplierInfo = SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(helperParam.getCurrAcct().getId()), selector);
            params.put("salerName", supplierInfo.getName());
            params.put("salerTaxNo", supplierInfo.getTaxRegisterNo());
        }
        String param = Kson.getGson().toJson(params);
        logger.error((Object)("getUserKey param=" + param));
        String userKeyUrl = PwyUrlHelp.getUserKeyUrl();
        try {
            String userKey = HttpClientUtil.doPost((String)userKeyUrl, (String)param);
            if (userKey != null) {
                JSONObject json = new JSONObject(userKey);
                if ("0000".equals(json.getString("errcode"))) {
                    return json.getJSONObject("data").getString("userKey");
                }
                throw new BOSException(json.getString("description"));
            }
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String dealNullString(Object value) {
        return value == null ? "" : value.toString();
    }

    protected void extendTicketParam(Map params) {
        params.put("ticketParam", "1110");
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)key);
    }
}

