/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client.util;

import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.tm.im.client.util.NumberExpandInfo;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;

public class NumberExpendRender
implements IBasicRender {
    public static final int SHOW_TO_STRING = 0;
    public static final int SHOW_NUMBER = 1;
    private int TABSIZE = 8;
    private int ICONSIZE = 10;
    private int margin = 2;
    private int showType = 0;
    protected SimpleTextRender simpleRender = new SimpleTextRender();
    protected HashMap acctIdToPos = new HashMap();
    protected HashMap acctIdToPosForBgOrg = new HashMap();

    public NumberExpendRender(int showType) {
        this.showType = showType;
    }

    public void setShowType(int showType) {
        this.showType = showType;
    }

    protected void drawExpanded(Graphics g, int x, int y) {
        g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
        int lineSize = this.ICONSIZE - 2 * this.margin;
        g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
    }

    protected void drawCollapsed(Graphics g, int x, int y) {
        g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
        int lineSize = this.ICONSIZE - 2 * this.margin;
        g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
    }

    protected void drawLeaf(Graphics g, int x, int y) {
        int lineSize = this.ICONSIZE - 2 * this.margin;
    }

    public boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
        String acctId = numberExpandInfo.getNumber();
        Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
        if (rec != null) {
            return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
        }
        return false;
    }

    public boolean inRectForBgOrg(NumberExpandInfo numberExpandInfo, int x, int y) {
        String acctId = numberExpandInfo.getLongNumber();
        Rectangle rec = (Rectangle)this.acctIdToPosForBgOrg.get(acctId);
        if (rec != null) {
            return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
        }
        return false;
    }

    public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
        if (obj instanceof NumberExpandInfo && clip.getBounds().width > 0 && clip.getBounds().height > 0) {
            NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
            int ident = numberExpandInfo.getLevel() * this.TABSIZE;
            Rectangle rect = clip.getBounds();
            int x = rect.x + ident;
            int y = rect.y + (rect.height - this.ICONSIZE) / 2;
            Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
            this.acctIdToPos.put(numberExpandInfo.getNumber(), iconRect);
            this.acctIdToPosForBgOrg.put(numberExpandInfo.getLongNumber(), iconRect);
            String value = null;
            switch (this.showType) {
                case 0: {
                    value = numberExpandInfo.toString();
                    break;
                }
                case 1: {
                    value = numberExpandInfo.getNumber();
                }
            }
            if (value == null) {
                value = "";
            }
            this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - this.ICONSIZE - this.TABSIZE, rect.height), value, style);
            this.paintIcon(graphics, numberExpandInfo, iconRect);
        } else if (obj != null) {
            this.simpleRender.draw(graphics, clip, obj.toString(), style);
        }
    }

    private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
        if (numberExpandInfo.isLeaf()) {
            this.drawLeaf(graphics, iconRect.x, iconRect.y);
        } else if (numberExpandInfo.isExpandStatus()) {
            this.drawExpanded(graphics, iconRect.x, iconRect.y);
        } else if (!numberExpandInfo.isExpandStatus()) {
            this.drawCollapsed(graphics, iconRect.x, iconRect.y);
        }
    }
}

