/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.scm.common.client.BillOptionsHelper;
import com.kingdee.eas.scm.common.client.PrecisionConfigUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.tm.im.common.client.AbstractIMBillListUI;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class IMBillListUI
extends AbstractIMBillListUI {
    private static final String PRECISION_CONFIG_UI = "com.kingdee.eas.scm.common.client.PrecisionConfigUI";
    private static final String USER_PRECISION = "userPrecision";
    private static final String NO_ZERO_SHOW = "noZeroShow";
    private static final Logger logger = CoreUIObject.getLogger(IMBillListUI.class);
    private IUIWindow precisionConfigWindow = null;
    protected boolean takeOutZero = true;
    protected int qtyPrecision = 10;
    protected int pricePrecision = 10;
    protected int taxPrecision = 10;
    protected int taxRatePrecision = 10;

    public void onLoad() throws Exception {
        super.onLoad();
        Map billOptionsMap = BillOptionsHelper.takeConfigType((IUIObject)this);
        String userPrecision = BillOptionsHelper.takeConfigTypeByUI((Map)billOptionsMap, (IUIObject)this, (String)USER_PRECISION);
        if (!StringUtils.isEmpty((String)userPrecision)) {
            String[] userPrecisions = userPrecision.split(",");
            try {
                if (userPrecisions.length == 4) {
                    this.qtyPrecision = Integer.parseInt(userPrecisions[0]);
                    this.pricePrecision = Integer.parseInt(userPrecisions[1]);
                    this.taxPrecision = Integer.parseInt(userPrecisions[2]);
                    this.taxRatePrecision = Integer.parseInt(userPrecisions[3]);
                }
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        boolean takeOutZero = BillOptionsHelper.takeConfigType((Map)billOptionsMap, (IUIObject)this, (String)NO_ZERO_SHOW, (boolean)true);
        this.boxMenuItemNoZero.setSelected(takeOutZero);
        this.handleFiledsPrecision(takeOutZero);
    }

    @Override
    public void actionPrecisionConfig_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        if (this.precisionConfigWindow == null) {
            this.precisionConfigWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PRECISION_CONFIG_UI, (Map)uiContext, null, OprtState.EDIT);
        }
        PrecisionConfigUI aPrecisionConfigUI = (PrecisionConfigUI)this.precisionConfigWindow.getUIObject();
        aPrecisionConfigUI.setDefaultValue(this.qtyPrecision, this.pricePrecision, this.taxPrecision, this.taxRatePrecision);
        this.precisionConfigWindow.show();
        if (!aPrecisionConfigUI.isCancel()) {
            this.qtyPrecision = aPrecisionConfigUI.getQtyPrecision();
            this.pricePrecision = aPrecisionConfigUI.getPricePrecision();
            this.taxPrecision = aPrecisionConfigUI.getExPrecision();
            this.taxRatePrecision = aPrecisionConfigUI.getTaxRatePrecision();
            this.takeOutZero = this.boxMenuItemNoZero.isSelected();
            String userPrecisionTemp = this.qtyPrecision + "," + this.pricePrecision + "," + this.taxPrecision + "," + this.taxRatePrecision;
            BillOptionsHelper.putConfigTypeByUI((IUIObject)this, (String)USER_PRECISION, (String)userPrecisionTemp);
            this.actionRefresh_actionPerformed(e);
            this.handleFiledsPrecision(this.takeOutZero);
        }
    }

    @Override
    public void actionNoZero_actionPerformed(ActionEvent e) throws Exception {
        this.takeOutZero = this.boxMenuItemNoZero.isSelected();
        BillOptionsHelper.putConfigTypeByUI((IUIObject)this, (String)NO_ZERO_SHOW, (boolean)this.takeOutZero);
        this.handleFiledsPrecision(this.takeOutZero);
    }

    private void handleFiledsPrecision(boolean takeOutZero) throws Exception {
        SCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])this.getQtyColumns(), (String)SCMClientUtils.getFormatPattern((int)this.qtyPrecision, (boolean)takeOutZero));
        SCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])this.getPriceColumns(), (String)SCMClientUtils.getFormatPattern((int)this.pricePrecision, (boolean)takeOutZero));
        SCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])this.getExColumns(), (String)SCMClientUtils.getFormatPattern((int)this.taxPrecision, (boolean)takeOutZero));
        SCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])this.getTaxRateColumns(), (String)SCMClientUtils.getFormatPattern((int)this.taxRatePrecision, (boolean)takeOutZero));
    }

    protected String[] getQtyColumns() {
        return null;
    }

    protected String[] getPriceColumns() {
        return null;
    }

    protected String[] getTaxRateColumns() {
        return null;
    }

    protected String[] getExColumns() {
        return null;
    }
}

