/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.common.comm.IMLanguageEnum;
import com.kingdee.eas.tm.im.common.comm.LocalServiceFactory;
import com.kingdee.eas.tm.im.common.comm.LocalServiceInfo;
import com.kingdee.eas.tm.im.common.comm.ServiceException;
import com.kingdee.eas.tm.im.common.comm.ServiceStateEnum;
import com.kingdee.eas.tm.im.common.comm.client.AbstractLocalServiceEditUI;
import com.kingdee.eas.tm.im.common.uihelper.EditUIHelper;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LocalServiceEditUI
extends AbstractLocalServiceEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LocalServiceEditUI.class);
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private Map btnMap = new HashMap();

    public LocalServiceEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSave);
        this.btnMap.put("actionCopy", this.actionCopy);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initBtnStatus();
        this.initComponents();
    }

    protected void initComponents() {
        if (this.editData.isIsScheduled()) {
            this.txtNumber.setEditable(false);
            this.txtApiUrl.setEditable(false);
            this.txtLoginUrl.setEditable(false);
        } else {
            this.txtNumber.setEditable(true);
            this.txtApiUrl.setEditable(true);
            this.txtLoginUrl.setEditable(true);
        }
    }

    private void initBtnStatus() {
        boolean isLight = false;
        if (!ServiceStateEnum.INITED.equals((Object)this.editData.getState())) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkBeforeEdit();
        super.actionEdit_actionPerformed(e);
        this.loadFields();
    }

    protected void checkBeforeEdit() throws BOSException, EASBizException {
        LocalServiceInfo info = LocalServiceFactory.getRemoteInstance().getLocalServiceInfo((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()));
        if (ServiceStateEnum.INITED.equals((Object)info.getState())) {
            throw new ServiceException(ServiceException.EPX_LOCALSERVICE_INITED);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
    }

    protected IObjectValue createNewData() {
        LocalServiceInfo editData = new LocalServiceInfo();
        editData.setServiceURL("http://ip:port/easportal");
        editData.setLoginUrl("/openapi/login");
        editData.setApiUrl("/openapi/api");
        editData.setLanguage(IMLanguageEnum.zh_CN);
        editData.setState(ServiceStateEnum.UNINIT);
        editData.setIsScheduled(false);
        return editData;
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        super.actionCancelCancel_actionPerformed(e);
        if (this.editData.getState() != null && ServiceStateEnum.INITED.equals((Object)this.editData.getState())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        super.actionCancel_actionPerformed(e);
        this.setOprtState("VIEW");
        this.loadFields();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        LocalServiceInfo editData = (LocalServiceInfo)newData;
        editData.setNumber(null);
        editData.setIsScheduled(false);
        editData.setState(ServiceStateEnum.UNINIT);
        editData.setAccountId(null);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LocalServiceFactory.getRemoteInstance();
    }
}

