/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.im.basedata.PrivateFieldSchemeCollection;
import com.kingdee.eas.tm.im.basedata.PrivateFieldSchemeFactory;
import com.kingdee.eas.tm.im.basedata.PrivateFieldSchemeInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogFactory;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogHisFactory;
import com.kingdee.eas.tm.im.common.comm.client.AbstractTaxTransLogDetailUI;
import com.kingdee.eas.tm.im.common.uihelper.PrivateComponent;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class TaxTransLogDetailUI
extends AbstractTaxTransLogDetailUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxTransLogDetailUI.class);
    private String logId = null;
    private int flag = 1;
    private static final String URL = "url";
    private static final String SENDMSG = "sendMsg";
    private static final String REVMSG = "revMsg";
    private static final String AMBIGUOUS_TEXT = "******";
    private List<String> privateFields = new ArrayList<String>();
    private Map<String, Integer> viewStateMap = new HashMap<String, Integer>();
    private Map<String, JTextComponent> fieldComponetMap = new HashMap<String, JTextComponent>();
    private Map<String, KDWorkButton> fieldButtonMap = new HashMap<String, KDWorkButton>();
    private CoreBaseInfo info = null;

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiCtx = this.getUIContext();
        this.logId = (String)uiCtx.get("logId");
        this.flag = (Integer)uiCtx.get("flag");
        if (StringUtils.isEmpty((String)this.logId)) {
            return;
        }
        this.info = TaxTransLogFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.logId));
        if (this.flag == 2) {
            this.info = TaxTransLogHisFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.logId));
        }
        this.btnShowUrl.setVisible(false);
        this.btnShowSendMsg.setVisible(false);
        this.btnShowRecvMsg.setVisible(false);
        this.txtSendMsg.setText(this.info.getString(SENDMSG), false);
        this.txtRevMsg.setText(this.info.getString(REVMSG), false);
        this.txtURL.setText(this.info.getString(URL), false);
        this.txtTime.setText(this.getTime(this.info), false);
        this.kDLabelContainer1.setBounds(new Rectangle(10, 5, 677, 19));
        this.kDLabelContainer1.repaint();
        this.registerPrivateFields();
    }

    private void registerPrivateFields() throws BOSException {
        ArrayList<String> supportPrivateFields = new ArrayList<String>();
        supportPrivateFields.add(URL);
        supportPrivateFields.add(SENDMSG);
        supportPrivateFields.add(REVMSG);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billBosType", (Object)"34DD32C1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isPrivate", (Object)true, CompareType.EQUALS));
        view.setFilter(filter);
        PrivateFieldSchemeCollection privateFieldSchemes = PrivateFieldSchemeFactory.getRemoteInstance().getPrivateFieldSchemeCollection(view);
        PrivateFieldSchemeInfo schemeInfo = null;
        int size = privateFieldSchemes.size();
        for (int i = 0; i < size; ++i) {
            schemeInfo = privateFieldSchemes.get(i);
            if (!supportPrivateFields.contains(schemeInfo.getFieldName())) continue;
            this.privateFields.add(schemeInfo.getFieldName());
        }
        if (this.privateFields.size() == 0) {
            return;
        }
        this.fieldComponetMap.put(URL, (JTextComponent)this.txtURL);
        this.fieldComponetMap.put(SENDMSG, (JTextComponent)this.txtSendMsg);
        this.fieldComponetMap.put(REVMSG, (JTextComponent)this.txtRevMsg);
        this.fieldButtonMap.put(URL, this.btnShowUrl);
        this.fieldButtonMap.put(SENDMSG, this.btnShowSendMsg);
        this.fieldButtonMap.put(REVMSG, this.btnShowRecvMsg);
        String field = null;
        int size2 = this.privateFields.size();
        for (int i = 0; i < size2; ++i) {
            field = this.privateFields.get(i);
            this.viewStateMap.put(field, 0);
        }
        if (this.privateFields.contains(URL)) {
            this.kDLabelContainer1.setBounds(new Rectangle(10, 5, 655, 19));
            this.kDLabelContainer1.repaint();
        }
        this.btnShowUrl.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent var1) {
                TaxTransLogDetailUI.this.toggle(TaxTransLogDetailUI.URL);
            }
        });
        this.btnShowSendMsg.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent var1) {
                TaxTransLogDetailUI.this.toggle(TaxTransLogDetailUI.SENDMSG);
            }
        });
        this.btnShowRecvMsg.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent var1) {
                TaxTransLogDetailUI.this.toggle(TaxTransLogDetailUI.REVMSG);
            }
        });
        this.setUIByViewState();
    }

    public void toggle(String field) {
        this.viewStateMap.put(field, this.viewStateMap.get(field) == 0 ? 1 : 0);
        this.setFieldUIByViewState(field, this.viewStateMap.get(field));
    }

    private void setUIByViewState() {
        String field2 = null;
        for (String field2 : this.viewStateMap.keySet()) {
            this.setFieldUIByViewState(field2, this.viewStateMap.get(field2));
        }
    }

    private void setFieldUIByViewState(String field, int state) {
        this.fieldButtonMap.get(field).setVisible(true);
        if (state == 0) {
            Icon icon = PrivateComponent.findIconByPath("image/eye-hide.png");
            this.setFieldText(field, AMBIGUOUS_TEXT);
            this.fieldComponetMap.get(field).setEditable(false);
            this.fieldButtonMap.get(field).setIcon(icon);
        } else {
            Icon icon = PrivateComponent.findIconByPath("image/eye-show.png");
            this.setFieldText(field, this.info.getString(field));
            this.fieldComponetMap.get(field).setEditable(true);
            this.fieldButtonMap.get(field).setIcon(icon);
        }
    }

    private void setFieldText(String field, String text) {
        JTextComponent component = this.fieldComponetMap.get(field);
        if (component == null) {
            return;
        }
        if (component instanceof KDTextArea) {
            ((KDTextArea)component).setText(text, false);
        } else {
            component.setText(text);
        }
    }

    public String getTime(CoreBaseInfo info) {
        Timestamp sendTime = (Timestamp)info.get("sendTime");
        Timestamp revTime = (Timestamp)info.get("revTime");
        if (sendTime == null || revTime == null) {
            return "";
        }
        return revTime.getTime() - sendTime.getTime() + "ms";
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }
}

