/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.log.common.Resource;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.client.MySwingWork;
import com.kingdee.eas.tm.im.client.MyThreadPool;
import com.kingdee.eas.tm.im.common.comm.LogStatusEnum;
import com.kingdee.eas.tm.im.common.comm.SendModeEnum;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogFactory;
import com.kingdee.eas.tm.im.common.comm.client.AbstractTaxTransLogListUI;
import com.kingdee.eas.tm.im.common.comm.client.TaxTransLogQueryPanelUI;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.im.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TaxTransLogListUI
extends AbstractTaxTransLogListUI
implements IPermSupport4ListUI {
    private static final long serialVersionUID = 3850257164306772271L;
    private static final Logger logger = CoreUIObject.getLogger(TaxTransLogListUI.class);
    private ListUIHelper uiHelper = null;
    private static final String SETCOMMUNCATIONUI_CLASS = "com.kingdee.eas.tm.im.common.comm.client.TaxCommunicationSetEditUI";
    private static final String TAXMESSEGSETTING_CLASS = "com.kingdee.eas.tm.im.common.comm.client.TaxMsgSettingListUI";
    private static final String IMFREEMARKER_LISTUI_CLASS = "com.kingdee.eas.tm.im.common.comm.client.IMFreeMarkerListUI";
    private static final String LOCALSERVICE_LISTUI_CLASS = "com.kingdee.eas.tm.im.common.comm.client.LocalServiceListUI";
    private static final String REMOTESERVICE_LISTUI_CLASS = "com.kingdee.eas.tm.im.common.comm.client.RemoteServiceListUI";
    int flag = 1;
    public static final int CURRENT = 1;
    public static final int HISTORY = 2;
    private CommonQueryDialog commonQueryDialog = null;
    private FilterInfo currentFilterInfo = null;
    protected IMetaDataPK logPk = new MetaDataPK("com.kingdee.eas.tm.im.common.comm.app", "TaxTransLogQuery");
    protected IMetaDataPK logHisPk = new MetaDataPK("com.kingdee.eas.tm.im.common.comm.app", "TaxTransLogHisQuery");
    private String currentCUID;
    private int invoicePercent = 0;

    public TaxTransLogListUI() throws Exception {
        this.uiHelper = new ListUIHelper(this);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBtnStatus();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        if (viewInfo.getFilter() == null || viewInfo.getFilter().getFilterItems() == null || viewInfo.getFilter().getFilterItems().size() == 0) {
            this.mainQuery = this.getViewInfoWhenNoSolution();
            this.currentFilterInfo = this.mainQuery.getFilter();
            viewInfo.setFilter(this.mainQuery.getFilter());
        }
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private EntityViewInfo getViewInfoWhenNoSolution() {
        Date currentDate = new Date(System.currentTimeMillis());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(2, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date lastMonth = calendar.getTime();
        FilterInfo filter = new FilterInfo();
        Timestamp dateFrom = new Timestamp(lastMonth.getTime());
        filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)dateFrom, CompareType.GREATER_EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private void initBtnStatus() throws EASBizException, BOSException {
        this.btnAddNew.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.menuItemEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.btnRetry.setEnabled(true);
        this.btnConfirmSuccess.setEnabled(true);
        this.btnConfirmFailure.setEnabled(true);
        this.btnMarkComplete.setEnabled(true);
        this.btnSetCommunication.setEnabled(true);
        this.menuEdit.setVisible(false);
        if (!Administrator.isCUAdmin(null, (IObjectPK)this.getUserPk())) {
            this.btnDump.setVisible(false);
            this.btnSetCommunication.setVisible(false);
            this.btnTaxMsgSetting.setVisible(false);
            this.btnFreeMarker.setVisible(false);
            this.btnLocalService.setVisible(false);
            this.btnRemoteService.setVisible(false);
        } else {
            this.btnDump.setVisible(true);
            this.btnSetCommunication.setVisible(true);
            this.btnTaxMsgSetting.setVisible(true);
            this.btnFreeMarker.setVisible(true);
            this.btnLocalService.setVisible(true);
            this.btnRemoteService.setVisible(true);
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxTransLogFactory.getRemoteInstance();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getType() == 1 && e.getClickCount() == 2) {
            this.checkSelected();
            UIContext ctx = new UIContext((Object)this);
            ctx.put("logId", this.getSelectedKeyValue());
            ctx.put("flag", new Integer(this.flag));
            try {
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.tm.im.common.comm.client.TaxTransLogDetailUI", (Map)ctx);
                uiWindow.show();
            }
            catch (UIException ex) {
                this.handUIException(ex);
            }
        }
    }

    @Override
    public void actionRetry_actionPerformed(ActionEvent e) throws Exception {
        ArrayList ids = this.getSelectedIdValues();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        if (ids.size() > 0) {
            String permItemName = "bd_taxTransLog_retry";
            this.checkFunctionPermission(ids, permItemName);
        }
        this.doActionInDeamon(e, 0);
    }

    @Override
    public void actionConfirmSuccess_actionPerformed(ActionEvent e) throws Exception {
        ArrayList ids = this.getSelectedIdValues();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        if (ids.size() > 0) {
            String permItemName = "bd_taxTransLog_confirmSuccess";
            this.checkFunctionPermission(ids, permItemName);
        }
        this.doActionInDeamon(e, 1);
    }

    @Override
    public void actionConfirmFailure_actionPerformed(ActionEvent e) throws Exception {
        ArrayList ids = this.getSelectedIdValues();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        if (ids.size() > 0) {
            String permItemName = "bd_taxTransLog_confirmFailure";
            this.checkFunctionPermission(ids, permItemName);
        }
        this.doActionInDeamon(e, 2);
    }

    @Override
    public void actionMarkComplete_actionPerformed(ActionEvent e) throws Exception {
        ArrayList ids = this.getSelectedIdValues();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        if (ids.size() > 0) {
            String permItemName = "bd_taxTransLog_markComplete";
            this.checkFunctionPermission(ids, permItemName);
        }
        this.doActionInDeamon(e, 3);
    }

    @Override
    public void actionSetCommunication_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SETCOMMUNCATIONUI_CLASS, (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionTaxMsgSetting_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TAXMESSEGSETTING_CLASS, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionFreeMarker_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IMFREEMARKER_LISTUI_CLASS, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionLocalService_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LOCALSERVICE_LISTUI_CLASS, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionRemoteService_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(REMOTESERVICE_LISTUI_CLASS, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public void checkFunctionPermission(ArrayList ids, String permItemName) throws EASBizException, BOSException {
        TaxTransLogFactory.getRemoteInstance().checkFunctionPermission(ids, permItemName);
    }

    private void doActionInDeamon(ActionEvent e, final int actionType) {
        this.checkSelected();
        this.invoicePercent = 0;
        String parentTxt = "";
        if (e.getSource() instanceof KDWorkButton) {
            KDWorkButton button = (KDWorkButton)e.getSource();
            parentTxt = button.getText();
        } else {
            KDMenuItem item = (KDMenuItem)e.getSource();
            item.getText();
            parentTxt = item.getText();
        }
        final MonitorInfo info = new MonitorInfo(parentTxt, null, (Object)this, true);
        MySwingWork worker = new MySwingWork(){

            public Object construct() {
                try {
                    TaxTransLogListUI.this.doActionWithLock(actionType);
                    TaxTransLogListUI.this.refreshList();
                }
                catch (Exception ex) {
                    TaxTransLogListUI.this.handUIException(ex);
                }
                catch (Throwable ex) {
                    TaxTransLogListUI.this.handUIException(ex);
                }
                return null;
            }

            public void finished() {
                this.timerStop();
                MyThreadPool.destroyMonitor(info);
                MyThreadPool.destroyPorgressDialog();
            }

            @Override
            public void refreshProgress() {
                MyThreadPool.refreshProgress(TaxTransLogListUI.this.invoicePercent);
            }
        };
        info.setWorker((SwingWorker)worker);
        MyThreadPool.getInstance();
        MyThreadPool.addActionThread(info);
        MyThreadPool.setBackgroundRunButtonEnabled(false);
    }

    private void doActionWithLock(int actionType) throws EASBizException, BOSException {
        ArrayList ids = this.getSelectedIdValues();
        try {
            IMUtils.tryLock(ids);
            this.doAction(actionType);
        }
        finally {
            IMUtils.releaseLock(ids);
        }
    }

    private void doAction(int actionType) throws BOSException, EASBizException {
        this.checkSelected();
        ArrayList billIds = this.getAllSelecteIDListValues();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("billIds", billIds);
        params.put("actionType", Integer.valueOf(actionType));
        params.put("flag", Integer.valueOf(this.flag));
        Map ret = TaxTransLogFactory.getRemoteInstance().buildLogParam(params);
        List list = (List)ret.get("list");
        BigDecimal a = new BigDecimal(90);
        BigDecimal b = new BigDecimal(list.size());
        BigDecimal c = BigDecimal.ZERO;
        if (list.size() > 0) {
            c = a.divide(b, 2, RoundingMode.HALF_UP);
        }
        ArrayList<String> errorMsg = new ArrayList<String>();
        Map resultMap = null;
        SendModeEnum sendMode = null;
        String logId = null;
        ArrayList<String> backLogIds = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            resultMap = (Map)list.get(i);
            this.invoicePercent = 10 + c.multiply(new BigDecimal(i)).intValue();
            if (resultMap.containsKey("error")) {
                errorMsg.add((String)resultMap.get("exception"));
                continue;
            }
            try {
                sendMode = (SendModeEnum)((Object)resultMap.get("sendMode"));
                if (SendModeEnum.CLIENT.equals((Object)sendMode)) {
                    PwyInvokeParam invokeParam = (PwyInvokeParam)resultMap.get("invokeParam");
                    if (invokeParam == null) continue;
                    this.doActionInDirect(invokeParam, actionType, errorMsg);
                    continue;
                }
                logId = (String)resultMap.get("logId");
                backLogIds.add(logId);
                continue;
            }
            catch (Exception e) {
                errorMsg.add(e.getMessage());
            }
        }
        if (backLogIds.size() > 0) {
            List backMsg = TaxTransLogFactory.getRemoteInstance().doActions(backLogIds, actionType);
            errorMsg.addAll(backMsg);
        }
        String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.common.comm.IMCommResource", (String)"LOGMSGBILL", (Object[])new Object[]{billIds.size() - errorMsg.size(), errorMsg.size()});
        MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)IMUtils.buildErrorMsg(errorMsg), (int)1);
    }

    private void doActionInDirect(PwyInvokeParam invokeParam, int actionType, ArrayList errorMsg) throws BOSException, EASBizException {
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        IPwyService pwyService = PwyServiceHelper.getPwyService(null, invokeParam);
        if (0 == actionType) {
            IObjectPK logPk = LogUtils.beginLog(null, "retry", BOSObjectType.create((String)"34DD32C1"), (IObjectPK)new ObjectUuidPK(pwyService.getInvokeParam().getPwyLog().getId().toString()), pwyService.getInvokeParam().getPwyLog().getNumber(), "im_taxTransLog_retry", cuInfo.getId().toString());
            pwyService.invoke();
            if (!pwyService.getInvokeParam().isSuccess() && !pwyService.getInvokeParam().isPartSuccess()) {
                errorMsg.add(pwyService.getInvokeParam().getDescription());
            } else {
                LogUtils.afterLog(null, logPk);
            }
        } else if (1 == actionType) {
            IObjectPK logPk = LogUtils.beginLog(null, "confirmSuccess", BOSObjectType.create((String)"34DD32C1"), (IObjectPK)new ObjectUuidPK(pwyService.getInvokeParam().getPwyLog().getId().toString()), pwyService.getInvokeParam().getPwyLog().getNumber(), "im_taxTransLog_confirmSuccess", cuInfo.getId().toString());
            pwyService.getInvokeParam().getPwyLog().setLogStatus(LogStatusEnum.SUCCESS);
            pwyService.updatePwyLog();
            LogUtils.afterLog(null, logPk);
        } else if (2 == actionType) {
            IObjectPK logPk = LogUtils.beginLog(null, "confirmFailure", BOSObjectType.create((String)"34DD32C1"), (IObjectPK)new ObjectUuidPK(pwyService.getInvokeParam().getPwyLog().getId().toString()), pwyService.getInvokeParam().getPwyLog().getNumber(), "im_taxTransLog_confirmFailure", cuInfo.getId().toString());
            pwyService.getInvokeParam().getPwyLog().setLogStatus(LogStatusEnum.FAILURE);
            pwyService.updatePwyLog();
            LogUtils.afterLog(null, logPk);
        } else if (3 == actionType) {
            IObjectPK logPk = LogUtils.beginLog(null, "markComplete", BOSObjectType.create((String)"34DD32C1"), (IObjectPK)new ObjectUuidPK(pwyService.getInvokeParam().getPwyLog().getId().toString()), pwyService.getInvokeParam().getPwyLog().getNumber(), "im_taxTransLog_markComplete", cuInfo.getId().toString());
            pwyService.invokeAfter();
            LogUtils.afterLog(null, logPk);
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setUiObject((IUIObject)this);
        dialog.setParentUIClassName(this.getClass().getName());
        dialog.setQueryObjectPK(this.logPk);
        dialog.setTitle(Resource.LOG_SEARCH);
        dialog.setShowShareType(16);
        dialog.setCurrentShareType(ShareTypeEnum.USER_NOORG_LEVEL);
        try {
            TaxTransLogQueryPanelUI logPanel = new TaxTransLogQueryPanelUI(this.flag);
            dialog.addUserPanel((KDPanel)logPanel);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        dialog.setWidth(600);
        dialog.setHeight(400);
        dialog.setShowFilter(true);
        dialog.setShowSorter(false);
        dialog.setShowToolbar(true);
        return dialog;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        if (!this.isPerformDefaultQuery(iQuery, queryName = TaxTransLogListUI.getQueryInfo((IMetaDataPK)this.logPk).getFullName()) && !this.isFirstDefaultQuery()) {
            if (this.commonQueryDialog == null) {
                this.commonQueryDialog = this.initCommonQueryDialog();
            }
            if (this.commonQueryDialog.show()) {
                this.tHelper.setDialog(this.commonQueryDialog);
                TaxTransLogQueryPanelUI logPanel = (TaxTransLogQueryPanelUI)((Object)this.commonQueryDialog.getCommonQueryParam().getPanels().get(0));
                this.flag = logPanel.getSelectedLogType() == 1 ? 1 : 2;
                FilterInfo filterInfo = this.commonQueryDialog.getEntityViewInfoResult() == null ? null : this.commonQueryDialog.getEntityViewInfoResult().getFilter();
                String filter = null;
                if (filterInfo != null) {
                    FilterInfo aFilter = this.getDefaultFilterForQuery();
                    if (aFilter != null && aFilter.getFilterItems().size() > 0) {
                        if (filterInfo.getFilterItems().size() > 0) {
                            filterInfo.mergeFilter(aFilter, "AND");
                        } else {
                            filterInfo = aFilter;
                        }
                    }
                    filter = filterInfo.toString().trim();
                }
                this.doQuery(this.commonQueryDialog);
                this.currentFilterInfo = filterInfo;
                if (this.flag == 1) {
                    this.showLog();
                } else {
                    this.showHisLog();
                }
            } else {
                this.tHelper.setDialog(this.commonQueryDialog);
                SysUtil.abort();
            }
        }
    }

    private void showLog() throws BOSException, EASBizException {
        this.flag = 1;
        this.mainQueryPK = this.logPk;
        if (this.currentFilterInfo != null) {
            this.mainQuery.setFilter(this.currentFilterInfo);
        }
        this.btnRetry.setVisible(true);
        this.btnConfirmSuccess.setVisible(true);
        this.btnConfirmFailure.setVisible(true);
        this.btnMarkComplete.setVisible(true);
        this.tblMain.removeRows();
        this.showMessageBar(Resource.APPLOG);
    }

    private void showHisLog() throws BOSException {
        this.flag = 2;
        this.mainQueryPK = this.logHisPk;
        this.mainQuery.setFilter(this.currentFilterInfo);
        this.tblMain.removeRows();
        this.btnRetry.setVisible(false);
        this.btnConfirmSuccess.setVisible(false);
        this.btnConfirmFailure.setVisible(false);
        this.btnMarkComplete.setVisible(false);
        this.showMessageBar(Resource.HISLOG);
    }

    protected void doDefaultSolution(IQuerySolutionFacade query, String queryName) throws Exception {
        super.doDefaultSolution(query, queryName);
        if (this.getCurrentSolutionInfo() != null) {
            QueryPanelInfo queryPanelInfo = this.getQueryPanelInfoByTypeAndClassName(this.getCurrentSolutionInfo(), QueryPanelTypeEnum.CUSTOMER_PANEL, "com.kingdee.eas.tm.im.common.comm.client.TaxTransLogQueryPanelUI");
            if (queryPanelInfo == null) {
                this.showLog();
                return;
            }
            String customerParams = queryPanelInfo.getCustomerParams();
            CustomerParams cp = new CustomerParams();
            cp = XMLBean.transStrToCommonCustParams((String)customerParams);
            String flag = cp.getCustomerParam("flag");
            if ("1".equals(flag)) {
                this.showLog();
            } else {
                this.showHisLog();
            }
        }
    }

    private QueryPanelInfo getQueryPanelInfoByTypeAndClassName(QuerySolutionInfo querySolutionInfo, QueryPanelTypeEnum panelType, String className) {
        QueryPanelCollection queryPanelCollection = querySolutionInfo.getQueryPanelInfo();
        int size = queryPanelCollection.size();
        for (int i = 0; i < size; ++i) {
            QueryPanelInfo queryPanelInfo = queryPanelCollection.get(i);
            if (!panelType.equals((Object)queryPanelInfo.getQueryPanelType()) || !className.equals(queryPanelInfo.getPanelClassName())) continue;
            return queryPanelInfo;
        }
        return null;
    }

    private void showMessageBar(String message) {
        final KDLabel barLabel = this.getMainStatusBar().getMsgLabel();
        barLabel.setForeground(SHOW_MESSAGE_FG_DEFAULT);
        final Color bg = this.getMessageBgcolor();
        barLabel.setIcon(this.getMessageIcon());
        barLabel.setText(message);
        if (bg != null && !this.isShowTextOnly()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    barLabel.setBackground(bg);
                                    barLabel.setOpaque(true);
                                    barLabel.repaint();
                                }
                            });
                            Thread.sleep(200L);
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    barLabel.setOpaque(false);
                                    barLabel.repaint();
                                }
                            });
                            Thread.sleep(200L);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).start();
        }
        barLabel.setText(message);
    }

    @Override
    public void actionDump_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"logUI", (Object)this);
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.tm.im.common.comm.client.TaxTransLogDumpUI", (Map)uiContext);
            uiWindow.show();
        }
        catch (UIException ex) {
            this.handUIException(ex);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.uiHelper.getHasPermissionOrgFilterForQuery();
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
        this.initUIMainOrgContext(orgID);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }
}

