/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.msg.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.InvResourceType;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.common.comm.msg.parser.AbstractIncomeInvoiceParser;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.math.BigDecimal;
import java.util.Map;

@Deprecated
public class IncomeInvoiceDownloadDetailParser
extends AbstractIncomeInvoiceParser {
    private static String original = null;
    private static String discount = null;
    private static String saleList = null;

    public IncomeInvoiceCollection parse(Context ctx, Map params) throws BOSException, EASBizException, JSONException {
        original = IMUtils.getString("com.kingdee.eas.tm.im.IMResource", "ORIGINAL_TOTAL", IMUtils.getLocale());
        discount = IMUtils.getString("com.kingdee.eas.tm.im.IMResource", "TOTAL_DISCOUNT", IMUtils.getLocale());
        saleList = IMUtils.getString("com.kingdee.eas.tm.im.IMResource", "SALES_LIST_FOR_DETAIL", IMUtils.getLocale());
        String orgid = (String)params.get("orgid");
        String retInfo = (String)params.get("retInfo");
        JSONObject dataJson = new JSONObject(retInfo);
        IncomeInvoiceCollection invoiceColl = new IncomeInvoiceCollection();
        String errcode = this.getStringValue(dataJson, "errcode");
        if (this.getSuccessCode().equals(errcode)) {
            JSONArray jsonArray = this.getJSONArray(dataJson, "invoice");
            int size = jsonArray.length();
            for (int i = 0; i < size; ++i) {
                IncomeInvoiceInfo invoiceInfo = this.parseHead(ctx, orgid, jsonArray.getJSONObject(i));
                if (invoiceInfo == null) continue;
                invoiceColl.add(invoiceInfo);
            }
        }
        return invoiceColl;
    }

    private IncomeInvoiceInfo parseHead(Context ctx, String orgid, JSONObject invoiceObject) throws BOSException, EASBizException, JSONException {
        IncomeInvoiceInfo invoiceInfo = null;
        IncomeInvoiceInfo srcInfo = null;
        String invoiceCode = null;
        String invoiceNumber = null;
        invoiceCode = this.getStringValue(invoiceObject, "fpdm");
        invoiceInfo = this.getIncomeInvoiceInfo(ctx, invoiceCode, invoiceNumber = this.getStringValue(invoiceObject, "fphm"));
        if (invoiceInfo == null || invoiceInfo.getId() == null) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        invoiceInfo.setCompany(companyInfo);
        String taxPeriod = this.getStringValue(invoiceObject, "taxbelong");
        if (taxPeriod != null && !"".equals(taxPeriod.trim())) {
            int year = Integer.parseInt(taxPeriod.substring(0, 4));
            int number = Integer.parseInt(taxPeriod.substring(4, 6));
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)year, (int)number, (CompanyOrgUnitInfo)companyInfo);
            invoiceInfo.setBelongTaxPeriod(periodInfo);
        }
        invoiceInfo.setInvoiceCode(invoiceCode);
        invoiceInfo.setInvoiceNumber(invoiceNumber);
        invoiceInfo.setNumber(invoiceInfo.getInvoiceCode() + "_" + invoiceInfo.getInvoiceNumber());
        invoiceInfo.setIsCreditNote(this.getBooleanValue(this.getStringValue(invoiceObject, "kplx")));
        if (invoiceInfo.isIsCreditNote()) {
            invoiceInfo.setSourceInvoiceCode(this.getStringValue(invoiceObject, "yfpdm"));
            invoiceInfo.setSourceInvoiceNumber(this.getStringValue(invoiceObject, "yfphm"));
            srcInfo = this.getIncomeInvoiceInfo(ctx, invoiceInfo.getSourceInvoiceCode(), invoiceInfo.getSourceInvoiceNumber());
            if (srcInfo != null && srcInfo.getId() != null) {
                IMUtils.traceUpAndDown(null, srcInfo.getId().toString(), "1343913D", invoiceInfo.getId().toString(), "1343913D");
            }
        }
        invoiceInfo.setBizDate(this.getDateValue(this.getStringValue(invoiceObject, "kprq")));
        invoiceInfo.setAmount(this.getBigDecimalValue(this.getStringValue(invoiceObject, "hjbhsje")));
        invoiceInfo.setTax(this.getBigDecimalValue(this.getStringValue(invoiceObject, "kphjse")));
        invoiceInfo.setAmountTax(this.getBigDecimalValue(this.getStringValue(invoiceObject, "jshjje")));
        invoiceInfo.setDescription(this.getStringValue(invoiceObject, "bz"));
        invoiceInfo.setTaxNumber(this.getStringValue(invoiceObject, "xhf_nsrsbh"));
        invoiceInfo.setBillingCompany(this.getStringValue(invoiceObject, "xhf_mc"));
        invoiceInfo.setContact(this.getStringValue(invoiceObject, "xhf_dzdh"));
        invoiceInfo.setBankInformation(this.getStringValue(invoiceObject, "xhf_yhzh"));
        invoiceInfo.setIsIssue(this.getBooleanValue(this.getStringValue(invoiceObject, "dkbz")));
        invoiceInfo.setPdfUrl(this.getStringValue(invoiceObject, "pdf_url"));
        invoiceInfo.setInvoiceType(PayInvoiceTypeEnum.VALUEADDEDTAXINV);
        invoiceInfo.setResourceType(InvResourceType.INV_DOWNLOAD);
        invoiceInfo.setIsInTax(true);
        invoiceInfo.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        JSONArray itemsJsonArray = this.getJSONArray(invoiceObject, "items");
        if (itemsJsonArray != null && itemsJsonArray.length() > 0) {
            invoiceInfo.getEntries().clear();
            int size = itemsJsonArray.length();
            for (int j = 0; j < size; ++j) {
                IncomeInvoiceEntryInfo entryInfo = this.parseEntry(ctx, itemsJsonArray.getJSONObject(j));
                if (entryInfo == null) continue;
                invoiceInfo.getEntries().add(entryInfo);
            }
        }
        return invoiceInfo;
    }

    private IncomeInvoiceEntryInfo parseEntry(Context ctx, JSONObject entryObject) throws BOSException {
        IncomeInvoiceEntryInfo entryInfo = null;
        String goodsName = this.getStringValue(entryObject, "xmmc");
        if (original.equals(goodsName) || discount.equals(goodsName) || saleList.equals(goodsName)) {
            return entryInfo;
        }
        entryInfo = new IncomeInvoiceEntryInfo();
        entryInfo.setProductName(this.getStringValue(entryObject, "xmmc"));
        entryInfo.setSpecs(this.getStringValue(entryObject, "ggxh"));
        entryInfo.setUnitName(this.getStringValue(entryObject, "xmdw"));
        entryInfo.setQuantity(this.getBigDecimalValue(this.getStringValue(entryObject, "xmsl")));
        entryInfo.setTaxExcluded(this.getBigDecimalValue(this.getStringValue(entryObject, "xmdj")));
        entryInfo.setMoney(this.getBigDecimalValue(this.getStringValue(entryObject, "xmje")));
        entryInfo.setTaxRate(this.getBigDecimalValue(this.getStringValue(entryObject, "sl")));
        entryInfo.setTaxAmt(this.getBigDecimalValue(this.getStringValue(entryObject, "se")));
        if (entryInfo.getTaxExcluded() != null) {
            entryInfo.setTaxPrice(entryInfo.getTaxExcluded().multiply(new BigDecimal(1).add(entryInfo.getTaxRate())));
        }
        entryInfo.setTaxTotal(entryInfo.getMoney().add(entryInfo.getTaxAmt()));
        entryInfo.setTaxClassificationNumber(this.getStringValue(entryObject, "spbm"));
        if (entryInfo.getTaxClassificationNumber() != null) {
            EntityViewInfo taxClassView = new EntityViewInfo();
            FilterInfo taxClassFilter = new FilterInfo();
            taxClassFilter.getFilterItems().add(new FilterItemInfo("mergeCode", (Object)entryInfo.getTaxClassificationNumber(), CompareType.EQUALS));
            taxClassView.setFilter(taxClassFilter);
            TaxClassificationCodeCollection taxClassColl = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(taxClassView);
            if (taxClassColl != null && taxClassColl.size() > 0) {
                TaxClassificationCodeInfo taxClassInfo = taxClassColl.get(0);
                entryInfo.setTaxClassificationCode(taxClassInfo);
            }
        }
        return entryInfo;
    }
}

