/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.msg.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IncomeAuthenticateEnum;
import com.kingdee.eas.tm.im.IncomeAuthenticateStatusEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.InvResourceType;
import com.kingdee.eas.tm.im.PwyHelper;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.common.comm.msg.parser.AbstractIncomeInvoiceParser;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Map;

@Deprecated
public class IncomeInvoiceDownloadWebParser
extends AbstractIncomeInvoiceParser {
    private static String original = null;
    private static String discount = null;
    private static String saleList = null;

    public IncomeInvoiceCollection parse(Context ctx, Map params) throws BOSException, EASBizException, JSONException {
        original = IMUtils.getString("com.kingdee.eas.tm.im.IMResource", "ORIGINAL_TOTAL", IMUtils.getLocale());
        discount = IMUtils.getString("com.kingdee.eas.tm.im.IMResource", "TOTAL_DISCOUNT", IMUtils.getLocale());
        saleList = IMUtils.getString("com.kingdee.eas.tm.im.IMResource", "SALES_LIST_FOR_DETAIL", IMUtils.getLocale());
        String orgid = (String)params.get("orgid");
        String retInfo = (String)params.get("retInfo");
        JSONObject dataJson = new JSONObject(retInfo);
        String errcode = this.getStringValue(dataJson, "errcode");
        IncomeInvoiceCollection invoiceColl = new IncomeInvoiceCollection();
        IncomeInvoiceInfo invoiceInfo = null;
        if (this.getSuccessCode().equals(errcode)) {
            JSONArray jsonArray = this.getJSONArray(dataJson, "data");
            int size = jsonArray.length();
            for (int i = 0; i < size; ++i) {
                invoiceInfo = this.parseHead(ctx, orgid, jsonArray.getJSONObject(i));
                if (invoiceInfo == null) continue;
                invoiceColl.add(invoiceInfo);
            }
        }
        return invoiceColl;
    }

    private IncomeInvoiceInfo parseHead(Context ctx, String orgid, JSONObject invoiceObject) throws JSONException, EASBizException, BOSException {
        JSONArray itemsJsonArray;
        int authstatus;
        int status;
        IncomeInvoiceInfo invoiceInfo = null;
        IncomeInvoiceInfo srcInfo = null;
        String invoiceCode = null;
        String invoiceNumber = null;
        if (Integer.parseInt(this.getStringValue(invoiceObject, "checkStatus")) == 2) {
            return null;
        }
        String type = this.getStringValue(invoiceObject, "invoiceType");
        if (!("1".equals(type) || "2".equals(type) || "3".equals(type) || "4".equals(type) || "5".equals(type))) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        invoiceInfo = this.getIncomeInvoiceInfo(ctx, invoiceCode, invoiceNumber);
        String taxPeriod = this.getStringValue(invoiceObject, "taxbelong");
        if (taxPeriod != null && !"".equals(taxPeriod.trim())) {
            int year = Integer.parseInt(taxPeriod.substring(0, 4));
            int number = Integer.parseInt(taxPeriod.substring(4, 6));
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)year, (int)number, (CompanyOrgUnitInfo)companyInfo);
            invoiceInfo.setBelongTaxPeriod(periodInfo);
        }
        invoiceCode = this.getStringValue(invoiceObject, "invoiceCode");
        invoiceNumber = this.getStringValue(invoiceObject, "invoiceNo");
        invoiceInfo.setCompany(companyInfo);
        invoiceInfo.setInvoiceCode(invoiceCode);
        invoiceInfo.setInvoiceNumber(invoiceNumber);
        invoiceInfo.setNumber(invoiceInfo.getInvoiceCode() + "_" + invoiceInfo.getInvoiceNumber());
        invoiceInfo.setIsCreditNote(this.getBooleanValue(this.getStringValue(invoiceObject, "type")));
        if (invoiceInfo.isIsCreditNote()) {
            invoiceInfo.setSourceInvoiceCode(this.getStringValue(invoiceObject, "originalInvoiceCode"));
            invoiceInfo.setSourceInvoiceNumber(this.getStringValue(invoiceObject, "originalInvoiceNo"));
            srcInfo = this.getIncomeInvoiceInfo(ctx, invoiceInfo.getSourceInvoiceCode(), invoiceInfo.getSourceInvoiceNumber());
            if (srcInfo != null && srcInfo.getId() != null) {
                IMUtils.traceUpAndDown(null, srcInfo.getId().toString(), "1343913D", invoiceInfo.getId().toString(), "1343913D");
            }
        }
        PwyHelper.setInvoiceType(invoiceInfo, type);
        invoiceInfo.setCheckCode(this.getStringValue(invoiceObject, "checkCode"));
        invoiceInfo.setBizDate(this.getDateValue(this.getStringValue(invoiceObject, "invoiceDate")));
        invoiceInfo.setBillingCompany(this.getStringValue(invoiceObject, "salerName"));
        invoiceInfo.setTaxNumber(this.getStringValue(invoiceObject, "salerTaxNo"));
        invoiceInfo.setContact(this.getStringValue(invoiceObject, "salerAddressPhone"));
        invoiceInfo.setBankInformation(this.getStringValue(invoiceObject, "salerAccount"));
        invoiceInfo.setBuyerTaxNo(this.getStringValue(invoiceObject, "buyerTaxNo"));
        invoiceInfo.setAmount(this.getBigDecimalValue(this.getStringValue(invoiceObject, "invoiceAmount")));
        invoiceInfo.setTax(this.getBigDecimalValue(this.getStringValue(invoiceObject, "totalTaxAmount")));
        invoiceInfo.setAmountTax(this.getBigDecimalValue(this.getStringValue(invoiceObject, "totalAmount")));
        invoiceInfo.setDescription(this.getStringValue(invoiceObject, "remark"));
        String invoiceTypeSign = this.getStringValue(invoiceObject, "fplx");
        if (invoiceTypeSign != null && "04".equals(invoiceTypeSign)) {
            invoiceInfo.setTmInvoiceType(TMInvoiceType.INVOICETYPE_TOLL);
        }
        if ((status = Integer.parseInt(this.getStringValue(invoiceObject, "invoiceStatus"))) == 0) {
            invoiceInfo.setStatus(IncomeStatusEnum.NORMAL);
        } else if (status == 1) {
            invoiceInfo.setStatus(IncomeStatusEnum.LOSECONTROL);
        } else if (status == 2) {
            invoiceInfo.setStatus(IncomeStatusEnum.CANCEL);
        } else if (status == 3) {
            invoiceInfo.setStatus(IncomeStatusEnum.CREDIT);
        } else if (status == 4) {
            invoiceInfo.setStatus(IncomeStatusEnum.UNUSUAL);
        } else if (status == 5) {
            invoiceInfo.setStatus(IncomeStatusEnum.UNNORMAL);
        } else if (status == 6) {
            invoiceInfo.setStatus(IncomeStatusEnum.UNCONFIRMRED);
        } else if (status == 7) {
            invoiceInfo.setStatus(IncomeStatusEnum.PARTLYRED);
        } else if (status == 8) {
            invoiceInfo.setStatus(IncomeStatusEnum.FULLRED);
        }
        invoiceInfo.setPdfUrl(this.getStringValue(invoiceObject, "downloadUrl"));
        invoiceInfo.setCheckDate(this.getDateValue(this.getStringValue(invoiceObject, "selectTime")));
        int n = authstatus = this.getStringValue(invoiceObject, "authenticateFlag") == null ? 0 : Integer.parseInt(this.getStringValue(invoiceObject, "authenticateFlag"));
        if (authstatus == 2) {
            invoiceInfo.setAuthenticateStatus(IncomeAuthenticateStatusEnum.PASSED);
            invoiceInfo.setAuthenticateWay(IncomeAuthenticateEnum.MANUAL);
            invoiceInfo.setAuthenticateDate(this.getDateValue(this.getStringValue(invoiceObject, "selectAuthenticateTime")));
        } else if (authstatus == 3) {
            invoiceInfo.setAuthenticateStatus(IncomeAuthenticateStatusEnum.PASSED);
            invoiceInfo.setAuthenticateWay(IncomeAuthenticateEnum.SCAN);
            invoiceInfo.setAuthenticateDate(this.getDateValue(this.getStringValue(invoiceObject, "scanAuthenticateTime")));
        } else {
            invoiceInfo.setAuthenticateStatus(IncomeAuthenticateStatusEnum.UNAUTHORIZED);
        }
        if (invoiceInfo.getId() == null) {
            invoiceInfo.setResourceType(InvResourceType.INV_DOWNLOAD);
            invoiceInfo.setIsInTax(true);
            invoiceInfo.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        }
        if ((itemsJsonArray = this.getJSONArray(invoiceObject, "items")) != null && itemsJsonArray.length() > 0) {
            invoiceInfo.getEntries().clear();
            int size = itemsJsonArray.length();
            for (int j = 0; j < size; ++j) {
                IncomeInvoiceEntryInfo entryInfo = this.parseEntry(ctx, itemsJsonArray.getJSONObject(j));
                if (entryInfo == null) continue;
                invoiceInfo.getEntries().add(entryInfo);
            }
        }
        return invoiceInfo;
    }

    private IncomeInvoiceEntryInfo parseEntry(Context ctx, JSONObject entryObject) throws BOSException {
        String goodsCode;
        IncomeInvoiceEntryInfo entryInfo = null;
        String goodsName = this.getStringValue(entryObject, "goodsName");
        if (original.equals(goodsName) || discount.equals(goodsName) || saleList.equals(goodsName)) {
            return entryInfo;
        }
        entryInfo = new IncomeInvoiceEntryInfo();
        entryInfo.setProductName(this.getStringValue(entryObject, "goodsName"));
        entryInfo.setSpecs(this.getStringValue(entryObject, "specModel"));
        entryInfo.setUnitName(this.getStringValue(entryObject, "unit"));
        entryInfo.setTaxExcluded(this.getBigDecimalValue(this.getStringValue(entryObject, "unitPrice")));
        entryInfo.setQuantity(this.getBigDecimalValue(this.getStringValue(entryObject, "num")));
        entryInfo.setTaxAmt(this.getBigDecimalValue(this.getStringValue(entryObject, "taxAmount")));
        entryInfo.setTaxRate(this.getBigDecimalValue(this.getStringValue(entryObject, "taxRate")));
        entryInfo.setMoney(this.getBigDecimalValue(this.getStringValue(entryObject, "detailAmount")));
        if (entryInfo.getTaxExcluded() != null) {
            entryInfo.setTaxPrice(entryInfo.getTaxExcluded().multiply(new BigDecimal(1).add(entryInfo.getTaxRate())));
        }
        if (!StringUtils.isEmpty((String)(goodsCode = this.getStringValue(entryObject, "goodsCode")))) {
            entryInfo.setTaxClassificationNumber(goodsCode);
            EntityViewInfo taxClassView = new EntityViewInfo();
            FilterInfo taxClassFilter = new FilterInfo();
            taxClassFilter.getFilterItems().add(new FilterItemInfo("mergeCode", (Object)goodsCode, CompareType.EQUALS));
            taxClassView.setFilter(taxClassFilter);
            TaxClassificationCodeCollection taxClassColl = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(taxClassView);
            if (taxClassColl != null && taxClassColl.size() > 0) {
                TaxClassificationCodeInfo taxClassInfo = taxClassColl.get(0);
                entryInfo.setTaxClassificationCode(taxClassInfo);
            }
        }
        entryInfo.setTaxTotal(entryInfo.getMoney().add(entryInfo.getTaxAmt()));
        return entryInfo;
    }
}

