/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.msg.parser;

import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckTypeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckWayEnum;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.NotDeductibleTypeEnum;
import com.kingdee.eas.tm.common.invoicePool.TMCheckStatus;
import com.kingdee.eas.tm.common.invoicePool.TMDiscountType;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.TMZeroTaxRateFlag;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.eas.tm.common.utils.TMJsonParser;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.common.comm.service.util.IncomeInvoicePwyHelper;
import com.kingdee.eas.tm.im.util.CheckAbsUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

public class IncomeInvoiceParser {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger((String)"IncomeInvoicePaser");
    private static final String BOSTYPE_INCOMEINVOICE = "1343913D";
    private Context ctx;
    private TMJsonParser parser;

    public IncomeInvoiceParser(Context ctx) {
        this.ctx = ctx;
    }

    public IncomeInvoiceParser(Context ctx, JSONObject jsonObject) {
        this.ctx = ctx;
        this.parser = new TMJsonParser(jsonObject);
    }

    public void reloadJson(JSONObject jsonObject) {
        this.parser = new TMJsonParser(jsonObject);
    }

    public String getMutex() {
        String invoiceCode = this.parser.getString("invoiceCode");
        String invoiceNo = this.parser.getString("invoiceNo");
        return invoiceCode + "_" + invoiceNo;
    }

    public IncomeInvoiceInfo getIncomeInvoiceInfo() {
        String invoiceType = this.parser.getString("invoiceType");
        PayInvoiceTypeEnum invoiceTypeEnum = this.getInvoiceType(invoiceType);
        if (invoiceTypeEnum == null) {
            logger.debug((Object)("Ignore! not vat invoice,type : " + invoiceType));
            return null;
        }
        TMInvoiceType tmInvoiceType = this.getTMInvoiceType(invoiceType);
        IncomeStatusEnum incomeStatusEnum = this.getIncomeStatusEnum(this.parser.getString("invoiceStatus"));
        if (incomeStatusEnum == null) {
            logger.debug((Object)"Ignore! incomeStatusEnum is null ");
            return null;
        }
        TMCheckStatus checkStatus = (TMCheckStatus)this.parser.getEnum(TMCheckStatus.class, "checkStatus");
        if (TMCheckStatus.NOT_PASS.equals((Object)checkStatus)) {
            logger.debug((Object)"Ignore! checkStatus not pass. ");
            return null;
        }
        String invoiceCode = this.parser.getString("invoiceCode");
        String invoiceNo = this.parser.getString("invoiceNo");
        IncomeInvoiceInfo invoice = IncomeInvoicePwyHelper.getInfoWithNumber(this.ctx, invoiceCode, invoiceNo);
        invoice.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        invoice.setInvoiceType(invoiceTypeEnum);
        invoice.setTmInvoiceType(tmInvoiceType);
        if (invoice.getStatus() != null && !incomeStatusEnum.equals((Object)invoice.getStatus())) {
            invoice.put("statusChaged", true);
            invoice.put("oldStatus", invoice.getStatus().getAlias());
            invoice.put("CurStatus", incomeStatusEnum.getAlias());
        }
        invoice.setStatus(incomeStatusEnum);
        invoice.setCheckStatus(checkStatus);
        invoice.setSerialNo(this.parser.getString("serialNo"));
        invoice.setBizDate(this.parser.getDate("invoiceDate"));
        invoice.setCheckCode(this.parser.getString("checkCode"));
        invoice.setBillingCompany(this.parser.getString("salerName"));
        invoice.setTaxNumber(this.parser.getString("salerTaxNo"));
        invoice.setContact(this.parser.getString("salerAddressPhone"));
        invoice.setBankInformation(this.parser.getString("salerAccount"));
        invoice.setBuyerName(this.parser.getString("buyerName"));
        invoice.setBuyerTaxNo(this.parser.getString("buyerTaxNo"));
        invoice.setBuyerAddressPhone(this.parser.getString("buyerAddressPhone"));
        invoice.setBuyerAccount(this.parser.getString("buyerAccount"));
        invoice.setAmount(this.parser.getBigDecimal("invoiceAmount"));
        invoice.setTax(this.parser.getBigDecimal("totalTaxAmount"));
        invoice.setAmountTax(this.parser.getBigDecimal("totalAmount"));
        invoice.setDescription(TMJsonParser.handleDescription((String)this.parser.getString("remark")));
        invoice.setMachineNo(this.parser.getString("machineNo"));
        invoice.setDrawer(this.parser.getString("drawer"));
        invoice.setReviewer(this.parser.getString("reviewer"));
        invoice.setPayee(this.parser.getString("payee"));
        invoice.setPdfUrl(this.parser.getString("pdfurl"));
        invoice.setInvalidDate(this.parser.getDate("invalidDate"));
        invoice.setIsCreditNote(this.parser.getBoolean("type"));
        invoice.setSourceInvoiceCode(this.parser.getString("originalInvoiceCode"));
        invoice.setSourceInvoiceNumber(this.parser.getString("originalInvoiceNo"));
        if ("4".equals(invoiceType) || "2".equals(invoiceType)) {
            this.parseCheckAbs(invoice);
        }
        invoice.setIsIssue(this.parser.getBoolean("proxyMark"));
        this.parseEntry(invoice);
        logger.debug((Object)("parse success: " + invoice.getNumber()));
        return invoice;
    }

    protected void parseCheckAbs(IncomeInvoiceInfo invoice) {
        Timestamp selectTime = this.parser.getTimestamp("selectTime");
        String authenticateFlag = this.parser.getString("authenticateFlag");
        Timestamp selectAuthenticateTime = this.parser.getTimestamp("selectAuthenticateTime");
        Timestamp scanAuthenticateTime = this.parser.getTimestamp("scanAuthenticateTime");
        String deductionPurpose = this.parser.getString("deductionPurpose");
        String taxPeriod = this.parser.getString("taxPeriod");
        String salerName = this.parser.getString("salerName");
        String salerTaxNo = this.parser.getString("salerTaxNo");
        BigDecimal effectiveTaxAmount = this.parser.getBigDecimal("effectiveTaxAmount");
        String notDeductibleType = this.parser.getString("notDeductibleType");
        CheckAbsInfo checkAbs = invoice.getCheckAbs();
        if (checkAbs == null) {
            checkAbs = CheckAbsUtil.createCheckAbs(invoice);
            invoice.setCheckAbs(checkAbs);
        }
        CheckStateEnum checkState = "0".equals(authenticateFlag) ? CheckStateEnum.Unchecked : CheckStateEnum.Checked;
        if (effectiveTaxAmount != null) {
            checkAbs.setEffectiveTaxAmt(effectiveTaxAmount);
        }
        checkAbs.setSalerName(salerName);
        checkAbs.setSalerTaxNo(salerTaxNo);
        checkAbs.setCheckState(checkState);
        checkAbs.setNotDeductibleType(NotDeductibleTypeEnum.getEnum((String)notDeductibleType));
        if (CheckStateEnum.Checked.equals((Object)checkState)) {
            checkAbs.setCheckTime((Date)selectTime);
            if ("3".equals(authenticateFlag)) {
                checkAbs.setCheckWay(CheckWayEnum.Scan);
                checkAbs.setConfirmTime((Date)scanAuthenticateTime);
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else if ("2".equals(authenticateFlag)) {
                checkAbs.setCheckWay(CheckWayEnum.Check);
                checkAbs.setConfirmTime((Date)selectAuthenticateTime);
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else if ("1".equals(authenticateFlag)) {
                checkAbs.setCheckWay(CheckWayEnum.Check);
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            } else {
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            }
            if (checkAbs.getCheckType() == null) {
                checkAbs.setCheckType(CheckTypeEnum.OFFLINE);
            }
            if (invoice.getCompany() == null) {
                checkAbs.put("taxPeriodStr", (Object)taxPeriod);
            } else {
                checkAbs.setTaxPeriod(CheckAbsUtil.getPeriodInfo(this.ctx, taxPeriod, invoice.getCompany()));
            }
            checkAbs.setCheckPurpose(CheckAbsUtil.getPurposeByValue(deductionPurpose));
        } else {
            checkAbs.setCheckTime(null);
            checkAbs.setCheckWay(null);
            checkAbs.setCheckPurpose(null);
            checkAbs.setCheckUser(null);
            checkAbs.setTaxPeriod(null);
            checkAbs.setConfirmTime(null);
            checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            checkAbs.setConfirmUser(null);
            checkAbs.setCheckType(null);
        }
    }

    private void parseEntry(IncomeInvoiceInfo invoice) {
        try {
            if (invoice.getEntries().size() > 0) {
                return;
            }
            JSONArray items = this.parser.getJSONArray("items");
            String original = IMUtils.getString("com.kingdee.eas.tm.im.IMResource", "ORIGINAL_TOTAL", LocaleUtils.locale_zh_CN);
            String discount = IMUtils.getString("com.kingdee.eas.tm.im.IMResource", "TOTAL_DISCOUNT", LocaleUtils.locale_zh_CN);
            String saleList = IMUtils.getString("com.kingdee.eas.tm.im.IMResource", "SALES_LIST_FOR_DETAIL", LocaleUtils.locale_zh_CN);
            if (items != null && items.length() > 0) {
                int size = items.length();
                for (int j = 0; j < size; ++j) {
                    JSONObject entryJson = items.getJSONObject(j);
                    this.parser.setJsonObject(entryJson);
                    IncomeInvoiceEntryInfo entry = new IncomeInvoiceEntryInfo();
                    String goodsName = this.parser.getString("goodsName");
                    if (original.equals(goodsName) || discount.equals(goodsName) || saleList.equals(goodsName)) continue;
                    entry.setProductName(goodsName);
                    entry.setTaxClassificationNumber(this.parser.getString("goodsCode"));
                    if (entry.getTaxClassificationNumber() != null) {
                        EntityViewInfo taxClassView = new EntityViewInfo();
                        FilterInfo taxClassFilter = new FilterInfo();
                        taxClassFilter.getFilterItems().add(new FilterItemInfo("mergeCode", (Object)entry.getTaxClassificationNumber(), CompareType.EQUALS));
                        taxClassView.setFilter(taxClassFilter);
                        TaxClassificationCodeCollection taxClassColl = this.ctx == null ? TaxClassificationCodeFactory.getRemoteInstance().getTaxClassificationCodeCollection(taxClassView) : TaxClassificationCodeFactory.getLocalInstance(this.ctx).getTaxClassificationCodeCollection(taxClassView);
                        if (taxClassColl != null && taxClassColl.size() > 0) {
                            TaxClassificationCodeInfo taxClassInfo = taxClassColl.get(0);
                            entry.setTaxClassificationCode(taxClassInfo);
                        }
                    }
                    entry.setSpecs(this.parser.getString("specModel"));
                    entry.setUnitName(this.parser.getString("unit"));
                    entry.setTaxExcluded(this.parser.getBigDecimal("unitPrice"));
                    if (this.parser.getBigDecimal("unitPrice") != null && this.parser.getBigDecimal("taxRate") != null) {
                        entry.setTaxPrice(this.parser.getBigDecimal("unitPrice").multiply(BigDecimal.ONE.add(this.parser.getBigDecimal("taxRate"))));
                    }
                    entry.setQuantity(this.parser.getBigDecimal("num"));
                    entry.setTaxAmt(this.parser.getBigDecimal("taxAmount"));
                    entry.setTaxRate(this.parser.getBigDecimal("taxRate"));
                    entry.setMoney(this.parser.getBigDecimal("detailAmount"));
                    entry.setTaxTotal(entry.getTaxAmt().add(entry.getMoney()));
                    entry.setZeroTaxRateFlag((TMZeroTaxRateFlag)this.parser.getEnum(TMZeroTaxRateFlag.class, "zeroTaxRateFlag"));
                    entry.setDiscountType((TMDiscountType)this.parser.getEnum(TMDiscountType.class, "discountType"));
                    entry.setPreferentialPolicy(this.parser.getBoolean("preferentialPolicy"));
                    entry.setVersionNo(this.parser.getString("versionNo"));
                    invoice.getEntries().add(entry);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public IncomeStatusEnum getIncomeStatusEnum(String value) {
        if ("0".equals(value)) {
            return IncomeStatusEnum.NORMAL;
        }
        if ("1".equals(value)) {
            return IncomeStatusEnum.LOSECONTROL;
        }
        if ("2".equals(value)) {
            return IncomeStatusEnum.CANCEL;
        }
        if ("3".equals(value)) {
            return IncomeStatusEnum.CREDIT;
        }
        if ("4".equals(value)) {
            return IncomeStatusEnum.UNUSUAL;
        }
        if ("5".equals(value)) {
            return IncomeStatusEnum.UNNORMAL;
        }
        if ("6".equals(value)) {
            return IncomeStatusEnum.UNCONFIRMRED;
        }
        if ("7".equals(value)) {
            return IncomeStatusEnum.PARTLYRED;
        }
        if ("8".equals(value)) {
            return IncomeStatusEnum.FULLRED;
        }
        return null;
    }

    public PayInvoiceTypeEnum getInvoiceType(String value) {
        if ("1".equals(value)) {
            return PayInvoiceTypeEnum.ELECTRONICINVOICE;
        }
        if ("2".equals(value)) {
            return PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE;
        }
        if ("3".equals(value)) {
            return PayInvoiceTypeEnum.COMMONINVOICE;
        }
        if ("4".equals(value)) {
            return PayInvoiceTypeEnum.VALUEADDEDTAXINV;
        }
        if ("5".equals(value)) {
            return PayInvoiceTypeEnum.COMMONINVOICE;
        }
        return null;
    }

    public TMInvoiceType getTMInvoiceType(String value) {
        if ("1".equals(value)) {
            return TMInvoiceType.INVOICETYPE_COMMON_ELECTRONIC;
        }
        if ("2".equals(value)) {
            return TMInvoiceType.INVOICETYPE_ELECTRONIC_SPECIAL;
        }
        if ("3".equals(value)) {
            return TMInvoiceType.INVOICETYPE_COMMON_PAPER;
        }
        if ("4".equals(value)) {
            return TMInvoiceType.INVOICETYPE_SPECIAL_PAPER;
        }
        if ("5".equals(value)) {
            return TMInvoiceType.INVOICETYPE_COMMON_PAPER_ROLL;
        }
        return null;
    }

    public void handleCompany(IncomeInvoiceInfo invoiceInfo, CompanyOrgUnitInfo companyInfo) {
        if (invoiceInfo.isIsAccept()) {
            return;
        }
        if (invoiceInfo.isFiVouchered()) {
            return;
        }
        if (invoiceInfo.getBizBillID() != null) {
            return;
        }
        invoiceInfo.setCompany(companyInfo);
        if (invoiceInfo.getCheckAbs() != null && invoiceInfo.getCheckAbs().get("taxPeriodStr") != null) {
            invoiceInfo.getCheckAbs().setTaxPeriod(CheckAbsUtil.getPeriodInfo(this.ctx, (String)invoiceInfo.getCheckAbs().get("taxPeriodStr"), invoiceInfo.getCompany()));
        }
    }

    public String handleDescription(String remark) {
        if (StringUtils.isEmpty((String)remark)) {
            return null;
        }
        remark = remark.replace("&lt;br/&gt;", "\r\n");
        remark = remark.replace("<br/>", "\r\n");
        return remark;
    }
}

