/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.makeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoicePwyService;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class MakeInvoiceDiskPwyService
extends MakeInvoicePwyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoiceDiskPwyService");

    public MakeInvoiceDiskPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public MakeInvoiceDiskPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    protected Map getPwyData() throws EASBizException, BOSException {
        MakeInvoiceInfo info;
        Map jsonMap = this.getPwyHead();
        jsonMap.put("sfrz", this.getPwySfrz());
        Map pwySjd = this.getPwySjd();
        if (this.getInvokeParam().getSetting().getBankAccount() != null && !this.getInvokeParam().getSetting().getBankAccount().trim().isEmpty()) {
            pwySjd.put("xhf_yhzh", this.getInvokeParam().getSetting().getBankAccount().trim());
        }
        if (this.getInvokeParam().getSetting().getAddressPhone() != null && !this.getInvokeParam().getSetting().getAddressPhone().trim().isEmpty()) {
            pwySjd.put("xhf_dzdh", this.getInvokeParam().getSetting().getAddressPhone().trim());
        }
        if ((info = this.getInvoice()) != null && this.isMakeInvoiceOprt(info)) {
            if (info.isIsPurchaseInvoice()) {
                pwySjd.put("sgfp", "2");
            } else if (info.isIsVehicle()) {
                pwySjd.put("sgfp", "18");
            }
        }
        String[] replaceFields = new String[]{"xhf_yhzh", "xhf_dzdh", "ghf_dzdh", "ghf_yhzh", "bz"};
        this.replaceSpecialCharToBlank(pwySjd, replaceFields);
        jsonMap.put("sjd", pwySjd);
        return jsonMap;
    }

    private void replaceSpecialCharToBlank(Map pwySjd, String[] fields) {
        int size = fields.length;
        for (int i = 0; i < size; ++i) {
            pwySjd.put(fields[i], this.replaceSpecialCharToBlank((String)pwySjd.get(fields[i])));
        }
    }

    private String replaceSpecialCharToBlank(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        byte[] utf8Space = new byte[]{-62, -96};
        try {
            value = value.replace(new String(utf8Space, "UTF-8"), " ");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage());
        }
        return value;
    }

    protected boolean isMakeInvoiceOprt(MakeInvoiceInfo info) {
        if (info == null) {
            return false;
        }
        ArrayList<String> oprt = new ArrayList<String>();
        oprt.add("3");
        oprt.add("110");
        oprt.add("100");
        return oprt.indexOf(this.getPwyCzlx()) > -1;
    }

    private Map getPwyHead() {
        String czlx = this.getPwyCzlx();
        String authCode = this.getAuthcode();
        String tid = this.getTid();
        return this.getPwyHelper().getHead(czlx, authCode, tid);
    }

    @Override
    public String getBaseURL() {
        return this.getInvokeParam().getSetting().getHttpAddress();
    }

    private Map getPwySfrz() {
        return this.getPwyHelper().getSfrzForMakeInvoice(this.getInvokeParam().getSetting());
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
    }

    public abstract Map getPwySjd() throws EASBizException, BOSException;

    @Override
    public abstract String getPwyCzlx();

    public abstract String getAuthcode();

    public abstract String getTid();

    @Override
    public abstract String getSuccessCode();

    @Override
    public String getPartSuccessCode() {
        return null;
    }
}

