/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.makeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.PaperPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MakeInvoicePaperPwyService
extends PaperPwyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.MakeInvoicePaperPwyService");

    public MakeInvoicePaperPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public MakeInvoicePaperPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public Map getPwySjd() throws BOSException {
        return this.getPwyHelper().getMakeInvoiceSjd(this.getInvoice(), this.getCtx());
    }

    @Override
    public String getPwyCzlx() {
        return "3";
    }

    @Override
    protected int getDefaultRetryTimes() {
        return 3;
    }

    @Override
    public String getTid() {
        if (this.getInvokeParam().getCompany() != null) {
            String taxNo = this.getInvokeParam().getCompany().getTaxNumber();
            if (!StringUtils.isEmpty((String)taxNo)) {
                taxNo = taxNo.trim();
            }
            return taxNo;
        }
        return "";
    }

    @Override
    public String getSuccessCode() {
        return "0";
    }

    @Override
    protected void resolveSuccess() {
        JSONObject resultJson = null;
        try {
            resultJson = new JSONObject(this.getInvokeParam().getRevMsg());
            JSONArray jsonArray = resultJson.getJSONArray("lists");
            JSONObject invoiceJson = jsonArray.getJSONObject(0);
            this.getInvokeParam().getPwyLog().setInvoiceNum(invoiceJson.getString("fphm"));
            this.getInvokeParam().getPwyLog().setInvoiceCode(invoiceJson.getString("fpdm"));
            JSONObject device = resultJson.getJSONObject("device_info");
            HashMap params = this.getInvokeParam().getParams();
            if (params == null) {
                params = new HashMap();
                this.getInvokeParam().setParams(params);
            }
            this.getInvokeParam().getParams().put("card_no", device.getString("card_no"));
            this.getInvokeParam().getParams().put("subid", device.getString("subid"));
            this.getInvokeParam().getParams().put("taxcode", device.getString("taxcode"));
            if (invoiceJson.has("pdfurl")) {
                this.getInvokeParam().getParams().put("pdfurl", invoiceJson.getString("pdfurl"));
            }
        }
        catch (Exception e) {
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("invoiceNo", this.getInvokeParam().getPwyLog().getInvoiceNum());
        param.put("invoiceNum", this.getInvokeParam().getPwyLog().getInvoiceCode());
        if (this.getInvokeParam().getParams() != null) {
            param.put("card_no", (String)this.getInvokeParam().getParams().get("card_no"));
            param.put("subid", (String)this.getInvokeParam().getParams().get("subid"));
            param.put("taxcode", (String)this.getInvokeParam().getParams().get("taxcode"));
            if (this.getInvokeParam().getParams().containsKey("pdfurl")) {
                param.put("pdfurl", (String)this.getInvokeParam().getParams().get("pdfurl"));
            }
        }
        BizInterfaceFactory.getMakeInvoice(this.getCtx()).make((IObjectPK)new ObjectUuidPK(this.getInvoice().getId().toString()), param);
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }
}

