/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.print;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.basedata.InvoiceScanFacadeFactory;
import com.kingdee.eas.tm.im.basedata.QrGenerateRecordInfo;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class IMPrintCommonDataProvider
implements BOSQueryDelegate {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.print.IMPrintCommonDataProvider");
    private List<String> ids = null;
    private IMetaDataPK qpk = null;
    private KDNoteHelper appHlp = null;
    private BOSObjectType bosType = null;

    public IMPrintCommonDataProvider() {
    }

    public IMPrintCommonDataProvider(KDNoteHelper appHlp, BOSObjectType bosType, List<String> ids) {
        this.appHlp = appHlp;
        this.bosType = bosType;
        this.ids = ids;
        logger.error((Object)("---IMPrintCommonDataProvider ids=" + ids + ",bosType=" + bosType + ",appHlp=" + appHlp));
    }

    public IMPrintCommonDataProvider(List<String> ids, IMetaDataPK qpk) {
        this.ids = ids;
        this.qpk = qpk;
        logger.error((Object)("---IMPrintCommonDataProvider ids=" + ids + ",qpk=" + qpk + ",bosType=" + this.bosType));
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        try {
            String str = ds.getID();
            if ("MakeInvoicePreviewQuery".equals(str) || "MakeInvoicePreviewQuery2".equals(str)) {
                String orgid;
                IQueryExecutor queryExcu = null;
                MetaDataPK queryPK = null;
                String queryKey = "com.kingdee.eas.tm.im.app.MakeInvoicePreviewQuery";
                queryPK = new MetaDataPK(queryKey);
                Locale locale = SysContext.getSysContext().getLocale();
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                HashSet<String> idset = new HashSet<String>(this.ids);
                fi.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
                viewInfo.setFilter(fi);
                queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
                queryExcu.setObjectView(viewInfo);
                IRowSet rows = queryExcu.executeQuery();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("entries.*"));
                sic.add(new SelectorItemInfo("company.*"));
                sic.add(new SelectorItemInfo("company.bank.*"));
                MakeInvoiceInfo invoiceInfo = MakeInvoiceFactory.getRemoteInstance().getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(this.ids.get(0)), sic);
                int pricePrecision = IMUtils.getDecimalParam(null, invoiceInfo.getCompany().getId().toString(), new String[]{"VATM001"}).intValue();
                String productListName = IMUtils.getString("com.kingdee.eas.tm.im.IMResource", "SALES_LIST_FOR_DETAIL", locale);
                boolean isRateSame = true;
                MakeInvoiceEntryInfo entryInfo = null;
                BigDecimal tempRate = null;
                if (invoiceInfo.getEntries().size() > 1) {
                    int size = invoiceInfo.getEntries().size();
                    for (int i = 0; i < size; ++i) {
                        entryInfo = invoiceInfo.getEntries().get(i);
                        if (tempRate != null && entryInfo.getTaxRate() != null && tempRate.compareTo(entryInfo.getTaxRate()) != 0) {
                            isRateSame = false;
                            break;
                        }
                        tempRate = entryInfo.getTaxRate();
                    }
                }
                if (StringUtils.isEmpty((String)(orgid = invoiceInfo.getMakeInvoiceOrgID()))) {
                    orgid = invoiceInfo.getCompany().getId().toString();
                }
                CompanyOrgUnitInfo companyInfo = invoiceInfo.getCompany();
                PwySettingInfo setting = PwySettingFactory.getRemoteInstance().getCollectionByCompany(orgid, OPTypeEnum.MakeInvoice, invoiceInfo.getId().toString(), null);
                int defaultPrecision = 2;
                String[] amtFields = new String[]{"noTaxAmtTotal", "taxAmtTotal", "priceTaxTotal", "entries.noTaxAmt", "entries.taxAmt", "entries.priceTax"};
                BigDecimal amt = null;
                while (rows.next()) {
                    String preferentialPolicies;
                    BigDecimal noTaxPrice;
                    BigDecimal noTaxAmtTotal = rows.getBigDecimal("noTaxAmtTotal");
                    BigDecimal taxAmtTotal = rows.getBigDecimal("taxAmtTotal");
                    BigDecimal priceTaxTotal = rows.getBigDecimal("priceTaxTotal");
                    rows.updateString("noTaxAmtTotalTxt", noTaxAmtTotal == null ? "" : "\uffe5" + noTaxAmtTotal.setScale(2, 4).toPlainString());
                    rows.updateString("taxAmtTotalTxt", taxAmtTotal == null ? "" : "\uffe5" + taxAmtTotal.setScale(2, 4).toPlainString());
                    rows.updateString("priceTaxTotalTxt", priceTaxTotal == null ? "" : "\uffe5" + priceTaxTotal.setScale(2, 4).toPlainString());
                    rows.updateString("priceTaxTotalChineseTxt", priceTaxTotal == null ? "" : IMUtils.getChineseFormat(priceTaxTotal, true, locale));
                    BigDecimal qty = rows.getBigDecimal("entries.quantity");
                    int rowType = rows.getInt("entries.billRowType");
                    if (qty == null || BigDecimal.ZERO.compareTo(qty) == 0 || rowType == 2) {
                        rows.updateString("entries.quantity", null);
                        rows.updateString("entries.noTaxPrice", null);
                        if (rowType == 2) {
                            rows.updateString("entries.specs", null);
                            rows.updateString("entries.makeInvoiceUnit", null);
                        }
                    }
                    if ((noTaxPrice = rows.getBigDecimal("entries.noTaxPrice")) != null && noTaxPrice.scale() < defaultPrecision) {
                        noTaxPrice = noTaxPrice.setScale(defaultPrecision, 6);
                        rows.updateBigDecimal("entries.noTaxPrice", noTaxPrice);
                    }
                    if (companyInfo.getBank() != null) {
                        rows.updateString("bankNameAccount", this.dealNullString(companyInfo.getBank().getName()) + this.dealNullString(companyInfo.getBankAccount()));
                    }
                    if (setting != null && !StringUtils.isEmpty((String)setting.getBankAccount())) {
                        rows.updateString("bankNameAccount", setting.getBankAccount());
                    }
                    if (companyInfo.getTaxAddress() != null) {
                        rows.updateString("taxAddressContactPhone", this.dealNullString(companyInfo.getTaxAddress()) + this.dealNullString(companyInfo.getContactPhone()));
                    }
                    if (setting != null && !StringUtils.isEmpty((String)setting.getAddressPhone())) {
                        rows.updateString("taxAddressContactPhone", setting.getAddressPhone());
                    }
                    rows.updateString("company.registeredCode", this.dealNullString(companyInfo.getRegisteredCode()));
                    rows.updateString("company.taxNumber", this.dealNullString(companyInfo.getTaxNumber()));
                    for (int i = 0; i < amtFields.length; ++i) {
                        amt = rows.getBigDecimal(amtFields[i]);
                        if (amt == null) continue;
                        rows.updateBigDecimal(amtFields[i], amt.setScale(2, 4));
                    }
                    rows.updateString("taxRateTxt", "");
                    rows.updateString("productTaxRate", "");
                    BigDecimal taxRate = rows.getBigDecimal("entries.taxRate");
                    if (taxRate != null) {
                        rows.updateString("taxRateTxt", taxRate.multiply(new BigDecimal(100)).intValue() + "%");
                        if (isRateSame) {
                            rows.updateString("productTaxRate", taxRate.multiply(new BigDecimal(100)).intValue() + "%");
                        }
                    }
                    if (invoiceInfo.isIsDiffTax()) {
                        rows.updateString("taxRateTxt", "***");
                    }
                    if (!"DutyFree".equals(preferentialPolicies = rows.getString("entries.preferentialPolicies")) && !"NoTaxation".equals(preferentialPolicies)) continue;
                    rows.updateString("taxRateTxt", PreferentialPoliciesEnum.getEnum(preferentialPolicies).getAlias());
                }
                rows.beforeFirst();
                return rows;
            }
            if ("InvoiceScanQuery".equals(str)) {
                String[] columnNames = new String[]{"totalAmount", "qrCode"};
                int colCount = columnNames.length;
                DynamicRowSet rowSet = new DynamicRowSet(colCount);
                for (int i = 0; i < colCount; ++i) {
                    ColInfo colInfo = new ColInfo();
                    colInfo.colType = 12;
                    colInfo.columnName = columnNames[i];
                    colInfo.nullable = 1;
                    rowSet.setColInfo(i + 1, colInfo);
                }
                rowSet.moveToInsertRow();
                HashMap<String, List<String>> param = new HashMap<String, List<String>>();
                param.put("printIds", this.ids);
                Map result = InvoiceScanFacadeFactory.getRemoteInstance().getInvoiceScanData(param);
                QrGenerateRecordInfo recordInfo = (QrGenerateRecordInfo)result.get("recordInfo");
                String totalAmount = (String)result.get("totalAmount");
                rowSet.updateString("totalAmount", totalAmount);
                rowSet.updateString("qrCode", recordInfo.getQrUrl());
                rowSet.insertRow();
                rowSet.beforeFirst();
                return rowSet;
            }
            if ("MakeInvoiceTempPreviewQuery".equals(str)) {
                if (this.bosType == null && this.ids.size() > 0) {
                    this.bosType = BOSUuid.read((String)this.ids.get(0)).getType();
                }
                IQueryExecutor queryExcu = null;
                MetaDataPK queryPK = null;
                String queryKey = "com.kingdee.eas.tm.im.app.MakeInvoiceTempPreviewQuery";
                queryPK = new MetaDataPK(queryKey);
                queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
                EntityViewInfo viewInfo = queryExcu.getObjectView();
                if (viewInfo == null) {
                    viewInfo = new EntityViewInfo();
                }
                FilterInfo fi = viewInfo.getFilter();
                FilterInfo filter = new FilterInfo();
                HashSet<String> idset = new HashSet<String>(this.ids);
                filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
                if (fi == null) {
                    fi = filter;
                } else {
                    fi.mergeFilter(filter, "and");
                }
                viewInfo.setFilter(fi);
                queryExcu.setObjectView(viewInfo);
                queryExcu.option().isAutoTranslateEnum = true;
                queryExcu.option().isAutoTranslateBoolean = true;
                IRowSet rows = queryExcu.executeQuery();
                return rows;
            }
            if (this.bosType == null && this.ids.size() > 0) {
                this.bosType = BOSUuid.read((String)this.ids.get(0)).getType();
            }
            IQueryExecutor queryExcu = null;
            MetaDataPK queryPK = null;
            queryPK = new MetaDataPK(this.getReportQueryName(this.bosType));
            queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            EntityViewInfo viewInfo = queryExcu.getObjectView();
            if (viewInfo == null) {
                viewInfo = new EntityViewInfo();
            }
            FilterInfo fi = viewInfo.getFilter();
            FilterInfo filter = new FilterInfo();
            HashSet<String> idset = new HashSet<String>(this.ids);
            filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
            if (fi == null) {
                fi = filter;
            } else {
                fi.mergeFilter(filter, "and");
            }
            viewInfo.setFilter(fi);
            queryExcu.setObjectView(viewInfo);
            queryExcu.option().isAutoTranslateEnum = true;
            queryExcu.option().isAutoTranslateBoolean = true;
            IRowSet rows = queryExcu.executeQuery();
            return rows;
        }
        catch (Exception e) {
            logger.error((Object)("rowSet is null " + e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String dealNullString(String str) {
        return str == null ? "" : str.trim();
    }

    protected String getReportQueryName(BOSObjectType bosType) {
        String queryPk = null;
        if ("412A6F98".equals(bosType.toString())) {
            queryPk = "com.kingdee.eas.tm.im.app.MakeInvoiceQuery";
        } else if ("AC368D2D".equals(bosType.toString())) {
            queryPk = "com.kingdee.eas.tm.im.app.MakeInvoiceReqQuery";
        } else if ("573282EF".equals(bosType.toString())) {
            queryPk = "com.kingdee.eas.tm.im.app.TaxTransferQuery";
        } else if ("DC794E3A".equals(bosType.toString())) {
            queryPk = "com.kingdee.eas.tm.im.app.VehicleMakeInvoiceQuery";
        } else if ("B4E229F6".equals(bosType.toString())) {
            queryPk = "com.kingdee.eas.tm.im.app.VehicleInvoiceReqQuery";
        } else if ("0CADF79B".equals(bosType.toString())) {
            queryPk = "com.kingdee.eas.tm.im.app.UsedCarInvoiceReqQuery";
        } else if ("03DDCDAF".equals(bosType.toString())) {
            queryPk = "com.kingdee.eas.tm.im.app.UsedCarMakeInvoiceQuery";
        }
        return queryPk;
    }
}

