/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.httpClient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.httpClient.SSLClientBuilder;
import com.kingdee.eas.tm.common.httpClient.SSLClientConfig;
import com.kingdee.eas.tm.im.IMException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpClientUtil {
    private static Logger logger = Logger.getLogger(HttpClientUtil.class);

    public static String doPost(String url, String param, Context ctx) throws EASBizException, BOSException {
        return HttpClientUtil.doPost1(url, param, SSLClientConfig.custom().setConfig(ctx).build());
    }

    public static String doPost1(String url, String param, SSLClientConfig config) throws EASBizException, BOSException {
        logger.error((Object)("HttpClientUtil doPost url=" + url + ",param=" + param));
        HttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        String contentType = null;
        try {
            httpClient = SSLClientBuilder.create().setConfig(config).builder();
            httpPost = new HttpPost(url);
            contentType = config != null ? config.getContentType() : "application/json";
            HttpClientUtil.setHeaders((HttpRequestBase)httpPost, config);
            StringEntity se = new StringEntity(param, "UTF-8");
            se.setContentEncoding((Header)new BasicHeader("Content-Type", contentType));
            se.setContentType(contentType);
            httpPost.setEntity((HttpEntity)se);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null) {
                if (response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 404) {
                    logger.error((Object)"HttpClientUtil doPost status is 404.");
                    throw new IMException(IMException.CON_TIME_OUT);
                }
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
                }
            }
        }
        catch (EASBizException ex) {
            logger.error((Object)("HttpClientUtil doPost ex=" + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        catch (Throwable e) {
            logger.error((Object)("HttpClientUtil doPost ex=" + e.getMessage()), e);
            if (e instanceof ConnectException || e instanceof SocketTimeoutException || e instanceof ConnectTimeoutException) {
                throw new IMException(IMException.CON_TIME_OUT);
            }
            throw new IMException(IMException.DOPOST_ERROR);
        }
        return result;
    }

    public static Map doPost2(String url, String param, SSLClientConfig config) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            resultMap.put("result", HttpClientUtil.doPost1(url, param, config));
        }
        catch (Exception e) {
            HttpClientUtil.setError(resultMap, e);
        }
        return resultMap;
    }

    public static String doPost3(String url, Map<String, String> map, SSLClientConfig config) throws Exception {
        logger.error((Object)("HttpClientUtil doPost url=" + url + ",map=" + map));
        HttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        String contentType = null;
        try {
            HttpResponse response;
            httpClient = SSLClientBuilder.create().setConfig(config).builder();
            httpPost = new HttpPost(url);
            contentType = config != null ? config.getContentType() : "application/json";
            HttpClientUtil.setHeaders((HttpRequestBase)httpPost, config);
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> elem : map.entrySet()) {
                list.add(new BasicNameValuePair(elem.getKey(), elem.getValue()));
            }
            if (list.size() > 0) {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, "UTF-8");
                entity.setContentEncoding((Header)new BasicHeader("Content-Type", contentType));
                httpPost.setEntity((HttpEntity)entity);
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)) != null) {
                if (response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 404) {
                    logger.error((Object)"HttpClientUtil doPost status is 404.");
                    throw new IMException(IMException.CON_TIME_OUT);
                }
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
                }
            }
        }
        catch (EASBizException ex) {
            logger.error((Object)("HttpClientUtil doPost ex=" + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        catch (Throwable e) {
            logger.error((Object)("HttpClientUtil doPost ex=" + e.getMessage()), e);
            if (e instanceof ConnectException || e instanceof SocketTimeoutException || e instanceof ConnectTimeoutException) {
                throw new IMException(IMException.CON_TIME_OUT);
            }
            throw new IMException(IMException.DOPOST_ERROR);
        }
        return result;
    }

    public static String doGet(String url, SSLClientConfig config) throws EASBizException, BOSException {
        HttpClient httpClient = null;
        HttpGet httpGet = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = SSLClientBuilder.create().setConfig(config).builder();
            httpGet = new HttpGet(url);
            HttpClientUtil.setHeaders((HttpRequestBase)httpGet, config);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
            }
        }
        catch (Exception ex) {
            logger.error((Object)("HttpClientUtil ex=" + ex));
            if (ex instanceof ConnectException) {
                throw new IMException(IMException.CON_TIME_OUT);
            }
            throw new BOSException((Throwable)ex);
        }
        logger.error((Object)("HttpClientUtil result=" + result));
        return result;
    }

    public static String doPost(String url, String param) throws EASBizException, BOSException {
        return HttpClientUtil.doPost1(url, param, SSLClientConfig.custom().setUseHttpClientOldApi(true).build());
    }

    public static Map post(String url, String param, int connectionTimeout, int soTimeout, String contentType) {
        SSLClientConfig config = SSLClientConfig.custom().setUseHttpClientOldApi(true).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(connectionTimeout).setSocketTimeout(soTimeout).setContentType(contentType).build();
        return HttpClientUtil.doPost2(url, param, config);
    }

    public static String doPost(String url, Map<String, String> map) throws Exception {
        return HttpClientUtil.doPost3(url, map, SSLClientConfig.custom().setUseHttpClientOldApi(true).build());
    }

    public static String doGet(String url) throws EASBizException, BOSException {
        return HttpClientUtil.doGet(url, SSLClientConfig.custom().setUseHttpClientOldApi(true).build());
    }

    private static void setHeaders(HttpRequestBase httpPost, SSLClientConfig config) {
        if (config == null) {
            return;
        }
        Map headers = config.getHeaders();
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                httpPost.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private static void setError(Map map, Throwable e) {
        map.put("errcode", "60000");
        map.put("description", e.getMessage());
    }
}

