/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.param;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.ParamImCollection;
import com.kingdee.eas.tm.im.ParamImInfo;
import com.kingdee.eas.tm.im.param.DataImportListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DataImportListenerFactory {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.param.DataImportListenerFactory");
    private List<DataImportListener> list = null;
    private static DataImportListenerFactory dataFactory = null;
    private static final String operation = "IMPORT";

    private DataImportListenerFactory() {
    }

    public static synchronized DataImportListenerFactory getInstance(Context ctx) throws EASBizException, BOSException {
        if (dataFactory == null) {
            dataFactory = new DataImportListenerFactory();
        }
        if (DataImportListenerFactory.dataFactory.list == null) {
            DataImportListenerFactory.dataFactory.list = DataImportListenerFactory.initListenerList(ctx);
        }
        return dataFactory;
    }

    public List<DataImportListener> getListenerList() {
        return this.list;
    }

    private static List<DataImportListener> initListenerList(Context ctx) throws BOSException, EASBizException {
        List<DataImportListener> objectList = new ArrayList<DataImportListener>();
        ParamImCollection params = IMFacadeFactory.getLocalInstance(ctx).getParamByOpera(operation);
        if (params != null && params.size() > 0) {
            List<String> classNames = DataImportListenerFactory.getClassNameList((IObjectCollection)params);
            objectList = DataImportListenerFactory.createObjectList(classNames);
        }
        return objectList;
    }

    private static List<String> getClassNameList(IObjectCollection params) {
        ArrayList<String> classNames = new ArrayList<String>();
        for (ParamImInfo info : params) {
            classNames.add(info.getValue());
        }
        return classNames;
    }

    private static List<DataImportListener> createObjectList(List<String> classNames) throws BOSException {
        ArrayList<DataImportListener> objectList = new ArrayList<DataImportListener>();
        for (int i = 0; i < classNames.size(); ++i) {
            try {
                String className = classNames.get(i);
                Class<?> objectClass = Class.forName(className);
                DataImportListener o = (DataImportListener)objectClass.newInstance();
                objectList.add(o);
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage());
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage());
            }
        }
        return objectList;
    }
}

