/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.ps.client;

import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.tm.common.help.msgHelp.client.TMMsgBox;
import com.kingdee.eas.tm.common.help.msgHelp.client.util.TMMsgURLUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMCellTextIconRender;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTipInfo;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipResourceUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipUtil;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsFactory;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.client.comp.IProgressMonitor;
import com.kingdee.eas.tm.im.client.comp.IRunnableWithProgress;
import com.kingdee.eas.tm.im.client.comp.ProgressDialog;
import com.kingdee.eas.tm.im.client.comp.ProgressDialogHelper;
import com.kingdee.eas.tm.im.common.IMCommonProcessor;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.pool.CheckServicePwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.ps.CheckServiceFacadeFactory;
import com.kingdee.eas.tm.im.ps.client.AbstractCheckServiceUI;
import com.kingdee.eas.tm.im.ps.client.InvoiceCheckFilterUI;
import com.kingdee.eas.tm.im.ps.client.util.PSClientUtils;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class CheckServiceUI
extends AbstractCheckServiceUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckServiceUI.class);
    private static final String OPR_DEDUCTCHECK = "Opr_DeductCheck";
    private static final String OPR_UNDODEDUCTCHECK = "Opr_UndoDeductCheck";
    protected ProgressDialog progressDialog = null;
    protected CommonQueryDialog commonQueryDialog = null;
    protected InvoiceCheckFilterUI filterUI = null;
    protected static final String NUMFORMAT = "###,##0.##########";
    protected static int PRECISION_2 = 2;
    protected static final String TB_ID = "id";
    protected static final String TB_SELECT = "select";
    protected static final String TB_AMOUNT = "amount";
    protected static final String TB_TAXAMT = "taxAmt";
    protected static final String TB_EFFECTIVETAXAMT = "effectiveTaxAmt";
    protected KDTSelectListener tableSelectChanged = null;
    protected KDTEditAdapter tblMainChange = null;
    private List<TMToolTipInfo> infoList = null;

    public void onLoad() throws Exception {
        super.onLoad();
        PSClientUtils.appendSelectFootRow(this.tblMain, this.getSumFields());
        this.menuItemAddNew.setVisible(false);
        this.menuEdit.setVisible(false);
        this.addCustomerToolTip();
    }

    protected void addCustomerToolTip() {
        this.infoList = new ArrayList<TMToolTipInfo>();
        this.infoList.add(new TMToolTipInfo("bizVoucherPeriodNumber", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("CHECKSERVICEUI_bizVoucherPeriodNumber"), ""));
        this.infoList.add(new TMToolTipInfo("isPayment", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("CHECKSERVICEUI_isPayment"), ""));
        this.infoList.add(new TMToolTipInfo("taxPeriod.number", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("CHECKSERVICEUI_taxPeriodNumber"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.tblMain, this.infoList);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        KDTable table = this.tblMain;
        if (e.getButton() == 1 && e.getClickCount() == 1 && e.getType() == 0) {
            TMToolTipInfo TMToolTipInfo2 = null;
            KDTCell cell = null;
            int index = -1;
            int size = this.infoList.size();
            for (int i = 0; i < size; ++i) {
                TMToolTipInfo2 = this.infoList.get(i);
                index = table.getColumnIndex(TMToolTipInfo2.getName());
                if (index == e.getColIndex()) continue;
                cell = table.getHead().getRow(0).getCell(table.getColumnIndex(TMToolTipInfo2.getName()));
                cell.setRenderer((IBasicRender)new TMCellTextIconRender());
            }
            table.repaint();
        }
    }

    protected String[] getSumFields() {
        return new String[]{TB_AMOUNT, TB_TAXAMT, TB_EFFECTIVETAXAMT};
    }

    public void onShow() throws Exception {
        super.onShow();
        this.formatTable();
    }

    public boolean isAutoIgnoreZero() {
        return false;
    }

    protected void formatTable() throws Exception {
        for (String field : this.getSumFields()) {
            this.tblMain.getColumn(field).getStyleAttributes().setNumberFormat(NUMFORMAT);
            this.tblMain.getColumn(field).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(TB_SELECT).getStyleAttributes().setLocked(false);
        this.tblMain.getColumn(TB_SELECT).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        if (this.tableSelectChanged == null) {
            this.tableSelectChanged = PSClientUtils.getSelectListener(TB_SELECT, this.getSumFields());
            this.tblMain.addKDTSelectListener(this.tableSelectChanged);
        }
        if (this.tblMainChange == null) {
            this.tblMainChange = new KDTEditAdapter(){

                public void editValueChanged(KDTEditEvent e) {
                    KDTable table = (KDTable)e.getSource();
                    if (CheckServiceUI.TB_SELECT.equals(table.getColumnKey(e.getColIndex()))) {
                        table.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getValue());
                        PSClientUtils.doSelectSum(CheckServiceUI.TB_SELECT, CheckServiceUI.this.getSumFields(), CheckServiceUI.this.tblMain);
                    }
                }
            };
        }
        this.tblMain.addKDTEditListener((KDTEditListener)this.tblMainChange);
        this.actionDeleteAll_actionPerformed(null);
    }

    @Override
    public void actionDeductCheck_actionPerformed(ActionEvent e) throws Exception {
        this.doInProgressDialog(OPR_DEDUCTCHECK);
    }

    @Override
    public void actionUndoCheck_actionPerformed(ActionEvent e) throws Exception {
        this.doInProgressDialog(OPR_UNDODEDUCTCHECK);
    }

    private void doInProgressDialog(String actionName) {
        if (this.progressDialog == null) {
            this.progressDialog = ProgressDialogHelper.createProgressDialog((CoreUI)this, true);
        }
        this.progressDialog.run(false, true, this.getRunnableWithProgress(actionName));
    }

    protected IRunnableWithProgress getRunnableWithProgress(final String actionName) {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(IProgressMonitor monitor) {
                try {
                    ArrayList<String> errList = new ArrayList<String>();
                    String action = EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)actionName);
                    monitor.beginTask(EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Msg_ProgressAction", (Object[])new Object[]{action}), -1);
                    monitor.nextStep(EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Msg_ProgressBuildParams"));
                    List ids = PSClientUtils.getSelectIDs(CheckServiceUI.this.tblMain, CheckServiceUI.TB_SELECT, CheckServiceUI.TB_ID);
                    if (ids.isEmpty()) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Err_NoSelect"));
                        return;
                    }
                    HashMap body = new HashMap();
                    body.put("taxPeriodMap", CheckServiceUI.this.filterUI.getResult().get("taxPeriodMap"));
                    body.put("ids", ids);
                    body.put("isUndo", CheckServiceUI.OPR_UNDODEDUCTCHECK.equals(actionName));
                    body.put("msgType", PwyServiceType.OPR_POOL_CHECKSERVICE_CHECK_DEDUCT);
                    body.put("ownerSystem", TransSrcSystemEnum.easgui);
                    body.put("deductibleMode", CheckServiceUI.OPR_DEDUCTCHECK.equals(actionName) ? "1" : "-1");
                    Map res = CheckServiceFacadeFactory.getRemoteInstance().checkInvoiceIsCanDeduct(ids, actionName);
                    ArrayList err = (ArrayList)res.get("errList");
                    if (err.size() > 0) {
                        List voildIds = (List)res.get("ids");
                        body.put("ids", voildIds);
                        if (voildIds != null && voildIds.size() > 0) {
                            if (!MsgBox.isYes((int)MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Msg_Data"), (String)IMUtils.buildErrorMsg(err)))) {
                                return;
                            }
                        } else {
                            String summaryMsg = EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"OprDetail", (Object[])new Object[]{0, ids.size()}) + "\n";
                            TMMsgBox.showDetailAndOK((Component)((Object)CheckServiceUI.this), (String)EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Opr_DetailFollow", (Object[])new Object[]{EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)actionName)}), (String)(summaryMsg + CheckServiceUI.this.handleErrMsg(err)), (int)1, (Map)TMMsgURLUtil.getMsgURL((String)"IMS"));
                            return;
                        }
                    }
                    Map result = CheckServiceFacadeFactory.getRemoteInstance().buildCheckInvokeParam(body);
                    monitor.nextStep(EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Msg_ProgressSend"));
                    int successSum = 0;
                    int failSum = 0;
                    int checkInvoiceNum = Integer.parseInt(CheckServiceUI.this.getParam());
                    for (String taxNo : result.keySet()) {
                        PwyInvokeParam invokeParam = (PwyInvokeParam)result.get(taxNo);
                        List checkAbsList = (List)invokeParam.getParams().get("checkAbsList");
                        PwySettingInfo info = invokeParam.getSetting();
                        if (!info.isFpdkType()) {
                            CheckServicePwyService pwyService = (CheckServicePwyService)PwyServiceHelper.getPwyService(null, invokeParam);
                            pwyService.invoke();
                            if (pwyService.isSuccess() || pwyService.isPartSuccess()) {
                                successSum += pwyService.getSuccessList().size();
                                failSum += pwyService.getFailList().size();
                            } else {
                                failSum += pwyService.getFailList().size();
                            }
                            CheckServiceUI.this.handleResult(errList, taxNo, invokeParam, pwyService);
                            continue;
                        }
                        int toIndex = checkInvoiceNum;
                        int totalSize = checkAbsList.size();
                        int pollNum = 0;
                        for (int j = 0; j < totalSize; j += checkInvoiceNum) {
                            if (j + checkInvoiceNum > totalSize) {
                                toIndex = totalSize - j;
                            }
                            List newSubList = checkAbsList.subList(j, j + toIndex);
                            ArrayList newCheckAbsList = new ArrayList();
                            for (int i = 0; i < newSubList.size(); ++i) {
                                newCheckAbsList.add(newSubList.get(i));
                            }
                            if (invokeParam.getParams().get("requestIds") != null && invokeParam.getParams().get("requestIds") instanceof String[]) {
                                String[] requestIds = (String[])invokeParam.getParams().get("requestIds");
                                invokeParam.getParams().put("requestId", requestIds[pollNum]);
                            } else {
                                invokeParam.getParams().put("requestId", BOSUuid.create((String)"88888888").toString());
                            }
                            invokeParam.setSendMsg(null);
                            invokeParam.getParams().put("checkAbsList", newCheckAbsList);
                            CheckServicePwyService pwyService = (CheckServicePwyService)PwyServiceHelper.getPwyService(null, invokeParam);
                            pwyService.invoke();
                            if (pwyService.isSuccess() || pwyService.isPartSuccess()) {
                                successSum += pwyService.getSuccessList().size();
                                failSum += pwyService.getFailList().size();
                            } else {
                                failSum += pwyService.getFailList().size();
                            }
                            invokeParam.setPwyLog(null);
                            invokeParam.setSend(false);
                            invokeParam.setInvokeActionMap(null);
                            invokeParam.setSendTime(null);
                            invokeParam.setRevTime(null);
                            invokeParam.setLogPK(null);
                            CheckServiceUI.this.handleResult(errList, taxNo, invokeParam, pwyService);
                            ++pollNum;
                        }
                    }
                    errList.add(0, EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"OprDetail", (Object[])new Object[]{successSum, failSum}) + "\n");
                    TMMsgBox.showDetailAndOK((Component)((Object)CheckServiceUI.this), (String)EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Opr_DetailFollow", (Object[])new Object[]{EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)actionName)}), (String)IMUtils.buildErrorMsg(errList), (int)1, (Map)TMMsgURLUtil.getMsgURL((String)"IMS"));
                    CheckServiceUI.this.refresh(null);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    CheckServiceUI.this.handUIException(e);
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    public String handleErrMsg(ArrayList err) {
        StringBuffer sb = new StringBuffer();
        HashSet errMsgSet = new HashSet();
        int size = err.size();
        for (int i = 0; i < size; ++i) {
            if (!errMsgSet.add(err.get(i))) continue;
            sb.append(err.get(i)).append("\r\n");
        }
        return sb.toString();
    }

    private String getParam() {
        String paramValue = "500";
        try {
            String realParamValue = IMFacadeFactory.getRemoteInstance().getParamByKey("CHECK_INVOICE_NUM");
            if (!StringUtils.isEmpty((String)realParamValue)) {
                paramValue = realParamValue;
            }
        }
        catch (Exception e) {
            logger.error((Object)("getParam error :" + e.getMessage()));
        }
        return paramValue;
    }

    private void handleResult(ArrayList errList, String taxNo, PwyInvokeParam invokeParam, CheckServicePwyService pwyService) {
        if (!pwyService.isSuccess()) {
            List<CheckAbsInfo> failList = pwyService.getFailList();
            errList.add(EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Err_ActionFailedDetail", (Object[])new Object[]{taxNo, "\r\n" + invokeParam.getDescription()}));
        }
    }

    protected void doAction(boolean isUndo) throws Exception {
        List ids = PSClientUtils.getSelectIDs(this.tblMain, TB_SELECT, TB_ID);
        if (ids.isEmpty()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.ps.PoolServiceResource", (String)"Err_NoSelect"));
            return;
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            if (this.getUIContext().get("OwnerWindow") == null) {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            try {
                this.commonQueryDialog.setProcessor((IProcessor)new IMCommonProcessor((IUIObject)this));
                ISCMFilter filterUI = (ISCMFilter)this.getFilterUI();
                filterUI.setIsSupportMultiOrgs(true);
                this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            this.commonQueryDialog.setWidth(910);
            this.commonQueryDialog.setHeight(550);
        }
        return this.commonQueryDialog;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new InvoiceCheckFilterUI();
        }
        return this.filterUI;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckAbsFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        PSClientUtils.selectRows(this.tblMain, TB_SELECT, true);
        PSClientUtils.doSelectSum(TB_SELECT, this.getSumFields(), this.tblMain);
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        PSClientUtils.selectRows(this.tblMain, TB_SELECT, false);
        PSClientUtils.cleanSum(TB_SELECT, this.getSumFields(), this.tblMain);
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        PSClientUtils.selectRows(this.tblMain, TB_SELECT, false);
        PSClientUtils.cleanSum(TB_SELECT, this.getSumFields(), this.tblMain);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        PSClientUtils.selectRows(this.tblMain, TB_SELECT, false);
        PSClientUtils.cleanSum(TB_SELECT, this.getSumFields(), this.tblMain);
    }

    public void refreshListForOrder() throws Exception {
        super.refreshListForOrder();
        PSClientUtils.selectRows(this.tblMain, TB_SELECT, false);
        PSClientUtils.cleanSum(TB_SELECT, this.getSumFields(), this.tblMain);
    }

    public void handUIException(Throwable exc) {
        if (TMMsgBox.handUIException((Component)((Object)this), (Throwable)exc, (String)"IMS")) {
            super.handUIException(exc);
        }
    }
}

