/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tm.im.client.util.IMClientUtils;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceFactory;
import com.kingdee.eas.tm.im.upgrade.client.AbstractDataUpgradeTraceListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import org.apache.log4j.Logger;

public class DataUpgradeTraceListUI
extends AbstractDataUpgradeTraceListUI {
    private static final Logger logger = CoreUIObject.getLogger(DataUpgradeTraceListUI.class);
    public static final String administrator = "administrator";
    public static final String COL_OPERATION = "operation";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initBtnStatus();
        boolean b = this.isLogin();
        if (!b) {
            this.abort();
        }
    }

    protected void initBtnStatus() {
        this.actionAddNew.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
    }

    private boolean isLogin() throws BOSException, EASBizException {
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            return true;
        }
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(userInfo.getId().toString())) {
            return true;
        }
        JComboBox<String> user = new JComboBox<String>();
        user.addItem(administrator);
        JPasswordField pwd = new JPasswordField("");
        Object[] message = new Object[]{EASResource.getString((String)"com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", (String)"UserName"), user, "", EASResource.getString((String)"com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", (String)"Pwd"), pwd};
        int res = JOptionPane.showConfirmDialog((Component)((Object)this), message, " ", 2, 3);
        if (res != 0) {
            return false;
        }
        String number = (String)user.getSelectedItem();
        if (EmptyUtil.isEmpty((String)number) || EmptyUtil.isEmpty((String)new String(pwd.getPassword()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", (String)"UserName_Or_Pwd_isNull"));
            SysUtil.abort();
        }
        userInfo = UserFactory.getRemoteInstance().getUserInfoByNumber(number);
        if (EmptyUtil.isEmpty((String)number) || !number.equals(administrator)) {
            if (userInfo != null) {
                if (!iPermission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()), null, "ksql_all") && !iPermission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(userInfo.getId()), null, "ksql_query")) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", (String)"Err_Permission"));
                    SysUtil.abort();
                }
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", (String)"UserName_isNotExist"));
                SysUtil.abort();
            }
        }
        if (DataUpgradeTraceListUI.matchPassword(userInfo, new String(pwd.getPassword()))) {
            return true;
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", (String)"Err_Pwd"));
        SysUtil.abort();
        return false;
    }

    public static boolean matchPassword(UserInfo userInfo, String password) throws EASBizException {
        if (StringUtils.isEmpty((String)password) && userInfo != null) {
            return StringUtils.isEmpty((String)userInfo.getPassword());
        }
        return PermissionUtils.matchPassword((UserInfo)userInfo, (String)password.trim());
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.tm.im.upgrade.client.DataUpgradeTraceEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DataUpgradeTraceFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        String id = (String)this.getUIContext().get("id");
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)id)) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        }
        return filter;
    }

    @Override
    public void actionUpgrade_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IMClientUtils.doDataUpgradeInProgress((CoreUI)this, this.getSelectedIdValues(), true);
    }

    protected String[] getLocateNames() {
        return new String[]{COL_OPERATION};
    }
}

