/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.api.AbstractDataUpgrade;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.IMSQLUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ARInvoiceCodeNumberFix
extends AbstractDataUpgrade {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.upgrade.impl.ARInvoiceCodeNumberFix");

    @Override
    protected void doUpgrade(Context ctx, DataUpgradeTraceInfo info) throws EASBizException, BOSException {
        try {
            if (StringUtils.isEmpty((String)info.getDefineConfig())) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", "DefineConfig_NOT_NULLl", IMUtils.getLocale())});
            }
            String filterSql = this.buildFilterSql(ctx, info);
            this.updateArInvoiceFields(ctx, filterSql);
            info.setIsProcessed(true);
            logger.debug((Object)"upgrade success");
        }
        catch (Exception e) {
            info.setIsProcessed(false);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected String buildFilterSql(Context ctx, DataUpgradeTraceInfo info) throws BOSException {
        String sql = IMSQLUtil.structureFilter(ctx, info.getDefineConfig(), info.getQuery());
        return sql;
    }

    protected void updateArInvoiceFields(Context ctx, String filterSql) throws BOSException {
        String selectSql = this.getSelectReqSql(filterSql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            HashMap<String, InvoiceInfo> unique = new HashMap<String, InvoiceInfo>();
            String updateSql = "update t_ar_otherbill set FInvoiceCode=?,FInvoiceNo=? where fid=?";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            InvoiceInfo invoice = new InvoiceInfo();
            while (rs.next()) {
                String srcID = rs.getString("srcID");
                String invoiceCode = rs.getString("invoiceNumber");
                String invoiceNo = rs.getString("invoiceNo");
                invoice = unique.containsKey(srcID) ? (InvoiceInfo)unique.get(srcID) : new InvoiceInfo();
                invoiceCode = this.merge(invoiceCode, invoice.getInvoiceNumber());
                invoiceNo = this.merge(invoiceNo, invoice.getInvoiceNo());
                invoice.setInvoiceNumber(invoiceCode);
                invoice.setInvoiceNo(invoiceNo);
                unique.put(srcID, invoice);
            }
            for (Map.Entry entry : unique.entrySet()) {
                Object[] param = new Object[]{((InvoiceInfo)entry.getValue()).getInvoiceNumber(), ((InvoiceInfo)entry.getValue()).getInvoiceNo(), entry.getKey()};
                paramList.add(param);
            }
            if (paramList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramList);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected String getSelectReqSql(String filterSql) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT relation.FBizBillID as srcID,relation.FInvoiceBillID as destID,").append("\n");
        sql.append(" dest.FInvoiceNumber as invoiceNumber,dest.FInvoiceNo as invoiceNo").append("\n");
        sql.append(" FROM T_IM_MakeInvoice dest").append("\n");
        sql.append(" INNER JOIN T_IM_MakeInvoiceRelation relation on dest.fid = relation.FInvoiceBillID").append("\n");
        sql.append(" WHERE relation.FBizBillID in (").append(filterSql).append(")").append("\n");
        sql.append(" ORDER BY relation.FBizBillID,dest.FInvoiceDate asc  ");
        return sql.toString();
    }

    protected String merge(String number1, String number2) {
        if (StringUtils.isEmpty((String)number1)) {
            return number2;
        }
        ArrayList<String> numberList = new ArrayList<String>();
        String[] numberArr = number1.split(";");
        int size = numberArr.length;
        for (int i = 0; i < size; ++i) {
            numberList.add(numberArr[i]);
        }
        if (!StringUtils.isEmpty((String)number2)) {
            numberList.add(number2);
        }
        return CollectionUtil.convertList2String(numberList, ";", false);
    }

    class InvoiceInfo {
        private String invoiceNumber;
        private String invoiceNo;

        InvoiceInfo() {
        }

        public String getInvoiceNumber() {
            return this.invoiceNumber;
        }

        public void setInvoiceNumber(String invoiceNumber) {
            this.invoiceNumber = invoiceNumber;
        }

        public String getInvoiceNo() {
            return this.invoiceNo;
        }

        public void setInvoiceNo(String invoiceNo) {
            this.invoiceNo = invoiceNo;
        }
    }
}

