/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillCollection;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.app.invoicepool.util.BizInvoicePoolUtil;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.api.AbstractDataUpgrade;
import com.kingdee.eas.tm.im.util.IMSQLUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class DownloadInvoiceByBizAccountBill
extends AbstractDataUpgrade {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.upgrade.impl.DownloadInvoiceByBizAccountBill");
    public StringBuffer errorMsg = new StringBuffer();

    protected void downloadInvoiceSingle(Context ctx, BizAccountBillInfo bizAccountBill) throws EASBizException, BOSException {
        IObjectCollection voucherCollection;
        logger.error((Object)("[BizAccountBill]:" + bizAccountBill.getNumber()));
        BizInvoicePoolUtil.submitDownLoadInvoice((Context)ctx, (BizCollBillBaseInfo)bizAccountBill);
        if (bizAccountBill.getAuditor() != null) {
            BizInvoicePoolUtil.setPassAddIncomeInvoice((Context)ctx, (BOSUuid)bizAccountBill.getId());
        }
        if (bizAccountBill.getPayDate() != null) {
            BizInvoicePoolUtil.updateIspayment((Context)ctx, (BizCollBillBaseInfo)bizAccountBill, (Boolean)true);
        }
        if ((voucherCollection = this.getVoucherInfos(ctx, bizAccountBill.getId().toString())) != null && voucherCollection.size() > 0) {
            BizInvoicePoolUtil.updateVoucherInfo((Context)ctx, (BOSUuid)bizAccountBill.getId(), (String)"", (BizCollBillBaseInfo)bizAccountBill, (IObjectCollection)voucherCollection, (String)"update");
        }
        logger.error((Object)("[BizAccountBill]:" + bizAccountBill.getNumber() + ":download success"));
    }

    @Override
    protected void doUpgrade(Context ctx, DataUpgradeTraceInfo info) throws EASBizException, BOSException {
        try {
            ctx.put((Object)"disablePermissionForKScript", (Object)true);
            if (StringUtils.isEmpty((String)info.getDefineConfig())) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", "DefineConfig_NOT_NULLl", IMUtils.getLocale())});
            }
            EntityViewInfo defView = this.buildFilter(ctx, info);
            BizAccountBillCollection col = this.getBizAccountBillCollection(ctx, defView);
            if (col == null) {
                logger.error((Object)"BizAccountBillCollection : SIZE - null");
            } else {
                logger.error((Object)("BizAccountBillCollection : SIZE - " + col.size()));
            }
            if (col == null || col.size() == 0) {
                throw new IMException(IMException.ERRORMSG, new Object[]{EASResource.getString((String)"com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", (String)"BillNotFound")});
            }
            this.downloadInvoiceWithMultithread(ctx, col);
            if (this.errorMsg.length() > 0) {
                throw new BOSException(this.errorMsg.toString());
            }
            info.setIsProcessed(true);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            ctx.remove((Object)"disablePermissionForKScript");
        }
    }

    private BizAccountBillCollection getBizAccountBillCollection(Context ctx, EntityViewInfo defView) throws ParserException, BOSException, IMException {
        if (defView == null || defView.getFilter() == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", "DefineConfig_NOT_NULLl", IMUtils.getLocale())});
        }
        BizAccountBillCollection col = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("payDate"));
        sic.add(new SelectorItemInfo("applierCompany"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("tickeEntries.*"));
        sic.add(new SelectorItemInfo("tickeEntries.ticketTypeId.*"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.company"));
        try {
            entityViewInfo.setFilter(defView.getFilter());
            entityViewInfo.setSelector(sic);
            col = BizAccountBillFactory.getLocalInstance((Context)ctx).getBizAccountBillCollection(entityViewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)("getBizAccountBillCollection failed." + e.getMessage()), (Throwable)e);
            throw e;
        }
        return col;
    }

    protected void downloadInvoiceWithMultithread(Context ctx, BizAccountBillCollection col) throws BOSException {
        ExecutorService service = null;
        try {
            int defaultThreadPoolSize = 8;
            int size = col.size();
            int threadPoolsize = size > defaultThreadPoolSize ? defaultThreadPoolSize : size;
            service = Executors.newFixedThreadPool(threadPoolsize);
            CountDownLatch latch = new CountDownLatch(size);
            BizAccountBillInfo bizAccountBill = null;
            for (int i = 0; i < size; ++i) {
                bizAccountBill = col.get(i);
                DownloadInvoiceTask task = new DownloadInvoiceTask(ctx, bizAccountBill, latch);
                service.execute(task);
            }
            latch.await();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
    }

    protected EntityViewInfo buildFilter(Context ctx, DataUpgradeTraceInfo info) throws BOSException {
        String filterItems = info.getDefineConfig();
        EntityViewInfo defView = new EntityViewInfo();
        try {
            defView.setFilter(new FilterInfo(IMSQLUtil.getDataFilterInfo(filterItems)));
            defView = this.addExtraFilter(ctx, defView);
            return defView;
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected EntityViewInfo addExtraFilter(Context ctx, EntityViewInfo defView) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo defFilter = new FilterInfo();
        if (defView != null) {
            view = defView;
            defFilter = defView.getFilter();
        }
        HashSet<Integer> statusSet = new HashSet<Integer>();
        statusSet.add(10);
        statusSet.add(20);
        statusSet.add(27);
        statusSet.add(40);
        statusSet.add(50);
        FilterInfo bizFilter = new FilterInfo();
        bizFilter.getFilterItems().add(new FilterItemInfo("state", statusSet, CompareType.NOTINCLUDE));
        defFilter.mergeFilter(bizFilter, "and");
        view.setFilter(defFilter);
        return view;
    }

    public IObjectCollection getVoucherInfos(Context ctx, String bizBillID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FID, FPeriodID, FVoucherTypeID, FNumber FROM T_GL_Voucher ");
        sql.append(" WHERE FID in ( ");
        sql.append(" SELECT FDestObjectID FROM T_BOT_Relation ");
        sql.append(" WHERE FSrcObjectID = ?");
        sql.append(" AND ");
        sql.append(" FDestEntityID = '2652E01E' ");
        sql.append(" ) Order By FLastUpdateTime ");
        HashSet<String> idSet = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{bizBillID});
            while (rs.next()) {
                idSet.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql error" + e.getMessage(), (Throwable)e);
        }
        VoucherCollection coll = null;
        if (idSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            coll = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(view);
        }
        return coll;
    }

    class DownloadInvoiceTask
    implements Runnable {
        private Context ctx = null;
        private CountDownLatch latch = null;
        private BizAccountBillInfo bizAccountBill = null;

        public DownloadInvoiceTask(Context ctx, BizAccountBillInfo bizAccountBill, CountDownLatch latch) {
            this.ctx = ctx;
            this.latch = latch;
            this.bizAccountBill = bizAccountBill;
        }

        @Override
        public void run() {
            try {
                DownloadInvoiceByBizAccountBill.this.downloadInvoiceSingle(this.ctx, this.bizAccountBill);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                DownloadInvoiceByBizAccountBill.this.errorMsg.append(e.getMessage()).append("\r\n");
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

