/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsFactory;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckWayEnum;
import com.kingdee.eas.tm.common.invoicePool.CommonSpecialInvoiceCollection;
import com.kingdee.eas.tm.common.invoicePool.CommonSpecialInvoiceEntryCollection;
import com.kingdee.eas.tm.common.invoicePool.CommonSpecialInvoiceEntryInfo;
import com.kingdee.eas.tm.common.invoicePool.CommonSpecialInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.CommonSpecialInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.TMAuthenticateFlag;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.InvResourceType;
import com.kingdee.eas.tm.im.IsDeductEnum;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.api.AbstractDataUpgrade;
import com.kingdee.eas.tm.im.util.CheckAbsUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class InvoicePoolVATDataUpgrade
extends AbstractDataUpgrade {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.upgrade.impl.InvoicePoolVATDataUpgrade");

    @Override
    protected void doUpgrade(Context ctx, DataUpgradeTraceInfo info) throws EASBizException, BOSException {
        try {
            logger.error((Object)"[InvoicePoolVATDataUpgrade] start");
            ctx.put((Object)"disablePermissionForKScript", (Object)true);
            this.invoicePoolVATDataUpgrade(ctx);
            info.setIsProcessed(true);
            logger.debug((Object)"upgrade success");
        }
        catch (Exception e) {
            info.setIsProcessed(false);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            ctx.remove((Object)"disablePermissionForKScript");
        }
    }

    protected void invoicePoolVATDataUpgrade(Context ctx) throws BOSException, EASBizException {
        int maxDealSize = 100;
        ArrayList<String> updateIds = new ArrayList<String>();
        String getIds = "select FID from T_TM_CommonSpecialInvoice";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getIds);
        try {
            while (rs.next()) {
                updateIds.add(rs.getString("FID"));
                logger.error((Object)("[InvoicePoolVATDataUpgrade]:FID:" + rs.getString("FID")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        logger.error((Object)("[InvoicePoolVATDataUpgrade]:updateIdsSize:" + updateIds.size()));
        int allSize = updateIds.size();
        if (allSize == 0) {
            return;
        }
        int times = 0;
        BigDecimal allSize1 = new BigDecimal(allSize);
        BigDecimal maxDealSize1 = new BigDecimal(maxDealSize);
        times = allSize1.divide(maxDealSize1).setScale(0, RoundingMode.CEILING).intValue();
        logger.error((Object)("[InvoicePoolVATDataUpgrade]:times:" + times));
        if (times == 0) {
            return;
        }
        int updateBegin = 0;
        int updateEnd = maxDealSize - 1;
        int now = 1;
        for (int i = 0; i < times; ++i) {
            HashSet commspecialIds = new HashSet();
            for (int j = updateBegin; j <= updateEnd; ++j) {
                commspecialIds.add(updateIds.get(j));
                if (now >= allSize) break;
                ++now;
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", commspecialIds, CompareType.INCLUDE));
            view.setFilter(filter);
            CommonSpecialInvoiceCollection csColl = CommonSpecialInvoiceFactory.getLocalInstance((Context)ctx).getCommonSpecialInvoiceCollection(view);
            logger.error((Object)("[InvoicePoolVATDataUpgrade]:csCollSize:" + csColl.size()));
            this.commSpeToIncomeInvoice(ctx, csColl);
            updateBegin = updateEnd + 1;
            updateEnd += maxDealSize;
        }
    }

    protected void commSpeToIncomeInvoice(Context ctx, CommonSpecialInvoiceCollection csColl) throws BOSException, EASBizException {
        CommonSpecialInvoiceInfo csInfo = null;
        int j = csColl.size();
        for (int i = 0; i < j; ++i) {
            csInfo = csColl.get(i);
            if (IncomeInvoiceFactory.getLocalInstance(ctx).exists("where number = '" + csInfo.getNumber() + "'")) {
                logger.error((Object)("[InvoicePoolVATDataUpgrade]:exists:" + csInfo.getNumber()));
                continue;
            }
            IncomeInvoiceInfo info = new IncomeInvoiceInfo();
            info.setId(BOSUuid.create((String)"1343913D"));
            info.setNumber(csInfo.getNumber());
            info.setInvoiceType(this.getInvoiceType(csInfo.getInvoiceType().getValue()));
            info.setCheckCode(csInfo.getCheckCode());
            info.setBillingCompany(csInfo.getSalerName());
            info.setTaxNumber(csInfo.getSalerTaxNo());
            info.setContact(csInfo.getSalerAddressPhone());
            info.setBankInformation(csInfo.getSalerAccount());
            info.setBuyerName(csInfo.getBuyerName());
            info.setBuyerTaxNo(csInfo.getBuyerTaxNo());
            info.setBuyerAddressPhone(csInfo.getBuyerAddressPhone());
            info.setBuyerAccount(csInfo.getBuyerAccount());
            info.setAmount(csInfo.getInvoiceAmount());
            info.setTax(csInfo.getTotalTaxAmount());
            info.setMachineNo(csInfo.getMachineNo());
            info.setDrawer(csInfo.getDrawer());
            info.setReviewer(csInfo.getReviewer());
            info.setPayee(csInfo.getPayee());
            if (csInfo.getInvoiceStatus() != null) {
                info.setStatus(this.getIncomeStatusEnum(csInfo.getInvoiceStatus().getValue()));
            }
            info.setInvalidDate(csInfo.getInvalidDate());
            info.setIsCreditNote(csInfo.isType());
            if (!StringUtils.isEmpty((String)csInfo.getPdfurl())) {
                info.setPdfUrl(csInfo.getPdfurl());
            }
            if (StringUtils.isEmpty((String)info.getPdfUrl()) && !StringUtils.isEmpty((String)csInfo.getKdcloudUrl())) {
                info.setPdfUrl(csInfo.getKdcloudUrl());
            }
            if (StringUtils.isEmpty((String)info.getPdfUrl()) && !StringUtils.isEmpty((String)csInfo.getSnapshotUrl())) {
                info.setPdfUrl(csInfo.getSnapshotUrl());
            }
            info.setSourceInvoiceCode(csInfo.getOriginalInvoiceCode());
            info.setSourceInvoiceNumber(csInfo.getOriginalInvoiceNo());
            info.setIsIssue(csInfo.isProxyMark());
            info.setSerialNo(csInfo.getSerialNo());
            info.setInvoiceCode(csInfo.getInvoiceCode());
            info.setInvoiceNumber(csInfo.getInvoiceNo());
            info.setBizDate(csInfo.getInvoiceDate());
            info.setDescription(csInfo.getRemark());
            info.setCompany(csInfo.getCompany());
            info.setAuditor(csInfo.getAuditor());
            info.setCreator(csInfo.getCreator());
            info.setCreateTime(csInfo.getCreateTime());
            info.setLastUpdateUser(csInfo.getLastUpdateUser());
            info.setLastUpdateTime(csInfo.getLastUpdateTime());
            info.setCU(csInfo.getCU());
            info.setResourceType(InvResourceType.INV_DOWNLOAD);
            info.setBizBillID(csInfo.getBizBillID());
            info.setBizBillNumber(csInfo.getBizBillNumber());
            info.setBizBillEntryID(csInfo.getBizBillEntryID());
            info.setBizBillType(csInfo.getBizBillType());
            info.setReBusiness(csInfo.isIsBusiness());
            info.setIsPayment(csInfo.isIsPayment());
            if (csInfo.get("isDeduct") == null) {
                info.setIsDeduct(IsDeductEnum.NULL);
            } else if (csInfo.isIsDeduct()) {
                info.setIsDeduct(IsDeductEnum.DEDUCTIBLE);
            } else {
                info.setIsDeduct(IsDeductEnum.NONDEDUCTIBLE);
            }
            info.setDeductTaxAmt(csInfo.getDeductTaxAmt());
            if (!StringUtils.isEmpty((String)csInfo.getVoucherID())) {
                VoucherInfo voucherInfo = new VoucherInfo();
                voucherInfo.setId(BOSUuid.read((String)csInfo.getVoucherID()));
                voucherInfo.setNumber(csInfo.getVoucherNumber());
                voucherInfo.setPeriod(csInfo.getVoucherPeriod());
                voucherInfo.setVoucherType(csInfo.getVoucherType());
                info.setVoucher(voucherInfo);
                info.setVoucherNumber(csInfo.getVoucherNumber());
                info.setVoucherType(csInfo.getVoucherType());
            }
            this.commSpeEntryUpgrade(ctx, csInfo, info);
            IncomeInvoiceFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
            if ("4".equals(info.getTmInvoiceType().getValue())) {
                logger.error((Object)("[InvoicePoolVATDataUpgrade]:infoParseCheckAbsStart:" + info.getId().toString()));
                this.parseCheckAbs(ctx, csInfo, info);
                logger.error((Object)("[InvoicePoolVATDataUpgrade]:infoParseCheckAbsEnd:" + info.getId().toString()));
            }
            String updateBotRelation = "update T_BOT_RELATION set FDESTENTITYID = '1343913D', FDESTOBJECTID = '" + info.getId().toString() + "' where FDESTOBJECTID = '" + csInfo.getId().toString() + "'";
            DbUtil.execute((Context)ctx, (String)updateBotRelation);
            logger.error((Object)("InvoicePoolUpgrade:" + csInfo.getId().toString() + "_" + info.getId().toString()));
        }
    }

    protected void commSpeEntryUpgrade(Context ctx, CommonSpecialInvoiceInfo csInfo, IncomeInvoiceInfo info) throws BOSException {
        CommonSpecialInvoiceEntryCollection csEntryColl = null;
        CommonSpecialInvoiceEntryInfo csEntryInfo = null;
        IncomeInvoiceEntryInfo entryInfo = null;
        csEntryColl = csInfo.getEntry();
        int j = csEntryColl.size();
        for (int i = 0; i < j; ++i) {
            csEntryInfo = csEntryColl.get(i);
            entryInfo = new IncomeInvoiceEntryInfo();
            entryInfo.setTaxClassificationNumber(csEntryInfo.getGoodsCode());
            if (!StringUtils.isEmpty((String)entryInfo.getTaxClassificationNumber())) {
                EntityViewInfo taxClassView = new EntityViewInfo();
                FilterInfo taxClassFilter = new FilterInfo();
                taxClassFilter.getFilterItems().add(new FilterItemInfo("mergeCode", (Object)entryInfo.getTaxClassificationNumber(), CompareType.EQUALS));
                taxClassView.setFilter(taxClassFilter);
                TaxClassificationCodeCollection taxClassColl = ctx == null ? TaxClassificationCodeFactory.getRemoteInstance().getTaxClassificationCodeCollection(taxClassView) : TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(taxClassView);
                if (taxClassColl != null && taxClassColl.size() > 0) {
                    TaxClassificationCodeInfo taxClassInfo = taxClassColl.get(0);
                    entryInfo.setTaxClassificationCode(taxClassInfo);
                }
            }
            entryInfo.setProductName(csEntryInfo.getGoodsName());
            entryInfo.setSpecs(csEntryInfo.getSpecModel());
            entryInfo.setUnitName(csEntryInfo.getUnit());
            entryInfo.setTaxExcluded(csEntryInfo.getUnitPrice());
            entryInfo.setQuantity(csEntryInfo.getNum());
            entryInfo.setTaxAmt(csEntryInfo.getTaxAmount());
            entryInfo.setTaxRate(csEntryInfo.getTaxRate());
            entryInfo.setMoney(csEntryInfo.getDetailAmount());
            entryInfo.setZeroTaxRateFlag(csEntryInfo.getZeroTaxRateFlag());
            entryInfo.setDiscountType(csEntryInfo.getDiscountType());
            entryInfo.setPreferentialPolicy("1".equals(csEntryInfo.getPreferentialPolicy()));
            entryInfo.setVersionNo(csEntryInfo.getVersionNo());
            info.getEntries().add(entryInfo);
        }
    }

    protected void parseCheckAbs(Context ctx, CommonSpecialInvoiceInfo csInfo, IncomeInvoiceInfo info) throws EASBizException, BOSException {
        CheckAbsInfo checkAbs = info.getCheckAbs();
        if (checkAbs == null) {
            checkAbs = CheckAbsUtil.createCheckAbs(info);
            info.setCheckAbs(checkAbs);
        }
        CheckStateEnum checkState = "0".equals(csInfo.getAuthenticateFlag().getValue()) ? CheckStateEnum.Unchecked : CheckStateEnum.Checked;
        checkAbs.setSalerName(csInfo.getSalerName());
        checkAbs.setSalerTaxNo(csInfo.getSalerTaxNo());
        checkAbs.setCheckState(checkState);
        if (CheckStateEnum.Checked.equals((Object)checkState)) {
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            if (!StringUtils.isEmpty((String)csInfo.getSelectTime())) {
                ts = Timestamp.valueOf(csInfo.getSelectTime());
                checkAbs.setCheckTime((Date)ts);
            }
            if ("3".equals(csInfo.getAuthenticateFlag().getValue())) {
                checkAbs.setCheckWay(CheckWayEnum.Scan);
                if (!StringUtils.isEmpty((String)csInfo.getScanAuthenticateTime())) {
                    ts = Timestamp.valueOf(csInfo.getScanAuthenticateTime());
                    checkAbs.setConfirmTime((Date)ts);
                }
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else if ("2".equals(csInfo.getAuthenticateFlag().getValue())) {
                checkAbs.setCheckWay(CheckWayEnum.Check);
                if (!StringUtils.isEmpty((String)csInfo.getSelectAuthenticateTime())) {
                    ts = Timestamp.valueOf(csInfo.getSelectAuthenticateTime());
                    checkAbs.setConfirmTime((Date)ts);
                }
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else if (TMAuthenticateFlag.CHECK.equals((Object)csInfo.getAuthenticateFlag())) {
                checkAbs.setCheckWay(CheckWayEnum.Check);
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            } else {
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            }
        } else {
            checkAbs.setCheckTime(null);
            checkAbs.setCheckWay(null);
            checkAbs.setCheckPurpose(null);
            checkAbs.setCheckUser(null);
            checkAbs.setTaxPeriod(null);
            checkAbs.setConfirmTime(null);
            checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            checkAbs.setConfirmUser(null);
        }
        if (checkAbs != null) {
            checkAbs.setCompany(info.getCompany());
            CheckAbsFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)checkAbs);
        }
    }

    public IncomeStatusEnum getIncomeStatusEnum(String value) {
        if ("0".equals(value)) {
            return IncomeStatusEnum.NORMAL;
        }
        if ("1".equals(value)) {
            return IncomeStatusEnum.LOSECONTROL;
        }
        if ("2".equals(value)) {
            return IncomeStatusEnum.CANCEL;
        }
        if ("3".equals(value)) {
            return IncomeStatusEnum.CREDIT;
        }
        if ("4".equals(value)) {
            return IncomeStatusEnum.UNUSUAL;
        }
        if ("5".equals(value)) {
            return IncomeStatusEnum.UNNORMAL;
        }
        if ("6".equals(value)) {
            return IncomeStatusEnum.UNCONFIRMRED;
        }
        if ("7".equals(value)) {
            return IncomeStatusEnum.PARTLYRED;
        }
        if ("8".equals(value)) {
            return IncomeStatusEnum.FULLRED;
        }
        return null;
    }

    public PayInvoiceTypeEnum getInvoiceType(String value) {
        if ("1".equals(value)) {
            return PayInvoiceTypeEnum.ELECTRONICINVOICE;
        }
        if ("2".equals(value)) {
            return PayInvoiceTypeEnum.ELECTRONICINVOICE;
        }
        if ("3".equals(value)) {
            return PayInvoiceTypeEnum.COMMONINVOICE;
        }
        if ("4".equals(value)) {
            return PayInvoiceTypeEnum.VALUEADDEDTAXINV;
        }
        if ("5".equals(value)) {
            return PayInvoiceTypeEnum.COMMONINVOICE;
        }
        return null;
    }
}

