/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.api.AbstractDataUpgrade;
import com.kingdee.eas.tm.im.util.IMSQLUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public abstract class MakeInvoiceReq2ArApDataUpgrade
extends AbstractDataUpgrade {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.upgrade.impl.MakeInvoiceReqDataUpgrade");

    @Override
    protected void doUpgrade(Context ctx, DataUpgradeTraceInfo info) throws EASBizException, BOSException {
        try {
            ctx.put((Object)"disablePermissionForKScript", (Object)true);
            if (StringUtils.isEmpty((String)info.getDefineConfig())) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", "DefineConfig_NOT_NULLl", IMUtils.getLocale())});
            }
            String filterSql = this.buildFilterSql(ctx, info);
            this.updateInvoiceReqFields(ctx, filterSql);
            info.setIsProcessed(true);
            logger.debug((Object)"upgrade success");
        }
        catch (Exception e) {
            info.setIsProcessed(false);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            ctx.remove((Object)"disablePermissionForKScript");
        }
    }

    protected abstract String getSrcEntryTable();

    protected void updateInvoiceReqFields(Context ctx, String filterSql) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE ").append(this.getSrcEntryTable()).append(" SET ");
        sql.append(" FUnInvoiceReqQty=FQuantity,FUnInvoiceReqBaseQty=FBaseQty,");
        sql.append(" FUnInvoiceReqAmount = FRecievePayAmount,FUnInvoiceReqAmountLocal = FRecievePayAmountLocal");
        sql.append(" WHERE (");
        sql.append("  (FInvoiceReqBaseQty = 0 and FUnInvoiceReqBaseQty = 0  and FInvoiceReqAmountLocal = 0 and FUnInvoiceReqAmountLocal = 0)");
        sql.append("  or ");
        sql.append("  (FUnInvoiceReqQty is null and FUnInvoiceReqBaseQty is null and FUnInvoiceReqAmount is null and FUnInvoiceReqAmountLocal is null)");
        sql.append(" )");
        sql.append(" and FParentID in (").append(filterSql).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected String buildFilterSql(Context ctx, DataUpgradeTraceInfo info) throws BOSException {
        String sql = IMSQLUtil.structureFilter(ctx, info.getDefineConfig(), info.getQuery());
        return sql;
    }
}

