/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.invoicePool.INonCompliantType;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceEntryCollection;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceEntryInfo;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantStateEnum;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantTypeCollection;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantTypeFactory;
import com.kingdee.eas.tm.common.invoicePool.NonCompliantTypeInfo;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NonCompliantInvoiceUtils {
    public static final String CHGOFINVSTATUS = "CHGofINVstatus";
    public static final String BLOFSUPPLIERS = "BLofSuppliers";
    public static final String BLREMOVED = "BLremoved";

    public static void updateNonCompliantInvoice(Context ctx, NonCompliantInvoiceInfo nonCompliantInvoice, Object invoice) throws EASBizException, BOSException {
        if (invoice instanceof IncomeInvoiceInfo) {
            IncomeInvoiceInfo info = (IncomeInvoiceInfo)invoice;
            if (info.getId() == null) {
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            }
            nonCompliantInvoice.setCompany(info.getCompany());
            nonCompliantInvoice.setBizDate((Date)info.getCreateTime());
            nonCompliantInvoice.setInvoiceType(info.getTmInvoiceType());
            nonCompliantInvoice.setInvoiceID(info.getId().toString());
            nonCompliantInvoice.setInvoiceCode(info.getInvoiceCode());
            nonCompliantInvoice.setInvoiceNo(info.getInvoiceNumber());
            nonCompliantInvoice.setInvoiceDate(info.getBizDate());
            nonCompliantInvoice.setAmount(info.getAmount());
            nonCompliantInvoice.setTax(info.getTax());
            nonCompliantInvoice.setAmountTax(info.getAmountTax());
            if (IncomeStatusEnum.NORMAL.equals((Object)info.getStatus())) {
                nonCompliantInvoice.setInvoiceState(TMInvoiceStatus.NORMAL);
            } else if (IncomeStatusEnum.LOSECONTROL.equals((Object)info.getStatus())) {
                nonCompliantInvoice.setInvoiceState(TMInvoiceStatus.OUT_OF_CONTROL);
            } else if (IncomeStatusEnum.CANCEL.equals((Object)info.getStatus())) {
                nonCompliantInvoice.setInvoiceState(TMInvoiceStatus.CANCEL);
            } else if (IncomeStatusEnum.CREDIT.equals((Object)info.getStatus())) {
                nonCompliantInvoice.setInvoiceState(TMInvoiceStatus.RED);
            } else if (IncomeStatusEnum.UNUSUAL.equals((Object)info.getStatus())) {
                nonCompliantInvoice.setInvoiceState(TMInvoiceStatus.ABNORMAL);
            } else if (IncomeStatusEnum.UNNORMAL.equals((Object)info.getStatus())) {
                nonCompliantInvoice.setInvoiceState(TMInvoiceStatus.UNNORMAL);
            } else if (IncomeStatusEnum.UNCONFIRMRED.equals((Object)info.getStatus())) {
                nonCompliantInvoice.setInvoiceState(TMInvoiceStatus.UNCONFIRMRED);
            } else if (IncomeStatusEnum.PARTLYRED.equals((Object)info.getStatus())) {
                nonCompliantInvoice.setInvoiceState(TMInvoiceStatus.PARTLYRED);
            } else if (IncomeStatusEnum.FULLRED.equals((Object)info.getStatus())) {
                nonCompliantInvoice.setInvoiceState(TMInvoiceStatus.FULLRED);
            }
            nonCompliantInvoice.setSalerName(info.getBillingCompany());
            nonCompliantInvoice.setSalerTaxNo(info.getTaxNumber());
            nonCompliantInvoice.setBizBillType(info.getBizBillType());
            nonCompliantInvoice.setBizBillNumber(info.getBizBillNumber());
            nonCompliantInvoice.setBizBillID(info.getBizBillID());
            nonCompliantInvoice.setBizBillEntryID(info.getBizBillEntryID());
            nonCompliantInvoice.setIsBusiness(info.isReBusiness());
            nonCompliantInvoice.setIsPayment(info.isIsPayment());
            nonCompliantInvoice.setIsAccept(info.isIsAccept());
            nonCompliantInvoice.setPdfUrl(info.getPdfUrl());
            if (info.getCheckAbs() != null) {
                nonCompliantInvoice.setCheckState(info.getCheckAbs().getCheckState());
                nonCompliantInvoice.setConfirmState(info.getCheckAbs().getConfirmState());
                nonCompliantInvoice.setTaxPeriod(info.getCheckAbs().getTaxPeriod());
            }
            Object statusChaged = null;
            statusChaged = info.get("statusChaged");
            if (statusChaged != null && Boolean.parseBoolean(statusChaged.toString())) {
                NonCompliantInvoiceUtils.addNonCompliantInvoiceEntry(ctx, nonCompliantInvoice, CHGOFINVSTATUS);
            }
            NonCompliantInvoiceUtils.updateInvoiceNonCompliantInfo(invoice);
        }
    }

    public static void updateInvoiceNonCompliantInfo(Object invoice) {
        if (invoice instanceof IncomeInvoiceInfo) {
            IncomeInvoiceInfo info = (IncomeInvoiceInfo)invoice;
            boolean isProcess = true;
            ArrayList<String> nonCompliantExplains = new ArrayList<String>();
            if (info.getNonCompliantInvoice() != null) {
                NonCompliantInvoiceInfo nonCompliantInvoice = info.getNonCompliantInvoice();
                NonCompliantInvoiceEntryCollection coll = nonCompliantInvoice.getEntry();
                NonCompliantInvoiceEntryInfo entryInfo = null;
                if (coll != null) {
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        entryInfo = coll.get(i);
                        if (NonCompliantStateEnum.untreated.equals((Object)entryInfo.getNonCompliantState())) {
                            isProcess = false;
                        }
                        if (entryInfo.getNonCompliantType() == null || nonCompliantExplains.contains(entryInfo.getNonCompliantType().getName())) continue;
                        nonCompliantExplains.add(entryInfo.getNonCompliantType().getName());
                    }
                    info.setIsNonCompliant(true);
                    info.setNonCompliantState(isProcess ? NonCompliantStateEnum.processed : NonCompliantStateEnum.untreated);
                    info.setNonCompliantExplain(CollectionUtil.convertList2String(nonCompliantExplains, ";", false));
                } else {
                    info.setIsNonCompliant(false);
                    info.setNonCompliantState(null);
                    info.setNonCompliantExplain(null);
                }
            } else {
                info.setIsNonCompliant(false);
                info.setNonCompliantState(null);
                info.setNonCompliantExplain(null);
            }
        }
    }

    public static void addNonCompliantInvoiceEntry(Context ctx, NonCompliantInvoiceInfo nonCompliantInvoice, String nonCompliantType) throws EASBizException, BOSException {
        NonCompliantInvoiceEntryCollection coll = null;
        NonCompliantInvoiceEntryInfo entryInfo = null;
        Map<String, NonCompliantTypeInfo> nonCompliantTypeMap = NonCompliantInvoiceUtils.getNonCompliantType(ctx, null);
        coll = nonCompliantInvoice.getEntry();
        if (coll == null) {
            coll = new NonCompliantInvoiceEntryCollection();
        }
        entryInfo = new NonCompliantInvoiceEntryInfo();
        if (nonCompliantTypeMap != null && nonCompliantTypeMap.get(nonCompliantType) != null) {
            entryInfo.setNonCompliantType(nonCompliantTypeMap.get(nonCompliantType));
        }
        entryInfo.setNonCompliantState(NonCompliantStateEnum.untreated);
        entryInfo.setCheckTime(new Timestamp(System.currentTimeMillis()));
        coll.add(entryInfo);
    }

    public static Map<String, NonCompliantTypeInfo> getNonCompliantType(Context ctx, Set<String> numbers) throws BOSException, EASBizException {
        HashMap<String, NonCompliantTypeInfo> paramMap = new HashMap<String, NonCompliantTypeInfo>();
        HashSet<String> numberSet = new HashSet<String>();
        numberSet.add(CHGOFINVSTATUS);
        numberSet.add(BLOFSUPPLIERS);
        numberSet.add(BLREMOVED);
        if (numbers != null && numbers.size() > 0) {
            numberSet.addAll(numbers);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        INonCompliantType factory = null;
        factory = ctx == null ? NonCompliantTypeFactory.getRemoteInstance() : NonCompliantTypeFactory.getLocalInstance((Context)ctx);
        NonCompliantTypeCollection col = factory.getNonCompliantTypeCollection(viewInfo);
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            paramMap.put(col.get(i).getNumber(), col.get(i));
        }
        return paramMap;
    }
}

