/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util.ofd.util;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1StreamParser;
import com.kingdee.bos.ctrl.cipher.asn1.DEREncodable;
import com.kingdee.bos.ctrl.cipher.asn1.DEROctetString;
import com.kingdee.bos.ctrl.cipher.asn1.DERSequence;
import com.kingdee.eas.tm.im.util.ofd.CompressHelper;
import com.kingdee.eas.tm.im.util.ofd.OfdErrorType;
import com.kingdee.eas.tm.im.util.ofd.StrUtil;
import com.kingdee.eas.tm.im.util.ofd.config.exception.ConvertException;
import com.kingdee.eas.tm.im.util.ofd.util.OfdReadUtil;
import com.kingdee.eas.tm.im.util.ofd.util.SVGConversionUtil;
import com.kingdee.eas.tm.im.util.ofd.util.SvgUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfdConvertUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfdConvertUtil.class);

    public static byte[] convertToImage(byte[] fileBytes, float zoomScale, int imageType) throws Exception {
        if (zoomScale > 3.0f) {
            throw new ConvertException(OfdErrorType.CONVERT_PNG_TOO_LARGE);
        }
        Map<String, Object> svgMap = OfdConvertUtil.ofdToSvgMap(fileBytes, false, -1);
        String svgStr = (String)svgMap.get("svgStr");
        float svgWidth = ((Float)svgMap.get("svgWidth")).floatValue();
        float svgHeight = ((Float)svgMap.get("svgHeight")).floatValue();
        byte[] svgBytes = svgStr.getBytes(Charset.forName("UTF-8"));
        return SVGConversionUtil.convertSvgBytes2Image(svgBytes, SvgUtil.getPxByMM(svgWidth) * zoomScale, SvgUtil.getPxByMM(svgHeight) * zoomScale, imageType);
    }

    public static List<Object> convertToMultImage(byte[] fileBytes, float zoomScale, boolean strFlag, int imageType, int pageNo) throws Exception {
        String svgStr = OfdConvertUtil.ofdToSvgStr(fileBytes, false, pageNo);
        return SVGConversionUtil.convertSvgBytes2MulImage(svgStr, zoomScale, strFlag, imageType);
    }

    public static byte[] convertToPdf(byte[] fileBytes) {
        try {
            String svgStr = OfdConvertUtil.ofdToSvgStr(fileBytes, true, -1);
            return SVGConversionUtil.convertSvgStr2Pdf(svgStr);
        }
        catch (Exception e) {
            LOGGER.error((Object)((Object)OfdErrorType.CONVERT_PDF_ERROR) + ":" + e.getMessage(), (Throwable)e);
            throw new ConvertException(OfdErrorType.CONVERT_PDF_ERROR);
        }
    }

    public static byte[] convertToSvg(byte[] fileBytes) {
        return OfdConvertUtil.ofdToSvgStr(fileBytes, false, -1).getBytes(Charset.forName("UTF-8"));
    }

    private static Map<String, Object> ofdToSvgMap(byte[] fileBytes, boolean pdfFlag, int pageNo) {
        Map<String, byte[]> ofdFileMap = CompressHelper.decompress(fileBytes);
        return OfdConvertUtil.readOfdDataToSvg(ofdFileMap, pdfFlag, pageNo);
    }

    private static String ofdToSvgStr(byte[] fileBytes, boolean pdfFlag, int pageNo) {
        Map<String, Object> svgMap = OfdConvertUtil.ofdToSvgMap(fileBytes, pdfFlag, pageNo);
        return (String)svgMap.get("svgStr");
    }

    private static Map<String, Object> readOfdDataToSvg(Map<String, byte[]> ofdFileMap, boolean pdfFlag, int pageNo) {
        String[] areaArr;
        float areaWidth;
        byte[] ofdMainByte = ofdFileMap.get("OFD.xml");
        String docRootPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/DocRoot");
        String signaturesPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/Signatures");
        String docRootDirPath = OfdReadUtil.getLastDirPath(docRootPath).toString();
        byte[] documentByte = ofdFileMap.get(docRootPath);
        Element documentEle = OfdReadUtil.getElementByByte(documentByte);
        Element commonDataEle = documentEle.element("CommonData");
        String documentResPath = commonDataEle.elementText("DocumentRes");
        Map<String, Object> multiMediaMap = OfdConvertUtil.getMultiMediaMap(ofdFileMap, docRootDirPath + documentResPath);
        String publicResPath = commonDataEle.elementText("PublicRes");
        Map<String, String> fontFamilyMap = OfdConvertUtil.getFontFamilyByPublicRes(ofdFileMap.get(docRootDirPath + publicResPath));
        String firstPageArea = commonDataEle.element("PageArea").elementText("PhysicalBox");
        float width = 210.0f;
        if (firstPageArea != null && (areaWidth = Float.parseFloat((areaArr = firstPageArea.split(" "))[2])) > 0.0f) {
            width = areaWidth;
        }
        List tempEleList = commonDataEle.elements("TemplatePage");
        Map<String, Element> templateMap = OfdConvertUtil.getTempEleMap(tempEleList);
        Element pagesEle = documentEle.element("Pages");
        List pageEleList = pagesEle.elements("Page");
        float offsetY = 0.0f;
        StringBuffer contentBuffer = new StringBuffer();
        for (int i = 0; i < pageEleList.size(); ++i) {
            if (pageNo != -1 && pageNo != i) continue;
            Element pageEle = OfdReadUtil.getElementByPath(ofdFileMap, (Element)pageEleList.get(i), docRootDirPath);
            String tempId = OfdConvertUtil.getTempEleIdByPage(pageEle);
            Element tempElePath = templateMap.get(tempId);
            if (tempElePath == null) {
                tempElePath = (Element)tempEleList.get(i);
            }
            Element tempEle = OfdReadUtil.getElementByPath(ofdFileMap, tempElePath, docRootDirPath);
            Map<String, Object> svgMap = SvgUtil.getPageSvg(tempEle, firstPageArea, fontFamilyMap, null, multiMediaMap, null, offsetY, i);
            StringBuffer svgBuffer = (StringBuffer)svgMap.get("svgBuffer");
            String signSvgString = null;
            if (i == 0) {
                signSvgString = OfdConvertUtil.getSignSvgString(ofdFileMap, signaturesPath);
            }
            SvgUtil.getPageSvg(pageEle, firstPageArea, fontFamilyMap, svgBuffer, multiMediaMap, signSvgString, offsetY, i);
            svgBuffer.append("</svg>");
            if (!pdfFlag) {
                offsetY = ((Float)svgMap.get("offsetY")).floatValue();
            }
            contentBuffer.append(svgBuffer);
        }
        StringBuffer pageBuffer = new StringBuffer("<svg ").append(" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ").append(" version=\"1.1\" ");
        pageBuffer.append("width=\"").append(width).append("mm\" height=\"").append(offsetY).append("mm\">");
        pageBuffer.append(contentBuffer);
        pageBuffer.append("</svg>");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("svgStr", pageBuffer.toString());
        map.put("svgWidth", Float.valueOf(width));
        map.put("svgHeight", Float.valueOf(offsetY));
        return map;
    }

    private static String getTempEleIdByPage(Element pageEle) {
        String tempEleId = null;
        Element templateEle = pageEle.element("Template");
        if (templateEle != null) {
            tempEleId = templateEle.attributeValue("TemplateID");
        }
        return tempEleId;
    }

    private static Map<String, Element> getTempEleMap(List<Element> tempEleList) {
        HashMap<String, Element> templateMap = new HashMap<String, Element>(tempEleList.size());
        for (Element templateEle : tempEleList) {
            templateMap.put(templateEle.attributeValue("ID"), templateEle);
        }
        return templateMap;
    }

    private static Map<String, String> getFontFamilyByPublicRes(byte[] fileBytes) {
        String fillColor;
        Element fillColorEle;
        Element drawParamEle;
        HashMap<String, String> map = new HashMap<String, String>();
        Element publicResEle = OfdReadUtil.getElementByByte(fileBytes);
        List fontEleList = publicResEle.element("Fonts").elements("Font");
        Element drawParamsEle = publicResEle.element("DrawParams");
        if (drawParamsEle != null && (drawParamEle = drawParamsEle.element("DrawParam")) != null && (fillColorEle = drawParamEle.element("FillColor")) != null && !StrUtil.isEmpty(fillColor = fillColorEle.attributeValue("Value"))) {
            map.put("fillColor", fillColor);
        }
        for (Element fontEle : fontEleList) {
            String fontFamilyName = fontEle.attributeValue("FamilyName");
            if (StrUtil.isEmpty(fontFamilyName)) {
                fontFamilyName = fontEle.attributeValue("FontName");
            }
            if ("KaiTi".equals(fontFamilyName)) {
                fontFamilyName = "\u6977\u4f53, KaiTi, Kai, simkai";
            }
            if (!StrUtil.isEmpty(fontFamilyName)) {
                fontFamilyName = fontFamilyName.replace("\u6977\u4f53", "\u6977\u4f53, KaiTi, Kai, simkai");
                fontFamilyName = fontFamilyName.replace("\u5b8b\u4f53", "\u5b8b\u4f53, SimSun, simsun");
            }
            map.put(fontEle.attributeValue("ID"), fontFamilyName);
        }
        return map;
    }

    private static Map<String, Object> getMultiMediaMap(Map<String, byte[]> ofdFileMap, String documentResPath) {
        Map<String, Object> multiMediaMap = null;
        byte[] docResByte = ofdFileMap.get(documentResPath);
        Element docResEle = OfdReadUtil.getElementByByte(docResByte);
        Element multiMediasEle = docResEle.element("MultiMedias");
        List multiMediaList = multiMediasEle.elements("MultiMedia");
        if (multiMediaList != null && !multiMediaList.isEmpty()) {
            String documentResDirPath = OfdReadUtil.getLastDirPath(documentResPath).append("Res/").toString();
            multiMediaMap = OfdConvertUtil.getMultiMediaMap(multiMediaList, documentResDirPath, ofdFileMap);
        }
        return multiMediaMap;
    }

    private static Map<String, Object> getMultiMediaMap(List<Element> multiMediaList, String documentResPath, Map<String, byte[]> ofdFileMap) {
        HashMap<String, Object> multiMediaMap = new HashMap<String, Object>();
        for (Element multiMediaEle : multiMediaList) {
            String fileName = multiMediaEle.elementText("MediaFile");
            String idStr = multiMediaEle.attributeValue("ID");
            multiMediaMap.put(idStr, fileName);
            multiMediaMap.put(idStr + "_BYTE", ofdFileMap.get(documentResPath + fileName));
        }
        return multiMediaMap;
    }

    private static String getSignSvgString(Map<String, byte[]> ofdFileMap, String signaturesPath) {
        try {
            Element signaturesEle = OfdReadUtil.getElementByPath(ofdFileMap, signaturesPath);
            Element signaturePathEle = signaturesEle.element("Signature");
            String signaturePath = signaturePathEle.attributeValue("BaseLoc");
            signaturePath = OfdReadUtil.getDirPath(signaturePath, signaturesPath);
            Element signatureEle = OfdReadUtil.getElementByPath(ofdFileMap, signaturePath);
            Element signedInfoEle = signatureEle.element("SignedInfo");
            String signBoundary = signedInfoEle.element("StampAnnot").attributeValue("Boundary");
            String signedValuePath = signatureEle.elementText("SignedValue");
            signedValuePath = OfdReadUtil.getDirPath(signedValuePath, signaturePath);
            byte[] signedValueByte = OfdReadUtil.getByteByPath(ofdFileMap, signedValuePath);
            return OfdConvertUtil.getSignPic(signedValueByte, signBoundary);
        }
        catch (Exception e) {
            LOGGER.error((Object)((Object)OfdErrorType.READ_SIGN_PIC_ERROR) + ":" + e.getMessage(), (Throwable)e);
            throw new ConvertException(OfdErrorType.READ_SIGN_PIC_ERROR);
        }
    }

    private static String getSignPic(byte[] signFileByte, String signBoundary) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(signFileByte);
        ASN1StreamParser asn1StreamParser = new ASN1StreamParser((InputStream)inputStream);
        DEREncodable sequenceParser = asn1StreamParser.readObject();
        DERSequence derSequence = (DERSequence)sequenceParser.getDERObject();
        DERSequence derSequence0 = (DERSequence)derSequence.getObjectAt(0);
        DERSequence derSequence1 = (DERSequence)derSequence0.getObjectAt(1);
        DERSequence sealPicSeq = (DERSequence)((DERSequence)derSequence1.getObjectAt(0)).getObjectAt(3);
        String picType = sealPicSeq.getObjectAt(0).toString();
        byte[] picBytes = ((DEROctetString)sealPicSeq.getObjectAt(1)).getOctets();
        String contentStr = null;
        if ("ofd".equals(picType)) {
            contentStr = OfdConvertUtil.getSignOfdBuffer(picBytes, signBoundary);
        }
        return contentStr;
    }

    private static String getSignOfdBuffer(byte[] picBytes, String signBoundary) {
        String[] signBoundaryArr = signBoundary.split(" ");
        float pageOffsetX = Float.parseFloat(signBoundaryArr[0]);
        float pageOffsetY = Float.parseFloat(signBoundaryArr[1]);
        Map<String, byte[]> signOfdMap = CompressHelper.decompress(picBytes);
        byte[] ofdMainByte = signOfdMap.get("OFD.xml");
        String docRootPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/DocRoot");
        String docRootDirPath = OfdReadUtil.getLastDirPath(docRootPath).toString();
        byte[] documentByte = signOfdMap.get(docRootPath);
        Element documentEle = OfdReadUtil.getElementByByte(documentByte);
        Element commonDataEle = documentEle.element("CommonData");
        String publicResPath = commonDataEle.elementText("PublicRes");
        Map<String, String> fontFamilyMap = OfdConvertUtil.getFontFamilyByPublicRes(signOfdMap.get(docRootDirPath + publicResPath));
        Element pagesEle = documentEle.element("Pages");
        List pageEleList = pagesEle.elements("Page");
        StringBuffer contentBuffer = new StringBuffer();
        for (int i = 0; i < pageEleList.size(); ++i) {
            List pathObjectEleList;
            Element pageEle = OfdReadUtil.getElementByPath(signOfdMap, (Element)pageEleList.get(i), docRootDirPath);
            Element contentEle = pageEle.element("Content");
            Element layerEle = contentEle.element("Layer");
            List textEleList = layerEle.elements("TextObject");
            if (textEleList != null && !textEleList.isEmpty()) {
                SvgUtil.getSvgTextByList(textEleList, fontFamilyMap, contentBuffer, pageOffsetX, pageOffsetY);
            }
            if ((pathObjectEleList = layerEle.elements("PathObject")) == null || pathObjectEleList.isEmpty()) continue;
            SvgUtil.getSvgLineByList(pathObjectEleList, contentBuffer, pageOffsetX, pageOffsetY);
        }
        return contentBuffer.toString();
    }
}

