/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.tm.im.BalanceAnalysisReportFacadeFactory;
import com.kingdee.eas.tm.rpt.client.AbstractMakeInvoiceAnalysisRptUI;
import com.kingdee.eas.tm.rpt.client.MakeInvoiceAnalysisRptConditionUI;
import java.awt.Color;
import org.apache.log4j.Logger;

public class MakeInvoiceAnalysisRptUI
extends AbstractMakeInvoiceAnalysisRptUI {
    private static final Logger logger = CoreUIObject.getLogger(MakeInvoiceAnalysisRptUI.class);

    public MakeInvoiceAnalysisRptUI() throws Exception {
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        this.tbl.getDataRequestManager().setPageRowCount(500);
        this.enableExportExcel(this.tbl);
        this.tbl.setEditable(false);
        this.tbl.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                MakeInvoiceAnalysisRptUI.this.tbl_afterDataFill(e);
            }
        });
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return BalanceAnalysisReportFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        MakeInvoiceAnalysisRptConditionUI condUI = new MakeInvoiceAnalysisRptConditionUI();
        return condUI;
    }

    protected void query() {
        this.tbl.removeColumns();
        this.tbl.removeRows();
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            this.tbl.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams para = new RptParams();
            if (from == 0) {
                para.setString("tempTable", this.getTempTable());
                StringBuffer ids = new StringBuffer();
                Object org = this.params.getObject("companyIds");
                if (org instanceof Object[]) {
                    Object[] orgs = (Object[])org;
                    ids.append("( '11111111111'");
                    for (int i = 0; i < orgs.length; ++i) {
                        CompanyOrgUnitInfo compOrg = (CompanyOrgUnitInfo)orgs[i];
                        ids.append(",'").append(compOrg.getId().toString()).append("'");
                    }
                    ids.append(")");
                }
                if (org instanceof CompanyOrgUnitInfo) {
                    CompanyOrgUnitInfo compOrg = (CompanyOrgUnitInfo)org;
                    ids.append("('").append(compOrg.getId().toString()).append("')");
                }
                if (org == null) {
                    ids.append("( '11111111111') ");
                }
                para.setObject("companyIds", (Object)ids.toString());
                para.setObject("dateFrom", this.params.getObject("dateFrom"));
                para.setObject("dateTo", this.params.getObject("dateTo"));
                para.setObject("customerFrom", this.params.getObject("customerFrom"));
                para.setObject("customerTo", this.params.getObject("customerTo"));
                para.setObject("billNumber", this.params.getObject("billNumber"));
                para.setObject("invoiceNo", this.params.getObject("invoiceNo"));
                para.setBoolean("isShowNoInvoice", this.params.getBoolean("isShowNoInvoice"));
                para.setBoolean("isShowZero", this.params.getBoolean("isShowZero"));
                para.setObject("srcBillType", this.params.getObject("srcBillType"));
                RptParams rpt = BalanceAnalysisReportFacadeFactory.getRemoteInstance().createTempTable(para);
                this.setTempTable(rpt.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
            }
            String[] mergeColumnKeys = new String[]{"FCompanyName", "FBillType", "FCustomerName", "FBizDate", "FBillNumber"};
            this.tbl.checkParsed();
            this.tbl.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tbl.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
            para.setString("tempTable", this.getTempTable());
            RptParams rpt = BalanceAnalysisReportFacadeFactory.getRemoteInstance().query(para, from, len);
            if (from == 0) {
                this.tbl.setRowCount(rpt.getInt("totalCount"));
            }
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tbl);
            this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        return super.showQueryDialog(useDefaultSolution);
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int last = e.getLastRow();
        IRow row = null;
        for (int i = from; i <= last; ++i) {
            row = this.tbl.getRow(i);
            if (row == null) {
                return;
            }
            Object indexVal = row.getCell("FIndex").getValue();
            if (indexVal == null || !"999999".equals(indexVal)) continue;
            row.getStyleAttributes().setBackground(new Color(255, 255, 153));
        }
    }
}

