/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.app;

import com.kingdee.eas.base.codingrule.app.Mutex;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class MutexFactory {
    private static Logger logger = Logger.getLogger(MutexFactory.class);

    private MutexFactory() {
    }

    public static Mutex createMutex(String name) {
        Mutex mutex = name != null ? LockPool.makeLock(name) : LockPool.makeLock("");
        return mutex;
    }

    private static class LockPool {
        private static Hashtable lockpool;

        private LockPool() {
        }

        public static synchronized Mutex makeLock(String name) {
            Mutex mutex;
            Date nowBegin = new Date();
            if (lockpool == null) {
                lockpool = new Hashtable();
            } else {
                int locknumber = lockpool.size();
                if (locknumber > 300) {
                    Date now = new Date();
                    Iterator it = lockpool.values().iterator();
                    if (locknumber > 900) {
                        while (it.hasNext()) {
                            Mutex mutex2 = (Mutex)it.next();
                            if ((now.getTime() - mutex2.getLastUsedTime().getTime()) / 6000L <= 10L) continue;
                            it.remove();
                        }
                    } else if (locknumber > 600) {
                        while (it.hasNext()) {
                            Mutex mutex3 = (Mutex)it.next();
                            if ((now.getTime() - mutex3.getLastUsedTime().getTime()) / 6000L <= 60L) continue;
                            it.remove();
                        }
                    } else {
                        while (it.hasNext()) {
                            Mutex mutex4 = (Mutex)it.next();
                            if ((now.getTime() - mutex4.getLastUsedTime().getTime()) / 6000L <= 120L) continue;
                            it.remove();
                        }
                    }
                }
            }
            if (lockpool.containsKey(name)) {
                mutex = (Mutex)lockpool.get(name);
            } else {
                mutex = new Mutex(name);
                lockpool.put(name, mutex);
            }
            Date nowEnd = new Date();
            float waitSecond = (float)(nowEnd.getTime() - nowBegin.getTime()) / 1000.0f;
            logger.debug((Object)("makeLock " + name + " using times : " + waitSecond + " second."));
            return mutex;
        }
    }
}

