/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.OrgMovePermissionInfo;
import com.kingdee.eas.base.permission.OrgMovePermissionParam;
import com.kingdee.eas.base.permission.UserFacadeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractAfterOrgMovePermissionHandlerUI;
import com.kingdee.eas.basedata.org.IAfterOrgMoveHandler;
import com.kingdee.eas.basedata.org.OrgMoveParam;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class AfterOrgMovePermissionHandlerUI
extends AbstractAfterOrgMovePermissionHandlerUI {
    private static final Logger logger = CoreUIObject.getLogger(AfterOrgMovePermissionHandlerUI.class);
    OrgMoveParam orgMoveParam = null;
    IAfterOrgMoveHandler afterOrgMoveHandler = null;
    private static final String IS_SELECTED = "isSelected";
    private static final String USER_NAME = "userName";
    private static final String USER_NUMBER = "userNumber";
    private static final String DEF_ORG_UNIT = "defOrgUnit";
    private static final String CONTROL_UNIT = "controlUnit";
    private static final String USER_ID = "userId";
    private static final String IS_DELETE_CU_PERM = "isDeleteCuPerm";
    private static final Color DISABLE_COLOR = new Color(192, 192, 192);
    private static final Color SEARCHED_COLOR = new Color(16574898);
    private static final Color ORIGIN_COLOR = Color.white;

    public void onLoad() throws Exception {
        super.onLoad();
        this.prepare();
        this.initComponent();
        this.initTable();
        this.fillTables();
    }

    private void initComponent() throws EASBizException, BOSException {
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.kdtShiftSearch, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.kdtStaySearch, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.kdtShiftSearch.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AfterOrgMovePermissionHandlerUI.this.search(AfterOrgMovePermissionHandlerUI.this.kdShiftTable, AfterOrgMovePermissionHandlerUI.this.kdtShiftSearch);
                }
            }
        });
        this.kdtStaySearch.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AfterOrgMovePermissionHandlerUI.this.search(AfterOrgMovePermissionHandlerUI.this.kdStayTable, AfterOrgMovePermissionHandlerUI.this.kdtStaySearch);
                }
            }
        });
        this.setButtonDefaultStyl(this.btnSelectAll1);
        this.setButtonDefaultStyl(this.btnClearAll1);
        this.setButtonDefaultStyl(this.btnSelectAll2);
        this.setButtonDefaultStyl(this.btnClearAll2);
        this.btnSelectAll1.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll1.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelectAll2.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll2.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    private void prepare() {
        this.afterOrgMoveHandler = (IAfterOrgMoveHandler)this.getUIContext().get("afterOrgMoveHandlerKey");
        this.orgMoveParam = this.afterOrgMoveHandler.getOrgMoveParam();
    }

    private void initTable() {
        this.kdShiftTable.checkParsed();
        this.kdShiftTable.getColumn(IS_SELECTED).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.kdShiftTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                int colIndex = e.getColIndex();
                IColumn col = AfterOrgMovePermissionHandlerUI.this.kdShiftTable.getColumn(colIndex);
                if (!AfterOrgMovePermissionHandlerUI.IS_SELECTED.equals(col.getKey())) {
                    return;
                }
                int rowIndex = e.getRowIndex();
                Boolean newValue = (Boolean)e.getValue();
                IRow row = AfterOrgMovePermissionHandlerUI.this.kdShiftTable.getRow(rowIndex);
                ICell cell = row.getCell(AfterOrgMovePermissionHandlerUI.IS_DELETE_CU_PERM);
                if (newValue.booleanValue()) {
                    cell.getStyleAttributes().setLocked(false);
                    cell.getStyleAttributes().setBackground(ORIGIN_COLOR);
                } else {
                    cell.getStyleAttributes().setLocked(true);
                    cell.setValue((Object)Boolean.FALSE);
                }
            }
        });
        IColumn isDeleteCuPermCol = this.kdShiftTable.getColumn(IS_DELETE_CU_PERM);
        isDeleteCuPermCol.setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.disableCol(this.kdShiftTable, IS_DELETE_CU_PERM);
        this.kdStayTable.checkParsed();
        this.kdStayTable.getColumn(IS_SELECTED).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
    }

    private void fillTables() throws Exception {
        OrgMovePermissionInfo info = UserFacadeFactory.getRemoteInstance().getOrgMovePermissionInfo(this.orgMoveParam);
        this.fillTable(this.kdShiftTable, info.getShiftUserList());
        this.fillTable(this.kdStayTable, info.getStayUserList());
    }

    private void fillTable(KDTable table, List<UserInfo> userList) throws Exception {
        for (UserInfo userInfo : userList) {
            IRow row = table.addRow();
            row.getCell(IS_SELECTED).setValue((Object)Boolean.FALSE);
            ICell isDeletePermCel = row.getCell(IS_DELETE_CU_PERM);
            if (isDeletePermCel != null) {
                isDeletePermCel.setValue((Object)Boolean.FALSE);
            }
            row.getCell(USER_NAME).setValue((Object)userInfo.getName());
            row.getCell(USER_NUMBER).setValue((Object)userInfo.getNumber());
            row.getCell(USER_ID).setValue((Object)userInfo.getId().toString());
            row.getCell(DEF_ORG_UNIT).setValue((Object)userInfo.getDefOrgUnit().getName());
            row.getCell(CONTROL_UNIT).setValue((Object)userInfo.getCU().getName());
        }
    }

    @Override
    public void actionBtnConfirm_actionPerformed(ActionEvent e) throws Exception {
        List<String> shiftUserList = this.getSelectedUserIdList(this.kdShiftTable, IS_SELECTED);
        List<String> shiftAndDeleteCuPermUserList = this.getSelectedUserIdList(this.kdShiftTable, IS_DELETE_CU_PERM);
        List<String> stayUserList = this.getSelectedUserIdList(this.kdStayTable, IS_SELECTED);
        OrgMovePermissionParam param = new OrgMovePermissionParam();
        param.setShiftAndDeleteCuPermUserList(shiftAndDeleteCuPermUserList);
        param.setShiftUserList(shiftUserList);
        param.setStayUserList(stayUserList);
        param.setOrgMoveParam(this.orgMoveParam);
        UserFacadeFactory.getRemoteInstance().executeOrgMovePermissionTask(param);
        this.afterOrgMoveHandler.setFinished(true);
        this.disposeUIWindow();
    }

    private List<String> getSelectedUserIdList(KDTable table, String columnName) {
        int rowCount = table.getRowCount();
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = table.getRow(i);
            ICell isDeleteCell = row.getCell(columnName);
            boolean isDelete = Boolean.parseBoolean(isDeleteCell.getValue().toString());
            if (!isDelete) continue;
            ret.add(row.getCell(USER_ID).getValue().toString());
        }
        return ret;
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.afterOrgMoveHandler.setFinished(false);
        this.disposeUIWindow();
    }

    private void setAllSelect(KDTable table, boolean selected, String colName) {
        int rowCount = table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            ICell cell = table.getRow(i).getCell(colName);
            if (cell.getStyleAttributes().isLocked()) continue;
            cell.setValue((Object)selected);
        }
    }

    private void enableCol(KDTable kdTable, String colName) {
        IColumn col = kdTable.getColumn(colName);
        col.getStyleAttributes().setLocked(false);
        col.getStyleAttributes().setBackground(ORIGIN_COLOR);
    }

    private void disableCol(KDTable kdTable, String colName) {
        IColumn col = kdTable.getColumn(colName);
        col.getStyleAttributes().setLocked(true);
        int rowCount = kdTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            kdTable.getRow(i).getCell(colName).setValue((Object)false);
        }
    }

    @Override
    public void actionSelectAll1_actionPerformed(ActionEvent e) throws Exception {
        if (IS_DELETE_CU_PERM.equals(this.getSelectedColName())) {
            this.setAllSelect(this.kdShiftTable, true, IS_DELETE_CU_PERM);
        } else {
            this.setAllSelect(this.kdShiftTable, true, IS_SELECTED);
            this.enableCol(this.kdShiftTable, IS_DELETE_CU_PERM);
        }
    }

    private String getSelectedColName() {
        int selectedColIndex = this.kdShiftTable.getSelectManager().getActiveColumnIndex();
        IColumn col = this.kdShiftTable.getColumn(selectedColIndex);
        String colName = null;
        if (col != null) {
            colName = col.getKey();
        }
        return colName;
    }

    @Override
    public void actionClearAll1_actionPerformed(ActionEvent e) throws Exception {
        if (IS_DELETE_CU_PERM.equals(this.getSelectedColName())) {
            this.setAllSelect(this.kdShiftTable, false, IS_DELETE_CU_PERM);
        } else {
            this.setAllSelect(this.kdShiftTable, false, IS_SELECTED);
            this.disableCol(this.kdShiftTable, IS_DELETE_CU_PERM);
        }
    }

    @Override
    public void actionSelectAll2_actionPerformed(ActionEvent e) throws Exception {
        this.setAllSelect(this.kdStayTable, true, IS_SELECTED);
    }

    @Override
    public void actionClearAll2_actionPerformed(ActionEvent e) throws Exception {
        this.setAllSelect(this.kdStayTable, false, IS_SELECTED);
    }

    private String getSearchStr(KDTextField kdtSearch) {
        return kdtSearch.getText();
    }

    private void search(KDTable kdTable, KDTextField kdTextSearch) {
        String searchStr = this.getSearchStr(kdTextSearch);
        int count = kdTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = kdTable.getRow(i);
            String name = row.getCell(USER_NAME).getValue().toString();
            String number = row.getCell(USER_NUMBER).getValue().toString();
            row.getStyleAttributes().setBackground(ORIGIN_COLOR);
            if (!name.toUpperCase().contains(searchStr.toUpperCase()) && !number.toUpperCase().contains(searchStr.toUpperCase())) continue;
            row.getStyleAttributes().setBackground(SEARCHED_COLOR);
        }
    }

    @Override
    public void actionSearchShift_actionPerformed(ActionEvent e) throws Exception {
        this.search(this.kdShiftTable, this.kdtShiftSearch);
    }

    @Override
    public void actionSearchStay_actionPerformed(ActionEvent e) throws Exception {
        this.search(this.kdStayTable, this.kdtStaySearch);
    }
}

