/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.permission.AuthenSchemeFactory;
import com.kingdee.eas.base.permission.AuthenSchemeInfo;
import com.kingdee.eas.base.permission.AuthenSchemeOrgUserFactory;
import com.kingdee.eas.base.permission.AuthenSchemeRuleFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractAuthenSchemeBatchAsscreditUI;
import com.kingdee.eas.base.permission.client.f7.NewOrgAuthenF7PromptDialog;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class AuthenSchemeBatchAsscreditUI
extends AbstractAuthenSchemeBatchAsscreditUI {
    private static final Logger logger = CoreUIObject.getLogger(AuthenSchemeBatchAsscreditUI.class);
    protected static final String PERM_RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private Set userIdSet = new HashSet();
    private Set orgIdSet = new HashSet();
    private Map orgRuleMap = new HashMap();
    private String authenSchemeId = null;
    private SelectorItemCollection userSelector = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initParm();
        this.initComponent();
        this.initAuthenSchemeF7();
        this.orgTable.getSelectManager().setSelectMode(10);
    }

    private void initParm() {
        Object authenSchemeIdObj = this.getUIContext().get("authenSchemeId");
        if (authenSchemeIdObj == null) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"CERTI_SOLUTION_NOT_EMPTY_AUTHEN"), (String)ThrowableHelper.toString((Exception)((Object)new BOSException(EASResource.getString((String)PERM_RESOURCE, (String)"CERTI_SOLUTION_NOT_EMPTY_AUTHEN")))), (int)0);
            SysUtil.abort();
        }
        this.authenSchemeId = (String)authenSchemeIdObj;
        this.getUIContext().remove("authenShemeId");
    }

    private void initAuthenSchemeF7() throws Exception {
        try {
            AuthenSchemeInfo authenSchemeInfo = null;
            ObjectUuidPK authenSchemePK = new ObjectUuidPK(this.authenSchemeId);
            authenSchemeInfo = AuthenSchemeFactory.getRemoteInstance().getAuthenSchemeInfo((IObjectPK)authenSchemePK);
            this.authenSchemeBizPromptBox.setData((Object)authenSchemeInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        this.authenSchemeBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                AuthenSchemeInfo oldScheme = (AuthenSchemeInfo)event.getOldValue();
                AuthenSchemeInfo newScheme = (AuthenSchemeInfo)event.getNewValue();
                if (oldScheme.getId().equals((Object)newScheme.getId())) {
                    return;
                }
                AuthenSchemeBatchAsscreditUI.this.authenSchemeId = newScheme.getId().toString();
                AuthenSchemeBatchAsscreditUI.this.userTable.removeRows(false);
                AuthenSchemeBatchAsscreditUI.this.orgTable.removeRows(false);
                AuthenSchemeBatchAsscreditUI.this.userIdSet.clear();
                AuthenSchemeBatchAsscreditUI.this.orgIdSet.clear();
            }
        });
    }

    private void initComponent() {
        this.userTable.setEditable(false);
        this.btnAddOrg.setEnabled(true);
        this.btnRemoveOrg.setEnabled(true);
        this.btnAddUser.setEnabled(true);
        this.btnRemoveUser.setEnabled(true);
        this.btnAssign.setEnabled(true);
        this.btnCancelAssign.setEnabled(true);
        this.btnSetRule.setEnabled(true);
        this.initOrgTable();
    }

    private void initOrgTable() {
        this.orgTable.checkParsed();
        IColumn isRuleColumn = this.orgTable.getColumn("isRule");
        KDCheckBox isRuleCheckBox = new KDCheckBox();
        KDTDefaultCellEditor isRuleEditor = new KDTDefaultCellEditor((JCheckBox)isRuleCheckBox);
        isRuleColumn.setEditor((ICellEditor)isRuleEditor);
        this.orgTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent event) {
                super.editValueChanged(event);
                if (!KDTable.class.isInstance(event.getSource())) {
                    return;
                }
                KDTable theOrgTable = (KDTable)event.getSource();
                IRow changeRow = theOrgTable.getRow(event.getRowIndex());
                String orgId = (String)changeRow.getCell("orgId").getValue();
                boolean isRule = (Boolean)event.getValue();
                AuthenSchemeBatchAsscreditUI.this.orgRuleMap.put(orgId, isRule);
            }
        });
        this.orgTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
            }
        });
    }

    @Override
    public void actionAddUser_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddUser_actionPerformed(e);
        if (this.orgIdSet == null) {
            MsgBox.showInfo((String)EASResource.getString((String)PERM_RESOURCE, (String)"FIRST_SELECT_ORG"));
            return;
        }
        KDCommonPromptDialog userF7 = new KDCommonPromptDialog();
        userF7.setEnabledMultiSelection(true);
        userF7.setSelectorCollection(this.getUserSelector());
        userF7.setEntityViewInfo(this.getUserFilter());
        userF7.setQueryInfo(MetaDataPK.create((String)"com.kingdee.eas.base.permission.app.UserListQuery2"));
        userF7.show();
        if (userF7.isCanceled()) {
            return;
        }
        Object[] selectedUsers = (Object[])userF7.getData();
        if (selectedUsers == null || selectedUsers.length == 0) {
            return;
        }
        this.fillUserTable(selectedUsers);
    }

    @Override
    public void actionAddOrg_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddOrg_actionPerformed(e);
        NewOrgAuthenF7PromptDialog newOrgF7 = new NewOrgAuthenF7PromptDialog();
        newOrgF7.setMultiSelect(true);
        newOrgF7.setNeedAddOrgRange(false);
        ArrayList<OrgViewType> orgViewTypeList = new ArrayList<OrgViewType>();
        Collection col = OrgTypeInfoMgr.getInstance().getAllOrgTypeInfo();
        for (OrgTypeInfo orgTypeInfo : col) {
            if (orgTypeInfo.getOrgViewType() == null || OrgViewType.UNIONDEBT == orgTypeInfo.getOrgViewType() || OrgViewType.CTRLUNIT == orgTypeInfo.getOrgViewType()) continue;
            orgViewTypeList.add(orgTypeInfo.getOrgViewType());
        }
        orgViewTypeList.add(0, OrgViewType.CTRLUNIT);
        OrgViewType[] orgViewTypeArray = new OrgViewType[orgViewTypeList.size()];
        orgViewTypeList.toArray(orgViewTypeArray);
        if (this.orgIdSet == null) {
            this.orgIdSet = new HashSet();
        }
        if (!this.orgIdSet.isEmpty()) {
            newOrgF7.setSelectedOrgIds(this.orgIdSet);
        }
        newOrgF7.show();
        if (newOrgF7.isCanceled()) {
            return;
        }
        Object[] selectedOrgs = (Object[])newOrgF7.getData();
        this.orgIdSet.clear();
        this.orgRuleMap.clear();
        this.orgTable.removeRows(false);
        if (selectedOrgs == null || selectedOrgs.length == 0) {
            return;
        }
        OrgUnitInfo orgInfo = null;
        for (Object org : selectedOrgs) {
            orgInfo = (OrgUnitInfo)org;
            this.orgIdSet.add(orgInfo.getId().toString());
        }
        Map lessOrgRuleMap = AuthenSchemeRuleFactory.getRemoteInstance().getRule(this.authenSchemeId, this.orgIdSet);
        orgInfo = null;
        IRow row = null;
        boolean isRule = false;
        Boolean isRuleObj = null;
        for (Object org : selectedOrgs) {
            orgInfo = (OrgUnitInfo)org;
            isRuleObj = (Boolean)lessOrgRuleMap.get(orgInfo.getId().toString());
            isRule = isRuleObj == null ? false : isRuleObj;
            this.orgRuleMap.put(orgInfo.getId().toString(), isRule);
            row = this.orgTable.addRow();
            row.getCell("orgId").setValue((Object)orgInfo.getId().toString());
            row.getCell("isRule").setValue((Object)isRule);
            row.getCell("orgNumber").setValue((Object)orgInfo.getNumber());
            row.getCell("orgName").setValue((Object)orgInfo.getName());
            row.getCell("isCompany").setValue((Object)orgInfo.isIsCompanyOrgUnit());
            row.getCell("isAdmin").setValue((Object)orgInfo.isIsAdminOrgUnit());
            row.getCell("isPurchase").setValue((Object)orgInfo.isIsPurchaseOrgUnit());
            row.getCell("isSale").setValue((Object)orgInfo.isIsSaleOrgUnit());
            row.getCell("isStorage").setValue((Object)orgInfo.isIsStorageOrgUnit());
            row.getCell("isHr").setValue((Object)orgInfo.isIsHROrgUnit());
            row.getCell("isProfit").setValue((Object)orgInfo.isIsProfitOrgUnit());
            row.getCell("isCost").setValue((Object)orgInfo.isIsCostOrgUnit());
            row.getCell("isUnion").setValue((Object)orgInfo.isIsUnion());
            row.getCell("isCtrl").setValue((Object)orgInfo.isIsCU());
            row.getCell("isTransport").setValue((Object)orgInfo.isIsTransportOrgUnit());
            row.getCell("isQuality").setValue((Object)orgInfo.isIsQualityOrgUnit());
        }
    }

    @Override
    public void actionRemoveOrg_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveOrg_actionPerformed(e);
        KDTSelectManager orgTableSManager = this.orgTable.getSelectManager();
        if (orgTableSManager.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)PERM_RESOURCE, (String)"PLEASE_SELECT_RECORD"));
            return;
        }
        KDTRange selectedRange = orgTableSManager.toRange();
        Iterator selectedIter = selectedRange.iterator();
        KDTSelectBlock oneBlock = null;
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
        int top = -1;
        int bottom = -1;
        while (selectedIter.hasNext()) {
            oneBlock = (KDTSelectBlock)selectedIter.next();
            top = oneBlock.getTop();
            bottom = oneBlock.getBottom();
            int i = 0;
            while (i + top <= bottom) {
                rowIndexList.add(new Integer(i + top));
                this.orgIdSet.remove(this.orgTable.getRow(i + top).getCell("orgId").getValue());
                ++i;
            }
        }
        Collections.sort(rowIndexList, (Comparator)new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if ((Integer)arg0 > (Integer)arg1) {
                    return -1;
                }
                if ((Integer)arg0 < (Integer)arg1) {
                    return 1;
                }
                return 0;
            }
        });
        int rowIndex = -1;
        for (Object e2 : rowIndexList) {
            rowIndex = (Integer)e2;
            this.orgTable.removeRow(rowIndex);
        }
        orgTableSManager.removeAll();
    }

    @Override
    public void actionRemoveUser_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveUser_actionPerformed(e);
        KDTSelectManager userTableSManager = this.userTable.getSelectManager();
        if (userTableSManager.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)PERM_RESOURCE, (String)"PLEASE_SELECT_RECORD"));
            return;
        }
        KDTRange selectedRange = userTableSManager.toRange();
        Iterator selectedIter = selectedRange.iterator();
        KDTSelectBlock oneBlock = null;
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
        int top = -1;
        int bottom = -1;
        while (selectedIter.hasNext()) {
            oneBlock = (KDTSelectBlock)selectedIter.next();
            top = oneBlock.getTop();
            bottom = oneBlock.getBottom();
            int i = 0;
            while (i + top <= bottom) {
                rowIndexList.add(new Integer(i + top));
                this.userIdSet.remove(this.userTable.getRow(i + top).getCell("id").getValue());
                ++i;
            }
        }
        Collections.sort(rowIndexList, (Comparator)new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if ((Integer)arg0 > (Integer)arg1) {
                    return -1;
                }
                if ((Integer)arg0 < (Integer)arg1) {
                    return 1;
                }
                return 0;
            }
        });
        int rowIndex = -1;
        for (Object e2 : rowIndexList) {
            rowIndex = (Integer)e2;
            this.userTable.removeRow(rowIndex);
        }
        userTableSManager.removeAll();
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssign_actionPerformed(e);
        if (this.userIdSet.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)PERM_RESOURCE, (String)"SELECT_USER_AT_LEAST"));
            return;
        }
        if (this.orgIdSet.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)PERM_RESOURCE, (String)"SELECT_ORG_AT_LEAST"));
            return;
        }
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"EXECUTE_UPDATEING"), (String)EASResource.getString((String)PERM_RESOURCE, (String)"WAITING"));
        dialog.setLongTimeTask(new ILongTimeTask2(){

            public Object exec() throws Exception {
                try {
                    AuthenSchemeOrgUserFactory.getRemoteInstance().assignAuthenScheme(AuthenSchemeBatchAsscreditUI.this.authenSchemeId, AuthenSchemeBatchAsscreditUI.this.orgIdSet, AuthenSchemeBatchAsscreditUI.this.userIdSet, true);
                    List resultList = AuthenSchemeRuleFactory.getRemoteInstance().checkAndSetRule(AuthenSchemeBatchAsscreditUI.this.authenSchemeId, AuthenSchemeBatchAsscreditUI.this.orgRuleMap);
                    return resultList;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return e;
                }
            }

            public void afterExec(Object result) throws Exception {
                if (Throwable.class.isInstance(result)) {
                    MsgBox.showDetailAndOK((Component)((Object)AuthenSchemeBatchAsscreditUI.this), (String)"\u6267\u884c\u5931\u8d25", (String)ThrowableHelper.toString((Throwable)((Throwable)result)), (int)0);
                } else if (!List.class.isInstance(result)) {
                    return;
                }
                List resultList = (List)result;
                if ("success".equals(resultList.get(0))) {
                    MsgBox.showInfo((String)"\u8bbe\u7f6e\u6210\u529f!");
                } else if ("fail".equals(resultList.get(0))) {
                    StringBuffer message = new StringBuffer();
                    message.append("\u60a8\u8bbe\u7f6e\u7684\u89c4\u5219\u548c\u4e0b\u9762\u663e\u793a\u7684\uff0c\u4e3a\u8be5\u7ec4\u7ec7\u5206\u914d\u7684\u8ba4\u8bc1\u65b9\u6848\u8bbe\u7f6e\u7684\u89c4\u5219\u51b2\u7a81\u4e86\u3002\n").append("\u60a8\u7684\u8bbe\u7f6e\u5c06\u4e0d\u4f1a\u751f\u6548\n").append("\u8ba4\u8bc1\u89c4\u5219\uff1a").append(resultList.get(1)).append("\u7ec4\u7ec7\uff1a").append(resultList.get(2));
                    MsgBox.showInfo((String)message.toString());
                }
            }
        });
        dialog.show();
    }

    @Override
    public void actionSetRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionSetRule_actionPerformed(e);
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), (String)"\u5904\u7406\u66f4\u65b0\u4e2d", (String)"\u8bf7\u7a0d\u540e");
        dialog.setLongTimeTask(new ILongTimeTask2(){

            public Object exec() throws Exception {
                try {
                    List resultList = AuthenSchemeRuleFactory.getRemoteInstance().checkAndSetRule(AuthenSchemeBatchAsscreditUI.this.authenSchemeId, AuthenSchemeBatchAsscreditUI.this.orgRuleMap);
                    return resultList;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return e;
                }
            }

            public void afterExec(Object result) throws Exception {
                if (Throwable.class.isInstance(result)) {
                    MsgBox.showDetailAndOK((Component)((Object)AuthenSchemeBatchAsscreditUI.this), (String)"\u6267\u884c\u5931\u8d25", (String)ThrowableHelper.toString((Throwable)((Throwable)result)), (int)0);
                } else if (!List.class.isInstance(result)) {
                    return;
                }
                List resultList = (List)result;
                if ("success".equals(resultList.get(0))) {
                    MsgBox.showInfo((String)"\u8bbe\u7f6e\u6210\u529f!");
                } else if ("fail".equals(resultList.get(0))) {
                    StringBuffer message = new StringBuffer();
                    message.append("\u60a8\u8bbe\u7f6e\u7684\u89c4\u5219\u548c\u4e0b\u9762\u663e\u793a\u7684\uff0c\u4e3a\u8be5\u7ec4\u7ec7\u5206\u914d\u7684\u8ba4\u8bc1\u65b9\u6848\u8bbe\u7f6e\u7684\u89c4\u5219\u51b2\u7a81\u4e86\u3002\n").append("\u60a8\u7684\u8bbe\u7f6e\u5c06\u4e0d\u4f1a\u751f\u6548\n").append("\u8ba4\u8bc1\u89c4\u5219\uff1a").append(resultList.get(1)).append("\u7ec4\u7ec7\uff1a").append(resultList.get(2));
                    MsgBox.showInfo((String)message.toString());
                }
            }
        });
        dialog.show();
    }

    @Override
    public void actionCancelAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelAssign_actionPerformed(e);
        if (this.userIdSet.size() == 0) {
            MsgBox.showInfo((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u7528\u6237!");
            return;
        }
        if (this.orgIdSet.size() == 0) {
            MsgBox.showInfo((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7!");
            return;
        }
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), (String)"\u5904\u7406\u66f4\u65b0\u4e2d", (String)"\u8bf7\u7a0d\u540e");
        dialog.setLongTimeTask(new ILongTimeTask2(){

            public Object exec() throws Exception {
                try {
                    AuthenSchemeOrgUserFactory.getRemoteInstance().cancelAssignAuthenScheme(AuthenSchemeBatchAsscreditUI.this.authenSchemeId, AuthenSchemeBatchAsscreditUI.this.orgIdSet, AuthenSchemeBatchAsscreditUI.this.userIdSet);
                    return "success";
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return e;
                }
            }

            public void afterExec(Object result) throws Exception {
                if (Throwable.class.isInstance(result)) {
                    MsgBox.showDetailAndOK((Component)((Object)AuthenSchemeBatchAsscreditUI.this), (String)"\u6267\u884c\u5931\u8d25", (String)ThrowableHelper.toString((Throwable)((Throwable)result)), (int)0);
                } else if ("success".equals(result)) {
                    MsgBox.showInfo((String)"\u6267\u884c\u5b8c\u6bd5");
                }
            }
        });
        dialog.show();
    }

    private EntityViewInfo getUserFilter() {
        StringBuffer orgRangeSql = new StringBuffer();
        orgRangeSql.append("select orgrange.fuserid ").append("from t_pm_orgrange orgrange ").append("where orgrange.forgid in (").append(ToolUtils.aryToStr(this.orgIdSet)).append(") ").append("and orgrange.ftype = ").append(10);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        view.setFilter(filterInfo);
        if (!this.userIdSet.isEmpty()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.userIdSet, CompareType.NOTINCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orgRangeSql.toString(), CompareType.INNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)20, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)60, CompareType.EQUALS));
        if (!this.userIdSet.isEmpty()) {
            filterInfo.setMaskString("( #0 and ( ( #1 and #2 ) or #3 ) )");
        } else {
            filterInfo.setMaskString("( ( #0 and #1 ) or #2 )");
        }
        return view;
    }

    private SelectorItemCollection getUserSelector() {
        if (this.userSelector != null) {
            return this.userSelector;
        }
        this.userSelector = new SelectorItemCollection();
        this.userSelector.add(new SelectorItemInfo("id"));
        this.userSelector.add(new SelectorItemInfo("number"));
        this.userSelector.add(new SelectorItemInfo("type"));
        this.userSelector.add(new SelectorItemInfo("name"));
        this.userSelector.add(new SelectorItemInfo("cu.name"));
        this.userSelector.add(new SelectorItemInfo("effectiveDate"));
        this.userSelector.add(new SelectorItemInfo("invalidationDate"));
        return this.userSelector;
    }

    private void fillUserTable(Object[] users) {
        UserInfo userInfo = null;
        IRow newRow = null;
        for (Object userObj : users) {
            userInfo = (UserInfo)userObj;
            this.userIdSet.add(userInfo.getId().toString());
            newRow = this.userTable.addRow();
            newRow.getCell("id").setValue((Object)userInfo.getId().toString());
            newRow.getCell("number").setValue((Object)userInfo.getNumber());
            newRow.getCell("type").setValue((Object)userInfo.getType().getAlias());
            newRow.getCell("name").setValue((Object)userInfo.getName());
            newRow.getCell("cuName").setValue((Object)userInfo.getCU().getName());
            newRow.getCell("effectiveDate").setValue((Object)userInfo.getEffectiveDate().toString());
            newRow.getCell("invalidationDate").setValue((Object)userInfo.getInvalidationDate().toString());
        }
    }
}

