/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.AuthenSchemeFactory;
import com.kingdee.eas.base.permission.AuthenSchemeInfo;
import com.kingdee.eas.base.permission.AuthenSchemeRoleCollection;
import com.kingdee.eas.base.permission.AuthenSchemeRoleFactory;
import com.kingdee.eas.base.permission.AuthenSchemeRoleInfo;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractAuthenSchemeChangeRoleUI;
import com.kingdee.eas.base.permission.util.ThrowableHelper;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AuthenSchemeChangeRoleUI
extends AbstractAuthenSchemeChangeRoleUI {
    private static final Logger logger = CoreUIObject.getLogger(AuthenSchemeChangeRoleUI.class);
    protected static final String PERM_RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private boolean isNeedFilterRoleByOrg = true;
    private String authenSchemeId = null;
    private Set originalTargetRoleSet = new HashSet();
    private Set nowTargetRoleSet = new HashSet();
    private Map<String, Integer> originalSourceRole2RowIndexMap = new HashMap<String, Integer>();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initParm();
        this.initComponent();
        this.refreshTargetTable();
        this.refreshSourceTable();
    }

    private void initParm() {
        Object authenSchemeIdObj = this.getUIContext().get("authenSchemeId");
        if (authenSchemeIdObj == null) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"CERTI_SOLUTION_NOT_EMPTY_AUTHEN"), (String)ThrowableHelper.toString(new BOSException(EASResource.getString((String)PERM_RESOURCE, (String)"CERTI_SOLUTION_NOT_EMPTY_AUTHEN"))), (int)0);
            SysUtil.abort();
        }
        this.authenSchemeId = (String)authenSchemeIdObj;
        this.getUIContext().remove("authenShemeId");
    }

    private void initComponent() throws Exception {
        this.sourceRoleTable.checkParsed();
        this.targetRoleTable.checkParsed();
        this.sourceRoleTable.setEditable(false);
        this.targetRoleTable.setEditable(false);
        this.sourceRoleContainer.setTitle(EASResource.getString((String)PERM_RESOURCE, (String)"CNA_ASSIGN_ROLE"));
        this.targetRoleContainer.setTitle(EASResource.getString((String)PERM_RESOURCE, (String)"IS_ASSIGN_ROLE"));
        this.btnSave.setEnabled(true);
        this.btnAdd.setEnabled(true);
        this.btnAddAll.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.btnDeleteAll.setEnabled(true);
        this.ckNeedFilterRoleByOrg.setEnabled(true);
        this.ckNeedFilterRoleByOrg.setSelected(true);
        this.ckNeedFilterRoleByOrg.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent paramChangeEvent) {
                AuthenSchemeChangeRoleUI.this.isNeedFilterRoleByOrg = AuthenSchemeChangeRoleUI.this.ckNeedFilterRoleByOrg.isSelected();
                AuthenSchemeChangeRoleUI.this.orgBizPromptBox.setEnabled(AuthenSchemeChangeRoleUI.this.isNeedFilterRoleByOrg);
                AuthenSchemeChangeRoleUI.this.refreshSourceTable();
            }
        });
        this.initAuthenSchemeF7();
        this.initOrgF7();
    }

    private void initAuthenSchemeF7() throws Exception {
        try {
            AuthenSchemeInfo authenSchemeInfo = null;
            ObjectUuidPK authenSchemePK = new ObjectUuidPK(this.authenSchemeId);
            authenSchemeInfo = AuthenSchemeFactory.getRemoteInstance().getAuthenSchemeInfo((IObjectPK)authenSchemePK);
            this.authenSchemeBizPromptBox.setData((Object)authenSchemeInfo);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        this.authenSchemeBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                AuthenSchemeInfo oldScheme = (AuthenSchemeInfo)event.getOldValue();
                AuthenSchemeInfo newScheme = (AuthenSchemeInfo)event.getNewValue();
                if (oldScheme.getId().equals((Object)newScheme.getId())) {
                    return;
                }
                AuthenSchemeChangeRoleUI.this.authenSchemeId = newScheme.getId().toString();
                AuthenSchemeChangeRoleUI.this.refreshSourceTable();
                AuthenSchemeChangeRoleUI.this.refreshTargetTable();
            }
        });
    }

    private void refreshTargetTable() {
        try {
            this.originalTargetRoleSet.clear();
            this.nowTargetRoleSet.clear();
            this.targetRoleTable.removeRows(false);
            EntityViewInfo filter = this.getTargetRoleFilter();
            AuthenSchemeRoleCollection authenSchemeRoleCollection = AuthenSchemeRoleFactory.getRemoteInstance().getAuthenSchemeRoleCollection(filter);
            Iterator authenSchemeRoleIter = authenSchemeRoleCollection.iterator();
            AuthenSchemeRoleInfo authenSchemeRoleInfo = null;
            RoleInfo roleInfo = null;
            BOSUuid roleIdUuid = null;
            String roleId = null;
            String roleNumber = null;
            String roleName = null;
            String description = null;
            CtrlUnitInfo cuInfo = null;
            String cuName = null;
            String cuNumber = null;
            while (authenSchemeRoleIter.hasNext()) {
                authenSchemeRoleInfo = (AuthenSchemeRoleInfo)authenSchemeRoleIter.next();
                roleInfo = authenSchemeRoleInfo.getRole();
                roleIdUuid = roleInfo == null ? null : roleInfo.getId();
                roleId = roleIdUuid == null ? "" : roleIdUuid.toString();
                roleNumber = roleInfo == null ? "" : roleInfo.getNumber();
                roleName = roleInfo == null ? "" : roleInfo.getName();
                description = roleInfo == null ? "" : roleInfo.getDescription();
                cuInfo = roleInfo == null ? null : roleInfo.getCU();
                cuName = cuInfo == null ? "" : cuInfo.getName();
                cuNumber = cuInfo == null ? "" : cuInfo.getNumber();
                this.addTargetRow(new String[]{roleId, roleNumber, roleName, cuName, cuNumber, description}, true);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)PERM_RESOURCE, (String)"REFRESH_ASSIGNED_ROLE_LIST_FAIL"), (String)ThrowableHelper.toString(e), (int)0);
            SysUtil.abort();
        }
    }

    private void addTargetRow(String[] cellValue, boolean isInit) {
        IRow newRow = this.targetRoleTable.addRow();
        if (cellValue[0] != null) {
            if (isInit) {
                this.originalTargetRoleSet.add(cellValue[0]);
            }
            this.nowTargetRoleSet.add(cellValue[0]);
        }
        newRow.getCell("id").setValue((Object)cellValue[0]);
        newRow.getCell("number").setValue((Object)cellValue[1]);
        newRow.getCell("name").setValue((Object)cellValue[2]);
        newRow.getCell("CU.name").setValue((Object)cellValue[3]);
        newRow.getCell("CU.number").setValue((Object)cellValue[4]);
        newRow.getCell("description").setValue((Object)cellValue[5]);
    }

    private EntityViewInfo getTargetRoleFilter() {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("role.id"));
        selectorItemCollection.add(new SelectorItemInfo("role.number"));
        selectorItemCollection.add(new SelectorItemInfo("role.name"));
        selectorItemCollection.add(new SelectorItemInfo("role.CU.name"));
        selectorItemCollection.add(new SelectorItemInfo("role.CU.number"));
        selectorItemCollection.add(new SelectorItemInfo("role.description"));
        view.setSelector(selectorItemCollection);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItemCollection = filterInfo.getFilterItems();
        filterItemCollection.add(new FilterItemInfo("authenScheme.id", (Object)this.authenSchemeId, CompareType.EQUALS));
        view.setFilter(filterInfo);
        return view;
    }

    private void initOrgF7() throws Exception {
        NewOrgF7 newOrgF7 = new NewOrgF7();
        newOrgF7.setMultiSelect(false);
        newOrgF7.setNeedAddOrgRange(false);
        newOrgF7.setOrgViewTypes(new OrgViewType[]{OrgViewType.CTRLUNIT});
        this.orgBizPromptBox.setSelector((KDPromptSelector)newOrgF7);
        FullOrgUnitInfo defaultOrgInfo = null;
        try {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            if (userInfo != null) {
                defaultOrgInfo = userInfo.getDefOrgUnit();
            }
            if (defaultOrgInfo == null) {
                String rootCUPK = "00000000-0000-0000-0000-000000000000CCE7AED4";
                BOSUuid rootCUUuid = BOSUuid.read((String)rootCUPK);
                ObjectUuidPK parentPK = new ObjectUuidPK(rootCUUuid);
                defaultOrgInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)parentPK);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        this.orgBizPromptBox.setData((Object)defaultOrgInfo);
        this.orgBizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                CoreBaseInfo oldOrg = (CoreBaseInfo)eventObj.getOldValue();
                CoreBaseInfo newOrg = (CoreBaseInfo)eventObj.getNewValue();
                if (newOrg.equals((Object)oldOrg)) {
                    return;
                }
                AuthenSchemeChangeRoleUI.this.refreshSourceTable();
            }
        });
    }

    private void refreshSourceTable() {
        try {
            this.originalSourceRole2RowIndexMap.clear();
            this.sourceRoleTable.removeRows(false);
            EntityViewInfo filter = this.getSourceRoleFilter();
            RoleCollection roleCollection = RoleFactory.getRemoteInstance().getRoleCollection(filter);
            Iterator roleIter = roleCollection.iterator();
            RoleInfo roleInfo = null;
            BOSUuid roleIdUuid = null;
            String roleId = null;
            String roleNumber = null;
            String roleName = null;
            String description = null;
            CtrlUnitInfo cuInfo = null;
            String cuName = null;
            String cuNumber = null;
            while (roleIter.hasNext()) {
                roleInfo = (RoleInfo)roleIter.next();
                roleIdUuid = roleInfo == null ? null : roleInfo.getId();
                roleId = roleIdUuid == null ? "" : roleIdUuid.toString();
                roleNumber = roleInfo == null ? "" : roleInfo.getNumber();
                roleName = roleInfo == null ? "" : roleInfo.getName();
                description = roleInfo == null ? "" : roleInfo.getDescription();
                cuInfo = roleInfo == null ? null : roleInfo.getCU();
                cuName = cuInfo == null ? "" : cuInfo.getName();
                cuNumber = cuInfo == null ? "" : cuInfo.getNumber();
                this.addSourceRow(new String[]{roleId, roleNumber, roleName, cuName, cuNumber, description});
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)PERM_RESOURCE, (String)"REFRESH_ALL_ROLE_LIST_FAIL"), (String)ThrowableHelper.toString(e), (int)0);
            SysUtil.abort();
        }
    }

    private void addSourceRow(String[] cellValue) {
        IRow newRow = this.sourceRoleTable.addRow();
        this.originalSourceRole2RowIndexMap.put(cellValue[0], newRow.getRowIndex());
        if (this.nowTargetRoleSet.contains(cellValue[0])) {
            newRow.getStyleAttributes().setBackground(Color.YELLOW);
        }
        newRow.getCell("id").setValue((Object)cellValue[0]);
        newRow.getCell("number").setValue((Object)cellValue[1]);
        newRow.getCell("name").setValue((Object)cellValue[2]);
        newRow.getCell("CU.name").setValue((Object)cellValue[3]);
        newRow.getCell("CU.number").setValue((Object)cellValue[4]);
        newRow.getCell("description").setValue((Object)cellValue[5]);
    }

    private EntityViewInfo getSourceRoleFilter() {
        CoreBaseInfo orgInfo = null;
        if (this.isNeedFilterRoleByOrg) {
            orgInfo = (CoreBaseInfo)this.orgBizPromptBox.getData();
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add(new SelectorItemInfo("number"));
        selectorItemCollection.add(new SelectorItemInfo("name"));
        selectorItemCollection.add(new SelectorItemInfo("CU.name"));
        selectorItemCollection.add(new SelectorItemInfo("CU.number"));
        selectorItemCollection.add(new SelectorItemInfo("description"));
        view.setSelector(selectorItemCollection);
        if (orgInfo == null) {
            return view;
        }
        String orgId = orgInfo.getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItemCollection = filterInfo.getFilterItems();
        filterItemCollection.add(new FilterItemInfo("CU.id", (Object)orgId, CompareType.EQUALS));
        view.setFilter(filterInfo);
        return view;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), (String)EASResource.getString((String)PERM_RESOURCE, (String)"EXECUTE_UPDATEING"), (String)EASResource.getString((String)PERM_RESOURCE, (String)"WAITING"));
        dialog.setLongTimeTask(new ILongTimeTask2(){

            public Object exec() throws Exception {
                try {
                    HashSet addRoleSet = new HashSet();
                    addRoleSet.addAll(AuthenSchemeChangeRoleUI.this.nowTargetRoleSet);
                    addRoleSet.removeAll(AuthenSchemeChangeRoleUI.this.originalTargetRoleSet);
                    HashSet deleteRoleSet = new HashSet();
                    deleteRoleSet.addAll(AuthenSchemeChangeRoleUI.this.originalTargetRoleSet);
                    deleteRoleSet.removeAll(AuthenSchemeChangeRoleUI.this.nowTargetRoleSet);
                    AuthenSchemeRoleFactory.getRemoteInstance().saveChange(AuthenSchemeChangeRoleUI.this.authenSchemeId, addRoleSet, deleteRoleSet);
                    return "success";
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    return e;
                }
            }

            public void afterExec(Object result) throws Exception {
                if (Throwable.class.isInstance(result)) {
                    MsgBox.showDetailAndOK((Component)((Object)AuthenSchemeChangeRoleUI.this), (String)EASResource.getString((String)AuthenSchemeChangeRoleUI.PERM_RESOURCE, (String)"EXECUTE_FAIL"), (String)ThrowableHelper.toString((Throwable)result), (int)0);
                } else if ("success".equals(result)) {
                    AuthenSchemeChangeRoleUI.this.refreshTargetTable();
                    AuthenSchemeChangeRoleUI.this.refreshSourceTable();
                    MsgBox.showInfo((String)EASResource.getString((String)AuthenSchemeChangeRoleUI.PERM_RESOURCE, (String)"EXECUTE_COMPLATE"));
                }
            }
        });
        dialog.show();
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        IRow row = null;
        Object newRow = null;
        String roleId = null;
        String roleNumber = null;
        String roleName = null;
        String cuName = null;
        String cuNumber = null;
        String description = null;
        for (int index = 0; index < this.sourceRoleTable.getRowCount(); ++index) {
            row = this.sourceRoleTable.getRow(index);
            roleId = (String)row.getCell("id").getValue();
            roleNumber = (String)row.getCell("number").getValue();
            roleName = (String)row.getCell("name").getValue();
            cuName = (String)row.getCell("CU.name").getValue();
            cuNumber = (String)row.getCell("CU.number").getValue();
            description = (String)row.getCell("description").getValue();
            if (this.nowTargetRoleSet.contains(roleId)) continue;
            row.getStyleAttributes().setBackground(Color.YELLOW);
            this.addTargetRow(new String[]{roleId, roleNumber, roleName, cuName, cuNumber, description}, false);
        }
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        KDTSelectManager sourceRoleTableSManager = this.sourceRoleTable.getSelectManager();
        if (sourceRoleTableSManager.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)PERM_RESOURCE, (String)"PLEASE_SELECT_RECORD"));
            return;
        }
        KDTRange selectedRange = sourceRoleTableSManager.toRange();
        Iterator selectedIter = selectedRange.iterator();
        KDTSelectBlock oneBlock = null;
        IRow nextRow = null;
        int top = -1;
        int bottom = -1;
        String roleId = null;
        String roleNumber = null;
        String roleName = null;
        String cuName = null;
        String cuNumber = null;
        String description = null;
        while (selectedIter.hasNext()) {
            oneBlock = (KDTSelectBlock)selectedIter.next();
            top = oneBlock.getTop();
            bottom = oneBlock.getBottom();
            int i = 0;
            while (i + top <= bottom) {
                nextRow = this.sourceRoleTable.getRow(i + top);
                nextRow.getStyleAttributes().setBackground(Color.YELLOW);
                roleId = (String)nextRow.getCell("id").getValue();
                roleNumber = (String)nextRow.getCell("number").getValue();
                roleName = (String)nextRow.getCell("name").getValue();
                cuName = (String)nextRow.getCell("CU.name").getValue();
                cuNumber = (String)nextRow.getCell("CU.number").getValue();
                description = (String)nextRow.getCell("description").getValue();
                if (!this.nowTargetRoleSet.contains(roleId)) {
                    this.addTargetRow(new String[]{roleId, roleNumber, roleName, cuName, cuNumber, description}, false);
                }
                ++i;
            }
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        KDTSelectManager targetRoleTableSManager = this.targetRoleTable.getSelectManager();
        if (targetRoleTableSManager.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)PERM_RESOURCE, (String)"PLEASE_SELECT_RECORD"));
            return;
        }
        KDTRange selectedRange = targetRoleTableSManager.toRange();
        Iterator selectedIter = selectedRange.iterator();
        KDTSelectBlock oneBlock = null;
        IRow nextRow = null;
        int top = -1;
        int bottom = -1;
        String roleId = null;
        ArrayList<Integer> deleteRowIndexList = new ArrayList<Integer>();
        while (selectedIter.hasNext()) {
            oneBlock = (KDTSelectBlock)selectedIter.next();
            top = oneBlock.getTop();
            bottom = oneBlock.getBottom();
            int i = 0;
            while (i + top <= bottom) {
                nextRow = this.targetRoleTable.getRow(i + top);
                roleId = (String)nextRow.getCell("id").getValue();
                int index = this.originalSourceRole2RowIndexMap.get(roleId);
                this.sourceRoleTable.getRow(index).getStyleAttributes().setBackground(Color.WHITE);
                this.nowTargetRoleSet.remove(roleId);
                deleteRowIndexList.add(i + top);
                ++i;
            }
        }
        Collections.sort(deleteRowIndexList, new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                int result = arg0.compareTo(arg1);
                switch (result) {
                    case 0: {
                        return result;
                    }
                    case 1: {
                        return -1;
                    }
                    case -1: {
                        return 1;
                    }
                }
                return result;
            }
        });
        for (Integer deleteRowIndex : deleteRowIndexList) {
            this.targetRoleTable.removeRow(deleteRowIndex.intValue());
        }
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteAll_actionPerformed(e);
        this.targetRoleTable.removeRows(false);
        this.nowTargetRoleSet.clear();
        this.refreshSourceTable();
    }
}

