/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.client.AbstractCloudUserExportUI;
import com.kingdee.eas.base.permission.client.helper.CloudUserExportHelper;
import com.kingdee.eas.base.permission.client.util.ILongTimeTask2;
import com.kingdee.eas.base.permission.client.util.LongTimeDialog2;
import com.kingdee.eas.base.permission.client.util.UITools2;
import com.kingdee.eas.base.permission.util.cloud.ExportAllUserHelper;
import com.kingdee.eas.base.permission.util.cloud.SynUserToCloudHelper;
import com.kingdee.eas.base.permission.util.cloud.bean.CloudUserInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class CloudUserExportUI
extends AbstractCloudUserExportUI {
    private static final Logger logger = CoreUIObject.getLogger(CloudUserExportUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final String FILE_NAME = "eas_import";
    private static final String FILE_NAME_ALL = "eas_all_import";
    private static final String SUFFIX = ".csv";
    private String isExportAll;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setIsExportAll();
        String filePath = this.assembleFilePath();
        this.txtPath.setText(filePath);
        this._setUITitle();
    }

    public String assembleFilePath() {
        String filePath = "";
        filePath = this.isExportAll() ? this.getDefaultFilePath() + File.separator + FILE_NAME_ALL + SUFFIX : this.getDefaultFilePath() + File.separator + FILE_NAME + SUFFIX;
        return filePath;
    }

    private void setIsExportAll() {
        this.isExportAll = (String)this.getUIContext().get("isExportAll");
    }

    private boolean isExportAll() {
        return !StringUtils.isEmpty((String)this.isExportAll) && "true".equals(this.isExportAll);
    }

    private void _setUITitle() {
        if (this.isExportAll()) {
            this.setUITitle(EASResource.getString((String)RESOURCE, (String)"exportAll"));
        }
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        final String exportPath = this.txtPath.getText();
        if (StringUtils.isEmpty((String)exportPath)) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"exportCloudUserPath"));
            return;
        }
        final LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), EASResource.getString((String)RESOURCE, (String)"OfflineExpUser"), EASResource.getString((String)RESOURCE, (String)"exporting_user"));
        dialog.setLongTimeTask(new ILongTimeTask2(){
            private Exception exception;
            String excMsg = "false";

            @Override
            public Object exec() throws Exception {
                try {
                    List<CloudUserInfo> data;
                    dialog.updateMsg("1." + EASResource.getString((String)CloudUserExportUI.RESOURCE, (String)"assemble_syn_data") + "...(1/2)");
                    try {
                        data = SynUserToCloudHelper.assembleCloudUserInfo(null);
                    }
                    catch (Exception e) {
                        MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)CloudUserExportUI.RESOURCE, (String)"assemble_failed"), (String)e.toString(), (int)0);
                        return "false";
                    }
                    dialog.updateMsg("2." + EASResource.getString((String)CloudUserExportUI.RESOURCE, (String)"export_user") + "...(2/2)");
                    try {
                        CloudUserExportHelper exportHelper = new CloudUserExportHelper(exportPath);
                        if (CloudUserExportUI.this.isExportAll()) {
                            ExportAllUserHelper exportAllHelper = new ExportAllUserHelper(exportPath);
                            exportAllHelper.execute(null, data);
                        } else {
                            exportHelper.execute(data);
                        }
                    }
                    catch (Exception e) {
                        MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)CloudUserExportUI.RESOURCE, (String)"export_user_failed"), (String)e.toString(), (int)0);
                        return "false";
                    }
                    return "true";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.exception = e;
                    return this.excMsg;
                }
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (Boolean.valueOf(String.valueOf(result)).booleanValue()) {
                    dialog.updateMsg(EASResource.getString((String)CloudUserExportUI.RESOURCE, (String)"export_user_success") + "...");
                    dialog.setOkButton(EASResource.getString((String)CloudUserExportUI.RESOURCE, (String)"export_result_view"), true);
                } else {
                    dialog.updateMsg(EASResource.getString((String)CloudUserExportUI.RESOURCE, (String)"export_user_failed") + "...");
                    dialog.setOkButton(EASResource.getString((String)CloudUserExportUI.RESOURCE, (String)"close"), true);
                }
            }

            @Override
            public void actionOkClick() throws Exception {
                try {
                    Runtime.getRuntime().exec("cmd  /c  start  " + exportPath);
                }
                catch (IOException e) {
                    logger.error((Object)("open " + exportPath + " error!"));
                }
            }
        });
        dialog.show();
    }

    @Override
    public void actionChoosePath_actionPerformed(ActionEvent e) throws Exception {
        String path = this.getDefaultFilePath();
        String fileName = "";
        fileName = this.isExportAll() ? FILE_NAME_ALL : FILE_NAME;
        KDFileChooser fileChooser = this.getKDFileChooser(EASResource.getString((String)RESOURCE, (String)"chooseFile"), path, fileName, SUFFIX);
        this.initFile(fileChooser, SUFFIX);
    }

    private String getDefaultFilePath() {
        return System.getProperty("user.home");
    }

    private File initFile(KDFileChooser fileChooser, String suffix) throws Exception {
        if (fileChooser == null) {
            return null;
        }
        int result = fileChooser.showSaveDialog(null);
        File file = fileChooser.getSelectedFile();
        if (result != 0) {
            return null;
        }
        if (!file.getAbsolutePath().endsWith(suffix)) {
            file = new File(file.getAbsolutePath() + suffix);
        }
        if (file.exists()) {
            int select = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"56_ExportExcelConfigUI"));
            if (select == 2) {
                return null;
            }
            if (select == 0 && !file.renameTo(file)) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"57_ExportExcelConfigUI"));
                return null;
            }
        }
        this.txtPath.setText(file.getAbsolutePath());
        return file;
    }

    private KDFileChooser getKDFileChooser(String title, String path, String fileName, String suffix) throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setSelectedFile(new File(path, fileName));
        fileChooser.setFileFilter(this.bulidFilter(suffix));
        return fileChooser;
    }

    private FileFilter bulidFilter(final String suffix) throws Exception {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                if (extension != null) {
                    return extension.equalsIgnoreCase(suffix);
                }
                return false;
            }

            private String getExtension(File f) {
                String ext = null;
                String fileName = f.getName();
                int i = fileName.lastIndexOf(".");
                if (i > 0 && i < fileName.length() - 1) {
                    ext = fileName.substring(i + 1).toLowerCase();
                }
                return ext;
            }

            @Override
            public String getDescription() {
                return suffix + "(" + suffix + ")";
            }
        };
        return fileFilter;
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }
}

