/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.AuthenModeFactory;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IUserOrgPermFacade;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.RuleParser;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermFacadeFactory;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.client.AbstractNewUserAccreditUI;
import com.kingdee.eas.base.permission.client.IPopMenuSourceUI;
import com.kingdee.eas.base.permission.client.IRuleAccreditUI;
import com.kingdee.eas.base.permission.client.RulePanel;
import com.kingdee.eas.base.permission.client.UserDiscretePermViewUI;
import com.kingdee.eas.base.permission.client.UserFieldAccessAccreditUI;
import com.kingdee.eas.base.permission.client.f7.AccreditF7PromptDialog;
import com.kingdee.eas.base.permission.client.f7.IDefaultSupportF7;
import com.kingdee.eas.base.permission.client.f7.ManageF7PromptDialog;
import com.kingdee.eas.base.permission.client.helper.NewUserAccreditTreeHelper;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.quickperm.PopMenuHelper;
import com.kingdee.eas.base.permission.client.quickperm.PopMenuPerformContext;
import com.kingdee.eas.base.permission.client.tree.UserOrgPermTreeBuilder;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.client.NewOrgF7PromptDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class NewUserAccreditUI
extends AbstractNewUserAccreditUI
implements IRuleAccreditUI,
IPopMenuSourceUI {
    private static Logger logger = Logger.getLogger(NewUserAccreditUI.class);
    private int curTabPage = 1;
    private boolean isShowRule = false;
    private RulePanel rulePanel = null;
    private RulePanel virtualRulePanel = null;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private UserInfo targetUser = null;
    private NewUserAccreditTreeHelper treeHelper = new NewUserAccreditTreeHelper();
    UserOrgPermTreeBuilder builder = new UserOrgPermTreeBuilder();
    private ConfigurationInfo configurationInfo = null;
    private PopMenuHelper popMenuHelper = null;
    private boolean isModified = false;
    private boolean execSave = false;
    private Set[] targetUOPsSet = new Set[3];
    private FullOrgUnitCollection orgCol = null;
    private IObjectPK sourceUserPK = null;
    private IObjectPK targetUserPK = null;
    private boolean hasShowAuthorization = false;
    private boolean hasShowNormal = false;
    private boolean hasShowForbidden = false;
    private boolean needSaveAuthorization = false;
    private boolean needSaveNormal = false;
    private boolean needSaveForbidden = false;
    private Map<Integer, TreeModel> sourceTreeModel = new HashMap<Integer, TreeModel>();
    private Map<String, UserOrgPermCollection> sourceUserOrgPermsCache = new WeakHashMap<String, UserOrgPermCollection>();
    private Map<String, UserOrgPermCollection> UserOrgPermsCache = new WeakHashMap<String, UserOrgPermCollection>();
    private static ExecutorService executorService = null;
    IDefaultSupportF7 accreditF7Dialog = null;
    IDefaultSupportF7 ctrlUnitF7Dialog = null;
    FullOrgUnitInfo lastAccreditF7DialogSelected = null;
    FullOrgUnitInfo lasectrlUnitF7DialogSelected = null;
    boolean tempTabChange = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService getExecutorService() {
        Class<NewUserAccreditUI> clazz = NewUserAccreditUI.class;
        synchronized (NewUserAccreditUI.class) {
            if (executorService == null) {
                executorService = new ThreadPoolExecutor(0, 3, 2L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return executorService;
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("CurrentUserPK", (Object)this.getCurrentUserPK());
        request.put("TargetUserPK", (Object)this.getTargetUserPK());
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    private void initUI() throws Exception {
        this.rulePanel = new RulePanel();
        this.rulePanel.setStatus(this.getOprtState());
        this.virtualRulePanel = new RulePanel();
        this.virtualRulePanel.setStatus(this.getOprtState());
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.btnDiscretePerm.setVisible(false);
        this.btnFieldAccessAccredit.setVisible(false);
        this.tHelper.getDisabledTables().add(this.rulePanel.getTable());
        this.lbcOrg.setBoundLabelText(OrgRangeType.BIZ_ORG_TYPE.getAlias());
        this.tViewSourcePerm.setShowControlPanel(true);
        this.tViewSourcePerm.setShowButton(true);
        this.tViewSourcePerm.setTitle(EASResource.getString((String)RESOURCE, (String)"QUICK_PANEL"));
        this.tviewAuthorizedPerm.setShowControlPanel(true);
        this.tviewAuthorizedPerm.setShowButton(true);
        this.tviewAuthorizedPerm.setTitle(EASResource.getString((String)RESOURCE, (String)"QUICK_PANEL"));
        this.tviewNormalPerm.setShowControlPanel(true);
        this.tviewNormalPerm.setShowButton(true);
        this.tviewNormalPerm.setTitle(EASResource.getString((String)RESOURCE, (String)"QUICK_PANEL"));
        this.tviewForbiddenPerm.setShowControlPanel(true);
        this.tviewForbiddenPerm.setShowButton(true);
        this.tviewForbiddenPerm.setTitle(EASResource.getString((String)RESOURCE, (String)"QUICK_PANEL"));
    }

    public void onShow() throws Exception {
        super.onShow();
        IUIWindow win = this.getUIWindow();
        ((Frame)win).setSize(700, 630);
    }

    private void showRulePanel(boolean isVisible) {
        this.changeTabStatus2Edit(this.curTabPage);
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.rulePanel.setVisible(isVisible);
        IUIWindow win = this.getUIWindow();
        if (isVisible) {
            if (win instanceof UIModelDialog) {
                ((UIModelDialog)win).setSize(636, 600);
            } else if (win instanceof Frame) {
                ((Frame)win).setSize(636, 600);
                this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 630, 500));
                this.add((Component)((Object)this.rulePanel), new KDLayout.Constraints(0, 345, 630, 170, 294));
                ((Frame)win).repaint();
                ((Frame)win).validate();
            }
        } else if (win instanceof UIModelDialog) {
            ((UIModelDialog)win).setSize(636, 452);
        } else if (win instanceof Frame) {
            ((Frame)win).setSize(636, 540);
            this.putClientProperty("OriginalBounds", new Rectangle(10, 10, 630, 354));
        }
    }

    private void initTab() throws EASBizException, BOSException {
        if (!this.targetUser.isBizAdmin()) {
            this.tabAssign.setEnabledAt(0, false);
        }
        this.tabAssign.setSelectedIndex(1);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.setUserInfo();
        this.loadConfigurationInfo();
        this.initTrees();
        this.initTab();
        this.initOrgF7();
        this.setRulePanelStatus();
    }

    private void loadConfigurationInfo() throws EASBizException, BOSException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        this.configurationInfo = iPermission.getConfigurationInfo();
    }

    private void setRulePanelStatus() {
        this.rulePanel.setButtonStatus(this.needRule());
    }

    private void initTrees() throws Exception {
        this.clearAllTrees();
    }

    private void setUserInfo() throws EASBizException, BOSException {
        this.targetUser = ToolUtils.getSimpleUserInfo(this.getTargetUserPK());
        this.txtUser.setText(this.targetUser.getNumber() + "(" + this.targetUser.getName() + ")");
    }

    private void clearAllTrees() {
        ((DefaultTreeModel)this.treeSourcePerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeAuthorizedPerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeNormalPerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeForbiddenPerm.getModel()).setRoot(null);
    }

    private void initOrgF7() throws EASBizException, BOSException {
        this.accreditF7Dialog = new AccreditF7PromptDialog((IUIObject)this, this.targetUser, false);
        this.pmtOrg.setSelector((KDPromptSelector)this.accreditF7Dialog);
        this.pmtOrg.setData(this.accreditF7Dialog.getDefaultData());
        this.pmtOrg.setEditable(false);
    }

    @Override
    public void reloadUI() throws Exception {
        Set expendAuthorizedNodes = this.treeHelper.getExpendedNodes(this.treeAuthorizedPerm);
        Set expendNormalNodes = this.treeHelper.getExpendedNodes(this.treeNormalPerm);
        Set expendForbiddenNodes = this.treeHelper.getExpendedNodes(this.treeForbiddenPerm);
        this.hasShowAuthorization = false;
        this.hasShowNormal = false;
        this.hasShowForbidden = false;
        this.needSaveAuthorization = false;
        this.needSaveNormal = false;
        this.needSaveForbidden = false;
        this.btnSubmit.setEnabled(false);
        this.buildAllTrees();
        this.loadRule(null);
        this.treeHelper.expand(this.treeAuthorizedPerm, expendAuthorizedNodes);
        this.treeHelper.expand(this.treeNormalPerm, expendNormalNodes);
        this.treeHelper.expand(this.treeForbiddenPerm, expendForbiddenNodes);
    }

    private void buildAllTrees() throws Exception {
        this.sourceUserPK = this.getCurrentUserPK();
        this.targetUserPK = this.getTargetUserPK();
        this.orgCol = this.getOrgCol();
        ExecutorService exec = NewUserAccreditUI.getExecutorService();
        try {
            ArrayList<BuildTreeThread> tasks = new ArrayList<BuildTreeThread>();
            tasks.add(new BuildTreeThread(true, this.curTabPage));
            if (!this.tempTabChange) {
                if (this.curTabPage == 0) {
                    tasks.add(new BuildTreeThread(false, 0));
                } else {
                    tasks.add(new BuildTreeThread(false, 1));
                    tasks.add(new BuildTreeThread(false, 2));
                }
            }
            exec.invokeAll(tasks);
            this.refreshSelectCustomIco();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public IUserOrgPermFacade getBizInterface() throws BOSException {
        return UserOrgPermFacadeFactory.getRemoteInstance();
    }

    private String getKey(IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgsColl, int permType) {
        String orgsCollStr = "";
        for (int i = 0; i < orgsColl.size(); ++i) {
            orgsCollStr = orgsCollStr + orgsColl.get(i).getId().toString();
        }
        return sourceUserPK.toString() + targetUserPK.toString() + orgsCollStr + permType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserOrgPermCollection getSourceUOPS(IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgsColl, int permType) throws Exception {
        String key = this.getKey(sourceUserPK, targetUserPK, orgsColl, permType);
        UserOrgPermCollection userOrgPermCollection = this.sourceUserOrgPermsCache.get(key);
        if (userOrgPermCollection == null) {
            userOrgPermCollection = this.getBizInterface().getSourceUOPS(sourceUserPK, targetUserPK, this.orgCol, false, permType);
            NewUserAccreditUI newUserAccreditUI = this;
            synchronized (newUserAccreditUI) {
                this.sourceUserOrgPermsCache.put(key, userOrgPermCollection);
            }
        }
        return userOrgPermCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserOrgPermCollection getTargetUOPS(IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgsColl, int permType) throws Exception {
        String key = this.getKey(sourceUserPK, targetUserPK, orgsColl, permType);
        UserOrgPermCollection userOrgPermCollection = this.UserOrgPermsCache.get(key);
        if (userOrgPermCollection == null) {
            userOrgPermCollection = this.getBizInterface().getTargetUOPS(sourceUserPK, targetUserPK, this.orgCol, false, permType);
            NewUserAccreditUI newUserAccreditUI = this;
            synchronized (newUserAccreditUI) {
                this.UserOrgPermsCache.put(key, userOrgPermCollection);
            }
        }
        return userOrgPermCollection;
    }

    private void refreshUserOrgPermsCache(IObjectPK sourceUserPK, IObjectPK targetUserPK, FullOrgUnitCollection orgsColl, UserOrgPermCollection[] uops) {
        if (uops[0] != null) {
            this.UserOrgPermsCache.remove(this.getKey(sourceUserPK, targetUserPK, orgsColl, 30));
        }
        if (uops[1] != null) {
            this.UserOrgPermsCache.remove(this.getKey(sourceUserPK, targetUserPK, orgsColl, 10));
        }
        if (uops[2] != null) {
            this.UserOrgPermsCache.remove(this.getKey(sourceUserPK, targetUserPK, orgsColl, 20));
        }
    }

    private void buildSourceTree(int index) throws Exception {
        try {
            UserOrgPermCollection sourceUOPS = this.getSourceUOPS(this.sourceUserPK, this.targetUserPK, this.orgCol, this.getCurPermType(index));
            TreeModel sourceTreeModel = this.treeHelper.getSourceTreeModel((IObjectCollection)sourceUOPS);
            this.treeSourcePerm.setModel(sourceTreeModel);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private FullOrgUnitCollection getOrgCol() throws BOSException {
        FullOrgUnitCollection ret = null;
        ArrayList<BOSUuid> orgList = new ArrayList<BOSUuid>();
        orgList.add(this.getSelectedOrgInfo().getId());
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(orgList, false), CompareType.INCLUDE));
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("id"));
        selectorCol.add(new SelectorItemInfo("cu"));
        selectorCol.add(new SelectorItemInfo("isUnion"));
        selectorCol.add(new SelectorItemInfo("maintainCU"));
        selectorCol.add(new SelectorItemInfo("orgtypestr"));
        selectorCol.add(new SelectorItemInfo("name"));
        selectorCol.add(new SelectorItemInfo("displayName"));
        entityViewInfo.setSelector(selectorCol);
        entityViewInfo.setFilter(filterInfo);
        ret = iFullOrgUnit.getFullOrgUnitCollection(entityViewInfo);
        return ret;
    }

    private FullOrgUnitCollection getOrgColById(String orgid) throws BOSException {
        FullOrgUnitCollection ret = null;
        ArrayList<String> orgList = new ArrayList<String>();
        orgList.add(orgid);
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(orgList, false), CompareType.INCLUDE));
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("id"));
        selectorCol.add(new SelectorItemInfo("cu"));
        selectorCol.add(new SelectorItemInfo("isUnion"));
        selectorCol.add(new SelectorItemInfo("maintainCU"));
        selectorCol.add(new SelectorItemInfo("orgtypestr"));
        selectorCol.add(new SelectorItemInfo("CU"));
        selectorCol.add(new SelectorItemInfo("maintainCU"));
        selectorCol.add(new SelectorItemInfo("name"));
        selectorCol.add(new SelectorItemInfo("displayName"));
        entityViewInfo.setSelector(selectorCol);
        entityViewInfo.setFilter(filterInfo);
        ret = iFullOrgUnit.getFullOrgUnitCollection(entityViewInfo);
        return ret;
    }

    private boolean alertSave(SelectorEvent e) throws Exception {
        if (this.getSelectedOrgInfo() != null && this.isModified && !this.execSave) {
            int isYes = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"alertSave"));
            if (MsgBox.isYes((int)isYes)) {
                LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
                dialog.setLongTimeTask(new ILongTimeTask(){

                    @Override
                    public Object exec() throws Exception {
                        NewUserAccreditUI.this.save();
                        return "";
                    }

                    @Override
                    public void afterExec(Object result) throws Exception {
                        MsgBox.showInfo((Component)((Object)NewUserAccreditUI.this), (String)EASResource.getString((String)NewUserAccreditUI.RESOURCE, (String)"accreditPermSucceed"));
                    }
                });
                dialog.show();
                if (e != null) {
                    e.setCanceled(true);
                }
                return true;
            }
            return MsgBox.isNo((int)isYes);
        }
        return true;
    }

    @Override
    protected void pmtOrg_dataChanged(DataChangeEvent e) throws Exception {
        FullOrgUnitInfo org = this.getSelectedOrgInfo();
        if (org != null && org.getCU() != null) {
            this.rulePanel.setCtrlUnitPK((IObjectPK)new ObjectUuidPK(org.getCU().getId()));
            this.targetUOPsSet = new Set[3];
            this.hasShowAuthorization = false;
            this.hasShowNormal = false;
            this.hasShowForbidden = false;
            this.needSaveAuthorization = false;
            this.needSaveNormal = false;
            this.needSaveForbidden = false;
            this.btnSubmit.setEnabled(false);
            this.buildAllTrees();
            this.isModified = false;
            this.execSave = false;
        } else {
            this.clearAllTrees();
        }
        if (this.tabAssign.getSelectedComponent().equals(this.tviewAuthorizedPerm)) {
            this.lasectrlUnitF7DialogSelected = org;
        } else {
            this.lastAccreditF7DialogSelected = org;
        }
        this.btnFieldAccessAccredit.setVisible(org != null);
    }

    @Override
    protected void pmtOrg_willShow(SelectorEvent e) throws Exception {
        if (this.alertSave(e)) {
            super.pmtOrg_willShow(e);
        } else {
            e.setCanceled(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setText(null);
        Icon addIcon = EASResource.getIcon((String)"imgTbtn_move_right");
        this.btnAdd.setIcon(addIcon);
        Icon addAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_right");
        this.btnAddAll.setIcon(addAllIcon);
        Icon deleteIcon = EASResource.getIcon((String)"imgTbtn_move_left");
        this.btnDelete.setIcon(deleteIcon);
        Icon deleteAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_left");
        this.btnDeleteAll.setIcon(deleteAllIcon);
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.setButtonDefaultStyl(this.btnSubmit);
        this.btnShowRule.setIcon(EASResource.getIcon((String)"imgTbtn_dataaccredit"));
        this.btnHideRule.setIcon(EASResource.getIcon((String)"imgTbtn_hiderule"));
        this.btnDiscretePerm.setIcon(EASResource.getIcon((String)"imgTbtn_scatterpurview"));
        this.btnFieldAccessAccredit.setIcon(EASResource.getIcon((String)"imgTbtn_fieldpurview"));
    }

    private synchronized UserOrgPermCollection[] getUICurrentUOPs() {
        UserOrgPermCollection[] results = new UserOrgPermCollection[3];
        if (this.needSaveAuthorization) {
            results[0] = this.treeHelper.getNewUserOrgPermFromTree(this.treeAuthorizedPerm, this.targetUserPK, (IObjectPK)new ObjectUuidPK(this.lastAccreditF7DialogSelected.getId().toString()), PermType.AUTHORIZATION);
        }
        if (this.needSaveNormal) {
            results[1] = this.treeHelper.getNewUserOrgPermFromTree(this.treeNormalPerm, this.targetUserPK, (IObjectPK)new ObjectUuidPK(this.lastAccreditF7DialogSelected.getId().toString()), PermType.NORMAL);
        }
        if (this.needSaveForbidden) {
            results[2] = this.treeHelper.getNewUserOrgPermFromTree(this.treeForbiddenPerm, this.targetUserPK, (IObjectPK)new ObjectUuidPK(this.lastAccreditF7DialogSelected.getId().toString()), PermType.FORBIDDEN);
        }
        return results;
    }

    @Override
    public RequestContext prepareActionSubmit(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
            UserOrgPermCollection[] results = this.getUICurrentUOPs();
            request.put("results", (Object)results);
        }
        return request;
    }

    @Override
    public boolean isPrepareActionSubmit() {
        return false;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.getSelectedOrgPK() != null) {
            this.checkCurrentNodeRule();
            this.save();
            UITools.showMsg(this, EASResource.getString((String)RESOURCE, (String)"accreditPermSucceed"), false);
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"orgIsNotSelected"));
        }
    }

    public void setNeedSaveNormal(boolean needSaveNormal) {
        this.needSaveNormal = needSaveNormal;
    }

    private void save() throws Exception {
        String msg;
        Object obj;
        if (this.execSave) {
            SysUtil.abort();
        }
        if ((obj = this.treeNormalPerm.getLastSelectedPathComponent()) != null) {
            this.storeRule((KDTreeNode)obj);
        }
        UserOrgPermCollection[] results = this.getUICurrentUOPs();
        ArrayList<String> permIdList = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            UserOrgPermCollection userOrgPermCollections = results[i];
            if (userOrgPermCollections == null || userOrgPermCollections.isEmpty()) continue;
            for (int j = 0; j < userOrgPermCollections.size(); ++j) {
                permIdList.add(userOrgPermCollections.get(j).getPermItemId());
            }
        }
        boolean isEnabledAuthen = AuthenModeFactory.getRemoteInstance().isEnablePermAuthen(permIdList, ToolUtils.orgCol2List(this.orgCol));
        if (isEnabledAuthen && this.isModified && MsgBox.showConfirm2((Component)((Object)this), (String)(msg = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"USER_WILL_NEED_AUTHEN"), this.getTargetUser().getNumber()))) == 2) {
            SysUtil.abort();
        }
        this.execSave = true;
        IUserOrgPermFacade iuopFacade = this.getBizInterface();
        if (this.lasectrlUnitF7DialogSelected != null && this.lastAccreditF7DialogSelected != null && this.lasectrlUnitF7DialogSelected.getId().toString().equals(this.lastAccreditF7DialogSelected.getId().toString())) {
            FullOrgUnitCollection orgs = this.getOrgColById(this.lastAccreditF7DialogSelected.getId().toString());
            iuopFacade.saveUserOrgPerms(this.sourceUserPK, this.targetUserPK, orgs, results, isEnabledAuthen);
            this.refreshUserOrgPermsCache(this.sourceUserPK, this.targetUserPK, orgs, results);
        } else {
            FullOrgUnitCollection orgs;
            if (this.needSaveAuthorization && this.lasectrlUnitF7DialogSelected != null) {
                UserOrgPermCollection[] param = new UserOrgPermCollection[]{results[0], null, null};
                orgs = this.getOrgColById(this.lasectrlUnitF7DialogSelected.getId().toString());
                iuopFacade.saveUserOrgPerms(this.sourceUserPK, this.targetUserPK, orgs, param, isEnabledAuthen);
                this.refreshUserOrgPermsCache(this.sourceUserPK, this.targetUserPK, orgs, results);
            }
            if ((this.needSaveNormal || this.needSaveForbidden) && this.lastAccreditF7DialogSelected != null) {
                UserOrgPermCollection[] param = new UserOrgPermCollection[]{null, results[1], results[2]};
                orgs = this.getOrgColById(this.lastAccreditF7DialogSelected.getId().toString());
                iuopFacade.saveUserOrgPerms(this.sourceUserPK, this.targetUserPK, orgs, param, isEnabledAuthen);
                this.refreshUserOrgPermsCache(this.sourceUserPK, this.targetUserPK, orgs, results);
            }
        }
        this.targetUOPsSet = new Set[3];
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    NewUserAccreditUI.this.reloadUI();
                }
                catch (Exception e) {
                    NewUserAccreditUI.this.handUIException(e);
                }
            }
        });
        this.isModified = false;
        this.execSave = false;
    }

    @Override
    public void actionShowRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionShowRule_actionPerformed(e);
        this.isShowRule = true;
        this.showRulePanel(this.isShowRule);
        this.rulePanel.refresh();
        IUIWindow win = this.getUIWindow();
        ((Frame)win).setSize(700, 790);
    }

    @Override
    public void actionHideRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionHideRule_actionPerformed(e);
        this.isShowRule = false;
        this.showRulePanel(this.isShowRule);
        this.rulePanel.refresh();
        this.onShow();
    }

    @Override
    public void actionDiscretePerm_actionPerformed(ActionEvent e) throws Exception {
        BOSObjectType objectType;
        Object obj = this.treeNormalPerm.getLastSelectedPathComponent();
        if (obj != null && (objectType = this.getRuleObjectType((KDTreeNode)obj)) != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"bosObjectType", (Object)objectType);
            uiContext.put((Object)"targetUserPK", (Object)this.getTargetUserPK());
            uiContext.put((Object)"targetOrgPK", (Object)(this.getSelectedOrgID() == null ? null : new ObjectUuidPK(this.getSelectedOrgID())));
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserDiscretePermViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            window.show();
        }
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        if (this.curTabPage == 0) {
            this.builder.addSelectionPaths(this.treeSourcePerm, this.treeAuthorizedPerm);
            this.builder.setDefaultIcon((KDTreeNode)this.treeAuthorizedPerm.getModel().getRoot());
        } else if (this.curTabPage == 1) {
            this.builder.addSelectionPaths(this.treeSourcePerm, this.treeNormalPerm);
            this.builder.setDataRuleIcon((KDTreeNode)this.treeNormalPerm.getModel().getRoot());
        } else if (this.curTabPage == 2) {
            this.builder.addSelectionPaths(this.treeSourcePerm, this.treeForbiddenPerm);
            this.builder.setForbiddenIcon((KDTreeNode)this.treeForbiddenPerm.getModel().getRoot());
        }
        this.changeTabStatus2Edit(this.curTabPage);
        this.isModified = true;
        this.refreshSelectCustomIco();
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        if (this.curTabPage == 0) {
            this.builder.addAllPaths(this.treeSourcePerm, this.treeAuthorizedPerm);
            this.builder.setDefaultIcon((KDTreeNode)this.treeAuthorizedPerm.getModel().getRoot());
        } else if (this.curTabPage == 1) {
            this.builder.addAllPaths(this.treeSourcePerm, this.treeNormalPerm);
            this.builder.setDataRuleIcon((KDTreeNode)this.treeNormalPerm.getModel().getRoot());
        } else if (this.curTabPage == 2) {
            this.builder.addAllPaths(this.treeSourcePerm, this.treeForbiddenPerm);
            this.builder.setForbiddenIcon((KDTreeNode)this.treeForbiddenPerm.getModel().getRoot());
        }
        this.changeTabStatus2Edit(this.curTabPage);
        this.isModified = true;
        this.refreshSelectCustomIco();
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        TreePath[] treePaths = null;
        if (this.curTabPage == 0) {
            treePaths = this.treeAuthorizedPerm.getSelectionPaths();
            if (treePaths != null) {
                int length = treePaths.length;
                KDTreeNode[] treeNodes = new KDTreeNode[length];
                for (int i = 0; i < length; ++i) {
                    treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
                }
                this.treeHelper.removeNodes(this.treeAuthorizedPerm, treeNodes);
            }
        } else if (this.curTabPage == 1) {
            treePaths = this.treeNormalPerm.getSelectionPaths();
            if (treePaths != null) {
                int length = treePaths.length;
                KDTreeNode[] treeNodes = new KDTreeNode[length];
                for (int i = 0; i < length; ++i) {
                    treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
                }
                this.treeHelper.removeNodes(this.treeNormalPerm, treeNodes);
                this.processRulePanel();
            }
        } else if (this.curTabPage == 2 && (treePaths = this.treeForbiddenPerm.getSelectionPaths()) != null) {
            int length = treePaths.length;
            KDTreeNode[] treeNodes = new KDTreeNode[length];
            for (int i = 0; i < length; ++i) {
                treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
            }
            this.treeHelper.removeNodes(this.treeForbiddenPerm, treeNodes);
        }
        if (treePaths != null) {
            this.changeTabStatus2Edit(this.curTabPage);
            this.isModified = true;
        }
        this.refreshSelectCustomIco();
    }

    private void processRulePanel() {
        if (this.treeNormalPerm == null || this.treeNormalPerm.getLastSelectedPathComponent() == null) {
            this.rulePanel.reset();
        }
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteAll_actionPerformed(e);
        KDTreeNode object = null;
        if (this.curTabPage == 0) {
            object = (KDTreeNode)this.treeAuthorizedPerm.getModel().getRoot();
            if (object != null) {
                KDTreeNode[] treeNodes = new KDTreeNode[]{object};
                this.treeHelper.removeNodes(this.treeAuthorizedPerm, treeNodes);
            }
        } else if (this.curTabPage == 1) {
            object = (KDTreeNode)this.treeNormalPerm.getModel().getRoot();
            if (object != null) {
                KDTreeNode[] treeNodes = new KDTreeNode[]{object};
                this.treeHelper.removeNodes(this.treeNormalPerm, treeNodes);
                this.processRulePanel();
            }
        } else if (this.curTabPage == 2 && (object = (KDTreeNode)this.treeForbiddenPerm.getModel().getRoot()) != null) {
            KDTreeNode[] treeNodes = new KDTreeNode[]{object};
            this.treeHelper.removeNodes(this.treeForbiddenPerm, treeNodes);
        }
        if (object != null) {
            this.changeTabStatus2Edit(this.curTabPage);
            this.isModified = true;
        }
        this.refreshSelectCustomIco();
    }

    private void changeTabStatus2Edit(int currentTab) {
        if (currentTab == 0) {
            this.needSaveAuthorization = true;
        } else if (currentTab == 1) {
            this.needSaveNormal = true;
        } else if (currentTab == 2) {
            this.needSaveForbidden = true;
        }
        this.btnSubmit.setEnabled(true);
    }

    private FullOrgUnitInfo getSelectedOrgInfo() {
        if (this.pmtOrg.getData() == null) {
            return null;
        }
        if (this.pmtOrg.getData() instanceof FullOrgUnitInfo) {
            return (FullOrgUnitInfo)this.pmtOrg.getData();
        }
        return null;
    }

    private IObjectPK getSelectedOrgPK() {
        if (this.getSelectedOrgInfo() == null) {
            return null;
        }
        return new ObjectUuidPK(this.getSelectedOrgInfo().getId());
    }

    private BOSUuid getSelectedOrgID() {
        if (this.getSelectedOrgInfo() == null) {
            return null;
        }
        return this.getSelectedOrgInfo().getId();
    }

    public String getSelectedOrgNumber() {
        if (this.getSelectedOrgInfo() == null) {
            return null;
        }
        return this.getSelectedOrgInfo().getNumber();
    }

    private IObjectPK getTargetUserPK() {
        return new ObjectUuidPK((String)this.getUIContext().get("targetID"));
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(this.getCurrentUser().getId());
    }

    private String getRuleStructure() throws EASBizException, ParserException, BOSException {
        return this.getRulePanel().getRuleStructure();
    }

    private void storeRule(KDTreeNode node) throws Exception {
        UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
        if (info.getPermItem().isIsLeaf()) {
            if (!StringUtils.isEmpty((String)info.getPermItem().getObjectType()) && info.getPermItem().isEnableDataPermission()) {
                String ruleStructure = this.getRuleStructure();
                info.setRuleStructure(ruleStructure);
                EntityObjectInfo entity = this.getEntity(BOSObjectType.create((String)info.getPermItem().getObjectType()));
                RuleParser ruleParser = new RuleParser(entity);
                ruleParser.setRuleStructure(ruleStructure);
                if (!StringUtils.isEmpty((String)ruleParser.buildExpr())) {
                    info.setRuleExpr(ruleParser.buildExpr());
                } else {
                    info.setRuleExpr(null);
                }
            }
        } else if (this.enableDataPermission(node)) {
            BOSObjectType objectType = this.getRuleObjectType(node);
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                String ruleStructure;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf()) continue;
                UserOrgPermInfo infoChild = (UserOrgPermInfo)child.getUserObject();
                if (!objectType.toString().equals(infoChild.getPermItem().getObjectType()) || StringUtils.isEmpty((String)(ruleStructure = this.getRuleStructure()))) continue;
                infoChild.setRuleStructure(ruleStructure);
                EntityObjectInfo entity = this.getEntity(objectType);
                RuleParser ruleParser = new RuleParser(entity);
                ruleParser.setRuleStructure(ruleStructure);
                infoChild.setRuleExpr(ruleParser.buildExpr());
            }
        }
    }

    private EntityObjectInfo getEntity(BOSObjectType objectType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getEntity(objectType);
    }

    private void loadRule(KDTreeNode node) throws EASBizException, ParserException, BOSException {
        if (node == null) {
            this.rulePanel.reset();
        } else {
            UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
            if (info.getPermItem().isIsLeaf() && !StringUtils.isEmpty((String)info.getPermItem().getObjectType()) && info.getPermItem().isEnableDataPermission()) {
                this.rulePanel.setBizObjectType(BOSObjectType.create((String)info.getPermItem().getObjectType()));
                String ruleStructure = info.getRuleStructure();
                this.rulePanel.setRuleStructure(ruleStructure);
                this.rulePanel.refresh();
            } else if (this.canBindRule(node)) {
                this.rulePanel.reset();
                this.rulePanel.setBizObjectType(this.getRuleObjectType(node));
            } else {
                this.rulePanel.reset();
            }
        }
    }

    @Override
    protected void treeNormalPerm_valueChanged(TreeSelectionEvent e) throws Exception {
        KDTreeNode oldNode;
        Object old;
        this.btnDiscretePerm.setVisible(false);
        if (e.getOldLeadSelectionPath() != null && (old = e.getOldLeadSelectionPath().getLastPathComponent()) != null && this.canBindRule(oldNode = (KDTreeNode)old) && !this.rulePanel.verify()) {
            this.loadRule(oldNode);
            this.treeNormalPerm.setSelectionPath(e.getOldLeadSelectionPath());
        }
        super.treeNormalPerm_valueChanged(e);
        if (e.getOldLeadSelectionPath() != null && (old = e.getOldLeadSelectionPath().getLastPathComponent()) != null) {
            this.storeRule((KDTreeNode)old);
        }
        if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null) {
            this.loadRule((KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent());
        }
        this.setDiscreteButtonStatus(e);
        this.setRulePanelStatus();
        this.addPopMenuExtendFunc(e);
    }

    private void addPopMenuExtendFunc(TreeSelectionEvent e) {
        if (this.popMenuHelper == null) {
            this.popMenuHelper = new PopMenuHelper(this, this.treeNormalPerm);
        }
        PopMenuPerformContext ctx = new PopMenuPerformContext();
        ctx.setTreeSelectEvent(e);
        ctx.setUiObject((IUIObject)this);
        ctx.setTargetUser(this.targetUser);
        ctx.setTargetOrgUnit((FullOrgUnitInfo)this.pmtOrg.getData());
        this.popMenuHelper.dealPopMenu(ctx);
    }

    private boolean enableDataPermission(KDTreeNode node) {
        if (node.isLeaf()) {
            UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
            if (info != null && !StringUtils.isEmpty((String)info.getPermItem().getObjectType()) && info.getPermItem().isEnableDataPermission()) {
                return true;
            }
        } else {
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                UserOrgPermInfo info;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf() || (info = (UserOrgPermInfo)child.getUserObject()) == null || StringUtils.isEmpty((String)info.getPermItem().getObjectType()) || !info.getPermItem().isEnableDataPermission()) continue;
                return true;
            }
        }
        return false;
    }

    private void setDiscreteButtonStatus(TreeSelectionEvent e) {
        BOSObjectType objectType;
        KDTreeNode node;
        Object old;
        if (e.getNewLeadSelectionPath() != null && (old = e.getNewLeadSelectionPath().getLastPathComponent()) != null && this.enableDataPermission(node = (KDTreeNode)old) && (objectType = this.getRuleObjectType(node)) != null) {
            this.btnDiscretePerm.setVisible(this.configurationInfo.getDiscretEntityTables().containsKey(objectType.toString()));
            return;
        }
        this.btnDiscretePerm.setVisible(false);
    }

    private void checkCurrentNodeRule() throws EASBizException, ParserException, BOSException {
        KDTreeNode node;
        Object object;
        if (this.treeNormalPerm.getSelectionPath() != null && (object = this.treeNormalPerm.getSelectionPath().getLastPathComponent()) != null && this.canBindRule(node = (KDTreeNode)object) && !this.rulePanel.verify()) {
            this.abort();
        }
    }

    private boolean needRule() {
        return this.rulePanel.getBizObjectType() != null;
    }

    private boolean canBindRule(KDTreeNode node) {
        if (node.isLeaf()) {
            UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
            return info != null && !StringUtils.isEmpty((String)info.getPermItem().getObjectType()) && info.getPermItem().isEnableDataPermission();
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            KDTreeNode child = (KDTreeNode)node.getChildAt(i);
            if (child.isLeaf()) {
                UserOrgPermInfo info = (UserOrgPermInfo)child.getUserObject();
                if (info == null || StringUtils.isEmpty((String)info.getPermItem().getObjectType()) || !info.getPermItem().isEnableDataPermission()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private BOSObjectType getRuleObjectType(KDTreeNode node) {
        if (node.isLeaf()) {
            UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
            String objectType = info.getPermItem().getObjectType();
            if (!StringUtils.isEmpty((String)objectType)) {
                return BOSObjectType.create((String)objectType);
            }
        } else {
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                UserOrgPermInfo info;
                String objectType;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf() || StringUtils.isEmpty((String)(objectType = (info = (UserOrgPermInfo)child.getUserObject()).getPermItem().getObjectType()))) continue;
                return BOSObjectType.create((String)objectType);
            }
        }
        return null;
    }

    @Override
    protected void tabAssign_stateChanged(ChangeEvent e) throws Exception {
        super.tabAssign_stateChanged(e);
        this.curTabPage = this.tabAssign.getSelectedIndex();
        if (this.rulePanel != null) {
            IDefaultSupportF7 orgF7 = this.accreditF7Dialog;
            if (this.curTabPage == 0) {
                if (this.isShowRule) {
                    this.showRulePanel(false);
                }
                this.btnShowRule.setVisible(false);
                this.btnHideRule.setVisible(false);
                if (this.ctrlUnitF7Dialog == null) {
                    this.ctrlUnitF7Dialog = new ManageF7PromptDialog((IUIObject)this, this.targetUser);
                    this.pmtOrg.setData(this.ctrlUnitF7Dialog.getDefaultData());
                    ((NewOrgF7PromptDialog)this.ctrlUnitF7Dialog).setMultiSelect(false);
                } else {
                    this.tempTabChange = true;
                    this.pmtOrg.setData((Object)this.lasectrlUnitF7DialogSelected);
                    this.tempTabChange = false;
                }
                orgF7 = this.ctrlUnitF7Dialog;
                this.lbcOrg.setBoundLabelText(OrgRangeType.MANAGE_ORG_TYPE.getAlias());
            } else if (this.curTabPage == 1) {
                this.btnShowRule.setVisible(!this.isShowRule);
                this.btnHideRule.setVisible(this.isShowRule);
                if (this.isShowRule) {
                    this.showRulePanel(this.isShowRule);
                }
                this.tempTabChange = true;
                this.pmtOrg.setData((Object)this.lastAccreditF7DialogSelected);
                this.tempTabChange = false;
                this.lbcOrg.setBoundLabelText(OrgRangeType.BIZ_ORG_TYPE.getAlias());
            } else if (this.curTabPage == 2) {
                if (this.isShowRule) {
                    this.showRulePanel(false);
                }
                this.btnShowRule.setVisible(false);
                this.btnHideRule.setVisible(false);
                this.tempTabChange = true;
                this.pmtOrg.setData((Object)this.lastAccreditF7DialogSelected);
                this.tempTabChange = false;
                this.lbcOrg.setBoundLabelText(OrgRangeType.BIZ_ORG_TYPE.getAlias());
            }
            this.pmtOrg.setSelector((KDPromptSelector)orgF7);
            this.pmtOrg.setEditable(false);
        }
        this.refreshSelectCustomIco();
    }

    private void refreshSelectCustomIco() {
        TreeModel model = this.treeSourcePerm.getModel();
        if (this.curTabPage == 1) {
            this.treeHelper.refreshCustomIcon((DefaultKingdeeTreeNode)model.getRoot(), (DefaultKingdeeTreeNode)this.treeNormalPerm.getModel().getRoot());
        } else if (this.curTabPage == 2) {
            this.treeHelper.refreshCustomIcon((DefaultKingdeeTreeNode)model.getRoot(), (DefaultKingdeeTreeNode)this.treeForbiddenPerm.getModel().getRoot());
        } else if (this.curTabPage == 0) {
            this.treeHelper.refreshCustomIcon((DefaultKingdeeTreeNode)model.getRoot(), (DefaultKingdeeTreeNode)this.treeAuthorizedPerm.getModel().getRoot());
        }
        try {
            this.onShow();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    public boolean isPrepareActionFieldAccessAccredit() {
        return true;
    }

    @Override
    public RequestContext prepareActionFieldAccessAccredit(IItemAction itemAction) throws Exception {
        return super.prepareActionFieldAccessAccredit(itemAction);
    }

    @Override
    public void actionFieldAccessAccredit_actionPerformed(ActionEvent e) throws Exception {
        super.actionFieldAccessAccredit_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"userPK", (Object)this.getTargetUserPK());
        uiContext.put((Object)"orgPK", (Object)this.getSelectedOrgPK());
        uiContext.put((Object)"targetUserInfo", (Object)this.getTargetUser());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserFieldAccessAccreditUI.class.getName(), (Map)uiContext, null, null);
        window.show();
    }

    @Override
    public RulePanel getRulePanel() {
        return this.rulePanel;
    }

    public UserInfo getTargetUser() {
        return this.targetUser;
    }

    @Override
    protected void treeNormalPerm_mouseClicked(MouseEvent e) throws Exception {
        super.treeNormalPerm_mouseClicked(e);
    }

    public boolean destroyWindow() {
        boolean ret = true;
        try {
            if (this.isModified) {
                ret = this.alertSave(null);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (ret) {
            return super.destroyWindow();
        }
        return false;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    public int getCurPermType(int index) {
        if (index == 1) {
            return 10;
        }
        if (index == 2) {
            return 20;
        }
        if (index == 0) {
            return 30;
        }
        return -1;
    }

    public void checkRulelength(String ruleStructure) throws BOSException {
        try {
            this.virtualRulePanel.setBizObjectType(this.rulePanel.getBizObjectType());
            this.virtualRulePanel.setRuleStructure(ruleStructure);
            this.virtualRulePanel.refresh();
            KDTreeNode obj = (KDTreeNode)this.treeNormalPerm.getLastSelectedPathComponent();
            UserOrgPermInfo info = (UserOrgPermInfo)obj.getUserObject();
            if (info.getPermItem().isIsLeaf() && !StringUtils.isEmpty((String)info.getPermItem().getObjectType()) && info.getPermItem().isEnableDataPermission()) {
                String ruleStructureCheck = this.virtualRulePanel.getRuleStructure();
                if (ruleStructureCheck != null && ruleStructureCheck.length() > 2500) {
                    MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"rule_over_length"));
                    SysUtil.abort();
                }
                EntityObjectInfo entity = this.getEntity(BOSObjectType.create((String)info.getPermItem().getObjectType()));
                RuleParser ruleParser = new RuleParser(entity);
                ruleParser.setRuleStructure(ruleStructure);
                String ruleExpr = ruleParser.buildExpr();
                if (ruleExpr != null && ruleExpr.length() > 2500) {
                    MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"rule_over_length"));
                    SysUtil.abort();
                }
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
    }

    class BuildTreeThread
    implements Callable<Void> {
        private boolean buildSource;
        private int tabIndex;

        public BuildTreeThread(boolean buildSource, int tabIndex) {
            this.buildSource = buildSource;
            this.tabIndex = tabIndex;
        }

        @Override
        public Void call() throws Exception {
            if (this.buildSource) {
                NewUserAccreditUI.this.buildSourceTree(this.tabIndex);
            } else {
                UserOrgPermCollection f_userOrgPerms;
                if (!NewUserAccreditUI.this.hasShowAuthorization && this.tabIndex == 0) {
                    try {
                        f_userOrgPerms = NewUserAccreditUI.this.getTargetUOPS(NewUserAccreditUI.this.sourceUserPK, NewUserAccreditUI.this.targetUserPK, NewUserAccreditUI.this.orgCol, 30);
                        NewUserAccreditUI.this.treeHelper.buildTopTargetTree(NewUserAccreditUI.this.treeAuthorizedPerm, (IObjectCollection)f_userOrgPerms);
                        NewUserAccreditUI.this.hasShowAuthorization = true;
                    }
                    catch (Exception e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NewUserAccreditUI.this.handUIException(e);
                            }
                        });
                    }
                }
                if (!NewUserAccreditUI.this.hasShowNormal && this.tabIndex == 1) {
                    try {
                        f_userOrgPerms = NewUserAccreditUI.this.getTargetUOPS(NewUserAccreditUI.this.sourceUserPK, NewUserAccreditUI.this.targetUserPK, NewUserAccreditUI.this.orgCol, 10);
                        NewUserAccreditUI.this.treeHelper.buildTopTargetTree(NewUserAccreditUI.this.treeNormalPerm, (IObjectCollection)f_userOrgPerms);
                        NewUserAccreditUI.this.hasShowNormal = true;
                    }
                    catch (Exception e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NewUserAccreditUI.this.handUIException(e);
                            }
                        });
                    }
                }
                if (!NewUserAccreditUI.this.hasShowForbidden && this.tabIndex == 2) {
                    try {
                        f_userOrgPerms = NewUserAccreditUI.this.getTargetUOPS(NewUserAccreditUI.this.sourceUserPK, NewUserAccreditUI.this.targetUserPK, NewUserAccreditUI.this.orgCol, 20);
                        NewUserAccreditUI.this.treeHelper.buildTopTargetTree(NewUserAccreditUI.this.treeForbiddenPerm, (IObjectCollection)f_userOrgPerms);
                        NewUserAccreditUI.this.hasShowForbidden = true;
                    }
                    catch (Exception e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NewUserAccreditUI.this.handUIException(e);
                            }
                        });
                    }
                }
            }
            return null;
        }
    }
}

