/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.PermissionReqException;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RoleInfoWithNumber;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.AbstractRoleBatchReqUI;
import com.kingdee.eas.base.permission.client.PermissionReqBillEditUI;
import com.kingdee.eas.base.permission.client.helper.UserRoleAssignHelper;
import com.kingdee.eas.base.permission.client.helper.UserRoleBatchAssignHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class RoleBatchReqUI
extends AbstractRoleBatchReqUI {
    private static final Logger logger = CoreUIObject.getLogger(RoleBatchReqUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private List selectOrgList = new ArrayList();
    private List unSuccessRoleid = new ArrayList();
    private int selectedIndex = 0;
    private boolean isModified;
    private boolean isFound = false;

    public void onLoad() throws Exception {
        this.setDoRequestData(false);
        super.onLoad();
        this.initF7();
        this.loadRoleList();
        this.initUIState();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setText(null);
        Icon addIcon = EASResource.getIcon((String)"imgTbtn_move_right");
        this.btnAdd.setIcon(addIcon);
        Icon addAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_right");
        this.btnAddAll.setText(null);
        this.btnAddAll.setIcon(addAllIcon);
        Icon deleteIcon = EASResource.getIcon((String)"imgTbtn_move_left");
        this.btnDelete.setText(null);
        this.btnDelete.setIcon(deleteIcon);
        Icon deleteAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_left");
        this.btnDeleteAll.setText(null);
        this.btnDeleteAll.setIcon(deleteAllIcon);
        this.btnSave.setEnabled(true);
        Icon savePermIcon = EASResource.getIcon((String)"imgTbtn_save");
        this.btnSave.setIcon(savePermIcon);
        Icon selectOrgIcon = EASResource.getIcon((String)"imgTbtn_selectcompany");
        this.btnSelectOrg.setIcon(selectOrgIcon);
    }

    private void initUIState() {
        this.search.setEnabled(true);
    }

    private void loadRoleList() throws Exception {
        IRole role = RoleFactory.getRemoteInstance();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sorterItemInfo);
        FilterInfo roleFilter = new FilterInfo();
        roleFilter.getFilterItems().add(new FilterItemInfo("id", (Object)"select froleid from T_PM_PermissionReqSensitiveRol", CompareType.NOTINNER));
        entityViewInfo.setFilter(roleFilter);
        RoleCollection coll = role.getRoleCollection(entityViewInfo);
        CtrlUnitInfo selectedCtrlInfo = this.getSelectedCtrlInfo();
        RoleCollection currentCURoles = UserRoleAssignHelper.filterByCU(coll, selectedCtrlInfo, null);
        DefaultListModel<RoleInfoWithNumber> assignModel = new DefaultListModel<RoleInfoWithNumber>();
        for (int i = 0; i < currentCURoles.size(); ++i) {
            assignModel.addElement(UserRoleBatchAssignHelper.toRoleInfoWithNumber(coll.get(i)));
        }
        this.lstAll.setModel(assignModel);
    }

    private CtrlUnitInfo getSelectedCtrlInfo() {
        if (this.pmtCtrlUnit.getData() instanceof CtrlUnitInfo) {
            return (CtrlUnitInfo)this.pmtCtrlUnit.getData();
        }
        return null;
    }

    private void initF7() throws EASBizException, BOSException {
        UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> sysUser = new HashSet<String>(5);
        sysUser.add("00000000-0000-0000-0000-00000000000113B7DE7F");
        sysUser.add("00000000-0000-0000-0000-00000000000213B7DE7F");
        sysUser.add("Wp3rRSFxRCaPFjuE2apQjRO33n8=");
        sysUser.add("00000000-0000-0000-0000-00000000000013B7DE7F");
        if (Administrator.isAdminType(currentUser.getType())) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select fid from t_pm_user where FCONTROLUNITID in (select forgid from t_pm_orgrange where Fuserid ='" + currentUser.getId().toString() + "' and FType =10)"), CompareType.INNER));
        } else if (Administrator.isBizAdmin(null, (IObjectPK)new ObjectUuidPK(currentUser.getId()))) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select fid from t_pm_user where FCONTROLUNITID in (select forgid from t_pm_orgrange where Fuserid ='" + currentUser.getId().toString() + "' and FType =30)"), CompareType.INNER));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)currentUser.getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("id", sysUser, CompareType.NOTINCLUDE));
        ev.setFilter(filter);
        this.bizUser.setEntityViewInfo(ev);
        this.bizUser.setQueryInfo("com.kingdee.eas.base.permission.app.F7UserQuery");
        this.bizUser.setEditFormat("$number$");
        this.bizUser.setCommitFormat("$number$");
        this.bizUser.setDisplayFormat("$number$($name$)");
        this.bizUser.setEnabledMultiSelection(true);
        NewCtrlF7 ctrlF7 = new NewCtrlF7();
        ctrlF7.setMultiSelect(false);
        ctrlF7.setShowAssistantOrg(false);
        ctrlF7.setContainSealUp(true);
        this.pmtCtrlUnit.setSelector((KDPromptSelector)ctrlF7);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getKeyFieldName() {
        return "orgId";
    }

    @Override
    public void actionSelectOrg_actionPerformed(ActionEvent e) throws Exception {
        Object[] users = (Object[])this.bizUser.getData();
        if (users == null || users.length < 1 || users[0] == null) {
            throw new PermissionReqException(PermissionReqException.CHECKUSERSEMPTY);
        }
        this.setDoRequestData(true);
        super.actionSelectOrg_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        HashSet selectedIDs = new HashSet();
        selectedIDs.addAll(this.selectOrgList);
        PermissionReqBillEditUI.AllOuF7ExceptSensitiveOrg orgF7 = new PermissionReqBillEditUI.AllOuF7ExceptSensitiveOrg(Arrays.asList((Object[])users));
        orgF7.setMultiSelect(true);
        orgF7.setShowSub(true);
        orgF7.setNeedAddSealUp(true);
        orgF7.setNeedAddAssistant(false);
        orgF7.setSelectedOrgIds(selectedIDs);
        orgF7.show();
        if (!orgF7.isCanceled()) {
            this.selectOrgList.clear();
            Object obj = orgF7.getData();
            OrgUnitInfo[] orgUnitInfoAry = (OrgUnitInfo[])obj;
            for (int i = 0; i < orgUnitInfoAry.length; ++i) {
                this.selectOrgList.add(orgUnitInfoAry[i].getId().toString());
            }
        }
        this.execQuery();
    }

    protected void execQuery() {
        try {
            if (this.mainQuery != null) {
                this.mainQuery.setFilter(this.getDefaultFilteInfo());
                this.setSortInfo(this.mainQuery);
            }
            super.execQuery();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handleException(e);
        }
    }

    private void setSortInfo(EntityViewInfo targetQuery) {
        targetQuery.getSorter().clear();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        targetQuery.getSorter().add(sorterItemInfo);
    }

    private FilterInfo getDefaultFilteInfo() throws BOSException {
        FilterInfo myFilterInfo = new FilterInfo();
        myFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(this.selectOrgList, false), CompareType.INCLUDE));
        return myFilterInfo;
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        if (this.lstAll.getSelectedIndex() == -1) {
            return;
        }
        Object[] objects = this.lstAll.getSelectedValues();
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            RoleInfo roleInfo = (RoleInfo)objects[i];
            if (this.isAssignRoleExists(roleInfo)) continue;
            ((DefaultListModel)this.lstAssign.getModel()).addElement(objects[i]);
            this.isModified = true;
        }
        int currentSize = ((DefaultListModel)this.lstAll.getModel()).getSize();
        int selectedIndex = this.lstAssign.getSelectedIndex();
        int nextSelectedIndex = selectedIndex;
        if (nextSelectedIndex <= currentSize - 1) {
            this.lstAll.setSelectedIndex(nextSelectedIndex);
        } else {
            this.lstAll.setSelectedIndex(currentSize - 1);
        }
    }

    private boolean isAssignRoleExists(RoleInfo roleInfo) {
        int size = this.lstAssign.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            RoleInfo info = (RoleInfo)this.lstAssign.getModel().getElementAt(i);
            if (!info.getId().equals((Object)roleInfo.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        int size = this.lstAll.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            RoleInfo roleInfo = (RoleInfo)this.lstAll.getModel().getElementAt(i);
            if (this.isAssignRoleExists(roleInfo)) continue;
            this.lstAssign.addElement((Object)roleInfo);
            this.isModified = true;
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        if (this.lstAssign.getSelectedIndex() == -1) {
            return;
        }
        int selectedIndex = this.lstAssign.getSelectedIndex();
        if (selectedIndex != -1) {
            this.removeRole();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"roleIsNotSelected"));
        }
    }

    private void removeRole() {
        this.isModified = true;
        Object[] objects = this.lstAssign.getSelectedValues();
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            ((DefaultListModel)this.lstAssign.getModel()).removeElement(objects[i]);
        }
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        this.isModified = true;
        HashSet<RoleInfo> set = new HashSet<RoleInfo>();
        int n = this.lstAssign.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            RoleInfo roleInfo = (RoleInfo)this.lstAssign.getModel().getElementAt(i);
            set.add(roleInfo);
        }
        for (Object e2 : set) {
            this.lstAssign.removeElement(e2);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        Object parent = this.getUIContext().get("Owner");
        if (parent instanceof PermissionReqBillEditUI) {
            PermissionReqBillEditUI owner = (PermissionReqBillEditUI)((Object)parent);
            Object[] users = (Object[])this.bizUser.getData();
            if (users == null || users.length < 1 || users[0] == null) {
                throw new PermissionReqException(PermissionReqException.CHECKUSERSEMPTY);
            }
            if (this.selectOrgList == null || this.selectOrgList.size() < 1) {
                throw new PermissionReqException(PermissionReqException.CHECKORGSEMPTY);
            }
            if (this.lstAssign.getModel() == null || this.lstAssign.getModel().getSize() < 1) {
                throw new PermissionReqException(PermissionReqException.CHECKROLESEMPTY);
            }
            this.disposeUIWindow();
            owner.callBack(users, this.selectOrgList, this.lstAssign.getModel());
        }
    }

    @Override
    public void actionSearchRole_actionPerformed(ActionEvent e) throws Exception {
        String content = this.searchContent.getText();
        if (StringUtils.isEmpty((String)content)) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"pls_input_rolenumber"));
            return;
        }
        if (this.selectedIndex == this.lstAll.getElementCount()) {
            this.selectedIndex = 0;
        }
        for (int i = this.selectedIndex; i < this.lstAll.getElementCount(); ++i) {
            ++this.selectedIndex;
            RoleInfo role = (RoleInfo)this.lstAll.getElement(i);
            if (role.getNumber().toUpperCase().indexOf(content.toUpperCase()) >= 0) {
                this.lstAll.setSelectedIndex(i);
                this.lstAll.ensureIndexIsVisible(i);
                this.isFound = true;
                if (i != this.selectedIndex) break;
                ++this.selectedIndex;
                break;
            }
            if (!this.isFound || i != this.lstAll.getElementCount() - 1) continue;
            i = -1;
            this.selectedIndex = 0;
            this.isFound = false;
        }
        if (!this.isFound) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_NoResult"));
        }
    }

    @Override
    protected void pmtCtrlUnit_dataChanged(DataChangeEvent e) throws Exception {
        this.loadRoleList();
    }
}

