/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.AuthenModeFactory;
import com.kingdee.eas.base.permission.ConfigurationInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionManager;
import com.kingdee.eas.base.permission.IPermissionRangeFacade;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.IUserOrgPerm;
import com.kingdee.eas.base.permission.IUserOrgPermFacade;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionManagerFactory;
import com.kingdee.eas.base.permission.PermissionRangeFacadeFactory;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.RuleParser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermFacadeFactory;
import com.kingdee.eas.base.permission.UserOrgPermFactory;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.client.AbstractUserAccreditUI;
import com.kingdee.eas.base.permission.client.IPopMenuSourceUI;
import com.kingdee.eas.base.permission.client.IRuleAccreditUI;
import com.kingdee.eas.base.permission.client.RulePanel;
import com.kingdee.eas.base.permission.client.UserDiscretePermViewUI;
import com.kingdee.eas.base.permission.client.UserFieldAccessAccreditUI;
import com.kingdee.eas.base.permission.client.helper.NewUserAccreditTreeHelper;
import com.kingdee.eas.base.permission.client.helper.OrgHelper;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.quickperm.PopMenuHelper;
import com.kingdee.eas.base.permission.client.quickperm.PopMenuPerformContext;
import com.kingdee.eas.base.permission.client.tree.IAccreditTreeBuilder;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.base.permission.util.LogNamesHelper;
import com.kingdee.eas.base.permission.util.LogProxy;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.client.OuF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.OUUnionF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class UserAccreditUI
extends AbstractUserAccreditUI
implements IRuleAccreditUI,
IPopMenuSourceUI {
    private static Logger logger = Logger.getLogger(UserAccreditUI.class);
    private KDTreeNode branch = null;
    private int curTabPage = 1;
    private UserOrgPermCollection uopsCopy = null;
    private boolean isShowRule = false;
    private RulePanel rulePanel = null;
    private static final int AUTHORIZATION_INDEX = 0;
    private static final int NORMAL_INDEX = 1;
    private static final int FORBIDDEN_INDEX = 2;
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private UserInfo targetUser = null;
    private Map accreditOrgs = new HashMap();
    private IAccreditTreeBuilder builder = null;
    private ConfigurationInfo configurationInfo = null;
    private PopMenuHelper popMenuHelper = null;
    private UserOrgPermCollection userOrgPerms = null;
    private Set targetUOPs = null;
    private Set[] targetUOPsSet = new Set[3];
    private boolean isModified = false;
    private boolean execSave = false;
    private NewUserAccreditTreeHelper treeHelper = null;
    private boolean isInitOver = false;
    private FullOrgUnitCollection orgCol = null;
    private IObjectPK sourceUserPK = null;
    private IObjectPK targetUserPK = null;

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("CurrentUserPK", (Object)this.getCurrentUserPK());
        request.put("TargetUserPK", (Object)this.getTargetUserPK());
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    private void initUI() throws Exception {
        this.rulePanel = new RulePanel();
        this.rulePanel.setStatus(this.getOprtState());
        this.add((Component)((Object)this.rulePanel), null);
        this.rulePanel.setBounds(new Rectangle(0, 345, 630, 170));
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.btnDiscretePerm.setVisible(false);
        this.btnFieldAccessAccredit.setVisible(false);
        this.tHelper.getDisabledTables().add(this.rulePanel.getTable());
    }

    public void onShow() throws Exception {
        super.onShow();
        this.showRulePanel(this.isShowRule);
    }

    private void showRulePanel(boolean isVisible) {
        this.btnShowRule.setVisible(!this.isShowRule);
        this.btnHideRule.setVisible(this.isShowRule);
        this.rulePanel.setVisible(isVisible);
        IUIWindow win = this.getUIWindow();
        if (isVisible) {
            if (win instanceof UIModelDialog) {
                ((UIModelDialog)win).setSize(636, 600);
            } else if (win instanceof Frame) {
                ((Frame)win).setSize(636, 600);
            }
        } else if (win instanceof UIModelDialog) {
            ((UIModelDialog)win).setSize(636, 452);
        } else if (win instanceof Frame) {
            ((Frame)win).setSize(636, 452);
        }
    }

    private void getAllPathTargetUOPs() throws Exception {
        int i = 1;
        IUserOrgPermFacade iuopFacade = UserOrgPermFacadeFactory.getRemoteInstance();
        int type = 10;
        if (this.treeAuthorizedPerm.isShowing()) {
            type = 30;
            this.targetUOPs = this.targetUOPsSet[0];
            i = 0;
        } else if (this.treeNormalPerm.isShowing()) {
            type = 10;
            this.targetUOPs = this.targetUOPsSet[1];
            i = 1;
        } else if (this.treeForbiddenPerm.isShowing()) {
            type = 20;
            this.targetUOPs = this.targetUOPsSet[2];
            i = 2;
        }
        if (this.targetUOPs != null && this.targetUOPs.size() > 0) {
            return;
        }
        UserOrgPermCollection t_userOrgPerms = iuopFacade.getAllPathTargetUOPs(this.sourceUserPK, this.targetUserPK, this.orgCol, type);
        this.targetUOPs = new HashSet();
        int size = t_userOrgPerms.size();
        for (int j = 0; j < size; ++j) {
            this.targetUOPs.add(t_userOrgPerms.get(j).getPermItem().getLongNumber());
        }
        this.targetUOPsSet[i] = this.targetUOPs;
    }

    private void initTab() throws EASBizException, BOSException {
        if (!this.targetUser.isBizAdmin()) {
            this.tabAssign.setEnabledAt(0, false);
        }
        this.tabAssign.setSelectedIndex(1);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.setUserInfo();
        this.loadConfigurationInfo();
        this.initTrees();
        this.initOrgF7();
        this.initTab();
        this.selectDefOrg();
        this.setRulePanelStatus();
        this.isInitOver = true;
    }

    private void loadConfigurationInfo() throws EASBizException, BOSException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        this.configurationInfo = iPermission.getConfigurationInfo();
    }

    private void setRulePanelStatus() {
        this.rulePanel.setButtonStatus(this.needRule());
    }

    private void selectDefOrg() throws EASBizException, BOSException {
        FullOrgUnitInfo defOrgUnit = this.targetUser.getDefOrgUnit();
        if (defOrgUnit != null) {
            this.setAccreditOrgs();
            if (this.accreditOrgs.containsKey(defOrgUnit.getId().toString())) {
                this.pmtOrg.setData((Object)defOrgUnit);
            }
        }
    }

    private void initTrees() throws Exception {
        this.treeHelper = new NewUserAccreditTreeHelper();
        this.initSourceTree();
        this.initTargetTree();
        this.clearAllTrees();
    }

    private void initSourceTree() {
        this.treeSourcePerm.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode curNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (curNode == null) {
                    return;
                }
                try {
                    UserAccreditUI.this.buildLevelSourceTree(curNode);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
    }

    private void buildLevelSourceTree(KDTreeNode parent) throws Exception {
        UserOrgPermInfo uop = (UserOrgPermInfo)parent.getUserObject();
        if (parent == null || this.treeHelper.isLeaf(parent) || this.treeHelper.isExpended(parent)) {
            return;
        }
        IUserOrgPermFacade iuopFacade = UserOrgPermFacadeFactory.getRemoteInstance();
        PermItemInfo parentPerm = this.treeHelper.getPermItem(parent);
        UserOrgPermCollection userOrgPerms = iuopFacade.getLevelSourceUOPs(this.sourceUserPK, this.targetUserPK, this.orgCol, parentPerm, false, this.curTabPage == 0 ? 30 : -1);
        this.treeHelper.buildLevelSourceTree(parent, (IObjectCollection)userOrgPerms, this.targetUOPs);
    }

    private void setUserInfo() throws EASBizException, BOSException {
        this.targetUser = this.getUserInfo(this.getTargetUserPK());
        this.txtUser.setText(this.targetUser.getNumber() + "(" + this.targetUser.getName() + ")");
    }

    private void clearAllTrees() {
        ((DefaultTreeModel)this.treeSourcePerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeAuthorizedPerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeNormalPerm.getModel()).setRoot(null);
        ((DefaultTreeModel)this.treeForbiddenPerm.getModel()).setRoot(null);
    }

    private void setAccreditOrgs() throws EASBizException, BOSException {
        IPermissionRangeFacade iPermissionRangeFacade = PermissionRangeFacadeFactory.getRemoteInstance();
        Collection col = iPermissionRangeFacade.getOrgRange(this.getTargetUserPK(), this.getCurrentUserPK());
        if (col != null) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                this.accreditOrgs.put(it.next().toString(), Boolean.FALSE);
            }
        }
    }

    private void initOrgF7() throws EASBizException, BOSException {
        OUUnionF7 orgF7 = new OUUnionF7((IUIObject)this);
        OrgHelper.setF7ByUser((OuF7PromptDialog)orgF7, this.getTargetUserPK());
        orgF7.disableTheOUWhichIsOnlyAdmin();
        orgF7.setMultiSelect(false);
        orgF7.setShowAssistantOrg(true);
        orgF7.setIsDisplayMaintain(true);
        orgF7.setIsShowContainSealUp(true);
        this.pmtOrg.setSelector((KDPromptSelector)orgF7);
        this.pmtOrg.setEditable(false);
    }

    @Override
    public void reloadUI() throws Exception {
        Set expendAuthorizedNodes = this.treeHelper.getExpendedNodes(this.treeAuthorizedPerm);
        Set expendNormalNodes = this.treeHelper.getExpendedNodes(this.treeNormalPerm);
        Set expendForbiddenNodes = this.treeHelper.getExpendedNodes(this.treeForbiddenPerm);
        this.buildAllTrees();
        this.loadRule(null);
        this.treeHelper.expand(this.treeAuthorizedPerm, expendAuthorizedNodes);
        this.treeHelper.expand(this.treeNormalPerm, expendNormalNodes);
        this.treeHelper.expand(this.treeForbiddenPerm, expendForbiddenNodes);
    }

    private void buildAllTrees() throws Exception {
        this.clearAllTrees();
        this.sourceUserPK = this.getCurrentUserPK();
        this.targetUserPK = this.getTargetUserPK();
        this.orgCol = this.getOrgCol();
        this.buildSourceTree();
        this.buildTargetTree();
    }

    public IUserOrgPerm getBizInterface() throws BOSException {
        return UserOrgPermFactory.getRemoteInstance();
    }

    private void buildSourceTree() throws Exception {
        IUserOrgPermFacade iuopFacade = UserOrgPermFacadeFactory.getRemoteInstance();
        this.userOrgPerms = iuopFacade.getTopSourceUOPs(this.sourceUserPK, this.targetUserPK, this.orgCol, false, this.curTabPage == 0 ? 30 : -1);
        this.getAllPathTargetUOPs();
        this.treeHelper.buildTopSourceTree(this.treeSourcePerm, (IObjectCollection)this.userOrgPerms, this.targetUOPs);
    }

    private void buildTargetTree() throws Exception {
        IUserOrgPermFacade iuopFacade = UserOrgPermFacadeFactory.getRemoteInstance();
        UserOrgPermCollection a_userOrgPerms = iuopFacade.getTopTargetUOPs(this.sourceUserPK, this.targetUserPK, this.orgCol, 30);
        UserOrgPermCollection n_userOrgPerms = iuopFacade.getTopTargetUOPs(this.sourceUserPK, this.targetUserPK, this.orgCol, 10);
        UserOrgPermCollection f_userOrgPerms = iuopFacade.getTopTargetUOPs(this.sourceUserPK, this.targetUserPK, this.orgCol, 20);
        this.treeHelper.buildTopTargetTree(this.treeAuthorizedPerm, (IObjectCollection)a_userOrgPerms);
        this.treeHelper.buildTopTargetTree(this.treeNormalPerm, (IObjectCollection)n_userOrgPerms);
        this.treeHelper.buildTopTargetTree(this.treeForbiddenPerm, (IObjectCollection)f_userOrgPerms);
    }

    private boolean alertSave(SelectorEvent e) throws Exception {
        if (this.getSelectedOrgInfo() != null && this.isModified && !this.execSave) {
            int isYes = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"alertSave"));
            if (MsgBox.isYes((int)isYes)) {
                LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
                dialog.setLongTimeTask(new ILongTimeTask(){

                    @Override
                    public Object exec() throws Exception {
                        UserAccreditUI.this.save();
                        return "";
                    }

                    @Override
                    public void afterExec(Object result) throws Exception {
                        MsgBox.showInfo((Component)((Object)UserAccreditUI.this), (String)EASResource.getString((String)UserAccreditUI.RESOURCE, (String)"accreditPermSucceed"));
                    }
                });
                dialog.show();
                if (e != null) {
                    e.setCanceled(true);
                }
                return true;
            }
            return MsgBox.isNo((int)isYes);
        }
        return true;
    }

    @Override
    protected void pmtOrg_dataChanged(DataChangeEvent e) throws Exception {
        super.pmtOrg_dataChanged(e);
        FullOrgUnitInfo org = this.getSelectedOrgInfo();
        if (org != null && org.getCU() != null) {
            this.rulePanel.setCtrlUnitPK((IObjectPK)new ObjectUuidPK(org.getCU().getId()));
            this.buildAllTrees();
            this.isModified = false;
            this.execSave = false;
        } else {
            this.clearAllTrees();
        }
        this.btnFieldAccessAccredit.setVisible(org != null);
    }

    @Override
    protected void pmtOrg_willShow(SelectorEvent e) throws Exception {
        if (this.alertSave(e)) {
            super.pmtOrg_willShow(e);
        } else {
            e.setCanceled(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setText(null);
        Icon addIcon = EASResource.getIcon((String)"imgTbtn_move_right");
        this.btnAdd.setIcon(addIcon);
        Icon addAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_right");
        this.btnAddAll.setIcon(addAllIcon);
        Icon deleteIcon = EASResource.getIcon((String)"imgTbtn_move_left");
        this.btnDelete.setIcon(deleteIcon);
        Icon deleteAllIcon = EASResource.getIcon((String)"imgTbtn_moveall_left");
        this.btnDeleteAll.setIcon(deleteAllIcon);
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.setButtonDefaultStyl(this.btnSubmit);
        this.btnShowRule.setIcon(EASResource.getIcon((String)"imgTbtn_dataaccredit"));
        this.btnHideRule.setIcon(EASResource.getIcon((String)"imgTbtn_hiderule"));
        this.btnDiscretePerm.setIcon(EASResource.getIcon((String)"imgTbtn_scatterpurview"));
        this.btnFieldAccessAccredit.setIcon(EASResource.getIcon((String)"imgTbtn_fieldpurview"));
    }

    private CtrlUnitInfo getCurrentCU() {
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private synchronized UserOrgPermCollection getCurrentUOPs() {
        UserOrgPermInfo userOrgPermInfo;
        KDTreeNode treeNode;
        UserOrgPermCollection userOrgPerms = new UserOrgPermCollection();
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)this.getTargetUserPK().toString()));
        userInfo.setNumber(this.targetUser.getNumber());
        FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
        fullOrgUnitInfo.setId(this.getSelectedOrgID());
        fullOrgUnitInfo.setNumber(this.getSelectedOrgNumber());
        Object object = this.treeAuthorizedPerm.getModel().getRoot();
        if (object != null) {
            KDTreeNode rootAuthorization = (KDTreeNode)object;
            Enumeration enumAuthorization = rootAuthorization.breadthFirstEnumeration();
            while (enumAuthorization.hasMoreElements()) {
                treeNode = (KDTreeNode)enumAuthorization.nextElement();
                userOrgPermInfo = (UserOrgPermInfo)treeNode.getUserObject();
                if (!userOrgPermInfo.getPermItem().isIsLeaf()) continue;
                userOrgPermInfo.setOwner(userInfo);
                userOrgPermInfo.setPermType(PermType.AUTHORIZATION);
                userOrgPermInfo.setOrg(fullOrgUnitInfo);
                userOrgPermInfo.setCtrlUnit(this.getCurrentCU());
                userOrgPerms.add(userOrgPermInfo);
            }
        }
        if ((object = this.treeNormalPerm.getModel().getRoot()) != null) {
            KDTreeNode rootAccredit = (KDTreeNode)object;
            Enumeration enumAccredit = rootAccredit.breadthFirstEnumeration();
            while (enumAccredit.hasMoreElements()) {
                treeNode = (KDTreeNode)enumAccredit.nextElement();
                userOrgPermInfo = (UserOrgPermInfo)treeNode.getUserObject();
                if (!userOrgPermInfo.getPermItem().isIsLeaf()) continue;
                userOrgPermInfo.setOwner(userInfo);
                userOrgPermInfo.setPermType(PermType.NORMAL);
                userOrgPermInfo.setOrg(fullOrgUnitInfo);
                userOrgPermInfo.setCtrlUnit(this.getCurrentCU());
                userOrgPerms.add(userOrgPermInfo);
            }
        }
        if ((object = this.treeForbiddenPerm.getModel().getRoot()) != null) {
            KDTreeNode rootForbidden = (KDTreeNode)object;
            Enumeration enumForbidden = rootForbidden.breadthFirstEnumeration();
            while (enumForbidden.hasMoreElements()) {
                treeNode = (KDTreeNode)enumForbidden.nextElement();
                userOrgPermInfo = (UserOrgPermInfo)treeNode.getUserObject();
                if (!userOrgPermInfo.getPermItem().isIsLeaf()) continue;
                userOrgPermInfo.setOwner(userInfo);
                userOrgPermInfo.setPermType(PermType.FORBIDDEN);
                userOrgPermInfo.setOrg(fullOrgUnitInfo);
                userOrgPermInfo.setCtrlUnit(this.getCurrentCU());
                userOrgPerms.add(userOrgPermInfo);
            }
        }
        return userOrgPerms;
    }

    private boolean isRuleChanged(String ruleA, String ruleB) {
        if (StringUtils.isEmpty((String)ruleA) || StringUtils.isEmpty((String)ruleB)) {
            return !StringUtils.isEmpty((String)ruleA) || !StringUtils.isEmpty((String)ruleB);
        }
        return !ruleA.equals(ruleB);
    }

    private UserOrgPermCollection[] getUOPReuslts() {
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        UserOrgPermCollection[] results = new UserOrgPermCollection[3];
        UserOrgPermCollection newUOPs = this.getCurrentUOPs();
        UserOrgPermCollection oldUOPs = this.uopsCopy;
        UserOrgPermCollection addUOPs = new UserOrgPermCollection();
        UserOrgPermCollection delUOPs = new UserOrgPermCollection();
        UserOrgPermCollection updateUOPs = new UserOrgPermCollection();
        beginTime = lowTimer.msValue();
        Map mapOldUOP = this.createUOPMap(oldUOPs);
        endTime = lowTimer.msValue();
        logger.debug((Object)("createUOPMap  " + (endTime - beginTime)));
        int size = newUOPs.size();
        for (int i = 0; i < size; ++i) {
            String key = PermissionCommonUtil.getKey(newUOPs.get(i));
            if (mapOldUOP.containsKey(key)) {
                UserOrgPermInfo oldUOP = (UserOrgPermInfo)mapOldUOP.get(key);
                UserOrgPermInfo newUOP = newUOPs.get(i);
                if (!this.isRuleChanged(oldUOP.getRuleStructure(), newUOP.getRuleStructure())) continue;
                newUOPs.get(i).setId(oldUOP.getId());
                updateUOPs.add(newUOPs.get(i));
                continue;
            }
            addUOPs.add(newUOPs.get(i));
        }
        Map mapNewUOP = this.createUOPMap(newUOPs);
        int size2 = oldUOPs.size();
        for (int i = 0; i < size2; ++i) {
            String key = PermissionCommonUtil.getKey(oldUOPs.get(i));
            if (mapNewUOP.containsKey(key)) continue;
            delUOPs.add(oldUOPs.get(i));
        }
        results[0] = addUOPs;
        results[1] = delUOPs;
        results[2] = updateUOPs;
        return results;
    }

    private Map createUOPMap(UserOrgPermCollection collection) {
        HashMap<String, UserOrgPermInfo> map = new HashMap<String, UserOrgPermInfo>();
        if (collection != null) {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                map.put(PermissionCommonUtil.getKey(collection.get(i)), collection.get(i));
            }
        }
        return map;
    }

    @Override
    public RequestContext prepareActionSubmit(IItemAction itemAction) throws Exception {
        RequestContext request = new RequestContext();
        if (request != null) {
            request.setClassName(this.getUIHandlerClassName());
            UserOrgPermCollection[] results = this.getUOPReuslts();
            request.put("results", (Object)results);
        }
        return request;
    }

    @Override
    public boolean isPrepareActionSubmit() {
        return false;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.getSelectedOrgPK() != null) {
            this.checkCurrentNodeRule();
            this.save();
            UITools.showMsg(this, EASResource.getString((String)RESOURCE, (String)"accreditPermSucceed"), false);
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"orgIsNotSelected"));
        }
    }

    private void save() throws Exception {
        Object obj;
        if (this.execSave) {
            SysUtil.abort();
        }
        if ((obj = this.treeNormalPerm.getLastSelectedPathComponent()) != null) {
            this.storeRule((KDTreeNode)obj);
        }
        UserOrgPermCollection[] results = this.getUICurrentUOPs();
        ArrayList<String> permIdList = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            UserOrgPermCollection userOrgPermCollections = results[i];
            if (userOrgPermCollections == null || userOrgPermCollections.isEmpty()) continue;
            for (int j = 0; j < userOrgPermCollections.size(); ++j) {
                permIdList.add(userOrgPermCollections.get(j).getPermItemId());
            }
        }
        boolean isEnabledAuthen = AuthenModeFactory.getRemoteInstance().isEnablePermAuthen(permIdList, ToolUtils.orgCol2List(this.orgCol));
        if (isEnabledAuthen && this.isModified) {
            String msg;
            boolean isIncludeAuthenPerms = false;
            UserOrgPermCollection oldUOPs = UserOrgPermFacadeFactory.getRemoteInstance().getAllTargetUOPs(this.sourceUserPK, this.targetUserPK, this.orgCol, 0);
            UserOrgPermCollection[] operations = UserOrgPermFacadeFactory.getRemoteInstance().getAllUopResults(this.sourceUserPK, this.targetUserPK, this.orgCol, results, oldUOPs);
            for (int i = 0; i < operations.length && !(isIncludeAuthenPerms = PermissionUtils.isIncludeAuthenPerms(operations[i])); ++i) {
            }
            if (isIncludeAuthenPerms && MsgBox.showConfirm2((Component)((Object)this), (String)(msg = MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"USER_WILL_NEED_AUTHEN"), this.getTargetUser().getNumber()))) == 2) {
                SysUtil.abort();
            }
        }
        this.execSave = true;
        IUserOrgPermFacade iuopFacade = UserOrgPermFacadeFactory.getRemoteInstance();
        LogProxy logProxy = new LogProxy();
        Thread beginThread = new Thread(new BeginLogThread(logProxy, results));
        beginThread.start();
        this.sourceUserPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        this.targetUserPK = this.getTargetUserPK();
        this.orgCol = this.getOrgCol();
        iuopFacade.saveUserOrgPerms(this.sourceUserPK, this.targetUserPK, this.orgCol, results, isEnabledAuthen);
        this.targetUOPsSet = new Set[3];
        Thread endThread = new Thread(new EndLogThread(logProxy));
        endThread.start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UserAccreditUI.this.reloadUI();
                }
                catch (Exception e) {
                    UserAccreditUI.this.handUIException(e);
                }
            }
        });
        this.isModified = false;
        this.execSave = false;
    }

    private FullOrgUnitCollection getOrgCol() throws BOSException {
        FullOrgUnitCollection ret = null;
        ArrayList<BOSUuid> orgList = new ArrayList<BOSUuid>();
        orgList.add(this.getSelectedOrgInfo().getId());
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ToolUtils.aryToStr(orgList, false), CompareType.INCLUDE));
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("id"));
        selectorCol.add(new SelectorItemInfo("isUnion"));
        selectorCol.add(new SelectorItemInfo("orgtypestr"));
        selectorCol.add(new SelectorItemInfo("name"));
        selectorCol.add(new SelectorItemInfo("displayName"));
        entityViewInfo.setSelector(selectorCol);
        entityViewInfo.setFilter(filterInfo);
        ret = iFullOrgUnit.getFullOrgUnitCollection(entityViewInfo);
        return ret;
    }

    private String getSaveOrgPermLogDetail(UserOrgPermCollection[] results) {
        if (results == null || results.length == 0) {
            logger.info((Object)"results is null or length is 0");
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        Locale locale = SysContext.getSysContext().getLocale();
        sb.append(LogNamesHelper.getLogName("userNumber4Log", locale)).append(":").append(this.getTargetUser().getNumber()).append("\n ").append(LogNamesHelper.getLogName("orgNumber4Log", locale)).append(":").append(this.getSelectedOrgNumber());
        sb.append("\n " + LogNamesHelper.getLogName("permName4Log", locale) + " {");
        for (int k = 0; k < results.length; ++k) {
            UserOrgPermCollection perms = results[k];
            int size = perms.size();
            for (int i = 0; i < size; ++i) {
                sb.append("\n [").append(LogNamesHelper.getLogName("permName4Log", locale) + ":").append(perms.get(i).getPermItem().getAlias()).append(",");
                sb.append("," + LogNamesHelper.getLogName("permType4Log", locale) + ":").append(perms.get(i).getPermType().getAlias()).append("]");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private synchronized UserOrgPermCollection[] getUICurrentUOPs() {
        UserOrgPermCollection[] results = new UserOrgPermCollection[3];
        IObjectPK targetOrgPK = this.getSelectedOrgPK();
        this.targetUserPK = this.getTargetUserPK();
        UserOrgPermCollection a_userOrgPerms = this.treeHelper.getUserOrgPermFromTree(this.treeAuthorizedPerm, this.targetUserPK, targetOrgPK, PermType.AUTHORIZATION);
        UserOrgPermCollection n_userOrgPerms = this.treeHelper.getUserOrgPermFromTree(this.treeNormalPerm, this.targetUserPK, targetOrgPK, PermType.NORMAL);
        UserOrgPermCollection f_userOrgPerms = this.treeHelper.getUserOrgPermFromTree(this.treeForbiddenPerm, this.targetUserPK, targetOrgPK, PermType.FORBIDDEN);
        results[0] = a_userOrgPerms;
        results[1] = n_userOrgPerms;
        results[2] = f_userOrgPerms;
        return results;
    }

    private boolean permChanged(UserOrgPermCollection[] results) {
        assert (results != null);
        int length = results.length;
        for (int i = 0; i < length; ++i) {
            if (results[i].size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionShowRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionShowRule_actionPerformed(e);
        this.isShowRule = true;
        this.showRulePanel(this.isShowRule);
        this.rulePanel.refresh();
        this.isModified = true;
    }

    @Override
    public void actionHideRule_actionPerformed(ActionEvent e) throws Exception {
        super.actionHideRule_actionPerformed(e);
        this.isShowRule = false;
        this.showRulePanel(this.isShowRule);
        this.rulePanel.refresh();
    }

    @Override
    public void actionDiscretePerm_actionPerformed(ActionEvent e) throws Exception {
        BOSObjectType objectType;
        Object obj = this.treeNormalPerm.getLastSelectedPathComponent();
        if (obj != null && (objectType = this.getRuleObjectType((KDTreeNode)obj)) != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"bosObjectType", (Object)objectType);
            uiContext.put((Object)"targetUserPK", (Object)this.getTargetUserPK());
            uiContext.put((Object)"targetOrgPK", (Object)(this.getSelectedOrgID() == null ? null : new ObjectUuidPK(this.getSelectedOrgID())));
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserDiscretePermViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            window.show();
        }
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        TreePath[] treePaths = this.treeSourcePerm.getSelectionPaths();
        if (treePaths != null) {
            int length = treePaths.length;
            KDTreeNode[] treeNodes = new KDTreeNode[length];
            for (int i = 0; i < length; ++i) {
                treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
            }
            Set extendedNodes = this.treeHelper.getExpendedNodes(this.treeSourcePerm);
            if (this.curTabPage == 0) {
                this.treeHelper.addNodes(this.treeAuthorizedPerm, treeNodes, extendedNodes);
                this.treeHelper.setDefaultIcon((KDTreeNode)this.treeAuthorizedPerm.getModel().getRoot());
            } else if (this.curTabPage == 1) {
                this.treeHelper.addNodes(this.treeNormalPerm, treeNodes, extendedNodes);
                this.treeHelper.setDataRuleIcon((KDTreeNode)this.treeNormalPerm.getModel().getRoot());
            } else if (this.curTabPage == 2) {
                this.treeHelper.addNodes(this.treeForbiddenPerm, treeNodes, extendedNodes);
                this.treeHelper.setForbiddenIcon((KDTreeNode)this.treeForbiddenPerm.getModel().getRoot());
            }
        }
        this.isModified = true;
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddAll_actionPerformed(e);
        Object object = this.treeSourcePerm.getModel().getRoot();
        if (object != null && object instanceof KDTreeNode) {
            Set extendedNodes = this.treeHelper.getExpendedNodes(this.treeSourcePerm);
            if (this.curTabPage == 0) {
                this.treeHelper.addNodes(this.treeAuthorizedPerm, new KDTreeNode[]{(KDTreeNode)object}, extendedNodes);
                this.treeHelper.setDefaultIcon((KDTreeNode)this.treeNormalPerm.getModel().getRoot());
            } else if (this.curTabPage == 1) {
                this.treeHelper.addNodes(this.treeNormalPerm, new KDTreeNode[]{(KDTreeNode)object}, extendedNodes);
                this.treeHelper.setDataRuleIcon((KDTreeNode)this.treeNormalPerm.getModel().getRoot());
            } else if (this.curTabPage == 2) {
                this.treeHelper.addNodes(this.treeForbiddenPerm, new KDTreeNode[]{(KDTreeNode)object}, extendedNodes);
                this.treeHelper.setForbiddenIcon((KDTreeNode)this.treeForbiddenPerm.getModel().getRoot());
            }
        }
        this.isModified = true;
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        TreePath[] treePaths = null;
        if (this.curTabPage == 0) {
            treePaths = this.treeAuthorizedPerm.getSelectionPaths();
            if (treePaths != null) {
                int length = treePaths.length;
                KDTreeNode[] treeNodes = new KDTreeNode[length];
                for (int i = 0; i < length; ++i) {
                    treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
                }
                this.treeHelper.removeNodes(this.treeAuthorizedPerm, treeNodes);
            }
        } else if (this.curTabPage == 1) {
            treePaths = this.treeNormalPerm.getSelectionPaths();
            if (treePaths != null) {
                int length = treePaths.length;
                KDTreeNode[] treeNodes = new KDTreeNode[length];
                for (int i = 0; i < length; ++i) {
                    treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
                }
                this.treeHelper.removeNodes(this.treeNormalPerm, treeNodes);
                this.processRulePanel();
            }
        } else if (this.curTabPage == 2 && (treePaths = this.treeForbiddenPerm.getSelectionPaths()) != null) {
            int length = treePaths.length;
            KDTreeNode[] treeNodes = new KDTreeNode[length];
            for (int i = 0; i < length; ++i) {
                treeNodes[i] = (KDTreeNode)treePaths[i].getLastPathComponent();
            }
            this.treeHelper.removeNodes(this.treeForbiddenPerm, treeNodes);
        }
        this.isModified = true;
    }

    private void processRulePanel() {
        if (this.treeNormalPerm == null || this.treeNormalPerm.getLastSelectedPathComponent() == null) {
            this.rulePanel.reset();
        }
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteAll_actionPerformed(e);
        KDTreeNode object = null;
        if (this.curTabPage == 0) {
            object = (KDTreeNode)this.treeAuthorizedPerm.getModel().getRoot();
            if (object != null) {
                KDTreeNode[] treeNodes = new KDTreeNode[]{object};
                this.treeHelper.removeNodes(this.treeAuthorizedPerm, treeNodes);
            }
        } else if (this.curTabPage == 1) {
            object = (KDTreeNode)this.treeNormalPerm.getModel().getRoot();
            if (object != null) {
                KDTreeNode[] treeNodes = new KDTreeNode[]{object};
                this.treeHelper.removeNodes(this.treeNormalPerm, treeNodes);
                this.processRulePanel();
            }
        } else if (this.curTabPage == 2 && (object = (KDTreeNode)this.treeForbiddenPerm.getModel().getRoot()) != null) {
            KDTreeNode[] treeNodes = new KDTreeNode[]{object};
            this.treeHelper.removeNodes(this.treeForbiddenPerm, treeNodes);
        }
        this.isModified = true;
    }

    private FullOrgUnitInfo getSelectedOrgInfo() {
        if (this.pmtOrg.getData() == null) {
            return null;
        }
        if (this.pmtOrg.getData() instanceof FullOrgUnitInfo) {
            return (FullOrgUnitInfo)this.pmtOrg.getData();
        }
        return null;
    }

    private IObjectPK getSelectedOrgPK() {
        if (this.getSelectedOrgInfo() == null) {
            return null;
        }
        return new ObjectUuidPK(this.getSelectedOrgInfo().getId());
    }

    private BOSUuid getSelectedOrgID() {
        if (this.getSelectedOrgInfo() == null) {
            return null;
        }
        return this.getSelectedOrgInfo().getId();
    }

    public String getSelectedOrgNumber() {
        if (this.getSelectedOrgInfo() == null) {
            return null;
        }
        return this.getSelectedOrgInfo().getNumber();
    }

    private IObjectPK getTargetUserPK() {
        return new ObjectUuidPK((String)this.getUIContext().get("targetID"));
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(this.getCurrentUser().getId());
    }

    private UserOrgPermCollection getUOPByPermType(PermType permType) {
        UserOrgPermCollection result = new UserOrgPermCollection();
        if (this.uopsCopy != null) {
            int size = this.uopsCopy.size();
            for (int i = 0; i < size; ++i) {
                UserOrgPermInfo info = this.uopsCopy.get(i);
                if (!permType.equals((Object)info.getPermType())) continue;
                result.add(info);
            }
        }
        return result;
    }

    private boolean isModify() {
        return this.isChanged((KDTreeNode)this.treeAuthorizedPerm.getModel().getRoot(), this.getUOPByPermType(PermType.AUTHORIZATION)) || this.isChanged((KDTreeNode)this.treeNormalPerm.getModel().getRoot(), this.getUOPByPermType(PermType.NORMAL)) || this.isChanged((KDTreeNode)this.treeForbiddenPerm.getModel().getRoot(), this.getUOPByPermType(PermType.FORBIDDEN));
    }

    private boolean isChanged(KDTreeNode node, UserOrgPermCollection uops) {
        if (node == null || uops == null || uops.size() == 0) {
            return node != null || uops != null && uops.size() != 0;
        }
        HashMap<BOSUuid, UserOrgPermInfo> mapUOP = new HashMap<BOSUuid, UserOrgPermInfo>(1000);
        int size = uops.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo info = uops.get(i);
            mapUOP.put(info.getPermItem().getId(), info);
        }
        Enumeration enumeration = node.breadthFirstEnumeration();
        int count = 0;
        while (enumeration.hasMoreElements()) {
            KDTreeNode temp = (KDTreeNode)enumeration.nextElement();
            if (!temp.isLeaf()) continue;
            ++count;
            UserOrgPermInfo info = (UserOrgPermInfo)temp.getUserObject();
            if (mapUOP.containsKey(info.getPermItem().getId())) {
                if (this.equalsBySimple(info, (UserOrgPermInfo)mapUOP.get(info.getPermItem().getId()))) continue;
                return true;
            }
            return true;
        }
        return uops.size() != count;
    }

    private boolean equalsBySimple(UserOrgPermInfo userOrgPermA, UserOrgPermInfo userOrgPermB) {
        return !(userOrgPermA == null || userOrgPermB == null ? userOrgPermA != null || userOrgPermB != null : (StringUtils.isEmpty((String)userOrgPermA.getRuleExpr()) || StringUtils.isEmpty((String)userOrgPermB.getRuleExpr()) ? !StringUtils.isEmpty((String)userOrgPermA.getRuleExpr()) || !StringUtils.isEmpty((String)userOrgPermB.getRuleExpr()) : !userOrgPermA.getRuleExpr().equals(userOrgPermB.getRuleExpr())));
    }

    private UserInfo getUserInfo(IObjectPK userPK) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bizAdmin"));
        sic.add(new SelectorItemInfo("defOrgUnit.id"));
        sic.add(new SelectorItemInfo("defOrgUnit.number"));
        sic.add(new SelectorItemInfo("defOrgUnit.name"));
        sic.add(new SelectorItemInfo("defOrgUnit.CU.id"));
        sic.add(new SelectorItemInfo("type"));
        IUser iUser = UserFactory.getRemoteInstance();
        return iUser.getUserInfo(userPK, sic);
    }

    private String getRuleStructure() throws EASBizException, ParserException, BOSException {
        return this.getRulePanel().getRuleStructure();
    }

    private void storeRule(KDTreeNode node) throws Exception {
        UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
        if (info.getPermItem().isIsLeaf()) {
            if (!StringUtils.isEmpty((String)info.getPermItem().getObjectType()) && info.getPermItem().isEnableDataPermission()) {
                String ruleStructure = this.getRuleStructure();
                info.setRuleStructure(ruleStructure);
                EntityObjectInfo entity = this.getEntity(BOSObjectType.create((String)info.getPermItem().getObjectType()));
                RuleParser ruleParser = new RuleParser(entity);
                ruleParser.setRuleStructure(ruleStructure);
                if (!StringUtils.isEmpty((String)ruleParser.buildExpr())) {
                    info.setRuleExpr(ruleParser.buildExpr());
                } else {
                    info.setRuleExpr(null);
                }
            }
        } else if (this.enableDataPermission(node)) {
            BOSObjectType objectType = this.getRuleObjectType(node);
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                String ruleStructure;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf()) continue;
                UserOrgPermInfo infoChild = (UserOrgPermInfo)child.getUserObject();
                if (!objectType.toString().equals(infoChild.getPermItem().getObjectType()) || StringUtils.isEmpty((String)(ruleStructure = this.getRuleStructure()))) continue;
                infoChild.setRuleStructure(ruleStructure);
                EntityObjectInfo entity = this.getEntity(objectType);
                RuleParser ruleParser = new RuleParser(entity);
                ruleParser.setRuleStructure(ruleStructure);
                infoChild.setRuleExpr(ruleParser.buildExpr());
            }
        }
    }

    private EntityObjectInfo getEntity(BOSObjectType objectType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getEntity(objectType);
    }

    private void loadRule(KDTreeNode node) throws EASBizException, ParserException, BOSException {
        if (node == null) {
            this.rulePanel.reset();
        } else {
            UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
            if (info.getPermItem().isIsLeaf() && !StringUtils.isEmpty((String)info.getPermItem().getObjectType()) && info.getPermItem().isEnableDataPermission()) {
                this.rulePanel.setBizObjectType(BOSObjectType.create((String)info.getPermItem().getObjectType()));
                String ruleStructure = info.getRuleStructure();
                this.rulePanel.setRuleStructure(ruleStructure);
                this.rulePanel.refresh();
            } else if (this.canBindRule(node)) {
                this.rulePanel.reset();
                this.rulePanel.setBizObjectType(this.getRuleObjectType(node));
            } else {
                this.rulePanel.reset();
            }
        }
    }

    @Override
    protected void treeNormalPerm_valueChanged(TreeSelectionEvent e) throws Exception {
        KDTreeNode oldNode;
        Object old;
        if (!this.isInitOver) {
            return;
        }
        this.btnDiscretePerm.setVisible(false);
        if (e.getOldLeadSelectionPath() != null && (old = e.getOldLeadSelectionPath().getLastPathComponent()) != null && this.canBindRule(oldNode = (KDTreeNode)old) && !this.rulePanel.verify()) {
            this.loadRule(oldNode);
            this.treeNormalPerm.setSelectionPath(e.getOldLeadSelectionPath());
        }
        super.treeNormalPerm_valueChanged(e);
        if (e.getOldLeadSelectionPath() != null && (old = e.getOldLeadSelectionPath().getLastPathComponent()) != null) {
            this.storeRule((KDTreeNode)old);
        }
        if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null) {
            this.loadRule((KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent());
        }
        this.setDiscreteButtonStatus(e);
        this.setRulePanelStatus();
        this.addPopMenuExtendFunc(e);
    }

    private void addPopMenuExtendFunc(TreeSelectionEvent e) {
        if (this.popMenuHelper == null) {
            this.popMenuHelper = new PopMenuHelper(this, this.treeNormalPerm);
        }
        PopMenuPerformContext ctx = new PopMenuPerformContext();
        ctx.setTreeSelectEvent(e);
        ctx.setUiObject((IUIObject)this);
        ctx.setTargetUser(this.targetUser);
        ctx.setTargetOrgUnit((FullOrgUnitInfo)this.pmtOrg.getData());
        this.popMenuHelper.dealPopMenu(ctx);
    }

    private boolean enableDataPermission(KDTreeNode node) {
        if (node.isLeaf()) {
            UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
            String objectType = info.getPermItem().getObjectType();
            if (!StringUtils.isEmpty((String)objectType) && info.getPermItem().isEnableDataPermission()) {
                return true;
            }
        } else {
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                UserOrgPermInfo info;
                String objectType;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf() || StringUtils.isEmpty((String)(objectType = (info = (UserOrgPermInfo)child.getUserObject()).getPermItem().getObjectType())) || !info.getPermItem().isEnableDataPermission()) continue;
                return true;
            }
        }
        return false;
    }

    private void setDiscreteButtonStatus(TreeSelectionEvent e) {
        BOSObjectType objectType;
        KDTreeNode node;
        Object old;
        if (e.getNewLeadSelectionPath() != null && (old = e.getNewLeadSelectionPath().getLastPathComponent()) != null && this.enableDataPermission(node = (KDTreeNode)old) && (objectType = this.getRuleObjectType(node)) != null) {
            this.btnDiscretePerm.setVisible(this.configurationInfo.getDiscretEntityTables().containsKey(objectType.toString()));
            return;
        }
        this.btnDiscretePerm.setVisible(false);
    }

    private void checkCurrentNodeRule() throws EASBizException, ParserException, BOSException {
        KDTreeNode node;
        Object object;
        if (this.treeNormalPerm.getSelectionPath() != null && (object = this.treeNormalPerm.getSelectionPath().getLastPathComponent()) != null && this.canBindRule(node = (KDTreeNode)object) && !this.rulePanel.verify()) {
            this.abort();
        }
    }

    private boolean needRule() {
        return this.rulePanel.getBizObjectType() != null;
    }

    private boolean canBindRule(KDTreeNode node) {
        if (node.isLeaf()) {
            UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
            return !StringUtils.isEmpty((String)info.getPermItem().getObjectType()) && info.getPermItem().isEnableDataPermission();
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            KDTreeNode child = (KDTreeNode)node.getChildAt(i);
            if (child.isLeaf()) {
                UserOrgPermInfo info = (UserOrgPermInfo)child.getUserObject();
                if (StringUtils.isEmpty((String)info.getPermItem().getObjectType()) || !info.getPermItem().isEnableDataPermission()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private BOSObjectType getRuleObjectType(KDTreeNode node) {
        if (node.isLeaf()) {
            UserOrgPermInfo info = (UserOrgPermInfo)node.getUserObject();
            String objectType = info.getPermItem().getObjectType();
            if (!StringUtils.isEmpty((String)objectType)) {
                return BOSObjectType.create((String)objectType);
            }
        } else {
            int size = node.getChildCount();
            for (int i = 0; i < size; ++i) {
                UserOrgPermInfo info;
                String objectType;
                KDTreeNode child = (KDTreeNode)node.getChildAt(i);
                if (!child.isLeaf() || StringUtils.isEmpty((String)(objectType = (info = (UserOrgPermInfo)child.getUserObject()).getPermItem().getObjectType()))) continue;
                return BOSObjectType.create((String)objectType);
            }
        }
        return null;
    }

    @Override
    protected void tabAssign_stateChanged(ChangeEvent e) throws Exception {
        if (!this.isInitOver) {
            return;
        }
        super.tabAssign_stateChanged(e);
        this.curTabPage = this.tabAssign.getSelectedIndex();
        if (this.rulePanel != null) {
            if (this.curTabPage == 0) {
                if (this.isShowRule) {
                    this.showRulePanel(false);
                }
                this.btnShowRule.setVisible(false);
                this.btnHideRule.setVisible(false);
            } else if (this.curTabPage == 1) {
                this.btnShowRule.setVisible(!this.isShowRule);
                this.btnHideRule.setVisible(this.isShowRule);
                if (this.isShowRule) {
                    this.showRulePanel(this.isShowRule);
                }
            } else if (this.curTabPage == 2) {
                if (this.isShowRule) {
                    this.showRulePanel(false);
                }
                this.btnShowRule.setVisible(false);
                this.btnHideRule.setVisible(false);
            }
            this.getAllPathTargetUOPs();
            this.treeHelper.buildTopSourceTree(this.treeSourcePerm, (IObjectCollection)this.userOrgPerms, this.targetUOPs);
        }
    }

    private void decorateSourceTree() throws EASBizException, BOSException {
        Thread thread = new Thread(){

            @Override
            public void run() {
                LowTimer lowTimer = new LowTimer();
                float beginTime = lowTimer.msValue();
                float endTime = lowTimer.msValue();
                try {
                    4.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (UserAccreditUI.this.treeSourcePerm != null && UserAccreditUI.this.treeSourcePerm.getModel() != null && UserAccreditUI.this.treeSourcePerm.getModel().getRoot() != null) {
                    try {
                        IPermissionManager iPermissionManager = PermissionManagerFactory.getRemoteInstance();
                        UserOrgPermCollection uops = (UserOrgPermCollection)iPermissionManager.getAllPerms(UserAccreditUI.this.getTargetUserPK(), UserAccreditUI.this.getSelectedOrgPK());
                        HashSet<BOSUuid> setUOPs = new HashSet<BOSUuid>();
                        int size = uops.size();
                        for (int i = 0; i < size; ++i) {
                            setUOPs.add(uops.get(i).getPermItem().getId());
                        }
                        Enumeration enumeration = ((KDTreeNode)UserAccreditUI.this.treeSourcePerm.getModel().getRoot()).breadthFirstEnumeration();
                        while (enumeration.hasMoreElements()) {
                            UserOrgPermInfo uop;
                            KDTreeNode node = (KDTreeNode)enumeration.nextElement();
                            UserAccreditUI.this.builder.setDefaultIcon(node);
                            if (!node.isLeaf() || !setUOPs.contains((uop = (UserOrgPermInfo)node.getUserObject()).getPermItem().getId())) continue;
                            UserAccreditUI.this.builder.setAdviceIcon(node);
                        }
                        UserAccreditUI.this.treeSourcePerm.repaint();
                        endTime = lowTimer.msValue();
                        logger.debug((Object)("decorateSourceTree()  " + (endTime - beginTime)));
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                    }
                }
            }
        };
        thread.start();
        logger.debug((Object)"decorateSourceTree' thread start.");
    }

    @Override
    public boolean isPrepareActionFieldAccessAccredit() {
        return true;
    }

    @Override
    public RequestContext prepareActionFieldAccessAccredit(IItemAction itemAction) throws Exception {
        return super.prepareActionFieldAccessAccredit(itemAction);
    }

    @Override
    public void actionFieldAccessAccredit_actionPerformed(ActionEvent e) throws Exception {
        super.actionFieldAccessAccredit_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"userPK", (Object)this.getTargetUserPK());
        uiContext.put((Object)"orgPK", (Object)this.getSelectedOrgPK());
        uiContext.put((Object)"targetUserInfo", (Object)this.getTargetUser());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserFieldAccessAccreditUI.class.getName(), (Map)uiContext, null, null);
        window.show();
    }

    @Override
    public RulePanel getRulePanel() {
        return this.rulePanel;
    }

    public UserInfo getTargetUser() {
        return this.targetUser;
    }

    @Override
    protected void treeNormalPerm_mouseClicked(MouseEvent e) throws Exception {
        super.treeNormalPerm_mouseClicked(e);
    }

    public boolean destroyWindow() {
        boolean ret = true;
        try {
            if (this.isModified) {
                ret = this.alertSave(null);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (ret) {
            return super.destroyWindow();
        }
        return false;
    }

    private void initTargetTree() {
        this.treeAuthorizedPerm.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode curNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (curNode == null) {
                    return;
                }
                try {
                    UserAccreditUI.this.buildLevelTargetTree(curNode, 30);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
        this.treeNormalPerm.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode curNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (curNode == null) {
                    return;
                }
                try {
                    UserAccreditUI.this.buildLevelTargetTree(curNode, 10);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
        this.treeForbiddenPerm.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTreeNode curNode = (KDTreeNode)event.getPath().getLastPathComponent();
                if (curNode == null) {
                    return;
                }
                try {
                    UserAccreditUI.this.buildLevelTargetTree(curNode, 20);
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
    }

    private void buildLevelTargetTree(KDTreeNode parent, int permType) throws Exception {
        if (parent == null || this.treeHelper.isLeaf(parent) || this.treeHelper.isExpended(parent)) {
            return;
        }
        IUserOrgPermFacade iuopFacade = UserOrgPermFacadeFactory.getRemoteInstance();
        PermItemInfo parentPerm = this.treeHelper.getPermItem(parent);
        UserOrgPermCollection userOrgPerms = null;
        boolean sourceFlag = false;
        if (this.treeHelper.isSourceFlag(parent)) {
            userOrgPerms = iuopFacade.getLevelSourceUOPs(this.sourceUserPK, this.targetUserPK, this.orgCol, parentPerm, false, this.curTabPage == 0 ? 30 : -1);
            sourceFlag = true;
        } else if (this.targetUOPs != null && this.treeHelper.contains(this.targetUOPs, parentPerm.getLongNumber())) {
            userOrgPerms = iuopFacade.getLevelTargetUOPs(this.sourceUserPK, this.targetUserPK, this.orgCol, parentPerm, permType);
        }
        this.treeHelper.buildLevelTargetTree(parent, (IObjectCollection)userOrgPerms, permType, sourceFlag);
    }

    private class BeginLogThread
    implements Runnable {
        private LogProxy logProxy;
        private UserOrgPermCollection[] results;

        public BeginLogThread(LogProxy logProxy, UserOrgPermCollection[] results) {
            this.logProxy = logProxy;
            this.results = results;
        }

        @Override
        public void run() {
            try {
                this.logProxy.beginLog(null, "saveUserOrgPerms", UserOrgPermFacadeFactory.getRemoteInstance().getType(), null, UserAccreditUI.this.getSaveOrgPermLogDetail(this.results));
            }
            catch (BOSException e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
    }

    private class EndLogThread
    implements Runnable {
        private LogProxy logProxy;

        public EndLogThread(LogProxy logProxy) {
            this.logProxy = logProxy;
        }

        @Override
        public void run() {
            while (true) {
                if (this.logProxy != null && this.logProxy.getLogPK() != null && !StringUtils.isEmpty((String)this.logProxy.getLogPK().toString())) {
                    this.logProxy.end();
                    return;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.error((Object)e);
                    continue;
                }
                break;
            }
        }
    }
}

