/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.SecurityException;
import com.kingdee.eas.base.permission.WeakPwLibCollection;
import com.kingdee.eas.base.permission.WeakPwLibFactory;
import com.kingdee.eas.base.permission.WeakPwLibInfo;
import com.kingdee.eas.base.permission.client.AbstractWeakPwLibListUI;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class WeakPwLibListUI
extends AbstractWeakPwLibListUI {
    private static final Logger logger = CoreUIObject.getLogger(WeakPwLibListUI.class);
    private static int MAX_WEAK_PW_COUNT = 50;
    private static int MAX_WEAK_PW_LENGTH = 80;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tlbMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    WeakPwLibListUI.this.loadTlbData();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    private void loadTlbData() throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SorterItemCollection sorterItemColl = new SorterItemCollection();
        sorterItemColl.add(new SorterItemInfo("password"));
        entityViewInfo.setSorter(sorterItemColl);
        WeakPwLibCollection weakPwLibColl = WeakPwLibFactory.getRemoteInstance().getWeakPwLibCollection(entityViewInfo);
        for (int i = 0; i < weakPwLibColl.size(); ++i) {
            WeakPwLibInfo weakPwLibInfo = weakPwLibColl.get(i);
            IRow irow = this.tlbMain.addRow();
            irow.getCell("id").setValue((Object)weakPwLibInfo.getId());
            irow.getCell("password").setValue((Object)weakPwLibInfo.getPassword());
        }
    }

    @Override
    protected void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.checkAddWeakPwLib();
        this.tlbMain.addRow();
    }

    @Override
    protected void actionDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tlbMain);
        if (selectedRows.length == 0) {
            return;
        }
        ArrayList<ObjectUuidPK> iObjId = new ArrayList<ObjectUuidPK>(selectedRows.length);
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            Object id = this.tlbMain.getRow(selectedRows[i]).getCell("id").getValue();
            if (id != null) {
                iObjId.add(new ObjectUuidPK(id.toString()));
            }
            this.tlbMain.removeRow(selectedRows[i]);
        }
        if (iObjId.size() > 0) {
            IObjectPK[] objectArr = new IObjectPK[iObjId.size()];
            for (int i = 0; i < iObjId.size(); ++i) {
                objectArr[i] = (IObjectPK)iObjId.get(i);
            }
            WeakPwLibFactory.getRemoteInstance().delete(objectArr);
        }
    }

    @Override
    protected void actionInsertRow_actionPerformed(ActionEvent e) throws Exception {
        this.checkAddWeakPwLib();
        int index = this.tlbMain.getSelectManager().getActiveRowIndex();
        this.tlbMain.addRow(index);
    }

    @Override
    protected void tlbMain_editDataStopped(KDTEditEvent e) throws Exception {
        Object oldValue = e.getOldValue();
        Object value = e.getValue();
        if (value == null || oldValue != null && oldValue.equals(value)) {
            return;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("password", value, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        int weakPwCount = WeakPwLibFactory.getRemoteInstance().getCount(entityViewInfo);
        if (weakPwCount > 0) {
            this.tlbMain.getRow(e.getRowIndex()).getCell("password").setValue((Object)"");
            throw new SecurityException(SecurityException.WEAK_PASSWORD_EXISTED);
        }
        WeakPwLibInfo weakPwLibInfo = new WeakPwLibInfo();
        if (((String)value).length() > MAX_WEAK_PW_LENGTH) {
            throw new SecurityException(SecurityException.WEAK_PASSWORD_LENGTH_LIMIT, new Object[]{MAX_WEAK_PW_LENGTH});
        }
        weakPwLibInfo.setPassword((String)value);
        Object pkId = this.tlbMain.getRow(e.getRowIndex()).getCell("id").getValue();
        if (pkId != null) {
            IObjectPK logpk = LogUtil.beginLog(null, (String)"updatePartial", (BOSObjectType)new WeakPwLibInfo().getBOSType(), null, (String)("\u4fee\u6539\u524d\uff1a" + oldValue + "   \u4fee\u6539\u540e\uff1a" + value), (String)"bs_permission_weakpwlib_update");
            weakPwLibInfo.setId(BOSUuid.read((String)pkId.toString()));
            SelectorItemCollection selectorItemColl = new SelectorItemCollection();
            selectorItemColl.add("password");
            WeakPwLibFactory.getRemoteInstance().updatePartial(weakPwLibInfo, selectorItemColl);
            LogUtil.afterLog(null, (IObjectPK)logpk);
        } else {
            IObjectPK logpk = LogUtil.beginLog(null, (String)"addnew", (BOSObjectType)new WeakPwLibInfo().getBOSType(), null, (String)value.toString(), (String)"bs_permission_weakpwlib_addnew");
            weakPwLibInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            IObjectPK id = WeakPwLibFactory.getRemoteInstance().addnew(weakPwLibInfo);
            this.tlbMain.getRow(e.getRowIndex()).getCell("id").setValue((Object)id.toString());
            LogUtil.afterLog(null, (IObjectPK)logpk);
        }
    }

    private void checkAddWeakPwLib() throws BOSException, SecurityException {
        if (this.tlbMain.getRowCount() >= MAX_WEAK_PW_COUNT) {
            throw new SecurityException(SecurityException.WEAK_PASSWORD_LIMIT, new Object[]{MAX_WEAK_PW_COUNT});
        }
        int weakPwCount = WeakPwLibFactory.getRemoteInstance().getCount(new EntityViewInfo());
        if (weakPwCount >= MAX_WEAK_PW_COUNT) {
            throw new SecurityException(SecurityException.WEAK_PASSWORD_LIMIT, new Object[]{MAX_WEAK_PW_COUNT});
        }
    }
}

