/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.machine;

import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.client.machine.HardwareInfoCollector;
import com.kingdee.eas.base.permission.client.machine.IMachineCode;
import com.kingdee.eas.base.permission.client.machine.MachineCodeUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class MachineCodeGenerator
implements IMachineCode {
    private static Logger logger = Logger.getLogger(MachineCodeGenerator.class);
    protected StringBuffer machineCode = new StringBuffer();
    private static IMachineCode machineCodeGenerator = null;
    private int iPolicy = 3;

    private MachineCodeGenerator() {
        String policy = PermissionCommonUtil.getMachineCodeGeneratorPolicy(null);
        try {
            this.iPolicy = Integer.parseInt(policy);
            if (this.iPolicy > 15 || this.iPolicy < 1) {
                this.iPolicy = 3;
            }
        }
        catch (NumberFormatException ex) {
            logger.error((Object)PermissionResUtil.getResource("res_82"), (Throwable)ex);
        }
    }

    public static IMachineCode getGenerator() {
        if (machineCodeGenerator == null) {
            machineCodeGenerator = new MachineCodeGenerator();
        }
        return machineCodeGenerator;
    }

    @Override
    public String getMachineCode() {
        StringBuffer machineCode = new StringBuffer();
        if (this.iPolicy == 2 || this.iPolicy == 4 || this.iPolicy == 6) {
            try {
                return MachineCodeUtil.getIpOrMacStr(this.iPolicy);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        if (this.iPolicy % 2 == 1) {
            try {
                machineCode.append(InetAddress.getLocalHost().getHostAddress()).append(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        if (this.iPolicy / 2 % 2 == 1) {
            machineCode.append(HardwareInfoCollector.getCollector().getMACAddress());
        }
        if (this.iPolicy / 4 % 2 == 1) {
            machineCode.append(HardwareInfoCollector.getCollector().getHardDriverID());
        }
        if (this.iPolicy / 8 % 2 == 1) {
            machineCode.append(HardwareInfoCollector.getCollector().getCPUID());
        }
        return machineCode.toString();
    }
}

