/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.plugin;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.AuthorizeTypeEnum;
import com.kingdee.eas.base.permission.DynamicCardException;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.PasswordAuthorizeInputUI;
import com.kingdee.eas.base.permission.client.plugin.IIdentityAuthorize;
import com.kingdee.eas.base.permission.client.util.CAIdentityAuthorize;
import com.kingdee.eas.base.permission.service.UsbKeyPermissionService;
import com.kingdee.eas.base.permission.service.helper.IPermissionParameter;
import com.kingdee.eas.base.permission.service.helper.PermissionParameterFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.SysUtil;
import java.awt.Window;
import java.util.Map;
import org.apache.log4j.Logger;

public class IdentityAuthorizeFactory {
    private static Logger logger = Logger.getLogger(IdentityAuthorizeFactory.class);

    public static IIdentityAuthorize getInstance(AuthorizeTypeEnum authorizeType) {
        IIdentityAuthorize authorize = null;
        switch (authorizeType.getValue()) {
            case 10: {
                authorize = new IIdentityAuthorize(){

                    @Override
                    public void checkIdentity(Window ownerUI, IObjectPK userPk) throws PermissionException {
                    }
                };
                break;
            }
            case 2: {
                authorize = new DynCardIdentityAuthorize();
                break;
            }
            case 1: {
                authorize = new UsbKeyIdentityAuthorize();
                break;
            }
            case 4: {
                authorize = new DynCardAndUsbKeyIdentityAuthorize();
                break;
            }
            case 3: {
                authorize = new UsbKeyAndDynCardIdentityAuthorize();
                break;
            }
            case 5: {
                authorize = new PasswordIdentityAuthorize();
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                authorize = new CAIdentityAuthorize();
            }
        }
        return authorize;
    }

    private static void checkUsbKeyPermission() throws PermissionException {
        UsbKeyPermissionService.checkUsbKeyInUse();
    }

    private static void checkPasswordPermission() throws PermissionException {
        UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
        if (currentUser == null) {
            return;
        }
        try {
            UIContext uiCtx = new UIContext();
            uiCtx.put((Object)"AuthorizeType", (Object)AuthorizeTypeEnum.pwdAuthor);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PasswordAuthorizeInputUI.class.getName(), (Map)uiCtx, null, OprtState.EDIT);
            PasswordAuthorizeInputUI passwordInputUI = (PasswordAuthorizeInputUI)uiWindow.getUIObject();
            uiWindow.show();
            if (!passwordInputUI.isLoginSuccessful()) {
                SysUtil.abort();
            }
        }
        catch (UIException e) {
            logger.error((Object)e);
        }
    }

    private static void checkDynPermission() throws DynamicCardException {
        UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
        if (currentUser == null) {
            return;
        }
        boolean isSame = currentUser.getLoginAuthorWay().equals((Object)LoginAuthorWayEnum.DYNAMIC);
        if (!isSame || isSame && IdentityAuthorizeFactory.isCheckForSameWay()) {
            try {
                UIContext uiCtx = new UIContext();
                uiCtx.put((Object)"AuthorizeType", (Object)AuthorizeTypeEnum.dynAuth);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PasswordAuthorizeInputUI.class.getName(), (Map)uiCtx, null, OprtState.EDIT);
                PasswordAuthorizeInputUI passwordInputUI = (PasswordAuthorizeInputUI)uiWindow.getUIObject();
                uiWindow.show();
                if (!passwordInputUI.isLoginSuccessful()) {
                    SysUtil.abort();
                }
            }
            catch (UIException e) {
                logger.error((Object)e);
            }
        }
    }

    private static boolean isCheckForSameWay() {
        IPermissionParameter iPermParam = PermissionParameterFactory.getRemoteInstance();
        return "true".equals(iPermParam.getPermissionParameter("isCheckForSameWay"));
    }

    static class UsbKeyAndDynCardIdentityAuthorize
    implements IIdentityAuthorize {
        UsbKeyAndDynCardIdentityAuthorize() {
        }

        @Override
        public void checkIdentity(Window ownerUI, IObjectPK userPk) throws PermissionException {
            try {
                IdentityAuthorizeFactory.checkUsbKeyPermission();
            }
            catch (DynamicCardException ex) {
                IdentityAuthorizeFactory.checkDynPermission();
            }
        }
    }

    static class DynCardAndUsbKeyIdentityAuthorize
    implements IIdentityAuthorize {
        DynCardAndUsbKeyIdentityAuthorize() {
        }

        @Override
        public void checkIdentity(Window ownerUI, IObjectPK userPk) throws PermissionException {
            try {
                IdentityAuthorizeFactory.checkDynPermission();
            }
            catch (DynamicCardException ex) {
                IdentityAuthorizeFactory.checkUsbKeyPermission();
            }
        }
    }

    static class UsbKeyIdentityAuthorize
    implements IIdentityAuthorize {
        UsbKeyIdentityAuthorize() {
        }

        @Override
        public void checkIdentity(Window ownerUI, IObjectPK userPk) throws PermissionException {
            IdentityAuthorizeFactory.checkUsbKeyPermission();
        }
    }

    static class DynCardIdentityAuthorize
    implements IIdentityAuthorize {
        DynCardIdentityAuthorize() {
        }

        @Override
        public void checkIdentity(Window ownerUI, IObjectPK userPk) throws PermissionException {
            IdentityAuthorizeFactory.checkDynPermission();
        }
    }

    static class PasswordIdentityAuthorize
    implements IIdentityAuthorize {
        private IIdentityAuthorize authorize = null;

        public PasswordIdentityAuthorize() {
            try {
                this.authorize = (IIdentityAuthorize)Class.forName("com.kingdee.eas.fdc.contract.ValidateWorkFlowPassword").newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)PermissionResUtil.getResource("res_85"), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)PermissionResUtil.getResource("res_85"), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)PermissionResUtil.getResource("res_85"), (Throwable)e);
            }
        }

        @Override
        public void checkIdentity(Window ownerUI, IObjectPK userPk) throws PermissionException {
            if (PermissionCommonUtil.isPasswordIDAuthorizeEnabled(null)) {
                if (this.authorize == null) {
                    IdentityAuthorizeFactory.checkPasswordPermission();
                } else {
                    this.authorize.checkIdentity(ownerUI, userPk);
                }
            }
        }
    }
}

