/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.permission.UsbKeyException;
import com.kingdee.eas.base.permission.service.helper.UsbKey4Login;
import com.kingdee.eas.base.security.SecurityAuthParamManagerFactory;
import com.kingdee.eas.base.security.provider.IPKICommonService;
import com.kingdee.eas.base.security.provider.PKICommonServiceFactory;
import com.kingdee.eas.base.security.provider.client.IPKIClientExt2Provider;
import com.kingdee.eas.base.security.usbkey.USBKeyInitFactory;
import com.kingdee.eas.base.uiframe.client.ILoginRPCFilter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.ILoginListener;
import com.kingdee.eas.common.client.LoginEvent;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class UsbKey4LoginFilter
implements ILoginListener,
ILoginRPCFilter {
    protected static Logger logger = Logger.getLogger(UsbKey4LoginFilter.class);
    private static String UKCA_CHECKPASSWORD = "UKCA_CHECKPASSWORD";
    private static String UKCA_CHECKUSER = "UKCA_CHECKUSER";

    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = UIActionPostman.getInstance(null);
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName("com.kingdee.eas.base.permission.app.UsbKey4LoginHandle");
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public void logined(LoginEvent e) throws BOSException, EASBizException {
    }

    public void beforeAuthenticating(LoginContext ctx) throws BOSLoginException {
        try {
            boolean isEnableUsbkeyAuth = SecurityAuthParamManagerFactory.getRemoteInstance().isEnableUsbkeyAuth();
            if (!isEnableUsbkeyAuth) {
                logger.error((Object)"\u672a\u5f00\u542f\u667a\u80fd\u94a5\u5319\u8ba4\u8bc1\uff0c\u4e0d\u8fdb\u884cUsbkey\u521d\u59cb\u5316!");
                return;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        logger.info((Object)"Set usbkey info before login start...");
        String userName = ctx.getUserName();
        String encodePwd = (String)ctx.get("Password");
        String password = null;
        try {
            password = CryptoTean.decrypt((String)userName, (String)encodePwd);
        }
        catch (CryptException e) {
            logger.error((Object)"Decrypt password error:", (Throwable)e);
            throw new BOSLoginException((Throwable)e);
        }
        IPKIClientExt2Provider ipkiClientExt2Provider = null;
        String usbKeyNumber1 = "";
        boolean isUSBKeyUser = false;
        try {
            ipkiClientExt2Provider = USBKeyInitFactory.getNewUsbKey();
            usbKeyNumber1 = new String(ipkiClientExt2Provider.getUserID(), "UTF-8");
            isUSBKeyUser = userName.equals(usbKeyNumber1);
        }
        catch (Exception e) {
            logger.error((Object)"Usbkey check user error:", (Throwable)e);
            try {
                ipkiClientExt2Provider = USBKeyInitFactory.getNewUsbKey();
                usbKeyNumber1 = new String(ipkiClientExt2Provider.getUserID(), "GBK");
                if (userName.equals(usbKeyNumber1)) {
                    isUSBKeyUser = true;
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Second usbkey check user error:", (Throwable)e);
                ex.printStackTrace();
            }
        }
        if (isUSBKeyUser) {
            Context userContext = new Context(null, ctx.getSlnName(), ctx.getAis(), ctx.getLocale(), ctx.getContextID());
            IPKICommonService iPKICommonService = PKICommonServiceFactory.getRemoteInstance();
            String randomText4Sign = null;
            try {
                randomText4Sign = iPKICommonService.initRandomNo(userContext, userName);
            }
            catch (BOSException e2) {
                logger.error((Object)"initRandomNo  error:", (Throwable)e2);
                throw new BOSLoginException((Throwable)e2);
            }
            catch (UsbKeyException e) {
                if (e.getSubCode().equals(UsbKeyException.NOT_START_USE_USBKEY.getCode())) {
                    logger.info((Object)("Login type is not usbkey, username=" + userName));
                    return;
                }
                logger.error((Object)"initRandomNo error:", (Throwable)((Object)e));
                throw new BOSLoginException((Throwable)((Object)e));
            }
            boolean isVerifySignatureInServer = true;
            try {
                isVerifySignatureInServer = SecurityAuthParamManagerFactory.getRemoteInstance().isVerifySignatureInServer();
            }
            catch (BOSException e2) {
                logger.error((Object)"Get parameter isVerifySignatureInServer error:", (Throwable)e2);
                isVerifySignatureInServer = "true".equalsIgnoreCase(System.getProperty("verifySignatureInServer", "true"));
            }
            if (randomText4Sign != null && isVerifySignatureInServer) {
                logger.debug((Object)("Usbkey randomText4Sign:" + randomText4Sign));
                try {
                    if (!ipkiClientExt2Provider.checkPasswd(password.getBytes("UTF-8"))) {
                        logger.error((Object)"Usbkey password verify error");
                        ctx.put("UsbKeyException", (Object)UsbKeyException.USB_PWD_ERROR.getName());
                        return;
                    }
                    USBKeyInitFactory.setPwd((String)password);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                logger.debug((Object)"Usbkey password verify success!");
                try {
                    logger.debug((Object)("Usbkey verify userName:" + userName));
                    byte[] dataSignature = ipkiClientExt2Provider.sign(randomText4Sign.getBytes("UTF-8"), userName, password.getBytes("UTF-8"));
                    logger.info((Object)"Set signature data to password in LoginContext...");
                    String dataSignatureStr = new String(dataSignature);
                    logger.debug((Object)("Usbkey verify dataSignatureStr:" + dataSignatureStr));
                    ctx.put("Password", (Object)dataSignatureStr);
                    ctx.setUserPass(dataSignatureStr);
                    byte[] cert = ipkiClientExt2Provider.exportCertificate();
                    if (cert != null) {
                        iPKICommonService.cacheEASCertificateInfo(userContext, userName, cert, ipkiClientExt2Provider.getKeyID());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Usbkey data signature error:", (Throwable)e);
                    throw new BOSLoginException((Throwable)e);
                }
                UsbKey4Login.setKeyNumber(ctx, ipkiClientExt2Provider.getKeyID());
            } else {
                logger.info((Object)"Usbkey randomText4Sign is null.");
                UsbKey4Login.setLoginInfo(ctx, userName, password);
            }
        } else {
            logger.info((Object)"Usbkey isUsbkeyUser return false.");
        }
        logger.info((Object)"Set usbkey info before login end!");
    }

    public void afterAuthenticated(Context arg0) throws BOSLoginException {
    }
}

