/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.quickperm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.permission.IRule;
import com.kingdee.eas.base.permission.RuleCollection;
import com.kingdee.eas.base.permission.RuleFactory;
import com.kingdee.eas.base.permission.RuleInfo;
import com.kingdee.eas.base.permission.client.quickperm.AdminOrgProxy;
import com.kingdee.eas.base.permission.client.quickperm.PopMenuConfigInfo;
import com.kingdee.eas.base.permission.client.quickperm.RuleNumberCreater;
import com.kingdee.eas.base.permission.util.DateUtils;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class RuleProxy {
    private static Logger logger = Logger.getLogger(RuleProxy.class);

    public RuleInfo saveAutoCreateRule(RuleInfo oldRule, String fieldName, FullOrgUnitInfo[] fullOrgUnit) throws BOSException, EASBizException {
        RuleInfo retRuleInfo = null;
        IRule iRule = RuleFactory.getRemoteInstance();
        if (oldRule.getId() == null) {
            RuleInfo ruleInfo = new RuleInfo();
            ruleInfo.setNumber(RuleNumberCreater.getNewRuleNumber());
            MutilLangeToolForParam.muti2Obj((String)("autoCreateRule_" + DateUtils.formatDateTime(SysUtil.getAppServerTime(null))), (IObjectValue)ruleInfo, (String)"name");
            ruleInfo.setBizObject(oldRule.getBizObject());
            MutilLangeToolForParam.muti2Obj((String)"auto create rule!", (IObjectValue)ruleInfo, (String)"description");
            ruleInfo.setIsDefault(true);
            ruleInfo.setScript(this.createCript(fieldName, fullOrgUnit));
            ruleInfo.setCU(ToolUtils.getCurrentCU());
            IObjectPK rulePK = iRule.addnew((CoreBaseInfo)ruleInfo);
            ruleInfo.setId(BOSUuid.read((String)rulePK.toString()));
            retRuleInfo = ruleInfo;
        } else {
            oldRule.setIsDefault(true);
            oldRule.setScript(this.createCript(fieldName, fullOrgUnit));
            oldRule.setCU(ToolUtils.getCurrentCU());
            iRule.submit((IObjectPK)new ObjectStringPK(oldRule.getId().toString()), (CoreBaseInfo)oldRule);
            retRuleInfo = oldRule;
        }
        return retRuleInfo;
    }

    private String createCript(String fieldName, FullOrgUnitInfo[] fullOrgUnit) {
        if (fullOrgUnit == null || fullOrgUnit.length == 0) {
            throw new IllegalArgumentException(" orgUnit is null!");
        }
        if (StringUtils.isEmpty((String)fieldName)) {
            throw new IllegalArgumentException(" fieldName is null!");
        }
        StringBuffer sb = new StringBuffer("");
        int size = fullOrgUnit.length;
        for (int i = 0; i < size; ++i) {
            sb.append(" ").append(fieldName).append("='").append(fullOrgUnit[i].getNumber()).append("' or");
        }
        String retStr = sb.toString();
        if (retStr.endsWith("or")) {
            retStr = retStr.substring(0, retStr.length() - 3);
        }
        return retStr;
    }

    public static String buildRuleExpr(String bizObjType, String ruleStructure) throws BOSException, EASBizException, ParserException {
        IRule iRule = RuleFactory.getRemoteInstance();
        return iRule.buidRuleExpr(bizObjType, ruleStructure);
    }

    public static RuleInfo getInfoFromUserOrgPerm(String structStr) {
        if (StringUtils.isEmpty((String)structStr)) {
            return null;
        }
        String takeOfWhere = structStr.replaceAll("WHERE", "");
        String takeOfAnd = takeOfWhere.replaceAll("AND", ",");
        String takeOfOr = takeOfAnd.replaceAll("OR", ",");
        String takeOfRight = takeOfOr.replace('(', ' ');
        String takeOfLeft = takeOfRight.replace(')', ' ');
        String[] idAry = StringUtils.split((String)takeOfLeft, (String)",");
        if (idAry == null || idAry.length == 0) {
            return null;
        }
        ArrayList<String> idList = new ArrayList<String>();
        int size = idAry.length;
        for (int i = 0; i < size; ++i) {
            if (StringUtils.isEmpty((String)idAry[i])) continue;
            idList.add(idAry[i]);
        }
        String idStr = ToolUtils.aryToStr(idList, true);
        if (StringUtils.isEmpty((String)idStr)) {
            return null;
        }
        RuleCollection ruleCol = null;
        try {
            IRule iRule = RuleFactory.getRemoteInstance();
            ruleCol = iRule.getRuleCollection("select * where id in (" + idStr + ")");
        }
        catch (BOSException e) {
            logger.info((Object)"", (Throwable)e);
        }
        if (ruleCol == null || ruleCol.isEmpty()) {
            return null;
        }
        int size2 = ruleCol.size();
        for (int i = 0; i < size2; ++i) {
            if (!RuleNumberCreater.isAutoCreateNumber(ruleCol.get(i).getNumber())) continue;
            return ruleCol.get(i);
        }
        return null;
    }

    public static Set getPKMap(String fieldName, String ruleExpr) throws BOSException {
        HashSet retSet = new HashSet();
        if (StringUtils.isEmpty((String)ruleExpr) || StringUtils.isEmpty((String)fieldName)) {
            return retSet;
        }
        if (ruleExpr.indexOf(fieldName) == -1) {
            return retSet;
        }
        String oneStr = ruleExpr.replaceAll(fieldName, "");
        String twoStr = oneStr.replaceAll("'", "");
        String parseStr = twoStr.replaceAll("or", ",");
        parseStr = parseStr.replaceAll("=", "");
        String[] parseAry = StringUtils.split((String)parseStr, (String)",");
        ArrayList<String> idList = new ArrayList<String>();
        int size = parseAry.length;
        for (int i = 0; i < size; ++i) {
            if (StringUtils.isEmpty((String)parseAry[i])) continue;
            idList.add(parseAry[i]);
        }
        String adminFieldName = null;
        int startPos = fieldName.lastIndexOf(".");
        if (startPos == -1) {
            return retSet;
        }
        adminFieldName = fieldName.substring(startPos + 1, fieldName.length());
        AdminOrgProxy adminOrgProxy = new AdminOrgProxy();
        return adminOrgProxy.getAdminIdSet(adminFieldName, idList);
    }

    public static Set getAlreadySelectAdminOrg(String permissionId, String fieldName, String permRule) throws BOSException, EASBizException {
        HashSet retSet = new HashSet();
        if (StringUtils.isEmpty((String)permRule)) {
            return retSet;
        }
        String keyWord = "WHERE";
        if (permRule.length() <= keyWord.length()) {
            return retSet;
        }
        String ruleId = permRule.substring(6, permRule.length()).trim();
        String ruleExpr = null;
        IRule iRule = RuleFactory.getRemoteInstance();
        RuleInfo oldRuleInfo = iRule.getRuleInfo((IObjectPK)new ObjectStringPK(ruleId));
        if (oldRuleInfo != null) {
            ruleExpr = oldRuleInfo.getScript();
        }
        return RuleProxy.getPKMap(PopMenuConfigInfo.getInstance().getValue(permissionId), ruleExpr);
    }
}

