/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.script;

import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.PermissionResUtil;
import com.kingdee.eas.common.SubSystemUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class RuleRefSQLGenerator {
    private static Logger logger = Logger.getLogger(RuleRefSQLGenerator.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final String MDB_VIEW = "com_kingdee_eas_base_permission";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private String metasPath = null;
    private String sqlFile = null;

    public RuleRefSQLGenerator(String metasPath, String sqlFile) {
        this.metasPath = metasPath;
        this.sqlFile = sqlFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSQLFile() {
        StringBuffer sqlText = new StringBuffer(4000);
        Map entities = this.getEntities();
        Set set = entities.keySet();
        for (BOSObjectType objectType : set) {
            EntityObjectInfo entity = (EntityObjectInfo)entities.get(objectType);
            sqlText.append(this.generateEntitySQL(entity));
        }
        OutputStreamWriter fileWriter = null;
        try {
            File file = new File(this.sqlFile);
            fileWriter = new FileWriter(file);
            fileWriter.write(sqlText.toString());
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e1) {
                    logger.error((Object)e1);
                }
                fileWriter = null;
            }
        }
    }

    private String generateEntitySQL(EntityObjectInfo entity) {
        StringBuffer sql = new StringBuffer();
        sql.append("--------------- " + EASResource.getString((String)RESOURCE, (String)"BIZ_OBJECT") + ": ").append(entity.getAlias()).append("(").append(entity.getFullName()).append(") ---------------------;").append(SEPARATOR);
        PropertyCollection properties = this.getLinkProperties(entity);
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)properties.get(i);
            RelationshipInfo relationshipInfo = linkPropertyInfo.getRelationship();
            if (!relationshipInfo.getType().equals((Object)RelationshipType.ASSOCIATION)) continue;
            EntityObjectInfo linkEntity = this.getLinkEntity(entity.getType(), linkPropertyInfo);
            sql.append("-- " + EASResource.getString((String)RESOURCE, (String)"BIZ_OBJECT") + ": ").append(entity.getAlias()).append("(").append(entity.getFullName()).append(")  " + PermissionResUtil.getResource("res_86")).append(linkPropertyInfo.getAlias()).append("(").append(linkPropertyInfo.getName()).append(" ) ;").append(SEPARATOR);
            sql.append("INSERT INTO T_PM_RuleRef (FRefObject, FRefProperty, FSrcObject )").append(" VALUES ( '").append(entity.getType().toString()).append("' , '").append(linkPropertyInfo.getName()).append("',  '").append(linkEntity.getType().toString()).append("' ); ").append(SEPARATOR);
        }
        sql.append(SEPARATOR);
        return sql.toString();
    }

    private EntityObjectInfo getLinkEntity(BOSObjectType mainObjectType, LinkPropertyInfo propertyInfo) {
        EntityObjectInfo linkEntity = propertyInfo.getRelationship().getSupplierObject();
        if (!linkEntity.getType().equals((Object)mainObjectType)) {
            return linkEntity;
        }
        return propertyInfo.getRelationship().getClientObject();
    }

    private PropertyCollection getLinkProperties(EntityObjectInfo entity) {
        PropertyCollection result = new PropertyCollection();
        PropertyCollection properties = entity.getInheritedNoDuplicatedProperties();
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = properties.get(i);
            if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
            result.add(propertyInfo);
        }
        return result;
    }

    private Map getEntities() {
        HashMap<BOSObjectType, EntityObjectInfo> entites = new HashMap<BOSObjectType, EntityObjectInfo>();
        MetaDataLoaderFactory.setClientMetaDataPath((String)this.metasPath);
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader(null);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)SubSystemUtils.getSubSystemByName((String)MDB_VIEW);
        Enumeration<TreeNode> enumeration = root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            MetaDataBriefInfo metaDataBriefInfo = ((IBriefViewTreeNode)enumeration.nextElement()).getMetaDataObjectBriefInfo();
            logger.info((Object)("metaDataBriefInfo: " + metaDataBriefInfo.getAlias()));
            if (!metaDataBriefInfo.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) continue;
            EntityObjectInfo entity = loader.getEntity(metaDataBriefInfo.getMetaDataPK());
            logger.info((Object)("entity: " + entity.getAlias()));
            entites.put(entity.getType(), entity);
        }
        return entites;
    }

    public static void main(String[] args) {
        RuleRefSQLGenerator generator = new RuleRefSQLGenerator("W:" + File.separator + "eas" + File.separator + "deploy" + File.separator + "apusic" + File.separator + "metas", "w:" + File.separator + "ruleRef.sql");
        generator.generateSQLFile();
    }
}

