/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.client.xuntong;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.IXunTongFacade;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.XunTongFacadeFactory;
import com.kingdee.eas.base.permission.util.Progressable;
import com.kingdee.eas.base.permission.xuntong.KeyManager;
import com.kingdee.eas.base.permission.xuntong.RSAUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.log4j.Logger;
import org.jdesktop.jdic.browser.WebBrowser;

public class XunTongUtil {
    private static Logger logger = Logger.getLogger(XunTongUtil.class);
    private static final String ROOT = "http://mcloud.kingdee.com";
    private static final String MCLOUD_ROOT_URL = "http://mcloud.kingdee.com/extmcloud";
    private static final String DATA_ACCESS_ROOT = "http://mcloud.kingdee.com/openaccess";
    private static final String IMPORT_ORG_URL = "http://mcloud.kingdee.com/openaccess/json/org/addnew";
    private static final String IMPORT_PERSON_URL = "http://mcloud.kingdee.com/openaccess/json/person/addnew";
    private static final String IMPORT_USER_URL = "http://mcloud.kingdee.com/openaccess/json/person/mapping";
    private static final String UPDATE_ORG_URL = "http://mcloud.kingdee.com/openaccess/json/org/update";
    private static final String DELETE_ORG_URL = "http://mcloud.kingdee.com/openaccess/json/org/delete";
    private static final String UPDATE_PERSON_URL = "http://mcloud.kingdee.com/openaccess/json/person/update";
    private static final String DELETE_PERSON_RUL = "http://mcloud.kingdee.com/openaccess/json/person/delete";
    private static final String CLIENT_ROOT = System.getProperty("easclient.root");
    private static final String PRIVATE_KEY_PATH = CLIENT_ROOT + File.separator + "app_private.key";
    private static final String PUBLIC_KEY_PATH = CLIENT_ROOT + File.separator + "app_public.key";
    private static final String REGISTER_URL = "http://mcloud.kingdee.com/extmcloud/open/privateKey.action";
    private static final String XUNTONG_ROOT = "http://xunt.im";
    private static final String DESKTOP_URL = "http://xunt.im/xtintegrated/desktopMessage.action";
    private static final String XUNTONG_PROTOCAL_URL = "http://xunt.im/xtintegrated/license.action";
    private static final String EID_KEY = "eid";
    private static final String SN_KEY = "sn";
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static String sn = null;
    private static String EID = null;
    private static final String UTF8 = "UTF-8";
    static KDDialog xunTongDialog = null;

    public static boolean isXunTongEnable() {
        return true;
    }

    public static void synchData(Progressable progressable) {
    }

    public static String getSn() {
        if (sn != null) {
            return sn;
        }
        try {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            sn = baseInfo.getSerialNum();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            sn = "";
        }
        return sn;
    }

    public static boolean isXunTongServiceEnable() {
        String url = "http://mcloud.kingdee.com/extmcloud/open/erpServiceCheck.action";
        try {
            String eid = XunTongUtil.getEID();
            if (StringUtils.isEmpty((String)eid)) {
                return XunTongUtil.registerBySN();
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(EID_KEY, eid);
            JSONObject ret = XunTongUtil.postEncrypt(url, "erpServiceCheck", params);
            if (ret != null && "true".equals(ret.getString("success"))) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        return false;
    }

    private static boolean registerBySN() {
        HashMap<String, String> params = new HashMap<String, String>();
        String custName = XunTongUtil.getSn();
        String email = "111@kingdee.com";
        String password = XunTongUtil.getSn();
        String serverURL = "http://www.kingdee.com";
        params.put("custName", custName);
        params.put("email", email);
        params.put("password", password);
        params.put("serverURL", serverURL);
        params.put(SN_KEY, XunTongUtil.getSn());
        JSONObject ret = XunTongUtil.postEncrypt(REGISTER_URL, "privateKey", params);
        return ret != null && "true".equals(ret.getString("success"));
    }

    public static boolean openXunTongService() {
        String url = "http://mcloud.kingdee.com/extmcloud/open/erpServiceOpen.action";
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(EID_KEY, XunTongUtil.getEID());
            JSONObject ret = XunTongUtil.postEncrypt(url, "erpServiceOpen", params);
            if (ret != null && "true".equals(ret.getString("success"))) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
            return false;
        }
        return false;
    }

    private static JSONObject httpGetJSONOBject(String url, Map<String, String> params) {
        JSONObject responseJson = new JSONObject();
        try {
            String response = XunTongUtil.httpGetString(url, params);
            logger.info((Object)("response:" + response));
            responseJson = JSONObject.parseObject((String)response);
            return responseJson;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return responseJson;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String httpGetString(String url, Map<String, String> params) {
        GetMethod httpGet = null;
        try {
            HttpClient httpClient = new HttpClient();
            httpGet = new GetMethod(url);
            NameValuePair[] parts = XunTongUtil.getNameValuePair(params);
            httpGet.setQueryString(parts);
            httpGet.setRequestHeader("Content-type", "text/html; charset=utf-8");
            httpClient.executeMethod((HttpMethod)httpGet);
            String response = new String(httpGet.getResponseBody(), UTF8);
            logger.info((Object)("response:" + response));
            httpGet.releaseConnection();
            String string = response;
            return string;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            httpGet.releaseConnection();
        }
        return "";
    }

    private static NameValuePair[] getNameValuePair(Map<String, String> params) {
        NameValuePair[] parts = new NameValuePair[params.size()];
        Iterator<Map.Entry<String, String>> paramItr = params.entrySet().iterator();
        int index = 0;
        while (paramItr.hasNext()) {
            NameValuePair pair;
            Map.Entry<String, String> entry = paramItr.next();
            parts[index] = pair = new NameValuePair(entry.getKey(), entry.getValue());
            ++index;
        }
        return parts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject postEncrypt(String url, String action, Map<String, String> params) {
        JSONObject responseJson = new JSONObject();
        Long timestamp = System.currentTimeMillis() / 1000L;
        String nonce = UUID.randomUUID().toString();
        PostMethod httpPost = null;
        try {
            String paramJsonStr = XunTongUtil.getParamJsonStr(params);
            String encrptedData = RSAUtils.encrypt(paramJsonStr, KeyManager.initPrivateKey(PRIVATE_KEY_PATH));
            String signaUrl = "url=" + XunTongUtil.constructRequestURL(url) + "&timestamp=" + timestamp + "&nonce=" + nonce + "&action=" + action + "&data=" + encrptedData;
            String signature = XunTongUtil.signature(signaUrl);
            JSONObject jsonBody = XunTongUtil.getJsonBody(action, encrptedData, nonce, signature, timestamp);
            HttpClient httpClient = new HttpClient();
            httpPost = new PostMethod(url);
            StringRequestEntity entry = new StringRequestEntity(jsonBody.toString(), "application/json;charset=utf-8", UTF8);
            httpPost.setRequestEntity((RequestEntity)entry);
            int statusCode = httpClient.executeMethod((HttpMethod)httpPost);
            String response = httpPost.getResponseBodyAsString();
            if (statusCode != 200) {
                httpPost.abort();
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"HTTP_STATUCODE") + ":" + statusCode + " " + EASResource.getString((String)RESOURCE, (String)"BIZ_REQUEST_FAIL"));
            }
            byte[] resultBytes = response.getBytes(UTF8);
            String msgContent = new String(resultBytes, UTF8);
            System.out.println(msgContent);
            responseJson = JSONObject.parseObject((String)msgContent);
            httpPost.releaseConnection();
            JSONObject jSONObject = responseJson;
            return jSONObject;
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
        return responseJson;
    }

    private static JSONObject getJsonBody(String action, String data, String nonce, String signature, Long timestamp) throws JSONException {
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("action", (Object)action);
        jsonBody.put("data", (Object)data);
        jsonBody.put("nonce", (Object)nonce);
        jsonBody.put("signature", (Object)signature);
        jsonBody.put("timestamp", (Object)timestamp);
        return jsonBody;
    }

    private static String signature(String url) {
        byte[] signBytes = null;
        try {
            byte[] bytes = url.getBytes("utf-8");
            signBytes = RSAUtils.sign(bytes, (PrivateKey)KeyManager.initPrivateKey(PRIVATE_KEY_PATH));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String(Base64.encodeBase64(signBytes));
    }

    private static String getParamJsonStr(Map<String, String> params) throws JSONException {
        JSONObject jsonObj = new JSONObject();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            jsonObj.put(entry.getKey(), (Object)entry.getValue());
        }
        return jsonObj.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject post(String url, Map<String, String> params) {
        HttpClient http = new HttpClient();
        PostMethod post = null;
        JSONObject responseJson = new JSONObject();
        try {
            post = new PostMethod(url);
            post.setRequestHeader("content-type", "application/x-www-form-urlencoded");
            NameValuePair[] parts = XunTongUtil.getNameValuePair(params);
            post.setRequestBody(parts);
            http.executeMethod((HttpMethod)post);
            String response = post.getResponseBodyAsString();
            logger.info((Object)("response:" + response));
            responseJson = JSONObject.parseObject((String)response);
            post.releaseConnection();
            JSONObject jSONObject = responseJson;
            return jSONObject;
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
        finally {
            post.releaseConnection();
        }
        return responseJson;
    }

    public static String getEID() {
        if (EID != null) {
            return EID;
        }
        try {
            IXunTongFacade xunTongFacade = XunTongFacadeFactory.getRemoteInstance();
            EID = xunTongFacade.getMID();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
        return EID;
    }

    public static JSONArray getPersonData() {
        try {
            IXunTongFacade xunTongFacade = XunTongFacadeFactory.getRemoteInstance();
            return xunTongFacade.getPersonData();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
            return new JSONArray();
        }
    }

    public static JSONArray getUserData() {
        try {
            IXunTongFacade xunTongFacade = XunTongFacadeFactory.getRemoteInstance();
            return xunTongFacade.getUserData();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
            return new JSONArray();
        }
    }

    public static JSONArray getAllAdmins() {
        JSONArray ret = new JSONArray();
        try {
            AdminOrgUnitCollection adminCol = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection("select id,name,parent.id where isSealUp=0");
            int size = adminCol.size();
            for (int i = 0; i < size; ++i) {
                AdminOrgUnitInfo admin = adminCol.get(i);
                HashMap<String, String> jsonObj = new HashMap<String, String>();
                jsonObj.put("id", admin.getId().toString());
                jsonObj.put("name", admin.getName());
                AdminOrgUnitInfo parent = admin.getParent();
                String parentId = parent == null ? null : parent.getId().toString();
                jsonObj.put("parentId", parentId);
                ret.add(jsonObj);
            }
            return ret;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return ret;
        }
    }

    public static byte[] encryptLarger(byte[] data, Key key) throws Exception {
        Cipher rsa = XunTongUtil.getRSACipher();
        rsa.init(1, key);
        SecureRandom random = new SecureRandom();
        byte[] secretKey = new byte[16];
        random.nextBytes(secretKey);
        Cipher aes = Cipher.getInstance("AES/GCM/PKCS5Padding", "BC");
        SecretKeySpec k = new SecretKeySpec(secretKey, "AES");
        aes.init(1, k);
        byte[] ciphedKey = rsa.doFinal(secretKey);
        byte[] ciphedData = aes.doFinal(data);
        byte[] result = new byte[128 + ciphedData.length];
        System.arraycopy(ciphedKey, 0, result, 0, 128);
        System.arraycopy(ciphedData, 0, result, 128, ciphedData.length);
        return result;
    }

    private static String getSN() {
        return "9880b6a9-a904-4612-aa50-b5410d11003d";
    }

    private static byte[] getKeyFromMCloud() {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(SN_KEY, XunTongUtil.getSN());
            JSONObject responseJson = XunTongUtil.postEncrypt(REGISTER_URL, "privateKey", params);
            String datas = responseJson.getString("data");
            datas = RSAUtils.decrypt(datas, KeyManager.initPrivateKey(PRIVATE_KEY_PATH));
            if (datas != null) {
                JSONObject respJson = JSONObject.parseObject((String)datas);
                return Base64.decodeBase64((byte[])respJson.getString("key").getBytes("utf-8"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
        return new byte[0];
    }

    public static byte[] getKey() {
        return XunTongUtil.getKeyFromMCloud();
    }

    public static String constructRequestURL(String url) {
        int slashIndex;
        String baseURL;
        int colonIndex;
        int index = url.indexOf("?");
        if (-1 != index) {
            url = url.substring(0, index);
        }
        if (-1 != (colonIndex = (baseURL = url.substring(0, slashIndex = url.indexOf("/", 8)).toLowerCase()).indexOf(":", 8))) {
            if (baseURL.startsWith("http://") && baseURL.endsWith(":80")) {
                baseURL = baseURL.substring(0, colonIndex);
            } else if (baseURL.startsWith("https://") && baseURL.endsWith(":443")) {
                baseURL = baseURL.substring(0, colonIndex);
            }
        }
        url = baseURL + url.substring(slashIndex);
        return url;
    }

    public static boolean importOrgs() {
        String url = IMPORT_ORG_URL;
        JSONArray orgArr = XunTongUtil.getAllAdmins();
        return XunTongUtil.importData(orgArr, "orgs", url);
    }

    public static boolean importPersons() {
        String url = IMPORT_PERSON_URL;
        JSONArray personArr = XunTongUtil.getPersonData();
        return XunTongUtil.importData(personArr, "persons", url);
    }

    public static boolean importUsers() {
        String url = IMPORT_USER_URL;
        JSONArray personArr = XunTongUtil.getUserData();
        return XunTongUtil.importData(personArr, "mapping", url);
    }

    private static boolean importData(JSONArray dataArr, String dataKey, String url) {
        if (dataArr == null || dataArr.size() == 0) {
            return false;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String nonce = UUID.randomUUID().toString();
        params.put("nonce", nonce);
        try {
            params.put(EID_KEY, XunTongUtil.getEID());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
        int size = dataArr.size();
        JSONArray subArr = new JSONArray();
        try {
            for (int i = 0; i < size; ++i) {
                if (i > 0 && i % 2000 == 0) {
                    XunTongUtil.postSubArray(url, subArr, dataKey, params);
                    subArr = new JSONArray();
                }
                subArr.add(dataArr.get(i));
            }
            if (subArr.size() > 0) {
                XunTongUtil.postSubArray(url, subArr, dataKey, params);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
        return false;
    }

    private static void postSubArray(String url, JSONArray subArr, String dataKey, Map<String, String> params) {
        String encryptedData = XunTongUtil.getEncryptedImportData(subArr, dataKey);
        params.put("data", encryptedData);
        XunTongUtil.post(url, params);
    }

    private static String getEncryptedImportData(JSONArray dataArr, String dataKey) {
        String dataCenterId = SysContext.getSysContext().getDCNumber();
        JSONObject json = new JSONObject();
        try {
            json.put(EID_KEY, (Object)XunTongUtil.getEID());
            json.put("dataCenterId", (Object)dataCenterId);
            json.put(dataKey, (Object)dataArr);
        }
        catch (Exception e) {
            XunTongUtil.handleException(e);
        }
        return XunTongUtil.encryptLarger(json.toString());
    }

    private static String encryptLarger(String str) {
        try {
            byte[] jsonBytes = str.getBytes(UTF8);
            PrivateKey privateKey = RSAUtils.restorePrivateKey(XunTongUtil.getKey());
            return new String(Base64.encodeBase64((byte[])RSAUtils.encryptLarger(jsonBytes, privateKey)), UTF8);
        }
        catch (Exception e) {
            XunTongUtil.handleException(e);
            return "";
        }
    }

    private static void handleException(Exception e) {
        logger.error((Object)"", (Throwable)e);
        ExceptionHandler.handle((Throwable)e);
    }

    public static void updateXuntongData() {
        try {
            if (StringUtils.isEmpty((String)XunTongUtil.getEID())) {
                return;
            }
            Map allUpdateData = XunTongFacadeFactory.getRemoteInstance().getAllUpdateData();
            XunTongUtil.importData((JSONArray)allUpdateData.get("addedorg"), "orgs", IMPORT_ORG_URL);
            XunTongUtil.importData((JSONArray)allUpdateData.get("updatedorg"), "orgs", UPDATE_ORG_URL);
            XunTongUtil.importData((JSONArray)allUpdateData.get("deletedorg"), "orgIds", DELETE_ORG_URL);
            XunTongUtil.importData((JSONArray)allUpdateData.get("addedperson"), "persons", IMPORT_PERSON_URL);
            XunTongUtil.importData((JSONArray)allUpdateData.get("updatedperson"), "persons", UPDATE_PERSON_URL);
            XunTongUtil.importData((JSONArray)allUpdateData.get("deletedperson"), "personIds", DELETE_PERSON_RUL);
            XunTongUtil.importData((JSONArray)allUpdateData.get("addeduser"), "mapping", IMPORT_USER_URL);
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
        }
    }

    private static JSONObject getXunTongDesktopData() {
        HashMap<String, String> params = new HashMap<String, String>();
        String nonce = UUID.randomUUID().toString();
        params.put(SN_KEY, XunTongUtil.getSn());
        params.put(EID_KEY, XunTongUtil.getEID());
        String dcId = SysContext.getSysContext().getDCNumber();
        params.put("dataCenterId", dcId);
        UserInfo curUser = SysContext.getSysContext().getCurrentUserInfo();
        String userId = curUser.getId().toString();
        params.put("userId", userId);
        PersonInfo person = curUser.getPerson();
        String personId = "";
        if (person != null) {
            personId = StringUtils.cnulls((Object)person.getId());
            params.put("personId", personId);
        }
        String token = XunTongUtil.encryptLarger(dcId + userId + personId);
        params.put("token", token);
        JSONObject ret = XunTongUtil.httpGetJSONOBject(DESKTOP_URL, params);
        return ret;
    }

    public static String getXunTongProtocal() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(EID_KEY, XunTongUtil.getEID());
        params.put(SN_KEY, XunTongUtil.getSn());
        params.put("language", "0");
        return XunTongUtil.httpGetString(XUNTONG_PROTOCAL_URL, params);
    }

    public static void showGuide() {
        int width = 200;
        int height = 200;
        int showTime = 0;
        String title = "";
        String url = "";
        if (!XunTongUtil.isXunTongServiceEnable()) {
            return;
        }
        JSONObject ret = XunTongUtil.getXunTongDesktopData();
        if (!"true".equals(ret.getString("success"))) {
            return;
        }
        JSONObject data = ret.getJSONObject("data");
        if (data == null) {
            return;
        }
        showTime = data.getIntValue("showTime");
        width = data.getIntValue("width");
        height = data.getIntValue("height");
        title = data.getString("title");
        url = data.getString("url");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        xunTongDialog = new KDDialog();
        xunTongDialog.setModal(false);
        xunTongDialog.setAlwaysOnTop(true);
        int dialogWidth = width + 45;
        int dialogHeight = height + 55;
        xunTongDialog.setFocusableWindowState(true);
        xunTongDialog.setSize(new Dimension(dialogWidth, dialogHeight));
        xunTongDialog.setUndecorated(false);
        xunTongDialog.setLocation(screenSize.width - dialogWidth - 20, screenSize.height - dialogHeight - 100);
        xunTongDialog.setTitle(title);
        xunTongDialog.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                xunTongDialog.setVisible(false);
            }
        });
        xunTongDialog.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                xunTongDialog.setVisible(false);
            }
        });
        WebBrowser browser = new WebBrowser();
        browser.setSize(width + 20, height + 10);
        try {
            browser.setURL(new URL(url));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        xunTongDialog.getContentPane().add((Component)browser);
        xunTongDialog.show();
        if (showTime > 0) {
            try {
                Thread.sleep(showTime * 1000);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            xunTongDialog.dispose();
        }
    }

    public static void closeXunTongDialog() {
        if (xunTongDialog != null) {
            xunTongDialog.dispose();
        }
    }

    public static Cipher getRSACipher() {
        Cipher rsa = null;
        try {
            rsa = Cipher.getInstance("RSA/ECB/OAEPWithMD5AndMGF1Padding");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"this should never happen", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            logger.error((Object)"this should never happen", (Throwable)e);
        }
        return rsa;
    }
}

