/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.service.helper.usbkeyimpl;

import com.itrus.pki.rsa.iTrusUsbKey;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.permission.UsbKeyException;
import com.kingdee.eas.base.permission.service.helper.AbstractUsbKeyBaseOperator;
import com.kingdee.eas.base.permission.service.helper.UsbKeyCtxHelper;
import org.apache.log4j.Logger;

public class MWkeyImp
extends AbstractUsbKeyBaseOperator {
    private iTrusUsbKey iUsbkey = null;
    private static Logger logger = Logger.getLogger((String)MWkeyImp.class.getName());

    @Override
    public String readFile(int fileName) throws UsbKeyException {
        try {
            iTrusUsbKey usbkey = this.getITrusUsbKey();
            this.debugInfo("return CryptoTean.encrypt(\"\", new String(usbkey.getUserID()));");
            return CryptoTean.encrypt((String)"", (String)new String(usbkey.getUserID(), "utf-8"));
        }
        catch (Exception e) {
            logger.info((Object)"", (Throwable)e);
            throw new UsbKeyException(UsbKeyException.USB_NOT_RIGHT);
        }
    }

    private iTrusUsbKey getITrusUsbKey() throws UsbKeyException {
        if (this.iUsbkey != null) {
            return this.iUsbkey;
        }
        try {
            this.iUsbkey = UsbKeyCtxHelper.createItrusUsbKey();
        }
        catch (Exception e) {
            throw new UsbKeyException(UsbKeyException.USB_INIT_ERROR, e);
        }
        if (this.iUsbkey.isUsbKeyExistent() == null) {
            throw new UsbKeyException(UsbKeyException.USB_INIT_ERROR);
        }
        return this.iUsbkey;
    }

    private void debugInfo(String debugInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)debugInfo);
        }
    }

    @Override
    public void writeFile(String str) throws UsbKeyException {
    }

    @Override
    public String getNo() throws UsbKeyException {
        iTrusUsbKey usbkey = this.getITrusUsbKey();
        return usbkey.GetKeyID();
    }

    @Override
    public void verifyPwd(String newPwd) throws UsbKeyException {
        this.debugInfo("iTrusUsbKey usbkey = getITrusUsbKey();");
        iTrusUsbKey usbkey = this.getITrusUsbKey();
        this.debugInfo("chekUsb");
        this.debugInfo("if(!usbkey.checkPasswd(newPwd.getBytes()))");
        if (usbkey.isUsbKeyExistent() != null && !usbkey.checkPasswd(newPwd.getBytes())) {
            throw new UsbKeyException(UsbKeyException.USB_PWD_ERROR);
        }
    }

    @Override
    public byte[] exportCertificate() throws UsbKeyException {
        iTrusUsbKey usbkey = this.getITrusUsbKey();
        this.debugInfo("usbkey.exportCertificate();");
        return usbkey.exportCertificate();
    }

    @Override
    public boolean isKeyLogin() throws UsbKeyException {
        iTrusUsbKey usbkey = this.getITrusUsbKey();
        return usbkey.hasLoginOn();
    }

    @Override
    public String isUsbKeyExistent() throws UsbKeyException {
        iTrusUsbKey usbkey = this.getITrusUsbKey();
        String isUsbKeyExistent = usbkey.isUsbKeyExistent();
        return isUsbKeyExistent;
    }
}

