/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.app.helper.PermCacheHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashSet;
import java.util.Set;

public class HrPermissionTools {
    public static String getPermisisonSqlByUserWithPerm(String userId, String permId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BaseUnit.fid FHrOrgID from t_org_hro BaseUnit ").append(" WHERE\u3000EXISTS (").append(HrPermissionTools.getAuthorizedOrgIdsSQL(userId, permId)).append(") ").append(" AND NOT EXISTS ( ").append(HrPermissionTools.getForbiddenOrgIdsSQL(userId, permId)).append(")");
        return sql.toString();
    }

    private static String getAuthorizedOrgIdsSQL(String userPK, String permItemID) {
        StringBuffer sql = new StringBuffer();
        String userID = userPK.toString();
        sql.append(" SELECT 1 FROM T_PM_UserOrgPerm USERORGPERM ").append(" WHERE UserOrgPerm.FOwner = '").append(userID).append("' AND UserOrgPerm.FPermItemID = '").append(permItemID).append("' AND UserOrgPerm.FPermType = ").append(10).append(" AND USERORGPERM.Forgid = BaseUnit.fid ").append(" UNION ALL ").append(" SELECT 1 FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = '").append(userID).append("' AND RolePerm.FPermItemID = '").append(permItemID).append("' AND RolePerm.FPermType = ").append(10).append(" AND UserRoleOrg.Forgid = BaseUnit.fid ");
        return sql.toString();
    }

    private static String getForbiddenOrgIdsSQL(String userPK, String permItemID) {
        StringBuffer sql = new StringBuffer();
        String userID = userPK.toString();
        sql.append(" SELECT 1 FROM T_PM_UserOrgPerm USERORGPERM ").append(" WHERE UserOrgPerm.FOwner = '").append(userID).append("' AND UserOrgPerm.FPermItemID = '").append(permItemID).append("' AND UserOrgPerm.FPermType = ").append(20).append(" AND USERORGPERM.Forgid = BaseUnit.fid ").append(" UNION ALL ").append(" SELECT 1 FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = '").append(userID).append("' AND RolePerm.FPermItemID = '").append(permItemID).append("' AND RolePerm.FPermType = ").append(20).append(" AND UserRoleOrg.Forgid = BaseUnit.fid ");
        return sql.toString();
    }

    public static Set<String> getAuthorizedHrOrgByUserWithPerm(Context ctx, String userId, String permId) throws BOSException {
        HashSet<String> HrOrgSet = (HashSet<String>)PermCacheHelper.getPermCacheValue((int)PermCacheHelper.ORGPERMCACHE, (String)userId, (String)permId);
        if (HrOrgSet != null && HrOrgSet.size() != 0) {
            return HrOrgSet;
        }
        HrOrgSet = new HashSet<String>();
        try {
            String sql = HrPermissionTools.getPermisisonSqlByUserWithPerm(userId, permId);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                HrOrgSet.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        PermCacheHelper.putPermCacheValue((int)PermCacheHelper.ORGPERMCACHE, (String)userId, (String)permId, HrOrgSet);
        return HrOrgSet;
    }

    public static Set<String> getUserAdminOrgRange(Context ctx, String userId) throws BOSException {
        HashSet<String> adminOrgSet = (HashSet<String>)PermCacheHelper.getPermCacheValue((int)PermCacheHelper.ORGRANGECACHE, (String)userId, (String)(OrgRangeType.ADMIN_ORG_TYPE.getAlias() + "_HR"));
        if (adminOrgSet != null && adminOrgSet.size() != 0) {
            return adminOrgSet;
        }
        adminOrgSet = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)HrPermissionTools.getUserAdaminOrgRangeSql(userId));
            while (rs.next()) {
                adminOrgSet.add(rs.getString("FAdminOrgID"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        PermCacheHelper.putPermCacheValue((int)PermCacheHelper.ORGRANGECACHE, (String)userId, (String)(OrgRangeType.ADMIN_ORG_TYPE.getAlias() + "_HR"), adminOrgSet);
        return adminOrgSet;
    }

    public static String getUserAdaminOrgRangeSql(String userId) {
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.fid FAdminOrgID from T_ORG_ADMIN t0").append(" where exists(select 1 from T_PM_OrgRange t1 where t0.fid = t1.FORGID AND t1.FUserID = '").append(userId).append("'").append(" and t1.FType = ").append(20).append(")").append(" AND t0.FISSTARTSHR = 1");
        return sql.toString();
    }

    public static void main(String[] args) {
        String sql = HrPermissionTools.getPermisisonSqlByUserWithPerm("w375b3otTC+Fh9r+sanxwhO33n8=", "5c5d487c-855e-4beb-a216-cc9156a72463PERMITEM");
        System.out.println(sql);
    }
}

