/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.cloud.activiation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCRegister;
import com.kingdee.eas.base.permission.util.cloud.activiation.NoActiviationUserInfo;
import com.kingdee.eas.base.permission.util.cloud.activiation.UserNoActiviationHelper;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserNoActiviationBuild
implements Serializable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.util.interior.UserNoActiviationBuild");
    private Context ctx = null;
    List<String> noActivationUsers = new ArrayList<String>();
    List<String> cloudNoActivationUsers = new ArrayList<String>();
    private Map<String, NoActiviationUserInfo> validUsers = new HashMap<String, NoActiviationUserInfo>();
    private Map<String, NoActiviationUserInfo> noActiviationUsers = new HashMap<String, NoActiviationUserInfo>();
    private Set<String> canAddNoActivionUsers = new HashSet<String>();

    public UserNoActiviationBuild(Context ctx) {
        this.ctx = ctx;
    }

    public void rebuildNoActiviationUsers() throws Exception {
        this.init();
        this.fetchValidUsers();
        this.checkRemoveInValidUsers();
        this.prepareNoAcitivtionUsers();
        this.prepareCanAddUsers();
    }

    public Map<String, NoActiviationUserInfo> getNoActiviationUsers() {
        return this.noActiviationUsers;
    }

    public Set<String> getCanAddNoActivionUsers() {
        return this.canAddNoActivionUsers;
    }

    public void addNoActiviationUsers(String[] erpNumbers) throws BOSException {
        UserNoActiviationHelper.addNoActivedErpUser(this.ctx, erpNumbers);
        for (String erpNumber : erpNumbers) {
            NoActiviationUserInfo noActiviationUserInfo = this.validUsers.get(erpNumber = erpNumber.toLowerCase());
            if (noActiviationUserInfo == null) continue;
            this.noActiviationUsers.put(erpNumber, noActiviationUserInfo);
        }
        this.updateSyncStatus(erpNumbers);
        this.prepareCanAddUsers();
    }

    public void removeNoActiviionUsers(String[] erpNumbers) throws BOSException {
        UserNoActiviationHelper.removeNoActivedErpUser(this.ctx, erpNumbers);
        for (String erpNumber : erpNumbers) {
            this.noActiviationUsers.remove(erpNumber);
        }
        this.updateSyncStatus(erpNumbers);
        this.prepareCanAddUsers();
    }

    public void removeAllNoActiviionUsers() throws BOSException {
        List<String> noActivationUsers = UserNoActiviationHelper.getNoActiviationUsers(this.ctx);
        String[] erpNumbers = new String[noActivationUsers.size()];
        erpNumbers = noActivationUsers.toArray(erpNumbers);
        UserNoActiviationHelper.removeNoActivedErpUser(this.ctx, erpNumbers);
        for (String erpNumber : erpNumbers) {
            this.noActiviationUsers.remove(erpNumber);
        }
        this.updateSyncStatus(erpNumbers);
        this.prepareCanAddUsers();
    }

    public void updateSyncStatus(String[] erpNumbers) throws BOSException {
        String sql = " update t_pm_user set FISSYNTOCLOUD = 0 where lower(fnumber)=?";
        try {
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (String erpNumber : erpNumbers) {
                Object[] param = new Object[]{erpNumber.toLowerCase()};
                params.add(param);
            }
            this.updateAllAis(sql, params);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void init() throws Exception {
        this.validUsers.clear();
        this.noActivationUsers.clear();
        this.cloudNoActivationUsers.clear();
        this.noActiviationUsers.clear();
        this.noActivationUsers = UserNoActiviationHelper.getNoActiviationUsers(this.ctx);
        this.cloudNoActivationUsers = UserNoActiviationHelper.getCloudNoActiviationUsers(this.ctx);
    }

    private void prepareNoAcitivtionUsers() throws Exception {
        for (String erpNumber : this.noActivationUsers) {
            NoActiviationUserInfo noActiviationUserInfo = this.validUsers.get(erpNumber);
            if (noActiviationUserInfo == null) {
                noActiviationUserInfo = new NoActiviationUserInfo();
                noActiviationUserInfo.setNumber(erpNumber);
            }
            noActiviationUserInfo.setValid(this.cloudNoActivationUsers.contains(erpNumber.toLowerCase()));
            this.noActiviationUsers.put(erpNumber, noActiviationUserInfo);
        }
    }

    private void prepareCanAddUsers() {
        this.canAddNoActivionUsers.clear();
        Set<String> validUserskeySet = this.validUsers.keySet();
        Set<String> noActiviationUserskeySet = this.noActiviationUsers.keySet();
        for (String erpNumber : validUserskeySet) {
            if (noActiviationUserskeySet.contains(erpNumber)) continue;
            this.canAddNoActivionUsers.add(erpNumber);
        }
    }

    private void checkRemoveInValidUsers() throws Exception {
        ArrayList<String> inValidUsers = new ArrayList<String>();
        for (String erpNumber : this.noActivationUsers) {
            if (this.validUsers.containsKey(erpNumber)) continue;
            inValidUsers.add(erpNumber);
        }
        String[] erpNumbers = new String[inValidUsers.size()];
        inValidUsers.toArray(erpNumbers);
        UserNoActiviationHelper.removeNoActivedErpUser(this.ctx, erpNumbers);
    }

    private void checkAddCloudValidUsers() throws Exception {
        ArrayList<String> cloudValidUsers = new ArrayList<String>();
        for (String erpNumber : this.cloudNoActivationUsers) {
            if (this.noActivationUsers.contains(erpNumber)) continue;
            cloudValidUsers.add(erpNumber);
        }
        String[] erpNumbers = new String[cloudValidUsers.size()];
        cloudValidUsers.toArray(erpNumbers);
        UserNoActiviationHelper.addNoActivedErpUser(this.ctx, erpNumbers);
    }

    private void fetchValidUsers() throws Exception {
        this.validUsers.clear();
        Set<String> sourceAISs = UserNoActiviationBuild.getAISs();
        for (String AIS : sourceAISs) {
            try {
                this.fetchValidUsersByAis(AIS);
            }
            catch (Exception e) {
                logger.error((Object)("fetchDbUsers error! ais:" + AIS), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchValidUsersByAis(String ais) throws BOSException, SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = DbConnector.getConnection((String)ais);
            String sql = this.getSql();
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String userId = rs.getString("FID");
                String erpNumber = rs.getString("FNUMBER").toLowerCase();
                String name = rs.getString("FNAME_L2");
                NoActiviationUserInfo user = this.validUsers.get(erpNumber);
                if (user == null) {
                    user = new NoActiviationUserInfo(userId, erpNumber, name);
                    this.validUsers.put(erpNumber, user);
                }
                user.getAiss().add(ais);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllAis(String sql, List list) throws Exception {
        Set<String> sourceAISs = UserNoActiviationBuild.getAISs();
        for (String ais : sourceAISs) {
            Connection conn = null;
            try {
                conn = DbConnector.getConnection((String)ais);
                DBUtil.executeBatchUpdate((Connection)conn, (String)sql, (List)list);
            }
            catch (Exception e) {
                logger.error((Object)("update error! ais:" + ais), (Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }

    private static Set<String> getAISs() throws Exception {
        HashSet<String> aisSet = new HashSet<String>();
        ArrayList dcList = new DCRegister().getDCList();
        Iterator iterator = dcList.iterator();
        while (iterator.hasNext()) {
            aisSet.add(((DCInfo)iterator.next()).getNumber());
        }
        return aisSet;
    }

    private String getSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FID ,FNAME_L2,FNUMBER ,FCELL ,FEMAIL,FISDELETE ,FFORBIDDEN FROM t_pm_user pmuser");
        sql.append(" where lower(pmuser.Fnumber) not in('administrator','user','authenadmin','sscadmin','auditadmin','virtualuser') and FISDELETE = 0 and FFORBIDDEN = 0 ");
        return sql.toString();
    }
}

