/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.util.xt;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.XTMobileFacadeFactory;
import com.kingdee.eas.base.permission.util.xt.RSAUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;

public class XunTongSynUtils {
    public static final String PROPERTIES_DIR_ENV_NAME = "eas.deploy";
    public static final String CLIENTROOT_DIR_ENV_NAME = "easclient.root";

    public static String getProductSN(Context ctx) {
        try {
            LicenseBaseInfo info = null;
            info = ctx != null ? LicenseSrvFactory.getInstance().getLicenseBaseInfo() : LicenseSrvAgentFactory.getRemoteInstance().getLicenseBaseInfo();
            return info.getSerialNum();
        }
        catch (LicenseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCust3gNO(Context ctx) {
        String mid = null;
        try {
            mid = ctx == null ? XTMobileFacadeFactory.getRemoteInstance().getCust3gNo() : XTMobileFacadeFactory.getLocalInstance(ctx).getCust3gNo();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return mid;
    }

    public static Key getServerPrivateKey(Context ctx, String mid) throws BOSException {
        if (StringUtils.isEmpty((String)mid)) {
            return null;
        }
        byte[] src = null;
        src = ctx == null ? XTMobileFacadeFactory.getRemoteInstance().getCust3gPriKey(mid) : XTMobileFacadeFactory.getLocalInstance(ctx).getCust3gPriKey(mid);
        try {
            return RSAUtils.restorePrivateKey(src);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey getCommonPrivateKey() throws BOSException {
        String configPath = null;
        if (XunTongSynUtils.runtimeIsClient()) {
            configPath = System.getProperty(CLIENTROOT_DIR_ENV_NAME);
            System.out.println("in client home");
        } else {
            String propertiesPath = System.getProperty("EAS_HOME") + "/server/properties/";
            configPath = propertiesPath + File.separator + "mobile";
            System.out.println("in server home");
        }
        String filePath = configPath + File.separator + "app_private.key";
        System.out.println("app privete key path =" + filePath);
        System.out.println("eas.properties.dir=" + System.getProperty("eas.properties.dir"));
        PrivateKey key = null;
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                byte[] src = new byte[((InputStream)is).available()];
                ((InputStream)is).read(src);
                key = RSAUtils.restorePrivateKey(src);
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return key;
    }

    public static String readRemoteProtocol() throws BOSException {
        HttpClient http = new HttpClient();
        GetMethod get = new GetMethod("http://xunt.im/xuntong/license.action");
        try {
            get.setParams(null);
            String responseBody = new String(get.getResponseBody(), "utf-8");
            System.out.println(responseBody);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readProtocol() throws BOSException {
        String configPath = XunTongSynUtils.runtimeIsClient() ? System.getProperty(CLIENTROOT_DIR_ENV_NAME) : System.getProperty(PROPERTIES_DIR_ENV_NAME);
        String filePath = configPath + File.separator + "protocol.txt";
        Object key = null;
        File file = new File(filePath);
        String protocol = null;
        if (file.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                byte[] src = new byte[((InputStream)is).available()];
                ((InputStream)is).read(src);
                protocol = new String(src, "UTF-8");
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return protocol;
    }

    private static boolean runtimeIsClient() {
        return System.getProperty(CLIENTROOT_DIR_ENV_NAME) != null;
    }

    public static final String randomString(int length) {
        if (length < 1) {
            return null;
        }
        Random randGen = new Random();
        char[] numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        char[] randBuffer = new char[length];
        for (int i = 0; i < randBuffer.length; ++i) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(71)];
        }
        return new String(randBuffer);
    }

    public static IRowSet query(Context ctx, String sql) throws BOSException {
        if (ctx != null) {
            return DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        return rs;
    }

    public static String convertSetToString(Set<String> idSet) {
        StringBuffer sb = new StringBuffer();
        if (idSet == null || idSet.size() == 0) {
            return "('')";
        }
        sb.append("(");
        Iterator<String> iter = idSet.iterator();
        int index = 0;
        while (iter.hasNext()) {
            if (index > 0) {
                sb.append(",");
            }
            sb.append("'").append(iter.next()).append("'");
            ++index;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String convertObjectToJson(Object object) {
        if (object == null || object.equals("")) {
            return "\"\"";
        }
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        builder.serializeNulls();
        builder.serializeSpecialFloatingPointValues();
        Gson gson = builder.create();
        String result = gson.toJson(object);
        if (result == null) {
            return "\"\"";
        }
        return result;
    }

    public static HashMap convertJsonToObject(String json) {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        builder.serializeNulls();
        builder.serializeSpecialFloatingPointValues();
        Gson gson = builder.create();
        return (HashMap)gson.fromJson(json.toString(), HashMap.class);
    }

    public static void saveLastUpdateTime(Context ctx, Timestamp time) throws BOSException {
        if (ctx != null) {
            XTMobileFacadeFactory.getLocalInstance(ctx).saveLastUpdateTime(time);
        } else {
            XTMobileFacadeFactory.getRemoteInstance().saveLastUpdateTime(time);
        }
    }

    public static Timestamp getLastUpdateTime(Context ctx) throws BOSException {
        String sql = "select flastupdatetime from T_HR_MCloudSynchTime";
        IRowSet rs = null;
        rs = ctx != null ? DbUtil.executeQuery((Context)ctx, (String)sql) : SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        try {
            if (rs.next()) {
                return rs.getTimestamp(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }
}

