/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.gpt.dynamic.processor.entity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.bos.gpt.dynamic.processor.ArrangeTypeEnum;
import com.kingdee.bos.gpt.dynamic.processor.dto.GPTTalkRequestDTO;
import com.kingdee.bos.gpt.dynamic.processor.dto.MessageDTO;
import com.kingdee.bos.gpt.dynamic.processor.entity.config.DetailConfig;
import com.kingdee.bos.gpt.dynamic.processor.entity.inputs.Inputs;
import com.kingdee.bos.gpt.dynamic.processor.entity.inputs.InputsInputs;
import com.kingdee.bos.gpt.dynamic.processor.entity.inputs.MessageInputs;
import com.kingdee.bos.gpt.dynamic.processor.entity.inputs.PromptInputs;
import com.kingdee.bos.gpt.dynamic.processor.entity.outputs.MessageOutputs;
import com.kingdee.bos.gpt.dynamic.processor.entity.outputs.OutPutsPutputs;
import com.kingdee.bos.gpt.dynamic.processor.entity.outputs.Outputs;
import com.kingdee.bos.gpt.dynamic.processor.entity.outputs.PromptOutputs;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Arrange<I extends Inputs, O extends Outputs>
implements Serializable {
    private String id;
    private String name;
    private String number;
    private String explain;
    private ArrangeTypeEnum type;
    private DetailConfig<I, O> detailConfig;
    private Integer order;

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public DetailConfig<I, O> getDetailConfig() {
        return this.detailConfig;
    }

    public void setDetailConfig(DetailConfig<I, O> detailConfig) {
        this.detailConfig = detailConfig;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getExplain() {
        return this.explain;
    }

    public ArrangeTypeEnum getType() {
        return this.type;
    }

    public void setType(ArrangeTypeEnum type) {
        this.type = type;
    }

    public void setExplain(String explain) {
        this.explain = explain;
    }

    public Map handle(GPTTalkRequestDTO dto) throws ParseException {
        Map map = this.detailConfig.handle(this.transformInputParams(dto, new HashMap<String, Object>()), dto);
        if (ArrangeTypeEnum.isAutomatic(this.type)) {
            return this.transformOutputParams(dto, map);
        }
        return map;
    }

    public Map transformInputParams(GPTTalkRequestDTO dto, Map<String, Object> inputParams) throws ParseException {
        List<I> inputs = this.detailConfig.getInputs();
        if (inputs != null) {
            switch (this.type) {
                case INPUTS: {
                    dto.getInputParams().put("#0 userInput", dto.getInput());
                    for (Inputs obj : inputs) {
                        if (!(obj instanceof InputsInputs)) continue;
                        InputsInputs input = (InputsInputs)obj;
                        String paramName = input.getRequestParamName();
                        String paramType = input.getRequestParamType();
                        Object paramValue = dto.getInputParams().get(paramName);
                        if (paramValue == null) continue;
                        paramValue = this.trabsformValue(paramType, paramValue);
                        dto.getInputParams().put("#1 " + this.name + "." + paramName, paramValue);
                    }
                    return inputParams;
                }
                case BACKEND: 
                case FONT: 
                case GUI: {
                    for (Inputs obj : inputs) {
                        if (!(obj instanceof InputsInputs)) continue;
                        InputsInputs input = (InputsInputs)obj;
                        String paramName = input.getRequestParamName();
                        String paramType = input.getRequestParamType();
                        String paramForm = input.getRequestParamForm();
                        Object paramValue = null;
                        if (!StringUtils.isEmpty((String)paramForm)) {
                            paramValue = "userInput".equalsIgnoreCase(paramForm) ? dto.getInputParams().get("#0 userInput") : dto.getInputParams().get(paramForm);
                        }
                        paramValue = this.trabsformValue(paramType, paramValue);
                        inputParams.put(paramName, paramValue);
                    }
                    return inputParams;
                }
                case PROMPT: {
                    for (Inputs obj : inputs) {
                        if (!(obj instanceof PromptInputs)) continue;
                        PromptInputs input = (PromptInputs)obj;
                        String paramName = input.getPromptParamName();
                        String paramType = input.getPromptParamType();
                        String paramForm = input.getPromptParamFrom();
                        Object paramValue = null;
                        if (!StringUtils.isEmpty((String)paramForm)) {
                            paramValue = "userInput".equalsIgnoreCase(paramForm) ? dto.getInputParams().get("#0 userInput") : dto.getInputParams().get(paramForm);
                        }
                        paramValue = this.trabsformValue(paramType, paramValue);
                        inputParams.put(paramName, paramValue);
                    }
                    return inputParams;
                }
                case MESSAGE: {
                    MessageDTO mdto;
                    StringBuffer sb = new StringBuffer();
                    String msgType = "text";
                    ArrayList<MessageDTO> msg = new ArrayList<MessageDTO>();
                    for (Inputs obj : inputs) {
                        if (!(obj instanceof MessageInputs)) continue;
                        MessageInputs input = (MessageInputs)obj;
                        String paramForm = input.getMessageParamFrom();
                        String paramType = input.getMessageParamType();
                        Object paramValue = input.getManualContent();
                        if (!StringUtils.isEmpty((String)paramForm)) {
                            paramValue = "userInput".equalsIgnoreCase(paramForm) ? dto.getInputParams().get("#0 userInput") : dto.getInputParams().get(paramForm);
                        }
                        if (!StringUtils.isEmpty((String)msgType)) {
                            if ("interation".equalsIgnoreCase(paramType)) {
                                msgType = paramType;
                            } else if ("chart".equalsIgnoreCase(paramType)) {
                                msgType = paramType;
                            }
                        }
                        if ("chart".equalsIgnoreCase(paramType)) {
                            MessageDTO mdto2;
                            if (sb.length() > 0) {
                                mdto2 = new MessageDTO();
                                mdto2.setMsgType("text");
                                mdto2.setMsg(sb.toString());
                                msg.add(mdto2);
                                sb.setLength(0);
                            }
                            mdto2 = new MessageDTO();
                            mdto2.setMsgType(paramType);
                            mdto2.setMsg(String.valueOf(paramValue));
                            msg.add(mdto2);
                            continue;
                        }
                        sb.append(paramValue);
                    }
                    if ("chart".equalsIgnoreCase(msgType)) {
                        if (sb.length() > 0) {
                            mdto = new MessageDTO();
                            mdto.setMsgType("text");
                            mdto.setMsg(sb.toString());
                            msg.add(mdto);
                        }
                    } else {
                        mdto = new MessageDTO();
                        mdto.setMsgType(msgType);
                        mdto.setMsg(sb.toString());
                        msg.add(mdto);
                    }
                    inputParams.put("content", JSON.toJSONString(msg));
                    return inputParams;
                }
            }
            return inputParams;
        }
        return inputParams;
    }

    public Object trabsformValue(String paramType, Object paramValue) throws ParseException {
        if ("string".equalsIgnoreCase(paramType)) {
            if (paramValue != null) {
                if (paramValue instanceof Number) {
                    paramValue = TypeConversionUtils.objToBigDecimal((Object)paramValue).toPlainString();
                } else if (paramValue instanceof Date) {
                    paramValue = DateTimeUtils.format((Date)((Date)paramValue));
                } else if (paramValue instanceof Map) {
                    String jsonString = JSON.toJSONString((Object)paramValue);
                    JSONObject jsonObject = JSON.parseObject((String)jsonString);
                    paramValue = JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain});
                } else {
                    paramValue = paramValue.toString();
                }
            }
        } else if ("integer".equalsIgnoreCase(paramType)) {
            paramValue = paramValue == null ? 0 : Integer.valueOf(paramValue.toString());
        } else if ("datetime".equalsIgnoreCase(paramType) && paramValue instanceof String) {
            paramValue = paramValue == null ? null : DateTimeUtils.parseDate((String)paramValue.toString());
        }
        return paramValue;
    }

    public Map transformOutputParams(GPTTalkRequestDTO dto, Map<String, Object> outputParams) throws ParseException {
        List<O> outputs = this.detailConfig.getOutputs();
        if (outputs != null) {
            switch (this.type) {
                case BACKEND: 
                case OUTPUTS: {
                    for (Outputs obj : outputs) {
                        if (!(obj instanceof OutPutsPutputs)) continue;
                        OutPutsPutputs output = (OutPutsPutputs)obj;
                        String paramName = output.getReponseParamName();
                        String paramType = output.getReponseParamType();
                        String paramForm = output.getReponseParamFrom();
                        Object paramValue = outputParams.get(paramName);
                        if (ArrangeTypeEnum.OUTPUTS.equals((Object)this.type) && !StringUtils.isEmpty((String)paramForm)) {
                            paramValue = dto.getInputParams().get(paramForm);
                        }
                        paramValue = this.trabsformValue(paramType, paramValue);
                        outputParams.put(paramName, paramValue);
                        dto.getInputParams().put("#" + this.order + " " + this.name + "." + paramName, paramValue);
                    }
                    return outputParams;
                }
                case FONT: 
                case GUI: {
                    for (Outputs obj : outputs) {
                        if (!(obj instanceof OutPutsPutputs)) continue;
                        OutPutsPutputs output = (OutPutsPutputs)obj;
                        String paramName = output.getReponseParamName();
                        String paramType = output.getReponseParamType();
                        Object paramValue = dto.getInputParams().get(paramName);
                        paramValue = this.trabsformValue(paramType, paramValue);
                        outputParams.put(paramName, paramValue);
                        dto.getInputParams().put("#" + this.order + " " + this.name + "." + paramName, paramValue);
                    }
                    return outputParams;
                }
                case PROMPT: {
                    for (Outputs obj : outputs) {
                        if (!(obj instanceof PromptOutputs)) continue;
                        PromptOutputs output = (PromptOutputs)obj;
                        String paramName = output.getPromptOutputParamName();
                        String paramType = output.getPromptOutputParamType();
                        Object paramValue = outputParams.get(paramName);
                        paramValue = this.trabsformValue(paramType, paramValue);
                        outputParams.put(paramName, paramValue);
                        dto.getInputParams().put("#" + this.order + " " + this.name + "." + paramName, paramValue);
                    }
                    return outputParams;
                }
                case MESSAGE: {
                    if (!StringUtils.isEmpty((String)dto.getInput())) {
                        dto.getInputParams().put("#" + this.order + " " + this.name + "." + ((MessageOutputs)outputs.get(0)).getMessageInputParamName(), dto.getInput());
                    }
                    return outputParams;
                }
            }
            return outputParams;
        }
        return outputParams;
    }
}

